
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/VARVIEW.H__   1.8   20 Jun 1996 09:27:16   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/VARVIEW.H__  $
** 
**    Rev 1.8   20 Jun 1996 09:27:16   ZJRD
** EasyPack/SLD Version 1.20a
** 
**    Rev 1.6   10 Jun 1996 10:21:54   ZJRD
** EasyPack/SLD Version 1.20
** 
**    Rev 1.4   29 May 1996 09:32:20   ZJRD
** EasyPack/SLD Version 1.95
** 
**    Rev 1.3   16 May 1996 09:03:32   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:12:24   ZJRD
** EasyPack/SLD Version 1.93
** 
**    Rev 1.1   02 May 1996 10:27:20   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 13:01:02   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:38:02   Shirley
** No change.
** 
**    Rev 1.29   02 Apr 1996 09:31:06   Shirley
** No change.
** 
**    Rev 1.28   15 Feb 1996 08:52:34   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:07:06   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:33:34   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:47:28   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:14:04   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:19:58   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:19:52   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:33:00   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:26:44   Shirley
** EasypPack/SLD Version 0.34c
** 
**    Rev 1.19   18 Jan 1996 10:11:32   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:13:08   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:11:10   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:15:00   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:29:30   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:21:46   Shirley
** EasyPack/SLD Version 0.31
** 
**    Rev 1.13   13 Nov 1995 09:23:26   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:34:20   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:32:18   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:46:10   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:07:14   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:49:22   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:43:58   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:27:00   Shirley
** EasyPack/SLD Version 0.1f
** 
**    Rev 1.5   18 Oct 1995 14:51:10   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:20:04   Shirley
** EasyPack/SLD Version 0.1d
** 
**    Rev 1.3   29 Sep 1995 09:51:54   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:54:18   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:46:20   Shirley
** EasyPack/SLDV0.1a 
** 
**    Rev 1.0   07 Sep 1995 09:55:12   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: VARVIEW.H
//
//  Description: The header file for the class: CVarView.
//
//  Author: Chen Jun
//
//  Date: 07/18/95
//
//  Modification:
//      1. 07/18/95, Initial version of the class: CVarView.
//
/////////////////////////////////////////////////////////////////////////////
#ifndef _VARVIEW_
#define _VARVIEW_


/////////////////////////////////////////////////////////////////////////////
// CVarView view

class CVarView : public CView
{
    DECLARE_DYNCREATE(CVarView)
public:
    CVarView();         // protected constructor used by dynamic creation
    void InitialMember(void);

// Attributes
public:
    virtual CVarDoc* GetDocument();

public:
    int m_nMaxRow;
    int m_nMaxCol;

    int m_nCurRow;
    int m_nCurCol;

   int m_nRowSize;
   int m_nColSize;

   int m_nStartRow;
   int m_nStartCol;
      
    CRect m_rectClient;

private:
    enum { bottomHeight = 20 };
    int m_nFontWidth;
    int m_nFontHeight;

private:
    enum { caretWidth = 2 };
    int m_xCaret;
    int m_yCaret;

private:
    int m_nClientLine;  // Indicate the start line in the client area.
    int m_nInitFlag;
    int m_nFocus;
    
// Operations
private:
    enum {
        noError = 0,        // No error.
        insufficientMemory, // Insufficient memory.
        bmpLoad,            // Cannot load VAR_xxx bitmap.
        hasError,
        maxError = 10       // Limition of error ID.
    };
    BOOL m_nErrorID;
    
    void DisplayErrorMessage(void) const;

private:
    enum { 
        pageUnit = 30,
        lineUnit = 1,
        pageScroll = 1,
        limitRow = 400,
        limitColumn = 400
    };
    int m_nLimitLine;
    int m_nLimitColumn;
//    void UpdateScrollSizes(void);

private:
    enum {
        bmpWidth = 16,
        bmpHeight = 13,
    };
    CBitmap m_bmpInvalid;
    CBitmap m_bmpSimple;
    CBitmap m_bmpOpen;
    CBitmap m_bmpClose;

    BOOL AllocateBitmap(void);
    void ReleaseBitmap(void);

    void DisplayBitmap(CDC* pDC, const int xPos, const int yPos);

public:
    enum {
        invalidSign = 0,
        simpleSign,
        openSign,
        closeSign
    };
    int m_nBmpStatus;
    void DetectVarFormat(void);

private:
    CString m_strName;
    CString m_strValue;
    CString m_strResult;

public:
    struct VarNode* m_pVarNode;
    void OutputAllVariable(CDC* pDC);
   void OutputOneVariable(CDC* pDC , int nLine);
    void UpdateBottomPane(void);

//private:
//    void UpdateModifiedRegion(BOOL bAdjustScrollRange);
//    void UpdateMarkLine(int nMarkLine);
//    void UpdateToLine(int nLine);
    
private:
    BOOL m_bCaretOn;
    void TurnOnCaret(void);
    void TurnOffCaret(void);
        
private:
    int m_nScrollBox;
    BOOL m_bAdjustScrollBox;
    BOOL m_bAdjustScrollRange;
    int m_nHScroll;
    int m_nVScroll;   

    void ResizeScroll();        
    void ResizeScrollBarRange();        

//    void AssumeScrollBox(void);
//    void RestoreScrollBox(void);
    
// Implementation
public:
    // Public function.
    void UpdateWholeWindow(void);
    void AddNewVariable(void);
    void DeleteOneNode(void);
    void DeleteAllNode(void);
    BOOL IsEmpty(void);
    void GetHighlightName(CString& strName);
    void GetHighlightValue(CString& strValue);
    void SearchToken(CString& strToken);
    void SearchNextToken(CString& strToken);
    BOOL ModifyValue(CString& strNewValue);
    void TypeCast(CString& strTypeCast);
    void EditVariableName(CString& strVariableName);
    
protected:
    virtual ~CVarView();    // protected destructor

    // Standard overrides of MFC classes.
    virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
    virtual void OnDraw(CDC* pDC);      // overridden to draw this view
    virtual void OnInitialUpdate();     // first time after construct
    virtual void OnPrepareDC(CDC* pDC, CPrintInfo* pInfo = NULL);

    // Generated message map functions
    //{{AFX_MSG(CVarView)
    afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
    afx_msg void OnSize(UINT nType, int cx, int cy);
    afx_msg void OnSetFocus(CWnd* pOldWnd);
    afx_msg void OnKillFocus(CWnd* pNewWnd);
    afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
    afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
    afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
    afx_msg BOOL OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message);
    afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
    afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
    afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
    afx_msg void OnShiftreturn();
    afx_msg void OnPaint();
    //}}AFX_MSG
    DECLARE_MESSAGE_MAP()
};

#endif
//////////////////////////////// End of File ////////////////////////////////
