
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/XVIEW.CPP   1.8   20 Jun 1996 09:24:32   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/XVIEW.CPP  $
** 
**    Rev 1.8   20 Jun 1996 09:24:32   ZJRD
** EasyPack/SLD Version 1.20a
** 
**    Rev 1.6   10 Jun 1996 10:19:10   ZJRD
** No change.
** 
**    Rev 1.5   05 Jun 1996 14:52:04   ZJRD
** EasyPack/SLD Version 1.96
** 
**    Rev 1.4   29 May 1996 09:28:06   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:08:26   ZJRD
** EasyPack/SLD Version 1.94
** 
**    Rev 1.2   10 May 1996 09:08:56   ZJRD
** EasyPack/SLD Version 1.93
** 
**    Rev 1.1   02 May 1996 10:24:52   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 13:00:36   Shirley
** EasyPack/SLD Version 1.91
** 
**    Rev 1.30   12 Apr 1996 10:37:38   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:52:10   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:06:40   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:33:10   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:48:06   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:12:26   Shirley
** EasyPack/SLD Version 0.35b
** 
**    Rev 1.23   26 Jan 1996 09:12:10   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:12:50   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:36:26   Shirley
** EasyPack/SLD Version 0.34d
** 
**    Rev 1.20   23 Jan 1996 11:24:52   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:09:14   Shirley
** EasyPack/SLD Version 0.34b
** 
**    Rev 1.18   15 Jan 1996 16:12:14   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:14:44   Shirley
** EasyPack/SLD Version 0.34
** 
**    Rev 1.16   30 Nov 1995 09:09:56   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:30:46   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:23:50   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:26:10   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:30:18   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:33:34   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:43:16   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:05:20   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:49:26   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:44:02   Shirley
** EasyPack/SLD Version 0.1g
** 
**    Rev 1.6   25 Oct 1995 14:27:04   Shirley
** EasyPack/SLD Version 0.1f
** 
**    Rev 1.5   18 Oct 1995 14:51:12   Shirley
** EasyPack/SLD Version 0.1e
** 
**    Rev 1.4   13 Oct 1995 13:18:48   Shirley
** EasyPack/SLD Version 0.1d
** 
**    Rev 1.3   29 Sep 1995 09:52:00   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:57:54   Shirley
** EasyPack/SLD Version 0.1b
** 
**    Rev 1.1   15 Sep 1995 09:46:26   Shirley
** EasyPack/SLDV0.1a 
** 
**    Rev 1.0   07 Sep 1995 09:55:16   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  XVIEW.CPP
//
//  Description:The implement file for the class: CXviewApp
//
//  Author:     Roger Zhang
//
//  Date:       03/04/95
//
//  Modification:
//
//      1. 03/04/95, Initial version 
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "resource.h"
                    
#include "dibapi.h"
#include "labeldlg.h"            
#include "about.h"          
#include "uicom.h"
#include "btnbar.h"
#include "mainfrm.h"
#include "xinit.h"
#include "xview.h"
#include "ctl3d.h"

#include "bmemwnd.h"
#include "bmemview.h"
#include "bmemdoc.h"

// Variable window.
#include "varpane.h"
#include "varfrm.h"
#include "vardoc.h"
#include "varview.h"

// Stack window.
#include "stkfrm.h"
#include "stkdoc.h"
#include "stkview.h"
#include "stklocal.h"

#include "perwin.h"
#include "per6doc.h"
#include "per6view.h"

//john 96.3
#include "cpust.h"

// add by Richard
#include "aliaspub.h"

#include "cpucom.h"
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


//for reduce the occupation of stack, Frank, 10/25/95  
extern unsigned char *inputStream;  //[MAX_COMM_BUFF];
extern unsigned char *outputStream; //[512];

void SaveCpuConfig();
/////////////////////////////////////////////////////////////////////////////
// CXviewApp

static DWORD        dwLabelTime;
static CLabelDialog * pLabel = 0;

void DelLabel(void)
{
    #ifndef _DEBUG
    if(::pLabel) {
        ::pLabel->DestroyWindow();
        delete ::pLabel;
        ::pLabel = 0;   
    }    
    #endif
}

void NewLabel(void)
{
    #ifndef _DEBUG
    ::pLabel = new CLabelDialog();
    #endif
}

BEGIN_MESSAGE_MAP(CXviewApp, CWinApp)
    //{{AFX_MSG_MAP(CXviewApp)          
    ON_COMMAND_EX(ID_FILE_MRU_FILE1, OnOpenRecentFile)
    ON_COMMAND_EX(ID_FILE_MRU_FILE2, OnOpenRecentFile)
    ON_COMMAND_EX(ID_FILE_MRU_FILE3, OnOpenRecentFile)
    ON_COMMAND_EX(ID_FILE_MRU_FILE4, OnOpenRecentFile)
    ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
    //}}AFX_MSG_MAP
    // Standard file based document commands
    //ON_COMMAND(ID_FILE_NEW, CWinApp::OnFileNew)
    //ON_COMMAND(ID_FILE_OPEN, CWinApp::OnFileOpen)
    // Standard print setup command
    //ON_COMMAND(ID_FILE_PRINT_SETUP, CWinApp::OnFilePrintSetup)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CXviewApp construction

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CXviewApp::CXviewApp
//
//  Description: Constructor of the class CXviewApp
//
//  Input:  None
//
//  Output: None
//
//  Return: None
//
/////////////////////////////////////////////////////////////////////////////
CXviewApp::CXviewApp()
{
    // TODO: add construction code here,
    // Place all significant initialization in InitInstance
    m_isInit = FALSE;    
    m_is3D = FALSE;    
    
    ::inputStream = new unsigned char [2048];
    ::outputStream = new unsigned char[512]; 
    
    //added by john  96.3
    m_bCanTimer = TRUE;
    m_bWaiting = FALSE;      
    m_nCpuStatus = m_nCpuStatusBak = STATUS_HALT;

    m_bTraceOn = FALSE;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CXviewApp::~CXviewApp
//
//  Description: Destructor of the class CXviewApp
//
//  Input:  None
//
//  Output: None
//
//  Return: None
//
/////////////////////////////////////////////////////////////////////////////
CXviewApp::~CXviewApp()
{
    delete ::outputStream;
    delete ::inputStream ;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CXviewApp::OnFileNew
//
//  Description: Open document. (Lane)
//
//  Input:  None
//
//  Output: None
//
//  Return: None
//
/////////////////////////////////////////////////////////////////////////////
void CXviewApp::OpenFileNew()
{
    OnFileNew();
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CXviewApp object

CXviewApp NEAR theApp;

char szAppPath[_MAX_PATH+1];

/////////////////////////////////////////////////////////////////////////////
// CXviewApp initialization

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CXviewApp::InitApplication
//
//  Description: Initialize application
//
//  Input:  None
//
//  Output: None
//
//  Return: TRUE -- Success
//          FALSE -- Fail
//
/////////////////////////////////////////////////////////////////////////////
BOOL CXviewApp::InitApplication()
{               
    return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CXviewApp::InitInstance
//
//  Description: Initialize instance
//
//  Input:  None
//
//  Output: None
//
//  Return: TRUE -- Success
//          FALSE -- Fail
//
/////////////////////////////////////////////////////////////////////////////
BOOL CXviewApp::InitInstance()
{
    if (m_hPrevInstance) {
        AfxMessageBox(IDS_PRM_APPRUN);
        return FALSE;
    }                     
    
    // Get Applicaton Path
    strcpy(::szAppPath, m_pszHelpFilePath);
    int i = strlen(::szAppPath);
    while(i) {
        if(::szAppPath[--i] == '\\')  break;
    }                                     
    ::szAppPath[i+1] = '\0';

    // Standard initialization
    // If you are not using these features and wish to reduce the size
    //  of your final executable, you should remove from the following
    //  the specific initialization routines you do not need.

    SetDialogBkColor();        // Set dialog background color to gray
    LoadStdProfileSettings();  // Load standard INI file options (including MRU)
    EnableVBX();               // Initialize VBX support

    // Register 3D control.
    if ( Ctl3dRegister(HANDLE(m_hInstance)) ) {
        Ctl3dAutoSubclass(HANDLE(m_hInstance));
        m_is3D = TRUE;
    }
    else {
        m_is3D = FALSE;
    }

    // Do initialize
// Marked by Chen Jun, 2/5/95.
// Examine SPA UI.
    DoWaitCursor(1);
    if (!::Init()) {
        DoWaitCursor(-1);
            
        ::DelLabel();    
        
        AfxMessageBox(IDS_ERR_INIT);
        return FALSE;
    }
    DoWaitCursor(-1);

    // Register the application's document templates.  Document templates
    //  serve as the connection between documents, frame windows and views.
    CMultiDocTemplate* pDocTemplate;
    pDocTemplate = new CMultiDocTemplate(
        IDR_BMEMORY,
        RUNTIME_CLASS(CBMemoryDoc),
        RUNTIME_CLASS(CBMemoryWindow),
        RUNTIME_CLASS(CBMemoryView));
    AddDocTemplate(pDocTemplate);

    pBMemDocTemplate = pDocTemplate;

    pPeriDocTemplate = new CMultiDocTemplate(
        IDR_PER6TYPE,
        RUNTIME_CLASS(CPer6Doc),
        RUNTIME_CLASS(CPerWin),        // standard MDI child frame
        RUNTIME_CLASS(CPer6View));
    AddDocTemplate(pPeriDocTemplate);

    // Register the Variable's document, frame and view.
    extern CMultiDocTemplate* pVarDocTemplate;
    pVarDocTemplate = new CMultiDocTemplate(
        IDR_VARIABLE,
        RUNTIME_CLASS(CVarDoc),
        RUNTIME_CLASS(CVarFrame),
        RUNTIME_CLASS(CVarView));
    AddDocTemplate(pVarDocTemplate);

    // Register the Stack's document, frame and view.
    extern CMultiDocTemplate* pStkDocTemplate;
    pStkDocTemplate = new CMultiDocTemplate(
        IDR_STACK,
        RUNTIME_CLASS(CStackDoc),
        RUNTIME_CLASS(CStackFrame),
        RUNTIME_CLASS(CStackView));
    AddDocTemplate(pStkDocTemplate);

    AddDocTemplate(new CMultiDocTemplate(IDR_STACK,
        RUNTIME_CLASS(CStackDoc),
        RUNTIME_CLASS(CStackFrame),
        RUNTIME_CLASS(CStackLocalView)));

    // create main MDI Frame window
    CMainFrame* pMainFrame = new CMainFrame;
    if (!pMainFrame->LoadFrame(IDR_MAINFRAME))
        return FALSE;
    m_pMainWnd = pMainFrame;

/*
    if (m_lpCmdLine[0] != '\0') {
        // TODO: add command line processing here
    }
*/

    if(!RestoreWindowPlacement()) {
        // The main window has been initialized, so show and update it.
        pMainFrame->ShowWindow(m_nCmdShow);
        pMainFrame->UpdateWindow();    
    }

    // enable close the label                    
    ::dwLabelTime = ::GetCurrentTime();
    m_isInit = TRUE;
    
    return TRUE;
}                    

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CXviewApp::OnIdle
//
//  Description: Destroy the label when time is on
//
//  Input:  None
//
//  Output: None
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL CXviewApp::OnIdle(LONG lCount)
{
    BOOL bResult = CWinApp::OnIdle(lCount);
          
    //#ifndef _ZDEBUG          
    // then do our work
    if (m_isInit && ::pLabel && ::pLabel->m_hWnd != NULL) {
        if (::GetCurrentTime() - ::dwLabelTime > 3000L) {
            // timeout expired, destroy the label window
            ::pLabel->DestroyWindow();
            delete ::pLabel;
            ::pLabel = 0;

            // NOTE: don't set bResult to FALSE,
            //  CWinApp::OnIdle may have returned TRUE
        } else {
            // check again later...
            bResult = TRUE;
        }
    }             
    //#endif

    return bResult;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CXviewApp::PreTranslateMessage
//
//  Description: Destroy the label when input from the user
//
//  Input:  None
//
//  Output: None
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL CXviewApp::PreTranslateMessage(MSG* pMsg)
{                              
    ( (((CMainFrame *)m_pMainWnd)->m_wndToolBar) ).FilterTipMessage(pMsg);
    
    BOOL bResult = CWinApp::PreTranslateMessage(pMsg);
          
    //#ifndef _ZDEBUG          
    if (m_isInit && ::pLabel && ::pLabel->m_hWnd != NULL &&
        (pMsg->message == WM_KEYDOWN ||
         pMsg->message == WM_SYSKEYDOWN ||
         pMsg->message == WM_LBUTTONDOWN ||
         pMsg->message == WM_RBUTTONDOWN ||
         pMsg->message == WM_MBUTTONDOWN ||
         pMsg->message == WM_NCLBUTTONDOWN ||
         pMsg->message == WM_NCRBUTTONDOWN ||
         pMsg->message == WM_NCMBUTTONDOWN)) 
    {
        ::pLabel->DestroyWindow();
        delete ::pLabel;
        ::pLabel = 0;
    }             
    //#endif

    return bResult;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CXviewApp::ExitInstance
//
//  Description: Called on exit
//
//  Input:  None
//
//  Output: None
//
//  Return: 0
//
/////////////////////////////////////////////////////////////////////////////
int CXviewApp::ExitInstance()
{            
    extern void XPost(void);
    XPost();
    SaveCpuConfig();
    // Unregister 3D control.
    if ( m_is3D ) {
        Ctl3dUnregister(m_hInstance);
    }
    
                     
    // add by Richard
    FreeTable();
                         
    return CWinApp::ExitInstance();
}               

/////////////////////////////////////////////////////////////////////////////
//  Message Handlers
/////////////////////////////////////////////////////////////////////////////
                                
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CXviewApp::OnOpenRecentFile
//
//  Description: Message handler of menu item -- Recent File
//
//  Input:  
//      nID -- menu item ID
//
//  Output: None
//
//  Return: TRUE
//
/////////////////////////////////////////////////////////////////////////////
BOOL CXviewApp::OnOpenRecentFile(UINT nID)
{               
    extern void LoadSourceFile(CString strFileName);        
    
    CString str = m_strRecentFiles[nID - ID_FILE_MRU_FILE1];        
    
    DoWaitCursor(1);
    LoadSourceFile(str);
    DoWaitCursor(-1);
    return TRUE;
}                                
                                
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CXviewApp::OnAppAbout
//
//  Description: Message handler of menu item -- Open the About dialog
//
//  Input:  None
//
//  Output: None
//
//  Return: None
//
/////////////////////////////////////////////////////////////////////////////
void CXviewApp::OnAppAbout()
{
    CAboutDialog* pDlgAbout = new CAboutDialog;
    pDlgAbout->DoModal();
    delete pDlgAbout;
}

/////////////////////////////////////////////////////////////////////////////
// VB-Event registration
// (calls to AfxRegisterVBEvent will be placed here by ClassWizard)

//{{AFX_VBX_REGISTER_MAP()
    UINT NEAR VBN_TABPAGEACTIVATE = AfxRegisterVBEvent("TABPAGEACTIVATE");
    UINT NEAR VBN_TABPAGESHOWN = AfxRegisterVBEvent("TABPAGESHOWN");
    UINT NEAR VBN_CLICK = AfxRegisterVBEvent("CLICK");
    UINT NEAR VBN_SELCHANGE = AfxRegisterVBEvent("SELCHANGE");
    UINT NEAR VBN_BLOCKSELECTED = AfxRegisterVBEvent("BLOCKSELECTED");
    UINT NEAR VBN_LEAVECELL = AfxRegisterVBEvent("LEAVECELL");
    UINT NEAR VBN_CHANGE = AfxRegisterVBEvent("CHANGE");
    UINT NEAR VBN_MOUSEUP = AfxRegisterVBEvent("MOUSEUP");
    UINT NEAR VBN_KEYUP = AfxRegisterVBEvent("KEYUP");
    UINT NEAR VBN_KEYDOWN = AfxRegisterVBEvent("KEYDOWN");
    UINT NEAR VBN_TABACTIVATE = AfxRegisterVBEvent("TABACTIVATE");
    UINT NEAR VBN_ADDNEWDATA = AfxRegisterVBEvent("ADDNEWDATA");
    UINT NEAR VBN_MOUSEDOWN = AfxRegisterVBEvent("MOUSEDOWN");
    UINT NEAR VBN_EDITMODE = AfxRegisterVBEvent("EDITMODE");
    UINT NEAR VBN_DBLCLICK = AfxRegisterVBEvent("DBLCLICK");
    UINT NEAR VBN_BUTTONCLICKED = AfxRegisterVBEvent("BUTTONCLICKED");
    UINT NEAR VBN_GOTFOCUS = AfxRegisterVBEvent("GOTFOCUS");
    UINT NEAR VBN_LOSTFOCUS = AfxRegisterVBEvent("LOSTFOCUS");
    UINT NEAR VBN_SETCAPTION = AfxRegisterVBEvent("SETCAPTION");
//}}AFX_VBX_REGISTER_MAP

/////////////////////////////////////////////////////////////////////////////
// CXviewApp commands

//added by john 96.3
CXviewApp *GetXviewAppJohn()
{ 
 return (CXviewApp *)AfxGetApp();
}

/////////////////////////////(EOF)///////////////////////////////////////////
void SaveCpuConfig()
{
	UINT cpuid=	CPU_ID;                        
	int i;    
	AfxGetApp()->WriteProfileInt("CpuWindow","CpuID",cpuid);
    char szT[64]; 
    char string[3];
	memset(szT,0,64);
	for( i=0;i<nCurRegs;i++)
	{
		strcat(szT,_itoa(RegSelect[i],string,10) );
		strcat(szT,"," );
	}
	AfxGetApp()->WriteProfileString("CpuWindow","CpuConfig",szT);
}