/***************************************************************************
**    $Header:   D:/ECB2S/SRC/LOG/CC.CPP   1.2.1.5   17 Apr 1997 15:42:58   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/CC.CPP  $
** 
**    Rev 1.2.1.5   17 Apr 1997 15:42:58   ZJRD
** No change.
** 
**    Rev 1.2.1.4   16 Apr 1997 10:17:26   ZJRD
** No change.
** 
**    Rev 1.2.1.3   10 Apr 1997 15:28:52   ZJRD
** 2.09F
** 
**    Rev 1.2.1.1   03 Apr 1997 15:10:18   ZJRD
** No change.
** 
**    Rev 1.2.1.0   28 Mar 1997 10:15:18   ZJRD
** easy pack sld 2.09d
** 
**    Rev 1.1   19 Mar 1997 11:26:30   ZJRD
** Easy Pack SLD 2.09c
**
**    $Header:   D:/ECB2S/SRC/LOG/CC.CPP   1.2.1.5   17 Apr 1997 15:42:58   ZJRD  $
**
**    $Log$
** 
**    Rev 1.3.1.0.1.2   09 Dec 1996 10:14:08   ZJRD
** EasyPack/SLD Version 2.0P
** 
**    Rev 1.3.1.0.1.0   11 Nov 1996 12:57:24   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.3.1.4   09 Sep 1996 13:13:22   ZJRD
** No change.
** 
**    Rev 1.3.1.3   05 Sep 1996 11:24:54   ZJRD
** No change.
** 
**    Rev 1.3.1.2   02 Sep 1996 09:52:00   ZJRD
** No change.
** 
**    Rev 1.3.1.1   28 Aug 1996 15:43:42   ZJRD
** EasyPack/SLD Version 1.9b
** 
**    Rev 1.3.1.0   12 Aug 1996 10:49:06   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.0   29 May 1996 09:35:32   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
// cc.cpp
//
// michael long
//                                                                           
// 5/15/96
//
/////////////////////////////////////////////////////////////////////////////
#include "stdafx.h"

#include "toolopt.h"
#include "cc.h"

/////////////////////////////////////////////////////////////////////////////
// diagnostic
#ifdef _DEBUG
void CCTool::Dump(CDumpContext &dc) const
{         
    CToolOption::Dump(dc);
    dc << "m_strMore = " << m_strMore << "\n";
    dc << "m_strPath = " << m_strPath << "\n"; 
     dc << "m_incPath = " << m_incPath << "\n";
}
#endif

/////////////////////////////////////////////////////////////////////////////
// operations
void CCTool::SetDefault(void)
{
    m_strMore = " ";
    m_strPath = "c:\\2500ad\\bin";
    m_incPath = "c:\\2500ad\\include"; 
}

BOOL CCTool::LoadOption(FILE * fp)
{
    ASSERT(fp);
    
    WORD wLen;
    if(fread(&wLen, 2, 1, fp) != 1)
        return FALSE;
    if(wLen > (WORD)32000)
        return FALSE;
        
    if(fread(m_strMore.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strMore.ReleaseBuffer(wLen);  
    if(fread(&wLen, 2, 1, fp) != 1)
        return FALSE;
    if(wLen > (WORD)32000)
        return FALSE;
        
    if(fread(m_strPath.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strPath.ReleaseBuffer(wLen);
    
    if(fread(&wLen, 2, 1, fp) != 1)
        return FALSE;
    if(wLen > (WORD)32000)
        return FALSE;
        
    if(fread(m_incPath.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_incPath.ReleaseBuffer(wLen);  
  
    return TRUE;
}                 

BOOL CCTool::SaveOption(FILE * fp)
{
    ASSERT(fp);
    
    WORD wLen = WORD(m_strMore.GetLength());           
    if(fwrite(&wLen, 2, 1, fp) != 1)
        return FALSE;
        
    if(fwrite(m_strMore.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strMore.ReleaseBuffer(wLen);  
    
    wLen = WORD(m_strPath.GetLength());           
    if(fwrite(&wLen, 2, 1, fp) != 1)
        return FALSE;
        
    if(fwrite(m_strPath.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;
                    
                    
    m_strPath.ReleaseBuffer(wLen);  
   
    wLen = WORD(m_incPath.GetLength());           
    if(fwrite(&wLen, 2, 1, fp) != 1)
        return FALSE;
        
    if(fwrite(m_incPath.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_incPath.ReleaseBuffer(wLen);  
   
    return TRUE;
}   
                            
CString CCTool::GetOption(void) const
{
    CString str = " ";
           
    str += m_strMore;
    str += " ";
    
    return str;     
}

