
/***************************************************************************
**
**    $Header:   D:/ECB2S/SRC/LOG/CPUREG.CPP   1.2.1.5   17 Apr 1997 15:43:46   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/CPUREG.CPP  $
** 
**    Rev 1.2.1.5   17 Apr 1997 15:43:46   ZJRD
** No change.
** 
**    Rev 1.2.1.4   16 Apr 1997 10:18:08   ZJRD
** 2.09F
** 
**    Rev 1.2.1.3   10 Apr 1997 15:29:30   ZJRD
** 2.09F
** 
**    Rev 1.2.1.1   03 Apr 1997 15:10:48   ZJRD
** No change.
** 
**    Rev 1.2.1.0   28 Mar 1997 10:15:48   ZJRD
** easy pack sld 2.09d
** 
**    Rev 1.1   19 Mar 1997 11:27:00   ZJRD
** Easy Pack SLD 2.09c
** 
**    Rev 1.0   12 Mar 1997 14:45:16   ZJRD
** Initial revision.
** 
**    Rev 1.7.1.0.1.2   09 Dec 1996 10:17:16   ZJRD
** EasyPack/SLD Version 2.0P
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 13:00:32   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:21:18   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:32:46   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 09:59:50   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:46:44   ZJRD
** No change.
** 
**    Rev 1.7.1.0   12 Aug 1996 10:51:38   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.5   05 Jun 1996 14:53:48   ZJRD
** No change.
** 
**    Rev 1.4   29 May 1996 09:32:44   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:03:56   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:12:48   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:27:42   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 13:01:24   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:38:24   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:51:22   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:05:48   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:35:16   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:49:34   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:15:44   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:12:38   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:13:18   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:40:14   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:22:16   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:13:10   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:14:36   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:13:26   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:11:18   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:34:42   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:22:26   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:27:46   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:31:18   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:27:52   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:41:06   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:06:48   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:51:12   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:44:58   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:31:20   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:47:14   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:21:34   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:52:40   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:55:10   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:47:32   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:55:00   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  CPUREG.CPP
//
//  Description:The implement file for the class: CRegisterDialog
//
//  Author:     Roger Zhang
//
//  Date:       04/20/95
//
//  Modification:
//
//      1. 04/20/95, Initial version 
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "resource.h"

#include "uicom.h"
#include "cpucom.h"
#include "cpureg.h"
#include "hosterrs.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif
                                 
/////////////////////////////////////////////////////////////////////////////
// the list for storing the register values that been entered before
#define MAX_RVAL_LIST   20                                                   

class CRegvalList : public CStringList                                 
{
public:        
    int m_nCount;           
    UINT m_Val[MAX_RVAL_LIST];
    CRegvalList() : m_nCount(0) {}  
    void AddNew(UINT uVal);
} ;                

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: Add new register value to the list
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CRegvalList::AddNew(UINT uVal)
{           
    int i;
    if(m_nCount < MAX_RVAL_LIST) {
        m_Val[m_nCount++] = uVal;
    } else {
        for(i = 1; i < MAX_RVAL_LIST; i++)  m_Val[i-1] = m_Val[i];
        m_Val[MAX_RVAL_LIST] = uVal;
    }
}

static CRegvalList RValList;                                 
/////////////////////////////////////////////////////////////////////////////
// CRegisterDialog dialog


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
CRegisterDialog::CRegisterDialog(int nRegIdx, CWnd* pParent /*=NULL*/)
 : m_nRegIdx(nRegIdx), CDialog(CRegisterDialog::IDD, pParent)
{
    //{{AFX_DATA_INIT(CRegisterDialog)
        // NOTE: the ClassWizard will add member initialization here
    //}}AFX_DATA_INIT
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CRegisterDialog::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CRegisterDialog)
        // NOTE: the ClassWizard will add DDX and DDV calls here
    //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CRegisterDialog, CDialog)
    //{{AFX_MSG_MAP(CRegisterDialog)
    ON_BN_CLICKED(IDC_REGISTER_DECRE, OnDecrement)
    ON_BN_CLICKED(IDC_REGISTER_INC, OnIncrement)
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CRegisterDialog message handlers

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL CRegisterDialog::OnInitDialog()
{
    CDialog::OnInitDialog();
    
    CenterWindow();
                  
    CString str("Register : ");
    str += RegName[m_nRegIdx];                  
    SetWindowText(str);
    
    char psz[256];
    wsprintf(psz, "0x%X", RegValue[m_nRegIdx]);
    SetDlgItemText(IDC_REGISTER_HEX, psz);
    if(nCpuRadix == CPU_HEX) {
        SetDlgItemText(IDC_REGISTER_VAL, psz);
        wsprintf(psz, "%u", RegValue[m_nRegIdx]);
        SetDlgItemText(IDC_REGISTER_DEC, psz); 
    } else {
        wsprintf(psz, "%u", RegValue[m_nRegIdx]);
        SetDlgItemText(IDC_REGISTER_DEC, psz); 
        SetDlgItemText(IDC_REGISTER_VAL, psz);
    }
        
    for(int i = 0; i < RValList.m_nCount; i ++) {
        if(nCpuRadix == CPU_HEX)
            wsprintf(psz, "0x%X", RValList.m_Val[RValList.m_nCount - i - 1]);
        else
            wsprintf(psz, "%u", RValList.m_Val[RValList.m_nCount - i - 1]);
        ((CComboBox *)GetDlgItem(IDC_REGISTER_VAL))->AddString(psz);        
    }
                
    ((CComboBox *)GetDlgItem(IDC_REGISTER_VAL))->SetFocus();

    return FALSE;                     
//    return TRUE;  // return TRUE  unless you set the focus to a control
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CRegisterDialog::OnDecrement()
{
    // TODO: Add your control notification handler code here
    char pch[256];                    
    DWORD dw;
    WORD w;
    
    int i, l = GetDlgItemText(IDC_REGISTER_VAL, pch, 255);
    if(!Str2Num(pch, dw)) {
        ErrDisplayError(ER_PRE_REG_VALUE);       
        ((CComboBox *)GetDlgItem(IDC_REGISTER_VAL))->SetFocus();
        return;
    }
    w=dw;
    -- w;
    for(i = 0; i < l; i ++)
        if(pch[i] == 'x' || pch[i] == 'X')  break;
    if(i < l)   wsprintf(pch, "0x%X", w);
    else wsprintf(pch, "%u", w);
    SetDlgItemText(IDC_REGISTER_VAL, pch);
    ((CComboBox *)GetDlgItem(IDC_REGISTER_VAL))->SetFocus();
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CRegisterDialog::OnIncrement()
{
    // TODO: Add your control notification handler code here
    
    char pch[256];                    
    DWORD dw;
    WORD w;
    
    int i, l = GetDlgItemText(IDC_REGISTER_VAL, pch, 255);
    if(!Str2Num(pch, dw)) {
        ErrDisplayError(ER_PRE_REG_VALUE);       
        ((CComboBox *)GetDlgItem(IDC_REGISTER_VAL))->SetFocus();
        return;
    }
    w=dw;
    ++ w;
    for(i = 0; i < l; i ++)
        if(pch[i] == 'x' || pch[i] == 'X')  break;
    if(i < l)   wsprintf(pch, "0x%X", w);
    else wsprintf(pch, "%u", w);
    SetDlgItemText(IDC_REGISTER_VAL, pch);
    ((CComboBox *)GetDlgItem(IDC_REGISTER_VAL))->SetFocus();
}


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CRegisterDialog::OnOK()
{
    // TODO: Add extra validation here
    char pch[256];                    
    DWORD dw;
    
    GetDlgItemText(IDC_REGISTER_VAL, pch, 255);
    if(!Str2Num(pch, dw) || (dw > (DWORD)0xFF && m_nRegIdx > 1) ||
        (dw > (DWORD)0xFFFF && m_nRegIdx < 2)) {
        ErrDisplayError(ER_PRE_REG_VALUE);       
        ((CComboBox *)GetDlgItem(IDC_REGISTER_VAL))->SetFocus();
        return;
    }
    else {                              
        #ifdef _ZLR_
        if(CpuSetRegfromWnd(m_nRegIdx, UINT(dw)))
        {
            CpuGetAllReg();
            ASSERT(isCpuOn);
            isCpuOn=FALSE;
            OnEmulation();
            isCpuOn=TRUE;
        }
        #else
            RegValue[m_nRegIdx] = UINT(dw);            
        #endif
        RValList.AddNew(RegValue[m_nRegIdx]);
        CDialog::OnOK();
    }
}

/////////////////////////////////////(EOF)///////////////////////////////////
