
/***************************************************************************
**
**    $Header$
**
**    $Log$
** 
****************************************************************************/

/***************************************************************************
**
** File name : abibase.h
**
** Description: define base data types which are used in ABI 
**
** Programmer: John 1997.1 for TW ABI
**
**
**    Copyright (C) 1997 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/

#ifndef _ABIBASE_
#define _ABIBASE_
//temp, must be removed lator
#define MEM_NORMAL 1
#define MEM_SFR 2
#define MEM_R 3



//typedef WORD STATUS;
typedef int STATUS;
typedef BYTE FLAG;          
typedef unsigned char U8;
typedef unsigned char UCHAR;
typedef unsigned short U16;
typedef unsigned long U32;
typedef char S8;
typedef short S16;
typedef long S32;
typedef int REG_MODE;
typedef int DIAG_ID;

const int BASE_TIME = 10000;

/* All ABI routines Return codes */
	#define ICE_OK                        0    /* Normal return */
	#define ICE_MICE_HALT              ( -1)   /* Target CPU halted */
	#define ICE_MEM_GUARD              ( -2)   /* Access the guarded memory */
	#define ICE_MEM_PROTECT            ( -3)   /* Access the protected memory */
	#define ICE_ERROR_READ             ( -4)   /* Memory read failure */
	#define ICE_ERROR_WRITE            ( -5)   /* Memory write failure */
	#define ICE_STEP_ERROR             ( -6)   /* Target cnnot step */
	#define ICE_NO_DIFF                ( -7)   /* No difference in memory compare 							     */
	#define ICE_NO_FOUND               ( -8)   /* Not found in memory search */
	#define ICE_BREAK                  ( -9)   /* Break on memory access */
	#define ICE_BREAK_I                (-10)   /* Break on instruction fetch */
	#define ICE_BAD_REG                (-11)   /* Bad register number encountered 							     */
	#define ICE_BAD_IN                 (-12)   /* Error encountered on user input 							     */
	#define ICE_HALT_USER              (-13)   /* user pressed ^C */
	#define ICE_ERROR_COM              (-14)   /* communication error */
	#define ICE_ERROR_MICE             (-15)   /* linking incorrect MICE model */
	#define ICE_MICE_LIMIT             (-16)   /* MICE limitation */
	#define ICE_BUS_REQUEST            (-17)   /* Bus request */
	#define ICE_BAD_FRAME              (-18)   /* invalid frame number */
	#define ICE_ERROR_BOUN             (-19)   /* error map boundary */
	#define ICE_MAP_FAIL               (-20)   /* memory map fail */
	#define ICE_ABS_OVERFLOW           (-21)   /* abs address overflow */
	#define ICE_TEST_FAIL              (-22)   /* test failure */
	#define ICE_CPU_RUN                (-23)   /* CPU free running */
	#define ICE_BROKE                  (-24)   /* CPU stop */
	#define ICE_NOT_READY              (-25)   /* target is not ready */
	#define ICE_COMMAND_ERROR          (-26)   /*  */
	#define ICE_TIME_OUT               (-27)   /*  */
	#define ICE_NO_TRACE_MODULE        (-28)   /*  */
	#define ICE_BKPT1_HALT             (-29)   /*  */
	#define ICE_BKPT2_HALT             (-30)   /*  */
	#define ICE_VIOL_HALT              (-31)   /*  */
	#define ICE_RBW_HALT               (-32)   /*  */
	#define ICE_TRIG_HALT              (-33)   /*  */
	#define ICE_LINK_MICE_FAIL         (-34)   /*  */
	#define ICE_WARN_START             (-35)   /*  */
	#define ICE_BANK_FULL              (-36)
	#define ICE_ADDR_RANGE_OVERFLOW    (-37)
	#define ICE_ATTRIBUTE_MISMATCH     (-38)
	#define ICE_BANK_MISMATCH          (-39)
	#define ICE_SPACE_MISMATCH         (-40)
	#define ICE_ADDR_MISMATCH          (-41)
	#define ICE_NO_VCC                 (-42) 
	#define ICE_USER_CC                (-43)
	#define ICE_TARGET_RESET           (-44)
	#define ICE_NO_EMM                 (-45)
	#define ICE_CNT_ERROR              (-46)
	#define ICE_TIMER_ERROR            (-47)
	#define ICE_EVENT_FULL             (-48)
	#define ICE_BUFFER_EMPTY           (-49)
	#define ICE_EMM_SET_ERROR          (-50)
	#define ICE_EP_PENDING             (-51)
	#define ICE_REC_TIME_OUT           (-52)
	#define ICE_INVALID_CPU            (-53) 
	#define ICE_MCE16A_FAIL            (-54)
	#define ICE_EMM_FAIL               (-55)
	#define ICE_TRACE_BOARD_FAIL       (-56)
	#define ICE_COV_RBW_FAIL           (-57)
	#define ICE_CPU_FLY                (-58)
	#define ICE_INVALID_FLY_COMMAND    (-59)
	#define ICE_INVALID_FIRMWARE       (-60) 
    #define ICE_FLASH_EREASE_FAIL	   (-61)
    #define ICE_FLASH_PROG_FAIL	  	   (-62)
    #define ICE_FLASH_SWITCH_FAIL	   (-63)
    #define ICE_NO_MATCH	  		   (-64)
    //97.2
    #define ICE_IDLE				   (-65)
    #define ICE_POWERDOWN			   (-66)
    #define ICE_SLEEPING			   (-67)
    //97.2 for JED
    #define ICE_JED_CHECK_DEVICE_ERROR (-68)
    #define ICE_JED_CHECK_DATA_ERROR (-69)
    #define ICE_JED_PROGRAME_VERIFY_ERROR (-70)
    //97.5 for diagnostic
    #define ICE_ERR_STOP_BY_USER (-81)
	#define	ICE_ERR_NOT_READY_FOR_DIAGNOSTIC (-82)


         
#endif
