/***************************************************************************
**
**    $Header$
**
**    $Log$
** 
****************************************************************************/

/***************************************************************************
**
** File name : abicore.cpp
**
** Description: 
**
** Modification:
**
** Programmer: john 1997.1.10
**
**    Copyright (C) 1996 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/
#include "stdafx.h"
#include "abicore.h"
//globle value
extern CBaseAbi* pAbi; 
//implemention of class CTWAbi
STATUS CTWAbi::emuChecksum(ADDR addr, U32 len, U16 *n,RET_ADDR* retAddr)
{ 
	STATUS status;
	m_Pipe.StartVar(CHECKSUM);
	m_Pipe.SaveVar(addr);
	m_Pipe.SaveVar(len);
	m_Pipe.EndVar(END_CODE);
		
	status = Start();
	
	if(ICE_ERROR_COM != status) { 	
		m_Pipe.LoadVar(*n);
		m_Pipe.LoadVar(*retAddr);
	}
	return status;
 }
 
STATUS CTWAbi::emuCompare(ADDR addr1, U32 len, ADDR addr2, RET_ADDR *findAddr1, RET_ADDR *findAddr2)
{ 
	STATUS status;
	m_Pipe.StartVar(COMPARE);
	m_Pipe.SaveVar(addr1);
	m_Pipe.SaveVar(len);  
	m_Pipe.SaveVar(addr2);
	m_Pipe.EndVar(END_CODE);
		
	status = Start(5*BASE_TIME);
	
	if(ICE_ERROR_COM != status) { 		
		m_Pipe.LoadVar(*findAddr1);
		m_Pipe.LoadVar(*findAddr2);
	}	
	return status;
 }

STATUS CTWAbi::emuCopy(ADDR addr1, U32 len, ADDR addr2,RET_ADDR* addrRet1,
                       RET_ADDR* addrRet2)
{                 
	STATUS status;
	m_Pipe.StartVar(COPY);
	m_Pipe.SaveVar(addr1);
	m_Pipe.SaveVar(len);  
	m_Pipe.SaveVar(addr2);
	m_Pipe.EndVar(END_CODE);
		
	status = Start(3*BASE_TIME);

	if(ICE_ERROR_COM != status) { 		   
		m_Pipe.LoadVar(*addrRet1);
		m_Pipe.LoadVar(*addrRet2);
	}	
	return status;
 }
                            
STATUS CTWAbi::emuFill(ADDR addr, U32 len, U16 patternLen, U8 *buff,
                            RET_ADDR* retAddr)
{ 
    WORD status;
	m_Pipe.StartVar(FILL_COMMAND);
	m_Pipe.SaveVar(addr);
	m_Pipe.SaveVar(len);  
	m_Pipe.SaveVar(patternLen);
	m_Pipe.SetVar((BYTE*)buff,(int)patternLen);
	m_Pipe.EndVar(END_CODE);
		
	status = Start();                       
	
	if(ICE_ERROR_COM != status) { 		   	
		m_Pipe.LoadVar(*retAddr);
	}	
	return status;
 }
                            
STATUS CTWAbi::emuGetAllReg(U32 *cpuReg)
{ 
	WORD status;                       
	int nPoint = 0;
	BYTE bLen = 0;
	
	int nAbiType[] = {GET_ALL_REG,  GET_ALL_REG2, 
					  GET_ALL_REG3, GET_ALL_REG4};
    
    for (int i=0; i<4; i++){
		m_Pipe.StartVar(nAbiType[i]);
		m_Pipe.EndVar(END_CODE);
			
		status = Start();
		if(ICE_OK != status) return status;     
		
		m_Pipe.LoadBuffer((BYTE*)(&(cpuReg[nPoint])),bLen);
		if (bLen == 0) break;
	    
		nPoint += bLen/sizeof(U32);
	}
    	
    	
/*					  
	//get reg section 1
	m_Pipe.StartVar(GET_ALL_REG);
	m_Pipe.EndVar(END_CODE);
		
	status = Start();
	if(ICE_OK != status) return status;
	m_Pipe.LoadBuffer((BYTE*)(&(cpuReg[nPoint])),bLen);
	
	//get reg section 2                       
	nPoint += bLen/sizeof(U32);
	m_Pipe.StartVar(GET_ALL_REG2);
	m_Pipe.EndVar(END_CODE);
			
	status = Start();
	if(ICE_OK != status) return status;
	m_Pipe.LoadBuffer((BYTE*)(&(cpuReg[nPoint])),bLen);
	
	//get reg section 3                       
	nPoint += bLen/sizeof(U32);
	m_Pipe.StartVar(GET_ALL_REG3);
	m_Pipe.EndVar(END_CODE);
		
	status = Start();
	if(ICE_OK != status) return status;
	m_Pipe.LoadBuffer((BYTE*)(&(cpuReg[nPoint])),bLen);
	
	//get reg section 4                       
	nPoint += bLen/sizeof(U32);
	m_Pipe.StartVar(GET_ALL_REG4);
	m_Pipe.EndVar(END_CODE);
		
	status = Start();
	if(ICE_OK != status) return status;
	m_Pipe.LoadBuffer((BYTE*)(&(cpuReg[nPoint])),bLen);
*/
		
	return status;
 }

STATUS CTWAbi::emuGetCpuStatus(U32 *cpuStatus)
{ 
	STATUS status;
	m_Pipe.StartVar(GET_CPU_STATUS);
	m_Pipe.EndVar(END_CODE);
		
	status = Start();

	if(ICE_OK == status) { 		   
		m_Pipe.LoadVar(*cpuStatus);
	}	
	return status;
 }

STATUS CTWAbi::emuGetID(U8 *ID_Info)
{ 
	STATUS status;
	m_Pipe.StartVar(GET_ID);
	m_Pipe.EndVar(END_CODE);
		
	status = Start();

	if(ICE_OK == status) { 		   
		m_Pipe.LoadBuffer((BYTE*)ID_Info);
	}	
	return status;
 }

STATUS CTWAbi::emuGetMap(ADDR addrStart,ADDR addrEnd,MAP_INFO *mapData)
{ 
    
    STATUS status;
    m_Pipe.StartVar(GET_MAP);
    m_Pipe.SaveVar(addrStart);	
	m_Pipe.SaveVar(addrEnd);
	m_Pipe.EndVar(END_CODE);
	status = Start();

	if(ICE_OK == status) { 		   
		m_Pipe.LoadVar(*mapData);
	}	
	return status;
 }

STATUS CTWAbi::emuGetMemN(ADDR addr, U16 len ,U8 *buff,RET_ADDR* retAddr)
{                        
	if(len<=128) {
	ASSERT(len<=128);
	STATUS status; 
	
	m_Pipe.StartVar(READ_MEM_N);
	m_Pipe.SaveVar(addr);
	m_Pipe.SaveVar(len);
	m_Pipe.EndVar(END_CODE);
			
	status = Start();
		
    if(ICE_ERROR_COM == status) return status;
	//if(ICE_OK == status) { 		   
		m_Pipe.GetVar((BYTE*)buff,len);
	//} else {                     
		m_Pipe.LoadVar(*retAddr);
		return status;
	//}    
	
	return status;
	} else {          
    STATUS status;   
    U16 nTmpLen = 0;     
    U16 CONSTLEN = 0x78;
    //len max is 0x7f
    
    for(int i=0; i<len/0x78; i++ ) {
		m_Pipe.StartVar(READ_MEM_N);
		m_Pipe.SaveVar(addr);
		m_Pipe.SaveVar(CONSTLEN);
		m_Pipe.EndVar(END_CODE);
			
		status = Start();
		
	    if(ICE_ERROR_COM == status) return status;
		//if(ICE_OK == status) { 		   
			m_Pipe.GetVar((BYTE*)(&(buff[nTmpLen])),CONSTLEN);
			nTmpLen += CONSTLEN;
			addr.addr += CONSTLEN;
		//} else {                     
			m_Pipe.LoadVar(*retAddr);
			return status;
		//}
	}	
	
	if(0 != (len%0x78) ) {
		m_Pipe.StartVar(READ_MEM_N);
		m_Pipe.SaveVar(addr);           
		CONSTLEN = len%0x78;
		m_Pipe.SaveVar(CONSTLEN);
		m_Pipe.EndVar(END_CODE);
			
		status = Start();
		
	    if(ICE_ERROR_COM == status) return status;
		//if(ICE_OK == status) { 		   
			CONSTLEN = len%0x78;
			m_Pipe.GetVar((BYTE*)(&(buff[nTmpLen])),CONSTLEN);
		//} else {                     
			m_Pipe.LoadVar(*retAddr);
		//}
	}
		
	return status;
	}
 }

STATUS CTWAbi::emuGetReg(REG_MODE regMode, S16 regId,U32 *content)
{                 
	STATUS status;
	m_Pipe.StartVar(GET_REG);
	m_Pipe.SaveVar(regMode);
	m_Pipe.SaveVar(regId);
	m_Pipe.EndVar(END_CODE);
		
	status = Start();

	if(ICE_OK == status) { 		   
		m_Pipe.LoadVar(*content);
	}	
	return status;
 }                

STATUS CTWAbi::emuSetReg(REG_MODE regMode, S16 regId,U32 content)
{                 
	STATUS status;
	m_Pipe.StartVar(SET_REG);
	m_Pipe.SaveVar(regMode);
	m_Pipe.SaveVar(regId);
	m_Pipe.SaveVar(content);
	m_Pipe.EndVar(END_CODE);
		
	status = Start();

	return status;
 }                

STATUS CTWAbi::emuGetVerify(U16 *verifyFlag)
{ 
    STATUS status;
	m_Pipe.StartVar(GET_VERIFY);
	m_Pipe.EndVar(END_CODE);
		
	status = Start();

	if(ICE_OK == status) { 		   
		m_Pipe.LoadVar(*verifyFlag);
	}	
	return status;
 }

STATUS CTWAbi::emuGo(U16 mode,ADDR fromAddr,ADDR tillAddr)
{ 
	STATUS status;
	m_Pipe.StartVar(GO_COMMAND);
	m_Pipe.SaveVar(mode);
	m_Pipe.SaveVar(fromAddr);
	m_Pipe.SaveVar(tillAddr);
	m_Pipe.EndVar(END_CODE);
		
	status = Start();

	return status;
 }

STATUS CTWAbi::emuReset(ADDR addr)
{ 
	STATUS status;
	m_Pipe.StartVar(RESET);
	m_Pipe.SaveVar(addr);
	m_Pipe.EndVar(END_CODE);
		
	status = Start();

	return status;

 }

STATUS CTWAbi::emuSearch(ADDR addr, U32 len, U8 *buff, U16 patternLen,U8 caseFlag,RET_ADDR* retAddr)
{ 
    STATUS status;
	m_Pipe.StartVar(SEARCH);
	m_Pipe.SaveVar(addr);
	m_Pipe.SaveVar(len);      
    m_Pipe.SaveVar(patternLen);                
	m_Pipe.SetVar((BYTE*)buff,(int)patternLen);
	m_Pipe.SaveVar(caseFlag); 
	m_Pipe.EndVar(END_CODE);
		
	status = Start(3*BASE_TIME);
	
    if(ICE_ERROR_COM != status) {
    	m_Pipe.LoadVar(*retAddr);
    }
	return status;

 }

STATUS CTWAbi::emuSetBp(ADDR addr)
{ 
	STATUS status;
	m_Pipe.StartVar(SET_BP);
	m_Pipe.SaveVar(addr);
	m_Pipe.EndVar(END_CODE);
		
	status = Start();

	return status;
 }

STATUS CTWAbi::emuGetBp(ADDR addr1, ADDR addr2, ADDR* bpAddr)
{ 
	STATUS status;
	m_Pipe.StartVar(GET_BP);
	m_Pipe.SaveVar(addr1);
	m_Pipe.SaveVar(addr2);
	m_Pipe.EndVar(END_CODE);
		
	status = Start();
	
    if(ICE_ERROR_COM != status) {
    	m_Pipe.LoadVar(*bpAddr);
    }
    
	return status;
 }

STATUS CTWAbi::emuSetID(U16 idFlag)
{ 
	STATUS status;
	m_Pipe.StartVar(SET_ID);
	m_Pipe.SaveVar(idFlag);
	m_Pipe.EndVar(END_CODE);
		
	status = Start();

	return status;
 }

STATUS CTWAbi::emuSetMap(ADDR addr1, ADDR addr2, U16 attrib)
{ 
	STATUS status;
	m_Pipe.StartVar(SET_MAP);
	m_Pipe.SaveVar(addr1);
	m_Pipe.SaveVar(addr2); 
	m_Pipe.SaveVar(attrib);
	m_Pipe.EndVar(END_CODE);
		
	status = Start();

	return status;
 }

STATUS CTWAbi::emuSetMemN(ADDR addr, U8 *buff, U16 patternLen,RET_ADDR* retAddr)
{ 
	ASSERT(patternLen<=128);
	STATUS status;
	
	m_Pipe.StartVar(SET_MEM_N);
	m_Pipe.SaveVar(addr);      
	m_Pipe.SaveVar(patternLen);      
	m_Pipe.SetVar((BYTE*)buff,patternLen);
	m_Pipe.EndVar(END_CODE); 
			
	status = Start();
		
    if(ICE_ERROR_COM != status) {
		m_Pipe.LoadVar(*retAddr);
		return status;
	}  
/*
	STATUS status;
	U16 nTmpLen = 0; 
	U16 CONSTLEN = 0x78;
	for(int i=0;i<patternLen/0x78;i++) {
		m_Pipe.StartVar(SET_MEM_N);
		m_Pipe.SaveVar(addr);      
		m_Pipe.SetVar((BYTE*)(&(buff[nTmpLen])),CONSTLEN);
		m_Pipe.EndVar(END_CODE); 
		nTmpLen += CONSTLEN;
		addr.addr += CONSTLEN;
			
		status = Start();
		
	    if(ICE_ERROR_COM != status) {
			m_Pipe.LoadVar(*retAddr);
			return status;
		}	
	}	
	
	if(0 != patternLen%0x78) {
		m_Pipe.StartVar(SET_MEM_N);
		m_Pipe.SaveVar(addr);                           
		CONSTLEN = patternLen%0x78;
		m_Pipe.SetVar((BYTE*)(&(buff[nTmpLen])),CONSTLEN);
		m_Pipe.EndVar(END_CODE); 
			
		status = Start();
		
	    if(ICE_ERROR_COM != status) {
			m_Pipe.LoadVar(*retAddr);
			return status;
		}
	}*/
	return status;
 }

STATUS CTWAbi::emuSetVerify(U16 verifyFlag)
{ 
	STATUS status;
	m_Pipe.StartVar(SET_VERIFY);
	m_Pipe.SaveVar(verifyFlag);
	m_Pipe.EndVar(END_CODE);
		
	status = Start();

	return status;
 }

STATUS CTWAbi::emuTest(ADDR addr1, U32 len,RET_ADDR* retAddr)
{                 
	STATUS status;
	m_Pipe.StartVar(TEST);
	m_Pipe.SaveVar(addr1);
	m_Pipe.SaveVar(len);
	m_Pipe.EndVar(END_CODE);
		
	status = Start();
	
    if(ICE_ERROR_COM != status) {
		m_Pipe.LoadVar(*retAddr);
	}	
	return status;
 }

STATUS CTWAbi::emuGetFWSupport(U16 * wCpuNum,U16* wCpuType)
{ 
	STATUS status;
	m_Pipe.StartVar(GET_FW_SUPPORT);
	m_Pipe.EndVar(END_CODE);
		
	status = Start();
	
    if(ICE_OK == status) {
		m_Pipe.LoadVar(*wCpuNum);
		m_Pipe.GetVar((BYTE*)wCpuType,(*wCpuNum)*sizeof(U16));
	}	
	return status;

 }

STATUS CTWAbi::emuClrBp(ADDR addr)
{ 
	STATUS status;
	m_Pipe.StartVar(CLR_BP);
	m_Pipe.SaveVar(addr);
	m_Pipe.EndVar(END_CODE);
		
	status = Start();

	return status;
 }

STATUS CTWAbi::emuClrEvent(U16 evId)
{ 
	STATUS status;
	m_Pipe.StartVar(CLR_EVENT);
	m_Pipe.SaveVar(evId);
	m_Pipe.EndVar(END_CODE);
		
	status = Start();
	
	return status;

 }

STATUS CTWAbi::emuClrAllEvent()
{ 
	STATUS status;
	m_Pipe.StartVar(CLEAR_ALL_EVENT);
	m_Pipe.EndVar(END_CODE);
		
	status = Start();
	
	return status;

 }

STATUS CTWAbi::emuGetTrigger(U8 *byTrigStatus,
                     U8 *byLv1Status, TRIGGER_LEVEL* pLv1,
                     U8 *byLv2Status, TRIGGER_LEVEL* pLv2,
                     TRIGGER_LOGIC* pTrigLogic)
{ 
	STATUS status;
	m_Pipe.StartVar(GET_TRIG);
	m_Pipe.EndVar(END_CODE);
		
	status = Start();
	
    if(ICE_OK == status) {
		m_Pipe.LoadVar(*byTrigStatus);
		m_Pipe.LoadVar(*byLv1Status);
		m_Pipe.LoadVar(*pLv1);
		m_Pipe.LoadVar(*byLv2Status);
		m_Pipe.LoadVar(*pLv2);
		m_Pipe.LoadVar(*pTrigLogic);
	}	
	return status;

 }

STATUS CTWAbi::emuGetEvent(U8 *byControl, U8 *byEv3,BUS_EVENT *pEv1, BUS_EVENT *pEv2)
{ 
	STATUS status;
	m_Pipe.StartVar(GET_EVENT);
	m_Pipe.EndVar(END_CODE);
		
	status = Start();
	
    if(ICE_OK == status) {
		m_Pipe.LoadVar(*byControl);
		m_Pipe.LoadVar(*byEv3);
		m_Pipe.LoadVar(*pEv1);
		m_Pipe.LoadVar(*pEv2);

	}	
	return status;

 }

STATUS CTWAbi::emuGetTraceDepth(U16 bufID,BUFFER_DEPTH *traceDepth)
{ 
	STATUS status;
	m_Pipe.StartVar(GET_DEPTH);
	m_Pipe.SaveVar(bufID);
	m_Pipe.EndVar(END_CODE);
		
	status = Start();
	
    if(ICE_OK == status) {
		m_Pipe.LoadVar(*traceDepth);
	}	
	return status;

 }
//not ok
STATUS CTWAbi::emuListTraceBuff(U32 dwStartFrame,
				            U32 dwLen, QUALIFY_INFO *qualifyInfo,
				          	U8 *frameLen,TRACE_INFO *traceInfo,
							U8 *readEnd)
{ 
	STATUS status;
	m_Pipe.StartVar(LIST_TRACE);
	m_Pipe.SaveVar(dwStartFrame);  
	m_Pipe.SaveVar(dwLen);   
	m_Pipe.SaveVar(*qualifyInfo);   
	m_Pipe.EndVar(END_CODE);
		
	status = Start(BASE_TIME*2);
	
    if(ICE_OK == status) {
    	int i = 0;       
    	BYTE bTmp;
    	m_Pipe.LoadVar(*frameLen);
    	for(int j=0;j<6;j++) {
    		m_Pipe.LoadBuffer((BYTE*)(&(traceInfo[i])),bTmp);
    		i = i + bTmp/sizeof(TRACE_INFO);
    	}
    	m_Pipe.LoadVar(*readEnd);
	}	
	return status;

 }
							
STATUS CTWAbi::emuSetEvent(U16 evId, BUS_EVENT *busEventData)
{ 
	STATUS status;
	m_Pipe.StartVar(SET_EVENT);
	m_Pipe.SaveVar(evId);
	m_Pipe.SaveVar(*busEventData);
	m_Pipe.EndVar(END_CODE);
		
	status = Start(BASE_TIME*3);
	return status;
 }

STATUS CTWAbi::emuSetExtEvent(U16 evData)
{ 
	STATUS status;
	m_Pipe.StartVar(SET_EXT_EVENT); 
	m_Pipe.SaveVar(evData);
	m_Pipe.EndVar(END_CODE);
		
	status = Start();
	
	return status;

 }

STATUS CTWAbi::emuSetTrigLogic(TRIGGER_LOGIC* trigLogicData)
{ 
	STATUS status;
	m_Pipe.StartVar(SET_TRIG);
	m_Pipe.SaveVar(*trigLogicData);	
	m_Pipe.EndVar(END_CODE);
		
	status = Start();
	
	return status;

 }

STATUS CTWAbi::emuSetQualify(QUALIFY* qualifyData)
{ 
	STATUS status;
	m_Pipe.StartVar(SET_QUALIFY);   
	m_Pipe.SaveVar(*qualifyData);
	m_Pipe.EndVar(END_CODE);
		
	status = Start(BASE_TIME*3);
	
	return status;

 }

STATUS CTWAbi::emuClearQualify()
{ 
	STATUS status;
	m_Pipe.StartVar(CLEAR_QUALIFY);
	m_Pipe.EndVar(END_CODE);
		
	status = Start();
	
	return status;

 }

STATUS CTWAbi::emuSetTrigLevel(int levelId, TRIGGER_LEVEL* trigLevelData)
{ 
	STATUS status;
	m_Pipe.StartVar(SET_LEVEL);  
	m_Pipe.SaveVar(levelId);
	m_Pipe.SaveVar(*trigLevelData);
	m_Pipe.EndVar(END_CODE);
		
	status = Start();
	
	return status;

 }

STATUS CTWAbi::emuSetTriggerStatus(U8 triggerFlag)
{ 
	STATUS status;
	m_Pipe.StartVar(SET_TRIGGER_STATUS);
	m_Pipe.SaveVar(triggerFlag);
	m_Pipe.EndVar(END_CODE);
		
	status = Start();
	
	return status;

 }

STATUS CTWAbi::emuSetTraceStatus (U8 tracerFlag)
{ 
	STATUS status;
	m_Pipe.StartVar(SET_TRACE_STATUS);
	m_Pipe.SaveVar(tracerFlag);
	m_Pipe.EndVar(END_CODE);
		
	status = Start();
	
	return status;

 }

STATUS CTWAbi::emuAbort()
{ 
	STATUS status;
	m_Pipe.StartVar(ABORT);
	m_Pipe.EndVar(END_CODE);
		
	status = Start();
	
	return status;

 }
 
STATUS CTWAbi::emuGetControl(U16 *signals) 
{
	STATUS status;
	m_Pipe.StartVar(GET_CONTROL);
	m_Pipe.EndVar(END_CODE);
		
	status = Start();
	
    if(ICE_OK == status) {
		m_Pipe.LoadVar(*signals);
	}	
	return status;

 }
 
STATUS CTWAbi::emuInput(U16 port, U16 len, U16 size, U8 *buff)
{
	STATUS status;
	m_Pipe.StartVar(INPUT);
	m_Pipe.SaveVar(port);  
	m_Pipe.SaveVar(len);
	m_Pipe.SaveVar(size);  
	m_Pipe.EndVar(END_CODE);
		
	status = Start();
	
    if(ICE_OK == status) {
		m_Pipe.LoadVar(*buff);
	}	
	return status;

 }

STATUS CTWAbi::emuOutput (U16 port, U8 *buff , U16 len, U16 size) 
{
	STATUS status;
	m_Pipe.StartVar(OUTPUT);
	m_Pipe.SaveVar(port);  
	m_Pipe.SaveVar(*buff);  
	m_Pipe.SaveVar(len);  
	m_Pipe.SaveVar(size);  
	m_Pipe.EndVar(END_CODE);
		
	status = Start();
	
	return status;

 }

STATUS CTWAbi::emuSetControl(U16 signals) 
{ 
	STATUS status;
	m_Pipe.StartVar(SET_CONTROL);
	m_Pipe.SaveVar(signals);  
	m_Pipe.EndVar(END_CODE);
		
	status = Start();
	
	return status;

 }

STATUS CTWAbi::emuStepOne()
{
	STATUS status;
	m_Pipe.StartVar(STEP_ONE);
	m_Pipe.EndVar(END_CODE);
		
	status = Start();
	
	return status;

 }

STATUS CTWAbi::emuStepOver() 
{
	STATUS status;
	m_Pipe.StartVar(STEP_OVER);
	m_Pipe.EndVar(END_CODE);
		
	status = Start();
	
	return status;

 }

STATUS CTWAbi::emuEreaseFlash(U32 bankNo,RET_ADDR* addr) 
{
	STATUS status;
	m_Pipe.StartVar(EREASE_FLASH);
	m_Pipe.SaveVar(bankNo);  
	m_Pipe.EndVar(END_CODE);
		
	status = Start();
	
    if(ICE_ERROR_COM != status) {
		m_Pipe.LoadVar(*addr);
	}	
	return status;

 }

STATUS CTWAbi::emuProgFlash(U8 dataLen, U8 bOptionBankLowOrHigh,U16 startAddr, U8 *dataContent) 
{ 
	STATUS status;
	m_Pipe.StartVar(PROG_FLASH);    
	m_Pipe.SaveVar(dataLen);  
	m_Pipe.SaveVar(bOptionBankLowOrHigh);//SEND 0 (LOW 64K)REQUIRE KOO
	m_Pipe.SaveVar(startAddr);  
	m_Pipe.SetVar((BYTE*)dataContent,dataLen);  
	m_Pipe.EndVar(END_CODE);
		
	status = Start();
	/*
    if(ICE_ERROR_COM != status) {
		m_Pipe.LoadVar(*addr);
	}*/	
	return status;

 }

STATUS CTWAbi::emuSwitchFlash()
{ 
	STATUS status;
	m_Pipe.StartVar(SWITCH_FLASH);
	m_Pipe.EndVar(END_CODE);
		
	status = Start();
	
	return status;

 }

STATUS CTWAbi::emuFillFlashBland(ADDR addr1, ADDR addr2, U8 blankValue,RET_ADDR* retAddr) 
{ 
	STATUS status;
	m_Pipe.StartVar(FILL_FLASH_BLANK);
	m_Pipe.SaveVar(addr1);  
	m_Pipe.SaveVar(addr2);  
	m_Pipe.SaveVar(blankValue);  
	m_Pipe.EndVar(END_CODE);
		
	status = Start();
	
    if(ICE_ERROR_COM != status) {
		m_Pipe.LoadVar(*retAddr);
	}	
	return status;

 }

STATUS CTWAbi::emuFwInit()
{
	STATUS status;
	m_Pipe.StartVar(FW_INIT);
	m_Pipe.EndVar(END_CODE);
		
	status = Start();
	
	return status;

 }

//implemention of class CSimulatorAbi
STATUS CSimulatorAbi::emuChecksum(ADDR addr, U32 len, U16 *n,RET_ADDR* )
{                                  
	ADDR addrTmp;
	addrTmp.addr = addr.addr+len-1;
	addrTmp.addrType = addr.addrType;
    if (pMemSim->GetCheckSum(addr,addrTmp,(WORD*)n)) return ICE_OK;
	else return ICE_STEP_ERROR;
 }

STATUS CSimulatorAbi::emuCompare(ADDR addr1, U32 len, ADDR addr2, RET_ADDR *findAddr1, RET_ADDR *)
{
	ADDR addrTmp;
	addrTmp.addr = addr1.addr+len-1;
	addrTmp.addrType = addr1.addrType;
    int status = pMemSim->CompareMem(addr1,addrTmp,addr2,&addrTmp);
    findAddr1->addr = addrTmp.addr;
    findAddr1->addrType= addrTmp.addrType;
    return (STATUS)status;
 }

STATUS CSimulatorAbi::emuCopy(ADDR addr1, U32 len, ADDR addr2,RET_ADDR*,
                                   RET_ADDR*)
{
	ADDR addrTmp;
	addrTmp.addr = addr1.addr+len-1;
	addrTmp.addrType = addr1.addrType;
	if (pMemSim->CopyMem(addr1,addrTmp,addr2)) return ICE_OK;
	else return ICE_STEP_ERROR;
 }
                                   
STATUS CSimulatorAbi::emuFill(ADDR addr, U32 len, U16 patternLen, U8 *buff,
                                   RET_ADDR* )
{
	ADDR addrTmp;
	addrTmp.addr = addr.addr+len-1;
	addrTmp.addrType = addr.addrType;
	if (pMemSim->FillMem(addr,addrTmp,buff,patternLen)) return ICE_OK;
	else return ICE_STEP_ERROR;
 }
                                   
STATUS CSimulatorAbi::emuGetAllReg(U32 *cpuReg)
{
 	if (pCpuSim->GetAllReg(cpuReg)) return ICE_OK;
	else return ICE_STEP_ERROR;
 }

STATUS CSimulatorAbi::emuGetCpuStatus(U32 *cpuStatus)
{   
	WORD wTmp;
 	if (pCpuSim->GetCpuStatus(&wTmp)) {
 		*cpuStatus = (U32)wTmp;
 		return ICE_OK;
 	} else return ICE_STEP_ERROR;
 }

STATUS CSimulatorAbi::emuGetID(U8 *ID_Info)
{
	if (pCpuSim->GetCpuId(ID_Info)) return ICE_OK;
	else return ICE_STEP_ERROR;
 }

STATUS CSimulatorAbi::emuGetMemN(ADDR addr, U16 len ,U8 *buff,RET_ADDR*)
{                                    
	ADDR addrTmp;
	addrTmp.addr = addr.addr+len-1;
	addrTmp.addrType = addr.addrType;
    if (pMemSim->GetMem(addr,addrTmp,buff)) return ICE_OK;
	else return ICE_STEP_ERROR;
 }

STATUS CSimulatorAbi::emuGetReg(REG_MODE , S16 regId,U32 *content)
{
    if (pCpuSim->GetOneReg(regId,(DWORD*)content)) return ICE_OK;
	else return ICE_STEP_ERROR;
 }
STATUS CSimulatorAbi::emuSetReg(REG_MODE, S16 regId, U32 content)
{
    if (pCpuSim->SetReg(regId,(DWORD)content)) return ICE_OK;
	else return ICE_STEP_ERROR;
 }

STATUS CSimulatorAbi::emuGetVerify(U16 *verifyFlag)
{   
	FLAG fTmp;
	if (pCpuSim->GetVerify(fTmp)) {
		*verifyFlag = fTmp;
		return ICE_OK;
	} else return ICE_STEP_ERROR;
 }

STATUS CSimulatorAbi::emuGo(U16 mode,ADDR fromAddr,ADDR tillAddr)
{
	if (pCpuSim->Go((FLAG)mode,fromAddr,tillAddr)) return ICE_OK;
	else return ICE_STEP_ERROR;
 }

STATUS CSimulatorAbi::emuReset(ADDR addr)
{
    if (pCpuSim->Reset(addr)) return ICE_OK;
	else return ICE_STEP_ERROR;
 }

STATUS CSimulatorAbi::emuSearch(ADDR addr, U32 len, U8 *buff, U16 patternLen,U8 caseFlag,RET_ADDR* retAddr)

{
	ADDR addrTmp;
	addrTmp.addr = addr.addr+len-1;
	addrTmp.addrType = addr.addrType;
	SEARCH_INFO info;
	info.caseFlag = caseFlag;
	info.srchBufLen = (BYTE)patternLen;
	memcpy(info.srchBuf,buff,patternLen);
    if (pMemSim->SearchMem(addr,addrTmp,info,addrTmp)) {
    	retAddr->addr = addrTmp.addr;
    	retAddr->addrType = addrTmp.addrType;
    	return ICE_OK;
    }	
	else return ICE_NO_MATCH;
 }

STATUS CSimulatorAbi::emuSetBp(ADDR )
{
	return ICE_OK;
 }

STATUS CSimulatorAbi::emuGetBp(ADDR , ADDR , ADDR* )
{
    return ICE_OK;
 }

STATUS CSimulatorAbi::emuSetID(U16 idFlag)
{                                            
	WORD wTmp;
    if (pCpuSim->SetCpuId((WORD)idFlag,&wTmp)) return ICE_OK;
	else return ICE_STEP_ERROR;
 }

STATUS CSimulatorAbi::emuSetMemN(ADDR addr, U8 *buff, U16 patternLen,RET_ADDR* )
{
	if (pMemSim->SetMem(addr,buff,patternLen)) return ICE_OK;
	else return ICE_STEP_ERROR;
 }

STATUS CSimulatorAbi::emuSetVerify(U16 verifyFlag)
{                           
	FLAG tmp = (FLAG)verifyFlag;
	if (pCpuSim->SetVerify(tmp)) return ICE_OK;
	else return ICE_STEP_ERROR;
 }

STATUS CSimulatorAbi::emuTest(ADDR addr1, U32 len,RET_ADDR* )
{
	ADDR addrTmp;
	addrTmp.addr = addr1.addr+len-1;
	addrTmp.addrType = addr1.addrType;
	if (pMemSim->TestMem(addr1,addrTmp)) return ICE_OK;
	else return ICE_STEP_ERROR;
 }

STATUS CSimulatorAbi::emuGetFWSupport(U16 * wCpuNum,U16* wCpuType)
{
   if (pCpuSim->GetFWSupport(wCpuNum,wCpuType)) return ICE_OK;
	else return ICE_STEP_ERROR;
 }

STATUS CSimulatorAbi::emuClrBp(ADDR )
{
	return ICE_OK;
 }

