/***************************************************************************
**
**    $Header$
**
**    $Log$
** 
****************************************************************************/

// ABIdll.cpp : Defines the class behaviors for the application.
//

#include "stdafx.h"
#include "abidll.h"
#include "abifn196.h"
#include "uiserial.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

int nUseCount = 0;
/////////////////////////////////////////////////////////////////////////////
// Initialization of MFC Extension DLL

#include <afxdllx.h>    // standard MFC Extension DLL routines

static AFX_EXTENSION_MODULE NEAR extensionDLL = { NULL, NULL };

extern "C" int CALLBACK LibMain(HINSTANCE hInstance, WORD, WORD, LPSTR)
{
	// Extension DLL one-time initialization - do not allocate memory here,
	// use the TRACE or ASSERT macros or call MessageBox
	AfxInitExtensionModule(::extensionDLL, hInstance);

	return 1;   // OK
}

CBaseAbi* pAbi = NULL;
CBaseSerialAgree  *pTheCom = NULL;
ABI_INIT_OPTION g_nOption;

// Exported DLL initialization is run in context of running application
extern "C" void WINAPI InitABIDLL()
{   
	
	// create a new CDynLinkLibrary for this app
	new CDynLinkLibrary(::extensionDLL);

	// add other initialization here
	
}

// Exported DLL initialization is run in context of running application
extern "C" BOOL WINAPI NewABIDLL(ABI_INIT_OPTION nOption)
{   
	// add other initialization here
	if( pAbi!= NULL ) {
		if(nOption == g_nOption) {
			nUseCount++;
			return TRUE;
		}	
		return FALSE;
	}	             
	g_nOption = nOption;
	if(MAKE_SIMULATOR_ABI == nOption) {
		if ((pAbi = new CSimulator196Abi) == NULL) return FALSE;
	} else if(MAKE_REAL_196_ABI == nOption || MAKE_REAL_196_ABI_FIRSTTIME == nOption) {  
		if ((pAbi = new C196Abi) == NULL) return FALSE;
		if ((pTheCom = new CWinSerialAgree_196) == NULL) return FALSE;
    	((C196Abi*)pAbi)->ConnectTo(pTheCom);
	    pTheCom->m_isRepeat = TRUE;    
	    //FOR COMMUNICATION ARGUEMENT SETTINGS
	    if(MAKE_REAL_196_ABI_FIRSTTIME == nOption) pTheCom->m_isFirstTime = TRUE;
	    else pTheCom->m_isFirstTime = FALSE;
	    if (!pTheCom->CommInit()) {
	    	AfxMessageBox("EasyPack 196F/SLD communication failure!");
	    	return FALSE;
    	}	
	} else if(MAKE_REAL_196_ABI_DIAGNOSTIC == nOption ) {  
		if ((pAbi = new C196Abi) == NULL) return FALSE;
		if ((pTheCom = new CWinSerialAgree_196_Diagnostic) == NULL) return FALSE;
    	((C196Abi*)pAbi)->ConnectTo(pTheCom);
	    pTheCom->m_isRepeat = TRUE;    
	    //FOR COMMUNICATION ARGUEMENT SETTINGS
	    if(MAKE_REAL_196_ABI_FIRSTTIME == nOption) pTheCom->m_isFirstTime = TRUE;
	    else pTheCom->m_isFirstTime = FALSE;
	    if (!pTheCom->CommInit()) {
	    	AfxMessageBox("EasyPack 196F/SLD communication failure!");
	    	return FALSE;
    	}	
	} else {            
		return FALSE;
	}              
	nUseCount++;
	return TRUE;
}


extern "C" BOOL WINAPI ExitABIDLL(){
	if(--nUseCount>0) return TRUE;
	if(NULL != pAbi) delete pAbi;
	if(NULL != pTheCom) delete pTheCom;
	return TRUE;
}

extern "C" CBaseAbi* WINAPI GetAbi() {
	return pAbi;
}

extern "C" CBaseSerialAgree* WINAPI GetCom() {
	return pTheCom;
}

extern "C" void WINAPI GetSerialBaudRateStr(CString& strBaud) {
	if(NULL == pTheCom) strBaud = "";
	else strBaud = pTheCom->GetSerialBaudRateStr();
} 

extern "C" void WINAPI GetSerialPortNumStr(CString& strPort) {
	if(NULL == pTheCom) strPort = "";
	else strPort = pTheCom->GetSerialPortNumStr();
} 

extern "C" STATUS WINAPI emuGetDiagnosticMeterTimer(BYTE& bTimer) {
	if(g_nOption != MAKE_REAL_196_ABI_DIAGNOSTIC) 
		return ICE_ERR_NOT_READY_FOR_DIAGNOSTIC;
	bTimer = ((CWinSerialAgree_196_Diagnostic*)pTheCom)->m_bWaitTime;
	return ICE_OK;	
}

extern "C" STATUS WINAPI emuSetDiagnosticIsStop(BOOL isStop) {
	if(g_nOption != MAKE_REAL_196_ABI_DIAGNOSTIC) 
		return ICE_ERR_NOT_READY_FOR_DIAGNOSTIC;
	((CWinSerialAgree_196_Diagnostic*)pTheCom)->m_isStop = isStop;
	return ICE_OK;	
}
