/***************************************************************************
**
**    $Header$ 
**
**    $Log$
** 
****************************************************************************/

/***************************************************************************
**
** File name : abifn196.cpp
**
** Description: 
**
** Modification:
**
** Programmer: john 1997.1.10
**
**    Copyright (C) 1996 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/
#include "stdafx.h"
#include "abifn196.h"

//implemention of class C196Abi
STATUS C196Abi::EmuStepRange(U16 uNextAddrNum, ADDR* NextAddr,ADDR* stopAddr)
{ 
	STATUS status;
	m_Pipe.StartVar(STEP);
	m_Pipe.SaveVar(uNextAddrNum);  
	m_Pipe.SetVar((BYTE*)NextAddr,uNextAddrNum*sizeof(ADDR));  
	m_Pipe.EndVar(END_CODE);
		
	status = Start();
	
    if(ICE_ERROR_COM != status) {
		m_Pipe.LoadVar(*stopAddr);
	}	
	return status;

 }      
 
STATUS C196Abi::emuInitBank(BANKINIT* bankInit)
{                 
	STATUS status;
	m_Pipe.StartVar(INIT_BANK);
	m_Pipe.SaveVar(*bankInit);  
	m_Pipe.EndVar(END_CODE);
		
	status = Start();
	
	return status;
 }
 
STATUS C196Abi::emuSelectBaud(BYTE bBaud)
{                 
	STATUS status;
	m_Pipe.StartVar(SELECT_BAUD);
	m_Pipe.SaveVar(bBaud);  
	m_Pipe.EndVar(END_CODE);
		
	status = Start();
	
	return status;
 }
 
STATUS C196Abi::emuTestCom(BYTE* pChar,BYTE& bRetLen)
{                 
	STATUS status;
	m_Pipe.StartVar(TEST_COM);
	m_Pipe.SetVar(pChar,255);  
	m_Pipe.EndVar(END_CODE);
		
	status = Start();     
	
	if(ICE_OK == status) {
		m_Pipe.LoadBuffer(pChar,bRetLen);
	}
	
	return status;
 }
 
STATUS C196Abi::emuSetMemMode(BYTE bMode)
{               
	STATUS status;
	m_Pipe.StartVar(SET_MEM_MODE);
	m_Pipe.SaveVar(bMode);  
	m_Pipe.EndVar(END_CODE);
		
	status = Start();     
	
	return status;
 }

STATUS C196Abi::emuGetMemMode(BYTE& bMode)
{                 
	STATUS status;
	m_Pipe.StartVar(GET_MEM_MODE);
	m_Pipe.EndVar(END_CODE);
		
	status = Start();     
	
	if(ICE_OK == status) {
		m_Pipe.LoadVar(bMode);
	}
	
	return status;

 }
 
STATUS C196Abi::emuGetUesData(BYTE bType,BYTE& bLen,BYTE* pBuff) {
	STATUS status;
	m_Pipe.StartVar(GET_UES_DATA);
	m_Pipe.SaveVar(bType);  	
	m_Pipe.EndVar(END_CODE);
	
	status = Start();                   
	
	if(ICE_OK == status) {
		m_Pipe.LoadVar(bLen);
		m_Pipe.GetVar((BYTE*)pBuff,bLen);
	}
	
	return status;
	
}                       

STATUS C196Abi::emuProgram(BYTE bType,BYTE bUes) {
	STATUS status;
	m_Pipe.StartVar(JED_PROGRAM);
	m_Pipe.SaveVar(bType);  	
	m_Pipe.SaveVar(bUes);
	m_Pipe.EndVar(END_CODE);
	
	status = Start(2*BASE_TIME);     
	
	return status;
	
}                       

STATUS C196Abi::emuSendProgData(WORD wAddr,BYTE bLen,BYTE* pBuff) {
	STATUS status;
	m_Pipe.StartVar(SEND_JED_DATA);
	m_Pipe.SaveVar(wAddr);  	
	m_Pipe.SaveVar(bLen);
	m_Pipe.SetVar((BYTE*)pBuff,bLen);  
	m_Pipe.EndVar(END_CODE);
	
	status = Start();  
	   
	
	return status;
	
}           

STATUS C196Abi::emuGetTimerCount(float& fTimerCounter) {               
    STATUS status;
	m_Pipe.StartVar(GET_ELAPSE_TIME);
	m_Pipe.EndVar(END_CODE);
	
	status = Start();  
	
	if(ICE_OK == status) {
		m_Pipe.LoadVar(fTimerCounter);
	}
	return status;

} 

STATUS C196Abi::emuSetMemN(ADDR addr, U8 *buff, U16 patternLen,RET_ADDR* retAddr)
{
	STATUS status;
	U16 nTmpLen = 0; 
	U16 CONSTLEN = 0x78;
	for(int i=0;i<patternLen/0x78;i++) {
		m_Pipe.StartVar(SET_MEM_N);
		m_Pipe.SaveVar(addr);      
		m_Pipe.SaveVar(CONSTLEN);
		m_Pipe.SetVar((BYTE*)(&(buff[nTmpLen])),CONSTLEN);
		m_Pipe.EndVar(END_CODE); 
		nTmpLen += CONSTLEN;
		addr.addr += CONSTLEN;
			
		status = Start();
		
	    if(ICE_ERROR_COM != status) {
			m_Pipe.LoadVar(*retAddr);
			return status;
		}	
	}	
	
	if(0 != patternLen%0x78) {
		m_Pipe.StartVar(SET_MEM_N);
		m_Pipe.SaveVar(addr);                           
		CONSTLEN = patternLen%0x78;
		m_Pipe.SaveVar(CONSTLEN);
		m_Pipe.SetVar((BYTE*)(&(buff[nTmpLen])),CONSTLEN);
		m_Pipe.EndVar(END_CODE); 
			
		status = Start();
		
	    if(ICE_ERROR_COM != status) {
			m_Pipe.LoadVar(*retAddr);
			return status;
		}
	}
	return status;
	
                  
 }

STATUS C196Abi::emuDiagnostic(BYTE* pbOption, DIAGNORESULT* result) {
	STATUS status;
	m_Pipe.StartVar(DIAGNOSTIC);
	m_Pipe.SetVar(pbOption,7);
	m_Pipe.EndVar(END_CODE);
	
	status = Start(BASE_TIME*5);  
	
	if(ICE_OK == status) {
		m_Pipe.LoadBuffer((BYTE*)(result->bErrorCode),result->bNum);
		result->bNum = result->bNum/2;
	} 
	return status;	
	
}   
