/***************************************************************************
**
**    $Header$
**                             
**    $Log$
** 
****************************************************************************/
/***************************************************************************
**
** File name : ABIFUNC.CPP
** Author:john chow
** Description:
**    Descript the ABI for TW ABI
**
**    Finished date: 97.1
**    modifed date:
**
**    Copyright (C) 1997 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/

#include "stdafx.h" 

#include "abicore.h"
#include "abitype.h"
#include "simulate.h"
#include "abiextfn.h"
#include "abifn196.h"
extern CBaseAbi* pAbi; 

#ifdef __cplusplus
extern "C" {
#endif	// __cplusplus

STATUS WINAPI emuAbort()                         
{ 
    return pAbi->emuAbort();
 }         
 
STATUS WINAPI emuChecksum(ADDR addr, U32 len, U16 *n,RET_ADDR* retAddr)
{ 
    return pAbi->emuChecksum(addr,len,n,retAddr);
 }         

STATUS WINAPI emuClrEvent(U16 evId)
{ 
    return pAbi->emuClrEvent(evId);
 }         

STATUS WINAPI emuClrAllEvent()
{ 
    return pAbi->emuClrAllEvent();
 }         

STATUS WINAPI emuCompare(ADDR addr1, U32 len, ADDR addr2, RET_ADDR *findAddr1, RET_ADDR *findAddr2)
{ 
    return pAbi->emuCompare(addr1,len,addr2,findAddr1,findAddr2);
 }         

STATUS WINAPI emuCopy(ADDR addr1, U32 len, ADDR addr2,RET_ADDR* addrRet1,RET_ADDR* addrRet2)
{ 
    return pAbi->emuCopy(addr1,len,addr2,addrRet1,addrRet2);
 }         

STATUS WINAPI emuFill(ADDR addr, U32 len, U16 patternLen, U8 *buff,RET_ADDR* retAddr)
{ 
    return pAbi->emuFill(addr,len,patternLen,buff,retAddr);
 }         

STATUS WINAPI emuGetAllReg(U32 *cpuReg)
{ 
    return pAbi->emuGetAllReg(cpuReg);
 }         

STATUS WINAPI emuGetTrigger(U8 *byTrigStatus,
                     U8 *byLv1Status, TRIGGER_LEVEL* pLv1,
                     U8 *byLv2Status, TRIGGER_LEVEL* pLv2,
                     TRIGGER_LOGIC* pTrigLogic)
{ 
    return pAbi->emuGetTrigger(byTrigStatus,
                     byLv1Status,pLv1,
                     byLv2Status,pLv2,
                     pTrigLogic);
}         
                     
STATUS WINAPI emuGetControl(U16 *signals)
{ 
    return pAbi->emuGetControl(signals);
 }         

STATUS WINAPI emuGetCpuStatus(U32 *cpuStatus)
{ 
    return pAbi->emuGetCpuStatus(cpuStatus);
 }         

STATUS WINAPI emuGetEvent(U8 *byControl, U8 *byEv3,BUS_EVENT *pEv1, BUS_EVENT *pEv2)
{ 
    return pAbi->emuGetEvent(byControl,byEv3,pEv1,pEv2);
 }         

STATUS WINAPI emuGetID(U8 *ID_Info)
{ 
    return pAbi->emuGetID(ID_Info);
}         

STATUS WINAPI emuGetMap(ADDR addrStart,ADDR addrEnd,MAP_INFO *mapData)
{ 
    return pAbi->emuGetMap(addrStart,addrEnd,mapData);
 }         

STATUS WINAPI emuGetMemN(ADDR addr, U16 len ,U8 *buff,RET_ADDR* retAddr)
{ 
    return pAbi->emuGetMemN(addr,len,buff,retAddr);
 }         

STATUS WINAPI emuGetReg(REG_MODE regMode, S16 regId,U32 *content)
{ 
    return pAbi->emuGetReg(regMode,regId,content);
 }         

STATUS WINAPI emuSetReg(REG_MODE regMode, S16 regId,U32 content)
{ 
    return pAbi->emuSetReg(regMode,regId,content);
 }         

STATUS WINAPI emuGetTraceDepth(U16 bufID,BUFFER_DEPTH *traceDepth)
{ 
    return pAbi->emuGetTraceDepth(bufID,traceDepth);
 }         

STATUS WINAPI emuGetVerify(U16 *verifyFlag)
{ 
    return pAbi->emuGetVerify(verifyFlag);
 }         

STATUS WINAPI emuGo(U16 mode,ADDR fromAddr,ADDR tillAddr)
{ 
    return pAbi->emuGo(mode,fromAddr,tillAddr);
 }         

STATUS WINAPI emuInput(U16 port, U16 len, U16 size, U8 *buff)
{ 
    return pAbi->emuInput(port,len,size,buff);
 }         

STATUS WINAPI emuListTraceBuff(U32 startFrame, 
                        U32 endFrame, QUALIFY_INFO *qualifyInfo,
                        U8 *frameLen,TRACE_INFO *traceInfo,
                        U8 *readEnd)
{ 
    return pAbi->emuListTraceBuff(startFrame, 
                        endFrame,qualifyInfo,
                        frameLen,traceInfo,
                        readEnd);
 }         
                        
STATUS WINAPI emuOutput(U16 port, U8 *buff , U16 len, U16 size)
{ 
    return pAbi->emuOutput(port,buff,len,size);
 }         

STATUS WINAPI emuReset(ADDR addr)
{ 
    return pAbi->emuReset(addr);
 }         

STATUS WINAPI emuSearch(ADDR addr, U32 len, U8 *buff, U16 patternLen,U8 caseFlag,
                 RET_ADDR* retAddr)
{ 
    return pAbi->emuSearch(addr,len,buff,patternLen,caseFlag,retAddr);
 }         
                 
STATUS WINAPI emuSetBp(ADDR addr)
{ 
    return pAbi->emuSetBp(addr);
 }         

STATUS WINAPI emuSetControl(U16 signals)
{ 
    return pAbi->emuSetControl(signals);
 }         

STATUS WINAPI emuSetEvent(U16 evId, BUS_EVENT *busEventData)
{ 
    return pAbi->emuSetEvent(evId,busEventData);
 }                                                 	

STATUS WINAPI emuSetExtEvent(U16 evData)
{ 
    return pAbi->emuSetExtEvent(evData);
 }         

STATUS WINAPI emuSetID(U16 idFlag)
{ 
    return pAbi->emuSetID(idFlag);
 }         

STATUS WINAPI emuSetMap(ADDR addr1, ADDR addr2, U16 attrib)
{ 
    return pAbi->emuSetMap(addr1,addr2,attrib);
 }         

STATUS WINAPI emuSetMemN(ADDR addr, U8 *buff, U16 patternLen,RET_ADDR* retAddr)
{ 
    return pAbi->emuSetMemN(addr,buff,patternLen,retAddr);
 }         

STATUS WINAPI emuSetTrigLogic(TRIGGER_LOGIC* trigLogicData)
{ 
    return pAbi->emuSetTrigLogic(trigLogicData);
 }         

STATUS WINAPI emuSetVerify(U16 verifyFlag)
{ 
    return pAbi->emuSetVerify(verifyFlag);
 }         

STATUS WINAPI EmuStepRange(U16 uNextAddrNum, ADDR* NextAddr,ADDR* stopAddr)
{ 
    return pAbi->EmuStepRange(uNextAddrNum,NextAddr,stopAddr);
 }         

STATUS WINAPI emuTest(ADDR addr1, U32 len,RET_ADDR* retAddr)
{ 
    return pAbi->emuTest(addr1,len,retAddr);
 }         

STATUS WINAPI emuGetFWSupport(U16* wCpuNum,U16* wCpuType)
{ 
    return pAbi->emuGetFWSupport(wCpuNum,wCpuType);
 }         

STATUS WINAPI emuClrBp(ADDR addr)
{ 
    return pAbi->emuClrBp(addr);
 }         

STATUS WINAPI emuStepOne()
{ 
    return pAbi->emuStepOne();
 }         

STATUS WINAPI emuStepOver()
{ 
    return pAbi->emuStepOver();
 }         

STATUS WINAPI emuEreaseFlash(U32 bankNo,RET_ADDR* addr)
{ 
    return pAbi->emuEreaseFlash(bankNo,addr);
 }         

STATUS WINAPI emuProgFlash(U8 dataLen, U8 bOptionBankLowOrHigh,U16 startAddr, U8 *dataContent)
{ 
    return pAbi->emuProgFlash(dataLen,bOptionBankLowOrHigh,startAddr,dataContent);
 }         

STATUS WINAPI emuSwitchFlash()
{ 
    return pAbi->emuSwitchFlash();
 }         

STATUS WINAPI emuFillFlashBland(ADDR addr1,ADDR addr2, U8 blankValue,RET_ADDR* retAddr)
{ 
    return pAbi->emuFillFlashBland(addr1,addr2,blankValue,retAddr);
 }         

STATUS WINAPI emuFwInit()
{ 
    return pAbi->emuFwInit();
 }         

STATUS WINAPI emuSetQualify(QUALIFY* qualifyData)
{ 
    return pAbi->emuSetQualify(qualifyData);
 }         

STATUS WINAPI emuClearQualify()
{ 
    return pAbi->emuClearQualify();
 }         

STATUS WINAPI emuSetTrigLevel(int levelId, TRIGGER_LEVEL* trigLevelData)
{ 
    return pAbi->emuSetTrigLevel(levelId,trigLevelData);
 }         

STATUS WINAPI emuSetTriggerStatus(U8 triggerFlag)
{ 
    return pAbi->emuSetTriggerStatus(triggerFlag);
 }         

STATUS WINAPI emuSetTraceStatus (U8 tracerFlag)
{ 
    return pAbi->emuSetTraceStatus (tracerFlag);
 }         

STATUS WINAPI emuInitBank(BANKINIT* bankInit)
{ 
    return pAbi->emuInitBank(bankInit);
 }         

STATUS WINAPI emuGetBp(ADDR addr1, ADDR addr2, ADDR* bpAddr)
{ 
    return pAbi->emuGetBp(addr1,addr2,bpAddr);
 }
          
STATUS WINAPI emuSelectBaud(BYTE bBaud)
{                                             
    return pAbi->emuSelectBaud(bBaud);
 }                                 
 
STATUS WINAPI emuTestCom(BYTE* pChar,BYTE& bRetLen)
{                                     
    return pAbi->emuTestCom(pChar,bRetLen);
 }

STATUS WINAPI emuSetMemMode(BYTE bMode)
{                                     
    return pAbi->emuSetMemMode(bMode);
 }

STATUS WINAPI emuGetMemMode(BYTE& bMode)
{                                     
    return pAbi->emuGetMemMode(bMode);
 }
 
STATUS WINAPI emuGetUesData(BYTE bType,BYTE& bLen,BYTE* pBuff) {
    return pAbi->emuGetUesData(bType,bLen,pBuff);
}

STATUS WINAPI emuProgram(BYTE bType,BYTE bUes) {
    return pAbi->emuProgram(bType,bUes);
}

STATUS WINAPI emuSendProgData(WORD wAddr,BYTE bLen,BYTE* pBuff) {
    return pAbi->emuSendProgData(wAddr,bLen,pBuff);
}

STATUS WINAPI emuGetTimerCount(float& fTimerCounter) {
    return pAbi->emuGetTimerCount(fTimerCounter) ;
}

STATUS WINAPI emuDiagnostic(BYTE* pbOption, DIAGNORESULT* result) {
	return pAbi->emuDiagnostic(pbOption,result);
}
#ifdef __cplusplus
}
#endif	// __cplusplus
