/***************************************************************************
**
**    $Header$
**
**    $Log$
** 
****************************************************************************/

/***************************************************************************
**
** File name : simulate.h
**
** Description: for 251 now has no HW and FW
**
** Modification:
**
** Programmer: john 1996.10.4
**
**    Copyright (C) 1996 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/
#ifndef _SIMULATE_H
#define _SIMULATE_H

#include "stdafx.h" 
#include "abitype.h"
//for SEARCH command
    typedef struct {
        FLAG caseFlag;
        char srchBufLen;
        char srchBuf[32];
    } SEARCH_INFO;         
    
/********************** for class CSimulateMem *******************************/
class CSimulateMem 
{  
//member
protected:
	int m_nErrCode;
	
//operator
public:
	int GetErrCode() { return m_nErrCode; };
//operator virtual
public:
	virtual BOOL GetMem(ADDR addrStart,ADDR addrEnd,BYTE* pbBuffer) = 0;		
	virtual BOOL SetMem(ADDR addrStart,BYTE* pbBuffer,DWORD dwLen) = 0;		
	virtual BOOL FillMem(ADDR addrStart,ADDR addrEnd,BYTE* pbBuffer,WORD wLen) = 0;		
	virtual BOOL GetCheckSum(ADDR addrStart, ADDR addrEnd, WORD* uChecksum) = 0;
	virtual BOOL TestMem(ADDR addrStart, ADDR addrEnd) = 0;
	virtual BOOL CopyMem(ADDR addrStart, ADDR addrEnd, ADDR addrDest) = 0;
	virtual BOOL SearchMem(ADDR addrStart, ADDR addrEnd, SEARCH_INFO searchInfo,
                           ADDR& addrRet) = 0;
    virtual BOOL CompareMem(ADDR addrStart, ADDR addrEnd, ADDR addrDest,
                  ADDR* addrRet) = 0;
	
 };

/********************** for class CSimulate251Mem *******************************/
class CSimulate251Mem : public CSimulateMem
{  
//member
private:
	CFile m_pMem0;
	CFile m_pMem1;
	CFile m_pMemFE;
	CFile m_pMemFF;
	CFile m_pMemS;
	
//operator
protected:
	virtual CFile* GetPoint(ADDR);
	virtual void PrepareFile();
//operator virtual
public:
	virtual BOOL GetMem(ADDR addrStart,ADDR addrEnd,BYTE* pbBuffer);		
	virtual BOOL SetMem(ADDR addrStart,BYTE* pbBuffer,DWORD dwLen);		
	virtual BOOL FillMem(ADDR addrStart,ADDR addrEnd,BYTE* pbBuffer,WORD wLen);		
	virtual BOOL GetCheckSum(ADDR addrStart, ADDR addrEnd, WORD* uChecksum);
	virtual BOOL TestMem(ADDR addrStart, ADDR addrEnd);
	virtual BOOL CopyMem(ADDR addrStart, ADDR addrEnd, ADDR addrDest);
	virtual BOOL SearchMem(ADDR addrStart, ADDR addrEnd, SEARCH_INFO searchInfo,
                           ADDR& addrRet);
    virtual BOOL CompareMem(ADDR addrStart, ADDR addrEnd, ADDR addrDest,
                  ADDR* addrRet);

//construct & destruct
public:
	CSimulate251Mem() {
		PrepareFile();
	};
	
	~CSimulate251Mem() {
	};		
    	
 };

/********************** for class CSimulateCpu *******************************/
class CSimulateCpu 
{  
//member
protected:
	int m_nErrCode;
//destruct
public:
	virtual ~CSimulateCpu() { };	
//operator
public:
	int GetErrCode() { return m_nErrCode; };
//operator virtual
public:
	virtual BOOL GetCpuId(BYTE *bCpuId) = 0;
	virtual BOOL SetCpuId(WORD wSetCpuId, WORD *wGetCpuId) = 0;
	virtual BOOL GetFwId(BYTE *bMajor,  BYTE *bMinor) = 0;
	virtual BOOL GetCpuStatus(WORD *wCpuStatus) = 0;	
	virtual BOOL GetAllReg(DWORD* wRegValue) = 0;
	virtual BOOL GetOneReg(WORD nRegId, DWORD* wRegValue) = 0;
	virtual BOOL SetReg(WORD iRegId, DWORD wRegValue) = 0;
	virtual BOOL GetRegLen(WORD *wRegLen) = 0;
	virtual BOOL GetFWSupport(WORD *wCpuNum, WORD* wCpuType) = 0;
	virtual BOOL GetTargetSupport(WORD *wCpuNum, WORD* wCpuType) = 0;
	virtual BOOL Reset(ADDR addr) = 0;
	virtual BOOL Abort() = 0;
	virtual BOOL Go(FLAG runFlag, ADDR addrStart, ADDR addrEnd) = 0;
	virtual BOOL StepOne() = 0;
	virtual BOOL StepOver() = 0;
	virtual BOOL StepRange(ADDR addrStart, ADDR addrEnd) = 0;
	virtual BOOL StepOverRange(ADDR addrStart, ADDR addrEnd) = 0;
	virtual BOOL SetVerify(FLAG uVerifyFlag) = 0;
	virtual BOOL GetVerify(FLAG& uVerifyFlag) = 0;
	
 };

/********************** for class CSimulate251Cpu *******************************/
class CSimulate251Cpu : public CSimulateCpu
{   
//member
private:
	DWORD m_dwPc;
	DWORD m_pdwReg[10];
	WORD m_wCpuId;
	BYTE m_bFWIdMajor,m_bFWIdMinor;
	WORD m_wCpuStatus;
	
//construct     
public:
	CSimulate251Cpu() {
		m_dwPc = 0x00000000;
		m_wCpuId = 0; 
		m_bFWIdMinor = m_bFWIdMajor = 0;
		m_wCpuStatus = 0;
	};
	virtual ~CSimulate251Cpu() { };
//operator
public:
//operator virtual
public:
	virtual BOOL GetCpuId(BYTE *bCpuId);
	virtual BOOL SetCpuId(WORD wSetCpuId, WORD *wGetCpuId);
	virtual BOOL GetFwId(BYTE *bMajor,  BYTE *bMinor);
	virtual BOOL GetCpuStatus(WORD *wCpuStatus);	
	virtual BOOL GetAllReg(DWORD* dwRegValue);
	virtual BOOL GetOneReg(WORD nRegId, DWORD* dwRegValue);
	virtual BOOL SetReg(WORD iRegId, DWORD dwRegValue);
	virtual BOOL GetRegLen(WORD *wRegLen);
	virtual BOOL GetFWSupport(WORD *wCpuNum, WORD* wCpuType);
	virtual BOOL GetTargetSupport(WORD *wCpuNum, WORD* wCpuType);
	virtual BOOL Reset(ADDR addr);
	virtual BOOL Abort();
	virtual BOOL Go(FLAG runFlag, ADDR addrStart, ADDR addrEnd);
	virtual BOOL StepOne();
	virtual BOOL StepOver();
	virtual BOOL StepRange(ADDR addrStart, ADDR addrEnd);
	virtual BOOL StepOverRange(ADDR addrStart, ADDR addrEnd);
	virtual BOOL SetVerify(FLAG uVerifyFlag);
	virtual BOOL GetVerify(FLAG& uVerifyFlag);
	
 };

/********************** for class CSimulate196Mem *******************************/
class CSimulate196Mem : public CSimulate251Mem
{
//member
private:
	CFile m_pMem0;
	CFile m_pMem1;
	CFile m_pMem2;
	CFile m_pMem3;
	CFile m_pMemI;
	
//operator
protected:
	virtual CFile* GetPoint(ADDR);
	virtual void PrepareFile(); 
//constructor
public:	
	CSimulate196Mem() {
		PrepareFile();
	};	
	
};
#endif
/*/////////////// end of file ///////////////////////*/