/***************************************************************************
**
**    $Header$
**
**    $Log$
** 
****************************************************************************/
/***************************************************************************
**
** File name : abitype.h
**
** Description: JOHN 1997.1 FOR TW ABI
**
**
**
**
** Programmer: 
**
**    Copyright (C) 1997 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/

#ifndef _ABITYPE_
#define _ABITYPE_
#include "abibase.h"

//only for init abidll using
    typedef enum {
    	MAKE_SIMULATOR_ABI,
    	MAKE_REAL_196_ABI,
    	MAKE_REAL_196_ABI_FIRSTTIME,//FOR communication sets("ep196 /s")
    	MAKE_REAL_196_ABI_DIAGNOSTIC,
    	MAKE_REAL_251_ABI,
    	MAKE_REAL_251_ABI_FIRSTTIME,//FOR communication sets("ep251 /s")
    } ABI_INIT_OPTION;
    
    typedef struct{
        U32 addr;
        U16 addrType;
    }ADDR;
    
    typedef struct{
        U32 addr;  
        U16 addrType;
        U32 data;
    }RET_ADDR;
    
    //address type (for pos)
    typedef enum {   
        MEM_UNDEFINED  = 0,   //for error or other using
        MEM_P0 = 1,             
        MEM_P1 = 2,             
        MEM_P2 =3,
        MEM_P3 =4,
        MEM_X0 = 5,         
        MEM_X1 = 6, 
        MEM_X2 = 7,
        MEM_X3 = 8,
        MEM_I = 10
    }ADDR_TYPE;


//defined for filter , qualify
    typedef struct {
        U8 filterFlag;
        U8 addrType;
        U8 dataType;

        U8 addrCount;
        U32 addrValue[10];//18 BIT
        U16 dataValue1;//8 or 16 BIT
        U16 dataValue2;
        U16 statusValue;
    } QUALIFY_INFO,QUALIFY;
    
//defined for trace info.
    typedef struct tracerec{
        U16 frameNo;
        U32 address; //bit0--17 : 18 bits address
                   //bit31 : 0 : 8 bit datum width
                   //   1 : 16 bit datum width
        U16 datum;//8 or 16 bits
        U8 status;//bit0--2 :  0:STATUS_S
                  //   1:STATUS_R
                  //   2:STATUS_W
                  //   3:STATUS_AK
              //bit 3-7:  5 bits spare
        U8 bExternal;     
    }TRACE_INFO;

//for trigger
    typedef struct {
        FLAG trigFlag;         /* 0 delay count    */
                               /* 1 foreward       */
                               /* 2 backward       */
                               /* 3 center         */
        FLAG runFlag;          /* 0 without run    */
                               /* 1 with run       */
        DWORD delayCount;      /* delay count(trigFlg=0 used) */
        WORD levelCount;
        WORD levelID[4];       /* level ID list*/
                               //LV1:           levelCount =1, levelID[0]=1
                               //LV2:           levelCount =1, levelID[0]=2
                               //LV1_Then_LV2:  levelCount =2, levelID[0]=1, levelID[1] =2
    } TRIGGER_LOGIC;

//for LEVEL command
    typedef struct {
        FLAG traceFlag;        /* 0 trace unchanged    */
                               /* 1 trace ON           */
                               /* 2 trace OFF          */
        FLAG timerFlag;        /* 0 timer unchanged    */
                               /* 1 timer ON           */
                               /* 2 timer OFF          */
        DWORD dwCond;          /* condition list       */
                            // EV1  AAAAAAAAH
                            // EV2  CCCCCCCCH
                            // EV3  F0F0F0F0H
                            // EV4  FF00FF00H
                            // EV5  FFFF0000H
                            // EV1 OR  EV2 = AAAAAAAAH OR  CCCCCCCCH = EEEEEEEEH
                            // EV2 AND EV3 = CCCCCCCCH AND F0F0F0F0H = C0C0C0C0H

    }  TRIGGER_LEVEL;

//defined for event
    typedef struct {
        U8 addrType;
        U8 dataType;

        U8 addrCount;
        U32 addrValue[10];//18 BIT
        U16 dataValue1;//8 or 16 BIT
        U16 dataValue2;
        U16 statusValue;
        U16 counter;//ev1 counter
    } BUS_EVENT;

//defined for map settings
    typedef enum {
        MAP_ERW = 0x0,  // external read/write(TARGET)
        MAP_ORW = 0x1,  // overlay read/write
        MAP_ER = 0x2,       // external read only(reserved)
        MAP_OR = 0x3,       // overlay read only
        MAP_GUARD=0x4       // guard
    } MAP_ATTR;

    typedef struct {
        ADDR addr1; 
        ADDR addr2; 
        U16  attr;
        //U8	 isCombination;
    }MAP_INFO;

//for bank init
    typedef struct {
        BYTE  bPinLow;
            //pin name (low part):
            //  0: p0.0   1: p0.1  ~63: p7.7, 0xff : none
        BYTE  bPinLowAct;
            //0: low active, 1: high active
        BYTE  bPinHigh;
            //pin name (high part):
            //  0: p0.0   1: p0.1  ~63: p7.7, 0xff : none
        BYTE  bPinHighAct;
            //0: low active, 1: high active
    } BANKINIT;

//defined for trace
    typedef struct {
        U32 startFrame;
        U32 endFrame;
    }BUFFER_DEPTH;
//defined for go command
    typedef enum {
       NORMAL_RUN = 0,
       FREE_RUN,
       FLY_RUN,//reserved
       MONITOR_RUN,//reserved
       TEST_RUN//reserved
    }RUN_MODE;
//defined for diagnostic    
typedef struct {
	BYTE    bNum;
	WORD    bErrorCode[100];//high byte = error belong section,low byte = error code
} DIAGNORESULT;
    /* define the F/W command ID for Pic  */
    typedef enum {  
        COMMAND_START,          /* 0  -- 0x0  not supported*/
        GET_ID,                 /* 1  -- 0x1  supported*/
        CHECKSUM,               /* 2  -- 0x2  supported*/
        CLR_EVENT,              /* 3  -- 0x3  supported */
        CLR_TRIG,               /* 4  -- 0x4  supported */
        COMPARE,                /* 5  -- 0x5  supported */
        COPY,                   /* 6  -- 0x6  supported */
        FUNCTION_TEST,          /* 7  -- 0x7  not supported */
        ESC_COMMAND,            /* 8  -- 0x8  not supported */
        FILL_COMMAND,           /* 9  -- 0x9  supported */
        GET_ALL_CO_REG,         /* 10 -- 0xa  not supported */
        GET_ALL_INTERNAL_REG,   /* 11 -- 0xb  not supported */
        GET_ALL_REG,            /* 12 -- 0xc  supported */
        GET_CO_COVERAGE,        /* 13 -- 0xd  not supported */
        GET_CO_REG,             /* 14 -- 0xe  not supported */
        GET_CONTROL,            /* 15 -- 0xf  supported */
        GET_DEPTH,              /* 16 -- 0x10 supported */
        GET_EVENT,              /* 17 -- 0x11 supported */
        GET_MAP,                /* 18 -- 0x12 supported */
        GET_MAP_SIZE,           /* 19 -- 0x13 not supported */
        GET_MODE,               /* 20 -- 0x14 not supported */
        GET_READY,              /* 21 -- 0x15 not supported */
        GET_REG,                /* 22 -- 0x16 supported */
        GET_SIZE,               /* 23 -- 0x17 not supported */
        GET_STAT,               /* 24 -- 0x18 not supported */
        GET_SYNC,               /* 25 -- 0x19 not supported */
        GET_VERIFY,             /* 26 -- 0x1a supported  */
        GET_WAIT,               /* 27 -- 0x1b not supported */
        GO_COMMAND,             /* 28 -- 0x1c supported  */
        HALT,                   /* 29 -- 0x1d not supported */
        INPUT,                  /* 30 -- 0x1e supported */
        LIST_TRACE,             /* 31 -- 0x1f supported */
        OUTPUT,                 /* 32 -- 0x20 supported */
        READ_MEM_N,             /* 33 -- 0x21 supported */
        RESET,                  /* 34 -- 0x22 supported */
        SEARCH,                 /* 35 -- 0x23 supported */
        SET_TRACE_BUFF,         /* 36 -- 0x24 not supported */
        SET_CONTROL,            /* 37 -- 0x25 supported */
        SET_CO_COVERAGE,        /* 38 -- 0x26 not supported */
        SET_CO_REG,             /* 39 -- 0x27 not supported */
        SET_EVENT,              /* 40 -- 0x28 supported */
        SET_EX_BKPT,            /* 41 -- 0x29 not supported */
        SET_ID,                 /* 42 -- 0x2a supported */
        SET_MEM_N,              /* 43 -- 0x2b supported */
        SET_MAP,                /* 44 -- 0x2c supported */
        SET_MODE,               /* 45 -- 0x2d not supported */
        SET_REG,                /* 46 -- 0x2e supported */
        SET_READY,              /* 47 -- 0x2f not supported */
        SET_SIZE,               /* 48 -- 0x20 not supported */
        SET_SYNC,               /* 49 -- 0x31 not supported */
        SET_TRACE_BREAK,        /* 50 -- 0x32 not supported */
        SET_TRIG,               /* 51 -- 0x33 supported */
        SET_TIMER_COUNTER,      /* 52 -- 0x34 not supported */
        SET_VERIFY,             /* 53 -- 0x35 supported */
        SET_WAIT,               /* 54 -- 0x36 not supported */
        STEP,                   /* 55 -- 0x37 supported (STEP RANGE)*/
        STEP_ONE,               /* 56 -- 0x38 supported*/
        TEST,                   /* 57 -- 0x39 supported */
        SET_EXT_EVENT,          /* 58 -- 0x3a supported   */
        SET_ALL_EVENT,          /* 59 -- 0x3b not supported */
        SET_TIMER_REG,          /* 60 -- 0x3c not supported   */
        GET_CPU_STATUS,         /* 61 -- 0x3d supported   */
        ABORT,                  /* 62 -- 0x3e supported  */
        GET_TRIG,               /* 63 -- 0x3f supported  */
        GET_LAST_BUFF,          /* 64 -- 0x40 not supported  */
        DIAGNOSTIC,             /* 65 -- 0x41 supported */
//new abi routine
        CONFIG_CPU = 0x50,          /* 80 -- 0x50 not supported   */
        GET_CONFIG,         /* 81 -- 0x51 not supported   */
        GET_FW_SUPPORT,     /* 82 -- 0x52 supported       */
        SET_BP,         /* 83 -- 0x53  supported         */
        CLR_BP,         /*    84  -- 0x54  supported       */
        SET_PORT,           /*    85 -- 0x55  not supported  */
        FW_INIT,            /*     86 -- 0X56 supported      */
        STEP_OVER,          /*    87 -- 0x57  supported      */
        CYCLE,          /*    88 -- 0x58 not supported       */
        EREASE_FLASH,       /*    89 -- 0x59 supported       */
        PROG_FLASH,         /*    90 -- 0x5a supported       */
        SWITCH_FLASH,       /*    91 -- 0x5b supported       */
        FILL_FLASH_BLANK,       /*    92 -- 0x5c supported   */
        SET_DECODE_RAM,     /*    93 -- 0x5d supported       */
        GET_HW_MODE,        /*    94 -- 0x5e not supported   */
        SELECT_BAUD,        /*    95 -- 0x5f supported   */
        CLEAR_ALL_EVENT,        /*    96 -- 0x60 supported   */
        SET_QUALIFY,            /*    97 -- 0x61 supported   */
        CLEAR_QUALIFY,      /*    98 -- 0x62 supported       */
        SET_LEVEL,          /*    99 -- 0x63 supported       */
        SET_TRIGGER_STATUS, /*    100 -- 0x64 supported      */
        SET_TRACE_STATUS,       /*    101 -- 0x65 supported  */
        INIT_BANK,          /*     102 -- 0x66 supported     */
        GET_BP,             /*     103 -- 0x67 supported     */
        SET_MEM_MODE,       /*    106 -- 0x68 supported*/
        GET_MEM_MODE,       /*    107 -- 0x69 supported*/
        
        //97.2 FOR JED
        JED_PROGRAM = 0x6a,        /*     106 -- 0x6a supported*/
        GET_UES_DATA,       /*     107 -- 0x6b supported*/
        SEND_JED_DATA,      /*     108 -- 0x6c supported*/
        GET_ELAPSE_TIME,    /*     109 -- 0x6d supported*/
        TEST_COM = 0xf0,        
        
        //MAX_COMMAND          /* All new command must add before this command. */

    } FW_COMMAND_ID;

typedef struct {
    BOOL bResult;// TRUE -- OK; FALSE WRONG
    WORD  nLoc; //error location    
    BYTE bSend;//byte send to fw
    BYTE bRet; //error byte return from firmware
    WORD nError;      //
    WORD nDetailError; //from CBaseCom
} COMTESTERR;
#endif
