/***************************************************************************
**
**    $Header$
**
**    $Log$
** 
****************************************************************************/

/****************************************************************************
**
**  Name:      Addrapi.h
**
**  Description: Main file of the address server API
**
**  Status: Initialization
**          1996/09/16        Annie Yi
**
**  Copyright (C) 1996 Microtek International.  All rights reserved.
******************************************************************************/
#ifndef __ADDRAPI__H
#define __ADDRAPI__H

enum { COMB1 = 0, COMB2 = 1, COMB4 = 2, SEPB1 = 3, SEPB2 = 4 };

/**----------------------------------------------------------------------
 **   AdrAddrToHex
 **
 **   addr        Set to the address.
 **   adrstr      Set to the converted address text string .
 **
 **   Remark
 **      Call this function to convert an address to text string. The
 **      address descripted by the ADDRESS struct.
 **      If there is no space, the adrSpace must set to 251SPACE_UNDEFINE.
 **      The result hex string hasn't any leading zero.
 **
 **   Return value
 **      One of the enum of ADDR_RETCODE.
 **      If this return value equal to ADDR_OK, the convert is successful.
 **      (See the defination of the ADDR_RETCODE)
 **
 **      Examples
 **         char         strTemp[150];
 **         ADDR_RETCODE retCode;
 **         ADDRESS      address;
 **
 **         address.adrSpace = SPACE_PROGRAM;
 **         address.address = 100;
 **         retCode = AdrAddrToHex(address, strTemp);
 **         if (ADR_OK == retCode)
 **             // The convert is successful. The address is correct.
 **         else
 **             // The convert is failure. The address has some error
 **
 **----------------------------------------------------------------------*/
 ADDR_RETCODE WINAPI 
 AdrAddrToHex( const ADDRESS   addr,  LPSTR    adrstr );

 ADDR_RETCODE WINAPI 
 AdrAddrToHex( const ADDRESS   addr,  CString  &adrstr );

 ADDR_RETCODE WINAPI 
 AdrDadAddrToHex( const ADDRESS   addr,  CString  &adrstr );

 ADDR_RETCODE WINAPI 
 AdrDadAddrToHex( const ADDRESS   addr,  LPSTR    adrstr );

/**----------------------------------------------------------------------
 **   AdrAddrToDec
 **
 **   addr     Set to the address.
 **   adrstr   Set to the converted address dec text string .
 **
 **   Remark
 **   Call this function to convert an address to dec text string. The space
 **   style's string will add to the front of the address's string.
 **   The converted address text string will store in the third parameter
 **   (adrstr).
 **   If there is no space, the adrSpace must set to 251SPACE_UNDEFINE.
 **   The result hex string hasn't any leading zero.
 **
 **   Return value
 **   One of the enum of ADDR_RETCODE.
 **   If this return value equal to ADDR_OK, the convert is successful.
 **   (See the defination of the ADDR_RETCODE)
 **
 **   Examples
 **      char         strTemp[150];
 **      ADDR_RETCODE retCode;
 **      ADDRESS      address;
 **
 **      address.adrSpace = SPACE_PROGRAM;
 **      address.address = 100;
 **      retCode = AdrAddrToDec(address, strTemp);
 **      if (ADR_OK == retCode)
 **         // The convert is successful. The address is correct.
 **      else
 **         // The convert is failure. The address has some error
 **
 **   The address of 100 in program area will be converted to the hex text
 **   string strTemp. The parameter strTemp is change to "P:100
 **
 **----------------------------------------------------------------------*/
 ADDR_RETCODE WINAPI 
 AdrAddrToDec( const ADDRESS   addr, LPSTR adrstr );

 ADDR_RETCODE WINAPI 
 AdrAddrToDec( const ADDRESS   addr, CString &adrstr );


/**----------------------------------------------------------------------
 **   AdrTextToAddr
 **
 **   adrstr  Set to the address text string;
 **   addr    Set to the return address(converted address)
 **
 **   Remark
 **   Call this function to convert a hex address text string.
 **   The converted address store in the second parameter(addr).
 **   The address text string will set to hex string or dec string.
 **   Distinguish the two string by the leading char "0x".
 **
 **   Return value
 **   One of the enum of ADDR_RETCODE.
 **   If this return value equal to ADDR_OK, the convert is successful.
 **   (See the defination of the ADDR_RETCODE).
 **
 **   If the address text string soesn't include any space, the field
 **   in ADDRESS (adrSpace) will set to SPACE_NORMAL.
 **		
 **	  If isHex = 1, the string is converted as address(only support hex)	
 **		
 **	  If isHes = 0, the string is converted as data(support C convertion)
 **
 **   Examples
 **       char            *adrStr = "r:0x64";
 **       ADDRESS         address;
 **       ADDR_RETCODE    retCode;
 **
 **       retCode = AdrHexToAddr(adrstr, address);
 **       if (ADR_OK == retCode)
 **           // The convert is successful. The address is correct.
 **       else
 **           // The convert is failure. The address has some error
 **
 **----------------------------------------------------------------------*/
 ADDR_RETCODE WINAPI 
 AdrTextToAddr(const LPSTR  adrstr, ADDRESS &addr, UINT isHex = 1);

 ADDR_RETCODE WINAPI 
 AdrTextToAddr(const CString& adrstr, ADDRESS &addr, UINT isHex = 1);

 // For shell window
 //  
 ADDR_RETCODE WINAPI 
 AdrShellToAddr(const CString& adrstr, ADDRESS &addr, 
                BYTE Space = BYTE(0));

 ADDR_RETCODE WINAPI 
 AdrShellToAddr(const LPSTR  adrstr, ADDRESS &addr, 
                BYTE Space = BYTE(0));

/**---------------------------------------------------------------------- 
 **   CheckAddrRange
 ** 
 **   address     Set to the address
 **   
 **   Remark
 **   Call this function to check the address range
 **
 **----------------------------------------------------------------------*/

 BOOL WINAPI 
 AdrCheckAddrRange(ADDRESS address);
   
/**----------------------------------------------------------------------
 **   AdrCheck2Add
 **   adrstr1     Set to the first address 
 **   adrstr2     Set to the second address 
 **
 **   Remark
 **   Call this function to check two address text string.
 **   No converting.
 **
 **   Return value
 **   One of the enum of ADDR_RETCODE.
 **   If this return value equal to ADDR_OK, the convert is successful.
 **   (See the defination of the ADDR_RETCODE).
 **
 **----------------------------------------------------------------------*/
 ADDR_RETCODE WINAPI 
 AdrCheck2Addr(const LPSTR adrstr1, const LPSTR  adrstr2, ADDR_SPACE space=0);

 ADDR_RETCODE WINAPI 
 AdrCheck2Addr(const CString& adrstr1, const CString& adrstr2, ADDR_SPACE space=0);

 ADDR_RETCODE WINAPI 
 AdrCheck2Addr(ADDRESS  adddress1, ADDRESS   address2);

/**----------------------------------------------------------------------
 **   AdrShlCheck2Addr
 **   adrstr1     Set to the first address 
 **   adrstr2     Set to the second address 
 **
 **   Remark
 **   Call this function to check two address text string. Only for shell
 **   No converting.
 **
 **   Return value
 **   One of the enum of ADDR_RETCODE.
 **   If this return value equal to ADDR_OK, the convert is successful.
 **   (See the defination of the ADDR_RETCODE).
 **
 **----------------------------------------------------------------------*/
 ADDR_RETCODE WINAPI 
 AdrShlCheck2Addr(const LPSTR adrstr1, const LPSTR adrstr2, ADDR_SPACE space=0);

 ADDR_RETCODE WINAPI 
 AdrShlCheck2Addr(const CString& adrstr1, const CString& adrstr2, ADDR_SPACE space=0);

/**----------------------------------------------------------------------
 **   AdrIsOk
 **   adrstr      Set to the address text string;
 **
 **   Remark
 **   Call this function to check the address text string.
 **   No converting.
 **
 **   Return value
 **   True if the address text string is correct.
 **----------------------------------------------------------------------*/
 BOOL WINAPI AdrIsOk(const LPSTR   adrstr);

 BOOL WINAPI AdrIsOk(const CString&  adrstr);


/**----------------------------------------------------------------------
 **   AdrErrorDeal
 **  
 **   Remark
 **   Process the address server's error.
 **   Call this function to display a message box(for general window process) if the callers don't want to process the error by themself.
 **
 **   Return value
 **   none
 **----------------------------------------------------------------------*/
 void WINAPI AdrErrorDeal(ADDR_RETCODE  retCode, CString &error);

 
 void WINAPI AdrSetAddrRange();    // Get all address range Max and Min

// ADDR_SPACE AdrGetSpace(CString &strAddress);
 
BOOL WINAPI 
AdrAddrToSymbol(const ADDRESS &addr, LPSTR symbol);

BOOL WINAPI 
AdrAddrToSymbol(const ADDRESS &addr, CString& symbol);

int WINAPI GetBankInfo(void);

DWORD WINAPI GetPMin(void);
DWORD WINAPI GetPMax(void);
DWORD WINAPI GetXMin(void);
DWORD WINAPI GetXMax(void);
DWORD WINAPI GetIMin(void);
DWORD WINAPI GetIMax(void);

#endif
