/***************************************************************************
**
**    $Header$
**
**    $Log$
** 
****************************************************************************/

/****************************************************************************
**
**  Name:      Ad196adr.h
**
**  Description:  The sub class C196adr deprived from the CFormatAddress
**                This class is process the 196 base family address
**                196 base family address has 2 kinds of format: 
**                
**				  1. prefix:address
**                    prefix is the space area. Those are :
**						s: 	SFR          
**	
**                2. absolute address
**		              range is 0~FFFFFF
** 
**                The address has one format: Hex 
**                      Hex has the prefix before address that is 0x
**                      
**
**                Another : the address is a symbol. The symbol has the format
**                as following:
**                      #ModuleName#SymbolName etc.
**                The process must deal all the statment described as before.
**
**  Status: Initialization
**          1996/09/16        Annie Yi
**
**  Copyright (C) 1996 Microtek International.  All rights reserved.
*****************************************************************************/

#ifndef __AD196ADR__H
#define __AD196ADR__H



class C196Address : CFormatAddress
{
private:
    BOOL     IsString;               // Construct from a string;
	ADDR_RETCODE  m_enumRetCode;          // Return code

	// Attribute
   	ADDR_SPACE  m_enumSpace;            // The enum space
      
private:
	// Implenmentation
	void  Initialize();                    // Initialize all attributes
    BOOL  Process(CFormatType *format);    // Process the address server

public:

	
public:
    //Constructor
    C196Address() {
	   	Initialize();
    }
      
    C196Address(const CString& str);        // from CString
    C196Address(const LPSTR lpsz);          // from LPSTR
    C196Address(const CString& str, 
                const UINT isHex);           // from CString
    C196Address(const LPSTR lpsz,           
                const UINT isHex);           // from LPSTR
    C196Address(ADDR_SIZE dw);              // from ADDR_SIZE
    C196Address(ADDRESS  adr);              // from ADDRESS struct
   
    //Inline function
    CString GetHexAddr();
    CString GetDecAddr();
 	ADDR_RETCODE GetRetCode();
 	ADDR_SIZE    GetAddress(); 
 	BYTE   GetSpace(); 
	BYTE   GetSpace(const ADDR_SIZE dwAddress);
 		
    // virtual function deprived from parent class
    virtual BOOL  ConvertCheck();                  // Convert the address and
                                                   // check it

    virtual BOOL  SplitPrefix(const char* lpsz);   // Split the prefix and
                                                   // address
};

#endif

////////////////////////////////(EOF)////////////////////////////////////////
