/***************************************************************************
**
**    $Header$
**
**    $Log$
** 
****************************************************************************/

/****************************************************************************
**
**  Name:   adcfmtad.h
**
**  Description:  Head file of adcfmtad.cpp
**                This file describe the class of CFormatAddress.
**                CFormatAddress deprived from the base class of CFormat.
**
**  Status:    Initialization
**             1997/2/11      Annie Yi
**
**  Copyright (C) 1996 Microtek International.  All rights reserved.
*****************************************************************************/

#ifndef __ADCFMTAD__H
#define __ADCFMTAD__H

//#include "abibase.h"

typedef enum tagADDRRET
{     
	ADR_OK            = 1,       // the address is OK
    ADR_FORMATERROR   = 2,       // the address format is error
    ADR_INVALIDCHAR   = 3,       // the address include invalid char
    ADR_OUTRANGE      = 4,       // the address out of range
    ADR_NOSYMBOL      = 5,       // The symbol doesn't exist(Only for conver
                                 // symbol to ADDRESS)
    ADR_COMPERROR     = 6,       // the second address is less than first
    ADR_OVERFLOW      = 7,       // the address text string is overflow
    ADR_EMPTY         = 8,       // the address text string is empty
      
}ADDR_RETCODE;

typedef enum tagFormatType
{
    IS_HEX      =  0,
    IS_DEC      =  1,
    IS_SYM      =  2,
    IS_SYM_DATA =  3,
    IS_UNKNOWN  =  32767
}FORMATTYPE;

//
//Data struct define
//

typedef    DWORD  ADDR_SIZE;
#define    HEXLENGTH       8
#define    DECLENGTH       9 

/**-----------------------------------------------------------
 ** Remarks
 **    This enum define the 196 based family's space style.
 **-----------------------------------------------------------*/
typedef BYTE  ADDR_SPACE  ;

#define   SPACE_UNDEFINE  BYTE(0)  // Undefine the area
#define   SPACE_P0	  	  BYTE(1) 
#define   SPACE_P1        BYTE(2) 
#define   SPACE_P2        BYTE(3) 
#define   SPACE_P3        BYTE(4) 
#define   SPACE_X0        BYTE(5) 
#define   SPACE_X1        BYTE(6) 
#define   SPACE_X2        BYTE(7) 
#define   SPACE_X3        BYTE(8) 
#define   SPACE_I         BYTE(10)

//only for build 2/11/97
/*
#define   SPACE_NORMAL	  BYTE(11)  // Normal address (0-FFFFFF)
#define   SPACE_PROGRAM   BYTE(12)  // Program area
#define   SPACE_EXTERNAL  BYTE(13)  // External area(Data)
#define   SPACE_INTERNAL  BYTE(14)  // Internal area(On chip)
#define   SPACE_R         BYTE(15)  // Special function register area
#define   SPACE_BIT       BYTE(16)  // Bit area   
#define   SPACE_S         BYTE(17)  // SFR (S:80-S:FF)
*/
struct  ADDRESS
{
	BYTE  adrSpace;   		// The address attribute                           
   	DWORD adrAddress; 		// The address
};

class CFormatAddress        // Virtua base class
{
//protected:
public:
    CString  m_strOriginAdr;  // Original address string. No any change
                              // Get from construct or Set function
    ADDR_SIZE  m_dwAddress;   // The data of address(converted form string,
                              // or get from constructor)
                              // After converted successful, the m_dwAddress
                              // is the address.

    CString  m_strPrefix;     // Prefix front the address.
                              // Such as in 196 base family the prefix of
                              // P0:0x87 is "P0"

    CString  m_strAddress;    // After split the prefix,
                              // In 196 family, it is the absoluted address

    CString  m_strAddressHex; // The converted hex address
    CString  m_strAddressDec; // The converted dec address    
    UINT     m_nDefaultIsHex; // Set the default input
                                  // 1 --> default is hex
                                  // 0 --> default is dec   

public:
    static void  SkipHeadWS  (char* lpsz);    // ship white space in head
    static BOOL  IsSpace     (char ch);       // distinguish the char is white space
    static void  CutTailWS   (char* lpsz);    // filter the tail white space
    static void  SkipHeadZero(char* lpsz);    // skip all zero in head
    static BOOL  IsZero      (char ch);       // distinguish the char is zero
    static BOOL  IsHex       (char* lpsz);    // distinguish the string is Hex
    static BOOL  IsDec       (char* lpsz);    // distinguish the string is Dec
    static BOOL  IsSymbol    (char* lpsz);    // distinguish the string is symbol(#AA)
    static BOOL  IsSymbolData(char* lpsz);    // distinguish the string is sym data ($aa)   
      
 	FORMATTYPE  IsWhichFormat (void);        // Return the format enum
    BOOL   CheckLength (FORMATTYPE ft, const CString &lpsz);  // Check if overflow

public:
    // Constructor                 
    CFormatAddress();

    //Implementation
    virtual  BOOL  SplitPrefix(const char* lpsz) = 0;
    virtual  BOOL  ConvertCheck() = 0;
};

#endif

//////////////////////////////////////(EOF)////////////////////////////////////

