/***************************************************************************
**
**    $Header$
**
**    $Log$
** 
****************************************************************************/

/****************************************************************************
**
**  Name:      Addrapi.cpp
**
**  Description: Main file of the address server API
**               Only for 196 base family CPU
**
**  Status: Initialization
**          1996/09/16        Annie Yi
**
**  Copyright (C) 1996 Microtek International.  All rights reserved.
******************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#include "stdafx.h"
#include "address.h"                // Include main head file
#include "export.h"

//#include "symblsvr.h"
// include error handling head file
//
#include "hosterrs.h"
//#include "errcodea.h"
//#include "errcodec.h"                   

//for build
//#include "dad.h"                   
//#include "cpucom.h"
//#include "cpusvr.h"               // Include CPU server for GetMemoryRange()

                       /****************************
                        *                          *
                        *    EXTERNAL VARIABLES    *
                        *                          *
                        ****************************/

//for build
//extern RETCODE EXPORT ErrGetErrorText(U32 errorCode, LPSTR lpszError ...);
//extern RETCODE EXPORT ErrGetErrorText(U32 errorCode, CString& strError ...);

                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/
static char* BASED_CODE SpaceString[] =
               {
                  "", "P0:", "P1:", "P2:", "P3:", "X0:", "X1:", "X2:", "X3:", "", "I:"
               };

                       /****************************
                        *                          *
                        *       GLOBAL VARS        *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *     LOCAL PROTOTYPES     *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *      EXECUTABLE CODE     *
                        *                          *
                        ****************************/

/**----------------------------------------------------------------------
 **   AdrAddrToHex
 **
 **   addr        Set to the address.
 **   adrstr      Set to the converted address text string .
 **
 **   Remark
 **      Call this function to convert an address to text string. The
 **      address descripted by the ADDRESS struct.
 **      If there is no space, the adrSpace must set to SPACE_UNDEFINE.
 **      The result hex string hasn't any leading zero.
 **
 **   Return value
 **      One of the enum of ADDR_RETCODE.
 **      If this return value equal to ADR_OK, the convert is successful.
 **      The second parameter -- adrstr will be changed to the hex address
 **      string if convert is successful. Otherwise, the adrstr will not
 **      be changed
 **
 **      (See the defination of the ADDR_RETCODE)
 **
 **      Examples
 **         char         strTemp[150];
 **         ADDR_RETCODE retCode;
 **         ADDRESS      address;
 **
 **         address.adrSpace = SPACE_P0;
 **         address.address = 100;
 **         retCode = AdrAddrToHex(address, strTemp);
 **         if (ADR_OK == retCode)
 **             // The convert is successful. The address is correct.
 **         else
 **             // The convert is failure. The address has some error
 **
 **         The address of 100 in program area will be converted to the
 **         hex text string strTemp. The parameter strTemp is change to
 **         "P0:0x64".
 **----------------------------------------------------------------------*/
ADDR_RETCODE WINAPI AdrAddrToHex( const ADDRESS   addr,  LPSTR    adrstr )
{
   	ASSERT(NULL != adrstr);

   	C196Address address(addr);
   	CString     adr;
   	ADDR_SPACE  space = SPACE_UNDEFINE;
   	BOOL        bIsOk = FALSE;
    
	adr.Empty();
		
   	bIsOk = address.ConvertCheck();
   	if (bIsOk) {
      	adr = address.GetHexAddr();
      	space = address.GetSpace();    	            	
		strcpy(adrstr, SpaceString[space]);
		strcat(adrstr, adr.GetBuffer(adr.GetLength()));						
   	}
   
   	return address.GetRetCode();
}

ADDR_RETCODE WINAPI AdrAddrToHex( const ADDRESS   addr,  CString  &adrstr )
{
   	C196Address address(addr);
   	CString     adr;
   	ADDR_SPACE  space = SPACE_UNDEFINE;
   	BOOL        bIsOk = FALSE;    
		
	adr.Empty();   	
   	bIsOk = address.ConvertCheck();
   	if (bIsOk) {
      	adr = address.GetHexAddr();
      	space = address.GetSpace();
    	adrstr = SpaceString[space];
     	adrstr += adr;
   	}      
   
   	return address.GetRetCode();
}  // End of AdrAddrToHex()


ADDR_RETCODE WINAPI AdrDadAddrToHex( const ADDRESS   addr,  CString  &adrstr )
{
   	C196Address address(addr);
   	CString     adr;                             
   	CString	    strTemp;	
   	CString     strAddr;
   	ADDR_SPACE  space = SPACE_UNDEFINE;
   	BOOL        bIsOk = FALSE;
   	   	           
	adr.Empty();   	   	   	           
	strTemp.Empty();   	   	   	           
	strAddr.Empty();   	   	   	           
	
   	bIsOk = address.ConvertCheck();
   	if (bIsOk) {
      	adr = address.GetHexAddr();
      	space = address.GetSpace();

  	 	strTemp = adr.Right(adr.GetLength()-2);
  	 	int nLen = strTemp.GetLength();
  	 	if ( nLen != 4) { 			
  	 		for ( int i=0; i<(4-nLen); i++ ) {
  	 			strAddr += '0';
  	 		}	           
  	 		strAddr += strTemp;
  	 	}
  	 	else {
  	 		strAddr = strTemp;
  	 	}
  	 	strAddr.MakeUpper();
     	adrstr = SpaceString[space];
     	adrstr += strAddr;
   	}      
   
   	return address.GetRetCode();
}  // End of AdrDadAddrToHex()


ADDR_RETCODE WINAPI AdrDadAddrToHex( const ADDRESS   addr,  LPSTR    adrstr )
{
   	ASSERT(NULL != adrstr);

   	C196Address address(addr);
   	CString     adr;       
   	CString	    strTemp;	   	
   	CString     strAddr;
   	ADDR_SPACE  space = SPACE_UNDEFINE;
   	BOOL        bIsOk = FALSE;   
   	char        pszTemp[256];
   	   	           
	adr.Empty();   	
	strTemp.Empty();
	strAddr.Empty();
	   	   	           
   	bIsOk = address.ConvertCheck();
   	if (bIsOk) {
      	adr = address.GetHexAddr();
      	space = address.GetSpace();

  	 	strTemp = adr.Right(adr.GetLength()-2);
  	 	int nLen = strTemp.GetLength();
  	 	if ( nLen != 4) { 			
  	 		for ( int i=0; i<(4-nLen); i++ ) {
  	 			strAddr += '0';
  	 		}	           
  	 		strAddr += strTemp;
  	 	}
  	 	else {
  	 		strAddr = strTemp;
  	 	}
  	 	strAddr.MakeUpper();
    	strcpy(adrstr, SpaceString[space]);
     	strcat(adrstr, strAddr);
   	}
   
   	return address.GetRetCode();
}


/**----------------------------------------------------------------------
 **   AdrAddrToDec
 **
 **   addr     Set to the address.
 **   adrstr   Set to the converted address dec text string .
 **
 **   Remark
 **   Call this function to convert an address to dec text string. 
 **   The converted address text string will store in the third parameter
 **   (adrstr).
 **   If there is no space, the adrSpace must set to 196SPACE_UNDEFINE.
 **   The result dec string hasn't any leading zero.
 **
 **   Return value
 **   One of the enum of ADDR_RETCODE.
 **   If this return value equal to ADR_OK, the convert is successful.
 **   (See the defination of the ADDR_RETCODE)
 **
 **   Examples
 **      char         strTemp[150];
 **      ADDR_RETCODE retCode;
 **      ADDRESS      address;
 **
 **      address.adrSpace = SPACE_PROGRAME;
 **      address.address = 100;
 **      retCode = AdrAddrToDec(address, strTemp);
 **      if (ADR_OK == retCode)
 **         // The convert is successful. The address is correct.
 **      else
 **         // The convert is failure. The address has some error
 **
 **   The address of 100 in program area will be converted to the dec text
 **   string strTemp. The parameter strTemp is change to "100"
 **
 **----------------------------------------------------------------------*/
/*
ADDR_RETCODE AdrAddrToDec( const ADDRESS   addr, LPSTR adrstr )
{
   	ASSERT(NULL != adrstr);

   	C196Address address(addr);
   	CString     adr = "";
   	ADDR_SPACE  space = SPACE_UNDEFINE;
   	BOOL        bIsOk = FALSE;

   	bIsOk = address.ConvertCheck();
   	if (bIsOk) {
      	adr = address.GetDecAddr();
      	space = address.GetSpace();
      	if (SPACE_S == space) { 
         	lstrcpy(adrstr, SpaceString[space]);
         	char *temp = new char[adr.GetLength()+1];
         	ASSERT(NULL != temp);
         	lstrcpy(temp, adr.GetBuffer(adr.GetLength()));
         	lstrcpy(adrstr+2, temp);
         	delete []temp;
      	}
      	else
	      	lstrcpy(adrstr, adr.GetBuffer(adr.GetLength()));   
   	}
   
   	return address.GetRetCode();
}

ADDR_RETCODE AdrAddrToDec( const ADDRESS   addr, CString &adrstr )
{

   	C196Address address(addr);
   	CString     adr = "";
   	ADDR_SPACE  space = SPACE_UNDEFINE;
   	BOOL        bIsOk = FALSE;

   	bIsOk = address.ConvertCheck();
   	if (bIsOk) {
      	adr = address.GetDecAddr();
      	space = address.GetSpace();
      	if (SPACE_S == space) {
          	adrstr = SpaceString[space];
          	adrstr += adr;
      	}
      	else
	      	adrstr = adr;
   	}      
   
   	return address.GetRetCode();
}  // End of AdrAddrToDec()
*/

/**----------------------------------------------------------------------
 **   AdrTextToAddr
 **
 **   adrstr  Set to the address text string;
 **   addr    Set to the return address(converted address)
 **
 **   Remark
 **   Call this function to convert a hex address text string.
 **   The converted address store in the second parameter(addr).
 **   The address text string will set to hex string only.
 **
 **   Return value
 **   One of the enum of ADDR_RETCODE.
 **   If this return value equal to ADR_OK, the convert is successful.
 **   (See the defination of the ADDR_RETCODE).
 **
 **   If the address text string doesn't include any space, the field
 **   in ADDRESS (adrSpace) will set to SPACE_UNDEFINE.
 **
 **   Examples
 **       char            *adrStr = "r:0x64";
 **       ADDRESS         address;
 **       ADDR_RETCODE    retCode;
 **
 **       retCode = AdrTextToAddr(adrstr, address);
 **       if (ADR_OK == retCode)
 **           // The convert is successful. The address is correct.
 **       else
 **           // The convert is failure. The address has some error
 **
 **----------------------------------------------------------------------*/
ADDR_RETCODE WINAPI AdrTextToAddr(const LPSTR  adrstr, ADDRESS &addr, UINT isHex)
{  
   	C196Address  address(adrstr, isHex);
   	BOOL         bIsOk = FALSE;
                                 
   	bIsOk = address.ConvertCheck();
   	if (bIsOk) {
      	addr.adrSpace = address.GetSpace();
      	addr.adrAddress = address.GetAddress();
   	}

   	return address.GetRetCode();
}


ADDR_RETCODE WINAPI AdrTextToAddr(const CString& adrstr, ADDRESS &addr, UINT isHex)
{  
   	C196Address  address(adrstr, isHex);
   	BOOL         bIsOk = FALSE;

   	bIsOk = address.ConvertCheck();
   	if (bIsOk) {
     	addr.adrSpace = address.GetSpace();
      	addr.adrAddress = address.GetAddress();
   	}

   	return address.GetRetCode();
}  // End of AdrTextToAddr()


///////////////////////////////////////////////////////////////////////
// AdrShellToAddr
//    Only for shell window
//    The third parameter is a space define(default is data area)
//
ADDR_RETCODE WINAPI
AdrShellToAddr(const CString& adrstr, ADDRESS &addr, ADDR_SPACE Space)
{
   	ADDR_RETCODE retCode;
   
   	retCode = AdrTextToAddr(adrstr, addr, 1);    // Convert as address
   	if (ADR_OK == retCode) {
    	if (SPACE_UNDEFINE == addr.adrSpace) {
        	addr.adrSpace = Space;           // Set to default space   	
		 	if (!AdrCheckAddrRange(addr)) {      
		 		retCode = ADR_OUTRANGE;
		 	}
		}	
	}
   	return retCode;
}

ADDR_RETCODE WINAPI 
AdrShellToAddr(const LPSTR  adrstr, ADDRESS &addr, ADDR_SPACE Space)
{
   	ADDR_RETCODE retCode;
   
   	retCode = AdrTextToAddr(adrstr, addr, 1);    // Convert as address
   	if (ADR_OK == retCode) {
      	if (SPACE_UNDEFINE == addr.adrSpace) {
        	addr.adrSpace = Space;           // Set to default space
		 	if (!AdrCheckAddrRange(addr)) {      
		 		retCode = ADR_OUTRANGE;
		 	}
		}	        	
   	}    
   
   	return retCode;
}


/**---------------------------------------------------------------------
 **   AdrCheckAddrRange
 **
 **   address     Set to the address
 **   
 **   Remark
 **   Call this function to check the address range
 **
 **---------------------------------------------------------------------*/

BOOL WINAPI AdrCheckAddrRange(ADDRESS address)
{
   	BOOL  bIsInRange = TRUE;
   	
   	switch(address.adrSpace) {
      	case  SPACE_P0:
      	case  SPACE_P1:
      	case  SPACE_P2:
      	case  SPACE_P3:      	             
            if ( address.adrAddress > dwpMax ||
                 address.adrAddress < dwpMin ) {
            	bIsInRange = FALSE;                
            } 
            break;                                     
      	case  SPACE_X0:
      	case  SPACE_X1:
      	case  SPACE_X2:
      	case  SPACE_X3:      	             
            if ( address.adrAddress > dwxMax ||
                 address.adrAddress < dwxMin ) {
            	bIsInRange = FALSE;                
            } 
            break;                                     
        case  SPACE_I:
            if ( address.adrAddress > dwiMax ||
                 address.adrAddress < dwiMin ) {
            	bIsInRange = FALSE;                
            } 
            break;                                           		
      	default:                                   
      		bIsInRange = FALSE;                
            break;
   	}
   
   	return bIsInRange;
}  // End of AdrCheckAddrRange()

/**----------------------------------------------------------------------
 **   AdrShlCheck2Addr
 **
 **   adrstr1     Set to the first address;
 **   adrstr2     Set to the second address;
 **   ADDR_SPACE  Set the default space
 **
 **   Remark
 **   Call this function to check two address. Only for shell window
 **   Check range
 **   No converting.
 **
 **   Return value
 **   One of the enum of ADDR_RETCODE.
 **   If this return value equal to ADR_OK, the convert is successful.
 **   (See the defination of the ADDR_RETCODE).
 **
 **----------------------------------------------------------------------*/
ADDR_RETCODE WINAPI AdrShlCheck2Addr(const LPSTR adrstr1, const LPSTR adrstr2, ADDR_SPACE space)
{
   	ADDRESS  address1, address2;
   	ADDR_RETCODE   adrRet = ADR_OK;                                
 
   	//adrRet = AdrTextToAddr(adrstr1, address1);
   	adrRet = AdrShellToAddr(adrstr1, address1, space);
   	if (ADR_OK != adrRet) {
      	CString error;
 	  	AdrErrorDeal(adrRet, error);
 	  	char* pszError = new char[error.GetLength()+2];
 	  	strcpy(pszError, error);
 	  	ShowLine(pszError);
 	  	delete []pszError;
      	return adrRet;      
   	}   
   
   	//adrRet = AdrTextToAddr(adrstr2, address2);
   	adrRet = AdrShellToAddr(adrstr2, address2);
   	if (ADR_OK != adrRet) {
      	CString error;
 	  	AdrErrorDeal(adrRet, error);
 	  	char* pszError = new char[error.GetLength()+2];
 	  	strcpy(pszError, error);
 	  	ShowLine(pszError);
 	  	delete []pszError;
      	return adrRet;
   	}   
   	adrRet = AdrCheck2Addr(address1, address2);
   	if (ADR_OK != adrRet) {
      	CString error;
 	  	AdrErrorDeal(adrRet, error);
 	  	char* pszError = new char[error.GetLength()+2];
 	  	strcpy(pszError, error);
 	  	ShowLine(pszError);
 	  	delete []pszError;  
   	}     
   
   	return adrRet;
}

ADDR_RETCODE WINAPI AdrShlCheck2Addr(const CString& adrstr1, const CString& adrstr2, ADDR_SPACE space) 
{
   	ADDRESS  address1, address2;
   	ADDR_RETCODE   adrRet = ADR_OK;

   	adrRet = AdrShellToAddr(adrstr1, address1, space);
   	if (ADR_OK != adrRet)
      	return adrRet;
   	adrRet = AdrShellToAddr(adrstr2, address2);
   	if (ADR_OK != adrRet)
      	return adrRet;
      
   	adrRet = AdrCheck2Addr(address1, address2);
   	return adrRet;
}


/**----------------------------------------------------------------------
 **   AdrCheck2Addr
 **
 **   adrstr1     Set to the first address;
 **   adrstr2     Set to the second address;
 **
 **   Remark
 **   Call this function to check two address.
 **   Check range
 **   No converting.
 **
 **   Return value
 **   One of the enum of ADDR_RETCODE.
 **   If this return value equal to ADR_OK, the convert is successful.
 **   (See the defination of the ADDR_RETCODE).
 **
 **----------------------------------------------------------------------*/
ADDR_RETCODE WINAPI AdrCheck2Addr(const LPSTR adrstr1, const LPSTR adrstr2, ADDR_SPACE space)
{
   	ADDRESS  address1, address2;
   	ADDR_RETCODE   adrRet = ADR_OK;

   	adrRet = AdrShellToAddr(adrstr1, address1, space);
   	if (ADR_OK != adrRet)
      	return adrRet;
   	adrRet = AdrTextToAddr(adrstr2, address2);
   	if (ADR_OK != adrRet)
      	return adrRet;

   	adrRet = AdrCheck2Addr(address1, address2);
   	return adrRet;
}

ADDR_RETCODE WINAPI AdrCheck2Addr(const CString& adrstr1, const CString& adrstr2, ADDR_SPACE space)
{
   	ADDRESS  address1, address2;
   	ADDR_RETCODE   adrRet = ADR_OK;

   	adrRet = AdrShellToAddr(adrstr1, address1, space);
   	if (ADR_OK != adrRet)
      	return adrRet;
   	adrRet = AdrShellToAddr(adrstr2, address2);
   	if (ADR_OK != adrRet)
      	return adrRet;
      
   	adrRet = AdrCheck2Addr(address1, address2);
   	return adrRet;
}

ADDR_RETCODE WINAPI AdrCheck2Addr(ADDRESS address1, ADDRESS address2)
{
   	ADDR_RETCODE   adrRet = ADR_OK;

	if ( address2.adrSpace == SPACE_UNDEFINE ) {
		address2.adrSpace = address1.adrSpace;
	}                                         
	
    if (!AdrCheckAddrRange(address1)) {
        adrRet = ADR_OUTRANGE;
        return adrRet;
    }   
    if (!AdrCheckAddrRange(address2)) {
        adrRet = ADR_OUTRANGE;   
        return adrRet;      
    }
   
	if ( address1.adrSpace != address2.adrSpace) {
	/*
		if ( address1.adrSpace >= SPACE_P0 && address1.adrSpace <= SPACE_P3  
		     && address2.adrSpace >= SPACE_P0 && address2.adrSpace <= SPACE_P3) {
			if ( address2.adrSpace < address1.adrSpace ) {
				adrRet = ADR_COMPERROR;	
				return adrRet;				 
			}   		
		}       
		else if (address1.adrSpace >= SPACE_X0 && address1.adrSpace <= SPACE_X3  
		     && address2.adrSpace >= SPACE_X0 && address2.adrSpace <= SPACE_X3) {
			if ( address2.adrSpace < address1.adrSpace ) {
				adrRet = ADR_COMPERROR;	
				return adrRet;				 
			}   		
		}   
		else {
			adrRet = ADR_COMPERROR;
	      	return adrRet;				 
		}
	*/
		adrRet = ADR_COMPERROR;
      	return adrRet;				 	
	}   
    else {
	    if (address1.adrAddress > address2.adrAddress) {
	        adrRet = ADR_COMPERROR;
	        return adrRet;      
	    }
	}

   	return adrRet;
}  // End of AdrCheck2Addr()


/**----------------------------------------------------------------------
 **   AdrIsOk
 **
 **   adrstr      Set to the address text string;
 **
 **   Remark
 **   Call this function to check the address text string.
 **   No converting.
 **
 **   Return value
 **   True if the address text string is correct.
 **----------------------------------------------------------------------*/
BOOL WINAPI AdrIsOk(const LPSTR   adrstr)
{

   	int isHex = 1;

   	C196Address  address(adrstr, isHex);
   	BOOL        bIsOk = FALSE;
   	ADDRESS     addr;
   
   	bIsOk = address.ConvertCheck();
   	if (bIsOk) {
      	addr.adrSpace = address.GetSpace();
      	addr.adrAddress = address.GetAddress();
   	}
   	else
      	return FALSE;
   
   	bIsOk = AdrCheckAddrRange(addr);
   
   	return bIsOk;
}

BOOL WINAPI AdrIsOk(const CString  adrstr)
{
   	//ASSERT("" != adrstr);
   	int isHex = 1;
   	C196Address  address(adrstr, isHex);
   	BOOL        bIsOk = FALSE;
   	ADDRESS     addr;
   
   	bIsOk = address.ConvertCheck();
   	if (bIsOk) {
      	addr.adrSpace = address.GetSpace();
      	addr.adrAddress = address.GetAddress();
   	}
   	else
      	return FALSE;
   
   	bIsOk = AdrCheckAddrRange(addr);

   	return bIsOk;
}  // End of AdrIsOk()

/**----------------------------------------------------------------------
 **   AdeErrorDeal
 **
 **   Remark
 **   Process the address server's error.
 **   Call this function to return an error message if the callers don't 
 **		want to process the error by themself.
 **
 **   Return value
 **   none
 **----------------------------------------------------------------------*/
void WINAPI AdrErrorDeal(ADDR_RETCODE  retCode, CString &error)
{          
	switch(retCode) {
      case  ADR_OK:              // the address is ok
            //error = "Address is OK!!";
            //::ErrGetErrorText(, strError);
            break;

      case  ADR_FORMATERROR:     // the address format is error
            ::ErrGetErrorText(ER_ADDR_FORMAT, error);
            break;

      case  ADR_INVALIDCHAR:     // the address include invalid char
            ::ErrGetErrorText(ER_ADDR_INVALID, error);
            break;

      case  ADR_OUTRANGE:        // the address out of range
            ::ErrGetErrorText(ER_ADDR_OUTRANGE, error);
            break;

      case  ADR_NOSYMBOL:        // The symbol doesn't exist(Only for conver
                                 // symbol to ADDRESS)
            ::ErrGetErrorText(ER_ADDR_SYMBOL, error);
            break;

      case  ADR_COMPERROR:       // the second address is less than first
            ::ErrGetErrorText(ER_ADDR_COMPARE, error);
            break;

      case  ADR_OVERFLOW:
            ::ErrGetErrorText(ER_ADDR_OVERFLOW, error);
            break;
            
      case  ADR_EMPTY:           // The address text string is empty
            ::ErrGetErrorText(ER_ADDR_EMPTY, error);
            break;
      default:
            ::ErrGetErrorText(ER_ADDR_EMPTY, error);
            break;      
   }

}  // End of AdrErrorDeal()


/**--------------------------------------------------------------------------
 **  Name:   AdrSetAddrRange
 **
 **  Description: Call this function to set the six static memner data(max or
 **               min address range). This function is a static function.
 **               Call this function must before all function. 
 **
 **  Parameters:
 **     input: none
 **
 **     output:none
 **-------------------------------------------------------------------------*/
 
void WINAPI AdrSetAddrRange()
{
   	//Call CPU server, get all space address range
   
	// for build, 2/12/97
/*
	dwpMin = 0;
	dwpMax = 0xffff;
	dwxMin = 0;
	dwxMax = 0xffff;
	dwiMin = 0;
	dwiMax = 0xff;
    return;
*/    
    CPUMEMORYRANGE stRange;

    DllGetMemoryRange(stRange);   // Get the current cpu memory
    dwpMin = stRange.pMin;     // program min
    dwpMax = stRange.pMax;     // program max
    dwxMin = stRange.xMin;     // data min
    dwxMax = stRange.xMax;     // data max
    dwiMin = stRange.iMin;     // on_chip min
    dwiMax = stRange.iMax;     // on_chip max
}
                       
BOOL WINAPI AdrAddrToSymbol(const ADDRESS &addr, LPSTR symbol)
{
   	// Add AddrToSymbol() by Symbol server
               
   	if (AddrToSym(addr.adrSpace, addr.adrAddress, symbol) != GOOD) {
   		return FALSE;			
   	}               
   	else {   
   		return TRUE;                 //   address.GetRetCode();
   	}	        
   	
//   	return TRUE;
}

BOOL WINAPI AdrAddrToSymbol(const ADDRESS &addr, CString& symbol)
{
   	// Add AddrToSymbol() by Symbol server
   	//

	char * chSymbol = new char[256];   
   	if (AddrToSym(addr.adrSpace, addr.adrAddress, chSymbol) != GOOD) {
   		delete chSymbol;
   		return FALSE;			
   	}                                                                
   	else {   		
   		symbol = chSymbol;
   		delete chSymbol;                                             
   		return TRUE;                 
   	}	


}  // End of AdrAddrToSymbol()

//Added by Annie, 2/12/97
int WINAPI GetBankInfo()
{                         
	//for build   4/16/97
	//Call CPU server to get bank switch information(has bank or not)
/*
					COMBINATION					SEPARATION
		1 bank		P0:  		  COMB1			P0:, X0:   			SEPB1
		2 bank		P0:, P1:      COMB2         P0:, P1:, X0:, X1:  SEPB2
		4 bank		P0: ~ P3:	  COMB4				
*/

	int nMapMode = 0;
	int nBankNum = 0;
	
	nMapMode = DllGetMemMode();		//0:COM, 1:SEP                  
	nBankNum = DllGetBankNumber();	//0: 1 BANK, 1: 2 BANKS, 2: 4BANKS
	
	if ( nMapMode == 0 ) {
		if ( nBankNum == 0 ) {
			return COMB1;
		}                
		else if ( nBankNum == 1 ) {
			return COMB2;
		}
		else if ( nBankNum == 2 ) {
			return COMB4;
		}	
	}
	else if ( nMapMode == 1 ) {
		if ( nBankNum == 0 ) {
			return SEPB1;
		}                
		else if ( nBankNum == 1 ) {
			return SEPB2;
		}
	}                     
	
	return COMB1;
	
	//return COMB2;
	//return COMB4;
	//return SEPB1;
	//return SEPB2;
}   

DWORD WINAPI GetPMin()
{
	return dwpMin;
}                 

DWORD WINAPI GetPMax()
{
	return dwpMax;
}                 

DWORD WINAPI GetXMin()
{
	return dwxMin;
}                 

DWORD WINAPI GetXMax()
{
	return dwxMax;
}                 

DWORD WINAPI GetIMin()
{
	return dwiMin;
}                 

DWORD WINAPI GetIMax()
{
	return dwiMax;
}                 

      
/////////////////////////////(EOF)//////////////////////////////

