/***************************************************************************
**
**    $Header$
**
**    $Log$
** 
****************************************************************************/

/****************************************************************************
**
**  Name:      FmtHex.cpp
**
**  Description:  This file describe the hexadecimal string class. Deprivde
**                from the class CFormatString.
**                This class process the hex string, convert it to data(number)
**
**  Status: Initialization
**          1996/03/04        Daniel Lin
**
**  Copyright (C) 1996 Microtek International.  All rights reserved.
*****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#include "stdafx.h"                                                
#include "address.h"                // Include main head file

                       /****************************
                        *                          *
                        *    EXTERNAL VARIABLES    *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *       GLOBAL VARS        *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *     LOCAL PROTOTYPES     *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *      EXECUTABLE CODE     *
                        *                          *
                        ****************************/

/**------------------------------------------------------------------------**
 ** Name: CFormatHexStr                                                    **
 **       Constructor of the CFormatHexStr                                 **
 **                                                                        **
 ** parameter :                                                            **
 **       CString&                                                         **
 **                                                                        **
 ** return value :                                                         **
 **       none                                                             **
 **------------------------------------------------------------------------**/

CFormatHexStr :: CFormatHexStr(CString& str)
{
   	m_strOriginHexStr = str;
}

/**------------------------------------------------------------------------**
 ** Name:  CFormatHexStr                                                   **
 **        Constructor                                                     **
 **                                                                        **
 ** parameter :                                                            **
 **        char* lpsz                                                      **
 **                                                                        **
 ** return value :                                                         **
 **        none                                                            **
 **------------------------------------------------------------------------**/

CFormatHexStr :: CFormatHexStr(char* lpsz)
{
   	m_strOriginHexStr = lpsz;
}

/**------------------------------------------------------------------------**
 ** Name:  Convert                                                         **
 **        COnvert the string                                              **
 **                                                                        **
 ** parameter :  none                                                      **
 **                                                                        **
 ** return value :   none                                                  **
 **------------------------------------------------------------------------**/

void
CFormatHexStr :: Convert()      // Process the convert
{
   	char *psz1 = new char[m_strOriginHexStr.GetLength()+2];
   	char *psz2 = new char[m_strOriginHexStr.GetLength()+2];
   
   	ASSERT(NULL != psz1);
   	ASSERT(NULL != psz2);
   	memset(psz1, 0, m_strOriginHexStr.GetLength()+2);
   	memset(psz2, 0, m_strOriginHexStr.GetLength()+2);
   	strcpy(psz1, m_strOriginHexStr.GetBuffer(m_strOriginHexStr.GetLength()));
   	strcpy(psz2, psz1+2);   //Skip head leading '0x'
   	m_bIsOk = Hex2Num(psz2, m_dwData);   	
   	delete []psz1;
   	delete []psz2;
   
   	return;
}

