/***************************************************************************
**
**    $Header$
**
**    $Log$
** 
****************************************************************************/

/****************************************************************************
**
**  Name:      Fmtsym.cpp
**
**  Description:  This file describe the symbol string class. Deprivde
**                from the class CFormatString.
**                This class process the symbol string, convert it to data(number)
**
**  Status: Initialization
**          1996/03/11        Daniel Lin
**
**  Copyright (C) 1996 Microtek International.  All rights reserved.
*****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#include "stdafx.h"                                                
#include "address.h"                // Include main head file
#include "export.h"
                       /****************************
                        *                          *
                        *    EXTERNAL VARIABLES    *
                        *                          *
                        ****************************/


                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *       GLOBAL VARS        *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *     LOCAL PROTOTYPES     *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *      EXECUTABLE CODE     *
                        *                          *
                        ****************************/

/**------------------------------------------------------------------------**
 ** Name: CFormatSymbol                                                    **
 **       Constructor of the CFormatSymbol                                 **
 **                                                                        **
 ** parameter :                                                            **
 **       CString&                                                         **
 **                                                                        **
 ** return value :                                                         **
 **       none                                                             **
 **------------------------------------------------------------------------**/

CFormatSymbol :: CFormatSymbol(const CString& str)
{
   	m_strOriginSymbol = str;
}

/**------------------------------------------------------------------------**
 ** Name:  CFormatSymbol                                                   **
 **        Constructor                                                     **
 **                                                                        **
 ** parameter :                                                            **
 **        char* lpsz                                                      **
 **                                                                        **
 ** return value :                                                         **
 **        none                                                            **
 **------------------------------------------------------------------------**/

CFormatSymbol :: CFormatSymbol(const char* lpsz)
{
   	m_strOriginSymbol = lpsz;
}  	

/**------------------------------------------------------------------------**
 ** Name:  Convert                                                         **
 **        Convert the string                                              **
 **                                                                        **
 ** parameter :  none                                                      **
 **                                                                        **
 ** return value :   none                                                  **
 **------------------------------------------------------------------------**/

void
CFormatSymbol :: Convert()      // Process the convert
{           
   	char *psz = new char[m_strOriginSymbol.GetLength()+2];
   	DWORD dwNum = 0;

   	ASSERT(NULL != psz);
   	strcpy(psz, m_strOriginSymbol.GetBuffer(m_strOriginSymbol.GetLength()));
   
   
   	// Call Symbol Server
   	// Symbol To Address
           
   	short uSymbolData = 0;
   
   	switch (m_uSymData) {
      	case  0:             // Symbol (# as leading char)
            if (0 == ::SymToAddr(psz, &m_uchType, &m_dwData))
               	m_bIsOk = TRUE;
            else
               	m_bIsOk = FALSE;   
            break;               
            
      	case  1:             // Symbol Data ($ as leading char)
            if (0 == ::GetUserVarValue(psz, uSymbolData)) {
               	m_dwData = (DWORD)uSymbolData;
               	m_bIsOk = TRUE;
            }               
            else
               	m_bIsOk = FALSE;   
            break;               
   	}            
      
   	delete []psz;
	return;
}
