/***************************************************************************
**
**    $Header$
**
**    $Log$
** 
****************************************************************************/

/****************************************************************************
**
**  Name:   Address.h
**
**  Description:  The main head file
**
**  Status:       Initialization
**                1996/09/16                    Annie Yi
**
**  Copyright (C) 1996 Microtek International.  All rights reserved.
**
*****************************************************************************/
#ifndef __ADDRESS__H
#define __ADDRESS__H

typedef enum tagADDRRET
{     
	ADR_OK            = 1,       // the address is OK
    ADR_FORMATERROR   = 2,       // the address format is error
    ADR_INVALIDCHAR   = 3,       // the address include invalid char
    ADR_OUTRANGE      = 4,       // the address out of range
    ADR_NOSYMBOL      = 5,       // The symbol doesn't exist(Only for conver
                                 // symbol to ADDRESS)
    ADR_COMPERROR     = 6,       // the second address is less than first
    ADR_OVERFLOW      = 7,       // the address text string is overflow
    ADR_EMPTY         = 8,       // the address text string is empty
      
}ADDR_RETCODE;

typedef BYTE  ADDR_SPACE  ;

#define   SPACE_UNDEFINE  BYTE(0)  // Undefine the area
#define   SPACE_P0	  	  BYTE(1) 
#define   SPACE_P1        BYTE(2) 
#define   SPACE_P2        BYTE(3) 
#define   SPACE_P3        BYTE(4) 
#define   SPACE_X0        BYTE(5) 
#define   SPACE_X1        BYTE(6) 
#define   SPACE_X2        BYTE(7) 
#define   SPACE_X3        BYTE(8) 
#define   SPACE_I         BYTE(10)

struct  ADDRESS
{
	BYTE  adrSpace;   		// The address attribute                           
   	DWORD adrAddress; 		// The address
};

#ifdef __cplusplus
extern "C" {
#endif	// __cplusplus

void WINAPI InitDLL_AddressServer();

#ifdef __cplusplus
}
#endif	// __cplusplus

//for build, 4/25/97
#include "abibase.h"
#include "addrapi.h"

#endif
//////////////////////////////////////(EOF)//////////////////////////////////

