/***************************************************************************
**
**    $Header$
**
**    $Log$
** 
****************************************************************************/

/****************************************************************************
**
**  Name:   Adfmtsym.h
**
**  Description:  Describe the class of CFormatSymbol. The sub class deprived
**                from the class CFormatString. This class process the symbol
**                The symbol format is:
**                   #ModuleName:#SymbolName
**
**  Status:       Initialization
**                1996/02/16                    Daniel Lin
**
**  Copyright (C) 1996 Microtek International.  All rights reserved.
**
*****************************************************************************/

#ifndef __ADFMTSYM__H
#define __ADFMTSYM__H

class CFormatSymbol : public CFormatString
{
   private:
      CString  m_strOriginSymbol;   // Oringinal symbol string as the format
                                    // #ModuleName:#SymbolName
      CString  m_strModule;         // The module name
      CString  m_strSymbol;         // The symbol name
      DWORD    m_dwData;            // Converted address data
      unsigned char m_uchType;      // Segment space type
      
   public:
      UINT     m_uSymData;          // 0 -- Symbol
                                    // 1 -- Symbol Data   
      
      // Constructor
      CFormatSymbol(const CString& str);
      CFormatSymbol(const char* lpsz);

      //Implementation
      virtual  void Convert();      // Process the convert   
      
      CString  GetModuleName()      // Return the module name
      {
         return m_strModule;
      };
      
      CString  GetSymbolName()      // Return the symbol name
      {
         return m_strSymbol;
      };
      
      DWORD    GetAddress()            // Return the symbol data
      {
         return m_dwData;
      };
      
      unsigned char GetSpace()      // Return the space type
      {
         return m_uchType;
      };
};

#endif

//////////////////////////////////(EOF)///////////////////////////////////////
