
#include "stdafx.h"
#include "resource.h"

#include "bankinit.h"
#include "abiextfn.h" 
#include "init196.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


extern void ShlReshowLine(char * pch, int nLen);
extern void ShowLine(char* pszBuffer);

/////////////////////////////////////////////////////////////////////////
int g_nMemMode=0, g_nBankNumber=0; 
int g_nLowPort=1, g_nLowBit=0;
int g_nHighPort=1, g_nHighBit=1;
int g_nLowSignal=0, g_nHighSignal=0;

BOOL InitBank()
{
 	 CString  strErr;
 	 int nComOrSep, nComBank, nSepBank;
 	 int nLowBit, nHighBit, nLowPort, nHighPort;
 	 int nLowSignal, nHighSignal;
// 	 int nWidth;
 	 
	 nComOrSep = AfxGetApp()->GetProfileInt("BankInfo","BankOption",-1);
	 if( !(nComOrSep==0||nComOrSep==1) ) goto FAIL;
	 if( nComOrSep==0 ){
	     nComBank = AfxGetApp()->GetProfileInt("BankInfo","BankNumber",-1);
	     if(!(nComBank==0||nComBank==1||nComBank==2)){
	        goto FAIL;
	     }
	 }
	 else {   
	     nSepBank = AfxGetApp()->GetProfileInt("BankInfo", "BankNumber",-1);
	     if(!(nSepBank==0||nSepBank==1)){
	        goto FAIL;
	     }
	 }
	 
	 nLowBit = AfxGetApp()->GetProfileInt("BankInfo","BankA16Bit",-1);
	 if(!IsValueValid(nLowBit, 0, 7)){
	    goto FAIL;
	 }
	 
	 nHighBit = AfxGetApp()->GetProfileInt("BankInfo","BankA17Bit",-1);
	 if(!IsValueValid(nHighBit, 0, 7)){
	    goto FAIL;
	 }
	     
	 nLowPort = AfxGetApp()->GetProfileInt("BankInfo","BankA16Port",-1);
	 if(!IsValueValid(nLowPort, 0, 7)){
	    goto FAIL;
	 }
	 
	 nHighPort = AfxGetApp()->GetProfileInt("BankInfo","BankA17Port",-1);
	 if(!IsValueValid(nHighPort, 0, 7)){
	    goto FAIL;
	 }
	 
	 if(nLowPort==nHighPort&&nLowBit==nHighBit){
	    if((nLowBit+1)<8) nHighBit = nLowBit + 1; 
	 }

	 nLowSignal = AfxGetApp()->GetProfileInt("BankInfo", "BankA16Signal", -1);
	 nHighSignal = AfxGetApp()->GetProfileInt("BankInfo", "BankA17Signal", -1);
	   
	 if(!(nLowSignal==1||nLowSignal==0)){
	    goto FAIL;
	  }
	 if(!(nHighSignal==1||nHighSignal==0)){
	    goto FAIL;
	  }
//	 nWidth = AfxGetApp()->GetProfileInt("BankInfo", "Width", -1);
     
//     if(!(nWidth==0||nWidth==1)) goto FAIL;
      
	 BANKINIT initbank;
	 int err;
	 
	 err = emuSetMemMode(U8(nComOrSep));
	 if(err != ICE_OK){
	    strErr.LoadString(IDS_BANK_1);
	    AfxMessageBox(strErr);
	    return 0;
	 }
	 g_nMemMode = nComOrSep;
	 
	 if(nComOrSep==0){
	    switch(nComBank){
	     case 0:
	          initbank.bPinLow = 0xff;
	          initbank.bPinHigh = 0xff;
	          break;
	     case 1:
	          initbank.bPinLow = BYTE((nLowPort+1)*8+nLowBit);   
	          initbank.bPinLowAct = BYTE(nLowSignal);
	          initbank.bPinHigh = 0xff;
	          break;
	     case 2:
	          initbank.bPinLow = BYTE((nLowPort+1)*8+nLowBit);   
	          initbank.bPinLowAct = BYTE(nLowSignal);
	          initbank.bPinHigh = BYTE((nHighPort+1)*8+nHighBit);   
	          initbank.bPinHighAct = BYTE(nHighSignal);
	          break;
	     default:
	          goto FAIL;
	    }
	  }     
	  else{  
	    switch(nSepBank){
	     case 0:
	          initbank.bPinLow = 0xff;
	          initbank.bPinHigh = 0xff;
	          break;
	     case 1:
	          initbank.bPinLow = BYTE((nLowPort+1)*8+nLowBit);   
	          initbank.bPinLowAct = BYTE(nLowSignal);
	          initbank.bPinHigh = 0xff;
	          break;
	     default:
	          goto FAIL;
	    }
	  }
	  err = emuInitBank(&initbank);
	  if(err != ICE_OK){
         strErr.LoadString(IDS_BANK_2);
	     AfxMessageBox(strErr);
	     return 0;
	  }
	  g_nBankNumber = (nComOrSep==0)?nComBank:nSepBank;  
	  g_nLowPort = nLowPort+1;
	  g_nLowBit = nLowBit;
	  g_nHighPort = nHighPort+1;
	  g_nHighBit = nHighBit;
	  g_nHighSignal = nHighSignal;
	  g_nLowSignal = nLowSignal;
	  
/*
	  U8 ID_Info[10];
	  err = emuGetID(ID_Info);
      if((ID_Info[5] == 0) && (nWidth == 1)){
         AfxMessageBox("  The current MICE setting only supports the 8 bits data bus,\n"
          "but the setting of Data Bus Width in the BANK SETUP is: 16\n "
          "bits data bus. \n"
          "  If the target is 8 bits data bus width, \n"
          "Please change the setting of the Data Bus Width in the BANK SETUP\n"
          "to 8 bits data bus width. \n"
          "  If the target is 16 bits data bus width.\n"
          "Please run the FWSETUP to updata the HardWare to support 16 bits\n"
          "data bus. When run the FWSETUP, please load the \n"
          "\\Hardware\\bus16bit.jed");
         return 0;
      }
      else if((ID_Info[5] == 1) && (nWidth == 0)){
 		 AfxMessageBox("  The current MICE setting only supports the 16 bits data bus,\n"
          "but the setting of Data Bus Width in the BANK SETUP is: 8\n "
          "bits data bus. \n"
          "  If the target is 16 bits data bus width, \n"
          "Please change the setting of the Data Bus Width in the BANK SETUP\n"
          "to 16 bits data bus width. \n"
          "  If the target is 8 bits data bus width.\n"
          "Please run the FWSETUP to updata the HardWare to support 8 bits\n"
          "data bus. When run the FWSETUP, please load the \n"
          "\\Hardware\\bus8bit.jed");
         return 0;       
      }
*/
	  return 1;
FAIL:
	 
	 strErr.LoadString(IDS_BANK_3);
	 AfxMessageBox(strErr);
	 return 1 ;    
  }   
  
BOOL IsValueValid(int value, int min, int max)
{
 
 for(int i=min; i<=max; i++){
     if(value == i) return 1;
 }
 return 0;
}
  
//for export to load dll

int WINAPI DllLdrGetMemMode(void)
{   
	//0:COM, 1:SEP                  
	return g_nMemMode;
}                     

int WINAPI DllLdrGetBankNumber(void)
{                      
	//0: 1 BANK, 1: 2 BANKS, 2: 4BANKS
	return g_nBankNumber;
}                     
	
int WINAPI DllLdrGetHighPort(void)
{   
	//0:COM, 1:SEP                  
	return g_nHighPort;
}                     

int WINAPI DllLdrGetHighBit(void)
{                      
	//0: 1 BANK, 1: 2 BANKS, 2: 4BANKS
	return g_nHighBit;
}                     
int WINAPI DllLdrGetLowPort(void)
{   
	//0:COM, 1:SEP                  
	return g_nLowPort;
}                     

int WINAPI DllLdrGetLowBit(void)
{                      
	//0: 1 BANK, 1: 2 BANKS, 2: 4BANKS
	return g_nLowBit;
}                     
int WINAPI DllLdrGetLowSignal(void)
{   
	//0:COM, 1:SEP                  
	return g_nLowSignal;
}                     

int WINAPI DllLdrGetHighSignal(void)
{                      
	//0: 1 BANK, 1: 2 BANKS, 2: 4BANKS
	return g_nHighSignal;
}                     

void WINAPI DLLLdrShowLine(char* pszBuffer)
{
	ShowLine( pszBuffer);
}	

void WINAPI DLLLdrShlReshowLine(char * pch, int nLen)
{
   ShlReshowLine(pch, nLen);
}       

