// bankinit.cpp : Defines the class behaviors for the application.
//

#include "stdafx.h"
#include "bankinit.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
// CBankinitApp commands
/////////////////////////////////////////////////////////////////////////////
// CBankInit dialog


CBankInit::CBankInit(CWnd* pParent /*=NULL*/)
	: CDialog(CBankInit::IDD, pParent)
{
	//{{AFX_DATA_INIT(CBankInit)
	m_nHighBit = -1;
	m_nHighPort = -1;
	m_nLowPort = -1;
	m_nLowBit = -1;
	//}}AFX_DATA_INIT
	m_nComOrSep = 1;
	m_nComBank = 0; 
	m_nSepBank = 0;
	m_nLowSignal = 0;
	m_nHighSignal = 0;
	
	GetBankInfoFromIni();
}

void CBankInit::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CBankInit)
	DDX_CBIndex(pDX, IDC_HBIT_COM, m_nHighBit);
	DDX_CBIndex(pDX, IDC_HPORT_COM, m_nHighPort);
	DDX_CBIndex(pDX, IDC_LPORT_COM, m_nLowPort);
	DDX_CBIndex(pDX, IDC_LBIT_COM, m_nLowBit);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CBankInit, CDialog)
	//{{AFX_MSG_MAP(CBankInit)
	ON_BN_CLICKED(IDC_COM, OnCom)
	ON_BN_CLICKED(IDC_SEP, OnSep)
	ON_BN_CLICKED(IDC_COM_1, OnCom1)
	ON_BN_CLICKED(IDC_COM_2, OnCom2)
	ON_BN_CLICKED(IDC_COM_4, OnCom4)
	ON_BN_CLICKED(IDC_SEP_1, OnSep1)
	ON_BN_CLICKED(IDC_SEP_2, OnSep2)
	ON_BN_CLICKED(IDC_HIGH_DISABLE, OnHighDisable)
	ON_BN_CLICKED(IDC_HIGH_ENABLE, OnHighEnable)
	ON_BN_CLICKED(IDC_LOW_DISABLE, OnLowDisable)
	ON_BN_CLICKED(IDC_LOW_ENABLE, OnLowEnable)
	ON_BN_CLICKED(IDC_HELP, OnHelp)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CBankInit message handlers

void CBankInit::OnCom()
{
	// TODO: Add your control notification handler code here
	if(m_nComOrSep==0) return;
	
	EnableComOpt(TRUE);
	EnableSepOpt(FALSE);
	if(m_nComBank==0){
	   CheckRadioButton(IDC_COM_1,IDC_COM_4,IDC_COM_1);
       if(m_nSepBank==1) EnableA16(FALSE);
	}                      
	else if(m_nComBank==1){
	   CheckRadioButton(IDC_COM_1,IDC_COM_4,IDC_COM_2);
       CheckSignalButton(1);
	   if(m_nSepBank==0) EnableA16(TRUE);
	}
	else{
       CheckSignalButton(0);
       
	   CheckRadioButton(IDC_COM_1,IDC_COM_4,IDC_COM_4);
       if(m_nSepBank==0){
	      EnableA16(TRUE);
	      EnableA17(TRUE);
	   }
	   else EnableA17(TRUE);
	}
	m_nComOrSep = 0;
}

void CBankInit::OnSep()
{
	// TODO: Add your control notification handler code here
	if(m_nComOrSep==1) return;
	EnableComOpt(FALSE);
	EnableSepOpt(TRUE);
	if(m_nSepBank==0){
	   if(m_nComBank==1) EnableA16(FALSE);
	   else if(m_nComBank==2){
	      EnableA16(FALSE);
	      EnableA17(FALSE);
	   }
	}
	else{
       CheckSignalButton(1);

	   if(m_nComBank==0) EnableA16(TRUE);
	   else if(m_nComBank==2) EnableA17(FALSE);
	}
	m_nComOrSep = 1;
	if(m_nSepBank==0){
	   CheckRadioButton(IDC_SEP_1,IDC_SEP_2,IDC_SEP_1);
	}
	else CheckRadioButton(IDC_SEP_1,IDC_SEP_2,IDC_SEP_2);
}

void CBankInit::OnOK()
{
	// TODO: Add extra validation here
	 UpdateData(TRUE);
	 
	 char buffer[5];
	 
	 sprintf(buffer, "%d\n", m_nComOrSep);
	 
	 WritePrivateProfileString("BankInfo","BankOption",buffer,m_strIniFile);
	 if(m_nComOrSep==0){
        sprintf(buffer, "%d\n", m_nComBank);
        WritePrivateProfileString("BankInfo","BankNumber",buffer,m_strIniFile);
     }   
	 else{
	    sprintf(buffer, "%d\n", m_nSepBank);
        WritePrivateProfileString("BankInfo","BankNumber",buffer,m_strIniFile);
     }
	 
	 sprintf(buffer, "%d\n", m_nLowBit);
	 WritePrivateProfileString("BankInfo","BankA16Bit",buffer,m_strIniFile);
	 sprintf(buffer, "%d\n", m_nHighBit);
	 WritePrivateProfileString("BankInfo","BankA17Bit",buffer,m_strIniFile);
	 sprintf(buffer, "%d\n", m_nLowPort);
	 WritePrivateProfileString("BankInfo","BankA16Port",buffer,m_strIniFile);
	 sprintf(buffer, "%d\n", m_nHighPort);
	 WritePrivateProfileString("BankInfo","BankA17Port",buffer,m_strIniFile);
	 sprintf(buffer, "%d\n", m_nLowSignal);
	 WritePrivateProfileString("BankInfo", "BankA16Signal", buffer,m_strIniFile);
	 sprintf(buffer, "%d\n", m_nHighSignal);
	 WritePrivateProfileString("BankInfo", "BankA17Signal", buffer,m_strIniFile);
	
     CDialog::OnOK();
}

void CBankInit::OnCom1()
{
	// TODO: Add your control notification handler code here
	if(m_nComBank==0) return;
	
	CheckRadioButton(IDC_COM_1,IDC_COM_4,IDC_COM_1);
    if(m_nComBank==1) EnableA16(FALSE);
	else{
	    EnableA16(FALSE);
	    EnableA17(FALSE);
	}
	m_nComBank = 0;
}

void CBankInit::OnCom2()
{
	// TODO: Add your control notification handler code here
	if(m_nComBank==1) return;
	
	CheckRadioButton(IDC_COM_1,IDC_COM_4,IDC_COM_2);
    CheckSignalButton(1);
    if(m_nComBank==0) {
       EnableA16(TRUE);
    }
	else{
       EnableA17(FALSE);
    }
	m_nComBank = 1;
}

void CBankInit::OnCom4()
{
	// TODO: Add your control notification handler code here
	if(m_nComBank==2) return;
	
	CheckRadioButton(IDC_COM_1,IDC_COM_4,IDC_COM_4);
    CheckSignalButton(0);
    if(m_nComBank==1) {
	   EnableA17(TRUE);
    }
	else{
	    EnableA16(TRUE);
	    EnableA17(TRUE);
	}
	m_nComBank = 2;
}

void CBankInit::OnSep1()
{
	// TODO: Add your control notification handler code here
	if(m_nSepBank==0) return;
	else{
	   CheckRadioButton(IDC_SEP_1,IDC_SEP_2,IDC_SEP_1);
       EnableA16(FALSE);
    }
	m_nSepBank = 0;
}

void CBankInit::OnSep2()
{
	// TODO: Add your control notification handler code here
	if(m_nSepBank==1) return;
	else {
	  CheckRadioButton(IDC_SEP_1,IDC_SEP_2,IDC_SEP_2);
      EnableA16(TRUE);
    }
	CheckSignalButton(1);
	m_nSepBank = 1;
}

void CBankInit::EnableComOpt(BOOL bEnable)
 {
   GetDlgItem(IDC_COM_STATIC)->EnableWindow(bEnable);
   GetDlgItem(IDC_COM_1)->EnableWindow(bEnable);
   GetDlgItem(IDC_COM_2)->EnableWindow(bEnable);
   GetDlgItem(IDC_COM_4)->EnableWindow(bEnable);
 }
 
void CBankInit::EnableSepOpt(BOOL bEnable)
 {
   GetDlgItem(IDC_SEP_STATIC)->EnableWindow(bEnable);
   GetDlgItem(IDC_SEP_1)->EnableWindow(bEnable);
   GetDlgItem(IDC_SEP_2)->EnableWindow(bEnable);
 }

void CBankInit::EnableA16(BOOL bEnable)
 {
   GetDlgItem(IDC_LOW_STATIC)->EnableWindow(bEnable);
   GetDlgItem(IDC_LPORT_STATIC)->EnableWindow(bEnable);
   GetDlgItem(IDC_LPORT_COM)->EnableWindow(bEnable);
   GetDlgItem(IDC_LBIT_STATIC)->EnableWindow(bEnable);
   GetDlgItem(IDC_LBIT_COM)->EnableWindow(bEnable);
   GetDlgItem(IDC_LSIG_STATIC)->EnableWindow(bEnable);
   GetDlgItem(IDC_LOW_ENABLE)->EnableWindow(bEnable);
   GetDlgItem(IDC_LOW_DISABLE)->EnableWindow(bEnable);
 }
 
void CBankInit::EnableA17(BOOL bEnable)
 {
   GetDlgItem(IDC_HIGH_STATIC)->EnableWindow(bEnable);
   GetDlgItem(IDC_HPORT_STATIC)->EnableWindow(bEnable);
   GetDlgItem(IDC_HPORT_COM)->EnableWindow(bEnable);
   GetDlgItem(IDC_HBIT_STATIC)->EnableWindow(bEnable);
   GetDlgItem(IDC_HBIT_COM)->EnableWindow(bEnable);
   GetDlgItem(IDC_HSIG_STATIC)->EnableWindow(bEnable);
   GetDlgItem(IDC_HIGH_ENABLE)->EnableWindow(bEnable);
   GetDlgItem(IDC_HIGH_DISABLE)->EnableWindow(bEnable);
 }
                     
void CBankInit::GetBankInfoFromIni()
{
	  // Get information of bank from EP196.ini
	 
	 if(GetWindowsDirectory(m_strWinPath.GetBuffer(200), 200)==0) return;
	 
	 m_strWinPath.ReleaseBuffer();
	 m_strIniFile = m_strWinPath + "\\EP196.ini";
	 
	 m_nComOrSep = GetPrivateProfileInt("BankInfo","BankOption",1,m_strIniFile);
	 if( m_nComOrSep > 1 ) m_nComOrSep = 0;
	 if( m_nComOrSep==0 ){
	     m_nComBank = GetPrivateProfileInt("BankInfo","BankNumber",0,m_strIniFile);
	     if(!(m_nComBank==0||m_nComBank==1||m_nComBank==2)){
	        m_nComBank = 0;
	     }
	 }
	 else {   
	     m_nSepBank = GetPrivateProfileInt("BankInfo", "BankNumber",0,m_strIniFile);
	     if(!(m_nSepBank==0||m_nSepBank==1||m_nSepBank==2)){
	        m_nSepBank = 0;
	     }
	 }
	 
	 m_nLowBit = GetPrivateProfileInt("BankInfo","BankA16Bit",0,m_strIniFile);
	 if(!IsValueValid(m_nLowBit, 0, 7)){
	    m_nLowBit = 0;
	 }
	 
	 m_nHighBit = GetPrivateProfileInt("BankInfo","BankA17Bit",0,m_strIniFile);
	 if(!IsValueValid(m_nHighBit, 0, 7)){
	    m_nHighBit = 0;
	 }
	     
	 m_nLowPort = GetPrivateProfileInt("BankInfo","BankA16Port",0,m_strIniFile);
	 if(!IsValueValid(m_nLowPort, 1, 7)){
	    m_nLowPort = 0;
	 }
	 
	 m_nHighPort = GetPrivateProfileInt("BankInfo","BankA17Port",0,m_strIniFile);
	 if(!IsValueValid(m_nHighPort, 1, 7)){
	    m_nHighPort = 0;
	 }
	 
	 if(m_nLowPort==m_nHighPort&&m_nLowBit==m_nHighBit){
	    if((m_nLowBit+1)<8) m_nHighBit = m_nLowBit + 1; 
	 }

	 m_nLowSignal = GetPrivateProfileInt("BankInfo", "BankA16Signal", 0,m_strIniFile);
	 m_nHighSignal = GetPrivateProfileInt("BankInfo", "BankA17Signal", 0,m_strIniFile);
	   
	 if(!(m_nLowSignal==1||m_nLowSignal==0)){
	    m_nLowSignal = 0;
	  }
	 if(!(m_nHighSignal==1||m_nHighSignal==0)){
	    m_nHighSignal = 0;
	  }  
	 return;
} 

BOOL CBankInit::IsValueValid(int value, int min, int max)
{
 
 for(int i=min; i<=max; i++){
     if(value == i) return 1;
 }
 return 0;
}

                      
BOOL CBankInit::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here             
	CenterWindow();
	if(m_nComOrSep==0){
	   CheckRadioButton(IDC_COM,IDC_SEP,IDC_COM);
	   EnableSepOpt(FALSE);
	   if(m_nComBank==0){
          CheckRadioButton(IDC_COM_1,IDC_COM_4,IDC_COM_1);
          EnableA16(FALSE);
	      EnableA17(FALSE);
	   }
	   else if(m_nComBank==1){
	      CheckRadioButton(IDC_COM_1,IDC_COM_4,IDC_COM_2);
          EnableA17(FALSE);
          CheckSignalButton(1);
       }
       else{
          CheckRadioButton(IDC_COM_1,IDC_COM_4,IDC_COM_4);
          CheckSignalButton(0);
       }
	}
	else{
	   CheckRadioButton(IDC_COM,IDC_SEP,IDC_SEP);
	   EnableComOpt(FALSE); 
	   if(m_nSepBank==0){
	      CheckRadioButton(IDC_SEP_1,IDC_SEP_2,IDC_SEP_1);
          EnableA16(FALSE);
	      EnableA17(FALSE);
       }
	   else{
	      EnableA17(FALSE);
	      CheckRadioButton(IDC_SEP_1,IDC_SEP_2,IDC_SEP_2);
          CheckSignalButton(1);
       }
 }     
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CBankInit::OnHighDisable()
{
	// TODO: Add your control notification handler code here
	if(m_nHighSignal == 1) return;
	
	CheckRadioButton(IDC_HIGH_ENABLE,IDC_HIGH_DISABLE,IDC_HIGH_DISABLE);
	m_nHighSignal = 1;
}

void CBankInit::OnHighEnable()
{
	// TODO: Add your control notification handler code here
	if(m_nHighSignal == 0) return;
	
	CheckRadioButton(IDC_HIGH_ENABLE,IDC_HIGH_DISABLE,IDC_HIGH_ENABLE);
	m_nHighSignal = 0;
}

void CBankInit::OnLowDisable()
{
	// TODO: Add your control notification handler code here
	if(m_nLowSignal == 1) return;
	
	CheckRadioButton(IDC_LOW_ENABLE,IDC_LOW_DISABLE,IDC_LOW_DISABLE);
	m_nLowSignal = 1;
}

void CBankInit::OnLowEnable()
{
	// TODO: Add your control notification handler code here
	if(m_nLowSignal == 0) return;
	
	CheckRadioButton(IDC_LOW_ENABLE,IDC_LOW_DISABLE,IDC_LOW_ENABLE);
	m_nLowSignal = 0;
}

void CBankInit::CheckSignalButton(BOOL flag)
{
	 if(m_nLowSignal == 1)
	    CheckRadioButton(IDC_LOW_ENABLE,IDC_LOW_DISABLE,IDC_LOW_DISABLE);
	 else CheckRadioButton(IDC_LOW_ENABLE,IDC_LOW_DISABLE,IDC_LOW_ENABLE);
	 
	 if(flag) return;
	
	 if(m_nHighSignal == 1)
	    CheckRadioButton(IDC_HIGH_ENABLE,IDC_HIGH_DISABLE,IDC_HIGH_DISABLE);
	 else CheckRadioButton(IDC_HIGH_ENABLE,IDC_HIGH_DISABLE,IDC_HIGH_ENABLE);
}

   


void CBankInit::OnHelp()
{
	// TODO: Add your control notification handler code here
	char szHelpPath[256];
	
	strcpy(szHelpPath, AfxGetApp()->m_pszHelpFilePath);
	
    int nLen = strlen(szHelpPath);
    while ( nLen ) {
	if ( '\\' == szHelpPath[--nLen] ) {
	    break;
	}
    }
    szHelpPath[++nLen] = '\0';
    
    strcat(szHelpPath, "ep196.hlp");

	::WinHelp(m_hWnd, szHelpPath,  HELP_CONTEXT, 0X200A0);
}
