/***************************************************************************
**
**    $Header:   D:/EP196/SRC/LOG/CPUDLG.H__   1.0   19 May 1997 14:39:14   ZJRD  $
**
**    $Log:   D:/EP196/SRC/LOG/CPUDLG.H__  $
** 
**    Rev 1.0   19 May 1997 14:39:14   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  CPUDLG.H
//
//  Description:The header file for the class: CRegcfgDialog, CRegisterDialog
//
//  Author:     Roger Zhang
//
//  Date:       04/25/95, 10/11/95, by Chris Fang
//
//  Modification:
//
//      1. 04/25/95, Initial version 
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#ifndef _CPUDLG_
#define _CPUDLG_

#include "cpucom.h"

/////////////////////////////////////////////////////////////////////////////
// the list for storing the register values that been entered before
#define MAX_RVAL_LIST   20

/////////////////////////////////////////////////////////////////////////////
// CRegcfgDialog dialog

class CRegcfgDialog : public CDialog
{
// Construction
public:
    CRegcfgDialog(CWnd* pParent = NULL);    // standard constructor
    ~CRegcfgDialog();

// Dialog Data
    BOOL    m_Reg[MAX_REGISTERS];
    CButton m_btnReg[MAX_REGISTERS];
    //{{AFX_DATA(CRegcfgDialog)
    enum { IDD = IDD_REGCONFIG};
    //}}AFX_DATA
// Implementation           

	enum {ID_SCROLL=11};
protected:
	BOOL	m_bScroll;        
	int		m_nPageRow;
	int		m_nMaxRow;
	
	CScrollBar* m_pScroll;
	CRect	m_rectFrame;

	void	ScrollReg(int nOldPos,int nRow);	
	void	DrawFrame(CDC * pdc, CRect rect,UINT flag);
	void    SetRegBoxSite(int nRegId, int nRow, int nCol);
protected:
    virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

    // Generated message map functions
    //{{AFX_MSG(CRegcfgDialog)
    afx_msg void OnUnselectAll();
    afx_msg void OnSelectAll();
    virtual void OnOK();
    virtual BOOL OnInitDialog();
	afx_msg void OnPaint();
	afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	//}}AFX_MSG
    DECLARE_MESSAGE_MAP()
};

class CRegvalList : public CStringList                                 
{
public:        
    int m_nCount;           
    DWORD m_Val[MAX_RVAL_LIST];
    CRegvalList() : m_nCount(0) {}  
    void AddNew(DWORD uVal);
};

/////////////////////////////////////////////////////////////////////////////
// CRegisterDialog dialog

class CRegisterDialog : public CDialog
{
// Construction
public:
    CRegisterDialog(int nRegIdx, CWnd* pParent = NULL);  
    int m_nRegIdx; 
    WORD m_dwByte;//added by dragon
    
// Dialog Data
    //{{AFX_DATA(CRegisterDialog)
	enum { IDD = IDD_REGISTER };
	//}}AFX_DATA

// Implementation
protected:
    virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

    // Generated message map functions
    //{{AFX_MSG(CRegisterDialog)
    afx_msg void OnDecrement();
    afx_msg void OnIncrement();
    virtual BOOL OnInitDialog();
    virtual void OnOK();
    //}}AFX_MSG
    DECLARE_MESSAGE_MAP()
};

#endif
//////////////////////////////////(EOF)//////////////////////////////////////
