/***************************************************************************
**
**    $Header:   D:/EP196/SRC/LOG/CPUSVR.H__   1.0   19 May 1997 14:39:14   ZJRD  $
**
**    $Log:   D:/EP196/SRC/LOG/CPUSVR.H__  $
** 
**    Rev 1.0   19 May 1997 14:39:14   ZJRD
** Initial revision.
** 
****************************************************************************/

/***************************************************************************
**
** File name : CPUSVR.H
** Author:BRIGHT CHEN  ,  JOHN CHOW
** Description:
**
**
**    Finished date: 1995.9.1   V 0.1
**    UPDATE DATE  : 1995.9.8   V 0.1A
**
**    Copyright (C) 1995 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/

#ifndef _CPUSVR_H_
#define _CPUSVR_H_

#include "abiextfn.h"
#include "cpucom.h"
#include "address.h"      
#include "regsvr.h"

#define MAXALINE 15 //john.chow 95.5
#define MAXLINES 20 //
#define MAXCHARS 20 //
#define MAXREGNAMELEN 30     
#define MAXCPUNAMELEN 30
#define MAXCPUNUM 80
#define MAXCPUNAMELENGTH 30

//CCpuServer functions as an interface between ABI and shell or cpu window,
//first call constructor to construct the object, then call member function
//initialize() to get cpumodule and set registerMasker.
struct Reg_Name_ID
{
	char Name[MAXREGNAMELEN];
	unsigned char  ID;
	//editted by JOHN.CHOW 95.6 for showing all registers in shell
	int locY;
	int locX;
	//************************************************************
};

typedef struct
	{
		DWORD begAddr;
		DWORD endAddr;
	} MEMORYBLOCK;

typedef struct
	{
		int reservecount;
		MEMORYBLOCK mr[5];
	} RANGE_INFO;

//for compatible with EP/SLD
struct CPUMEMORYRANGE
{ 
	DWORD pMax,pMin,xMax,xMin,iMax,iMin,
				   rMax,rMin,bMax,bMin,sMax,sMin;
};

struct CONTROLOPTION
{ 
	WORD controlReset,controlEa,controlEben;
}; 
                   
int InitCpu(int iRoger);
void GetCpuName(CString& strName);
BOOL _export Id2RegName(WORD id, char* pName);
BOOL GetRegName(WORD wRegId, char* pOutput);
BOOL GetRegValue(WORD wRegId, DWORD& dwOutput);
BOOL CpuGetAllReg();
BOOL CpuSetRegfromWnd(WORD reg_id,DWORD content);

void RegisterCmd(int nArgc,char* pszArgv[]);
void ResetCmd(int nArgc, char* pszArgv[]);
BOOL CpuReset(ADDRESS addr);

char ** PreCpuInitialize(int &iRoger);
int GetControlOption(CString &strReset,CString &strEa,CString &strEben);
BOOL GetMemoryRange(RANGE_INFO& ri);


#ifdef __cplusplus
extern "C" {
#endif	// __cplusplus  
extern WORD WINAPI GetCurrentBank();
extern WORD WINAPI GetCpuId(void);
extern void WINAPI GetMemoryRange(CPUMEMORYRANGE& cmr);

#ifdef __cplusplus
}
#endif	// __cplusplus  


class CCpuServer
{
//constructor
public:
	CCpuServer();
	~CCpuServer();

//data member
private:
	//ADDED TO SUPPORT SET CPU MODULE
	char			**cpuNameList;
	int				sMaxCpuNum;
	WORD			cpuIDList[MAXCPUNUM];
	//ADDED TO SUPPORT SET CPU MODULE two
	char			**cpuNameValid;
	int				sMaxCpuValid;    
	short			cpuIDValid[MAXCPUNUM];

public:
	WORD			m_wCpuModule;
	CString         CpuName;    
	int				m_nErrorID;
	CPUMEMORYRANGE  cpuMemoryRange;			//EP51  type
	CONTROLOPTION   controlOption;

//function member:
private:
	BOOL			GetCpuListFromFile();
	BOOL			GetRegFromFile();
	void			ShowAllRegByArray();//only used in ShowAllRegToShell()

public:
	BOOL			Initialize(int);
	char**			PreCpuInitialize(int &iRoger);

	STATUS			GetAllReg();
	BOOL			Id2RegName(WORD id, CString& name);
	void			ShowOneRegToShell(WORD  reg_id);
	void			ShowAllRegToShell();
	
	BOOL			SetRegfromWnd(WORD reg_id, DWORD content);
	void			SetRegfromShell(WORD reg_id, DWORD content, WORD nBank = 0);

	BOOL			ResetbyWnd(ADDRESS addr);
	void			ResetbyShell(ADDRESS addr);

	void			DisplayErrorMessage(void) const;
	void			DisplayErrorMessageBox(void) const;
	//added by dragon
	int             GetRegisterLen(CRegItem* regItem, char* DisplayStr, WORD nBank = 0, BOOL bFlag=0);

};

#endif

//////////////////////////////(EOF)////////////////////////////////////
