/***************************************************************************
**
**    $Header:   D:/EP196/SRC/LOG/CPUTYPE.CPP   1.0   19 May 1997 14:39:16   ZJRD  $
**
**    $Log:   D:/EP196/SRC/LOG/CPUTYPE.CPP  $
** 
**    Rev 1.0   19 May 1997 14:39:16   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  CPUTYPE.CPP
//
//  Description:The implement file for the class: CCputypeDialog
//
//  Author:     Chris Fang
//
//  Date:       10/25/95
//
//  Modification:
//
//      1. 10/25/95, Ver 0.1f
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////


#include "stdafx.h"
#include "resource.h"

#include "cputype.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

extern char ** PreCpuInitialize(int &);
	             
/////////////////////////////////////////////////////////////////////////////
// CCputypeDialog dialog


CCputypeDialog::CCputypeDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CCputypeDialog::IDD, pParent)
{
	m_pCpu = PreCpuInitialize(m_nCnt);
	if(!m_pCpu)	{
		m_nType = -1;
		return;
	}	

	m_nType = 0;
	//{{AFX_DATA_INIT(CCputypeDialog)
	m_strCpu = m_pCpu[m_nType];
	//}}AFX_DATA_INIT    
	SetHelpID(IDD);
}

void CCputypeDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCputypeDialog)
	DDX_Control(pDX, IDC_CPUTYPE_LIST, m_list);
	DDX_Text(pDX, IDC_CPUTYPE_CPU, m_strCpu);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CCputypeDialog, CDialog)
	//{{AFX_MSG_MAP(CCputypeDialog)
	ON_LBN_SELCHANGE(IDC_CPUTYPE_LIST, OnSelchangeCputypeList)
	ON_WM_CREATE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CCputypeDialog message handlers

int CCputypeDialog::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CDialog::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	// TODO: Add your specialized creation code here
	if(!m_pCpu) {
		return -1;
	}
	
	return 0;
}

BOOL CCputypeDialog::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	CenterWindow();
	
	for(int i = 0; i < m_nCnt; i ++) {
		ASSERT(m_pCpu[i]);
		m_list.AddString(m_pCpu[i]);  
	}	   
	m_list.SetCurSel(m_nType);
		
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CCputypeDialog::OnOK()
{
	// TODO: Add extra validation here
	m_nType = m_list.GetCurSel();
	
	if(m_nType != LB_ERR) 
		CDialog::OnOK();
}

void CCputypeDialog::OnSelchangeCputypeList()
{
	// TODO: Add your control notification handler code here
	m_nType = m_list.GetCurSel();	
	if(m_nType != LB_ERR) {
		m_strCpu = m_pCpu[m_nType];
	 	UpdateData(FALSE);
	}
}
                        
/////////////////////////////////////////////////////////////////////////////
// return: -1 -- Default type
//		   >=0-- Selected type
int InitGetCpuType(void)
{
 	CCputypeDialog dlg;
 	int result;

 	result = dlg.DoModal();
 	
 	if(result==IDOK) return dlg.m_nType;
 	else return -1; 
}
                        
//////////////////////////////(EOF)//////////////////////////////////////////                              

void CCputypeDialog::OnCancel()
{
	// TODO: Add extra cleanup here
	
	CDialog::OnCancel();
}
