/***************************************************************************
**
**    $Header$
**
**    $Log$
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  CPUWIN.H
//
//  Description:The header file for the class: CCpuWindow
//
//  Author:     Roger Zhang
//
//  Date:       04/12/95
//
//  Modification:
//
//      1. 04/12/95, Initial version 
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#ifndef _CPUWIN_
#define _CPUWIN_                                            

#include "cpucom.h"
                                            
/////////////////////////////////////////////////////////////////////////////
// CCpuWindow frame

class CCpuWindow : public CMDIChildWnd
{
    DECLARE_DYNCREATE(CCpuWindow)
public:
    CCpuWindow();           
    BOOL Create(LPCSTR szTitle, LONG style = 0,
        const RECT& rect = rectDefault, CMDIFrameWnd * pParent = NULL );

// Attributes
public:
    enum { NAME_LEN = 12, VAL_LEN = 6 };
    
    BOOL    m_bAdd;//for displaying pc(p0)
    
    BOOL	m_isSel;
    
    DWORD	m_OldValue[MAX_REGISTERS];
    DWORD	m_NewValue[MAX_REGISTERS];
	void 	SaveOldValue(void);
    
// Operations
public:
    void ShowRegValue(CDC * pdc, int nIdx, DWORD& uVal, BOOL isNormal);
    BOOL GetRegs(void);

// Implementation
protected:
    static CMenu NEAR m_menu;
    int m_nFont;
    CSize m_szFont;
    CSize m_szName;
    CSize m_szValue;
    CSize m_szGap;    
    CPoint m_ptFirst;
    int m_nCols;
    int m_nRows;
    CSize m_szScroll;
        

    virtual ~CCpuWindow();
    void CalcXY(int nIdx, int &x, int &y);
    void CalcPoint(BOOL isName, int nIdx, int &x, int &y);
    void DrawFrame(CDC * pdc, BOOL isName, int nIdx, int nConvex);
    void ShowRegName(CDC * pdc, int nIdx);
    void Resize(int cx, int cy);

//    virtual BOOL PreCreateWindow(CREATESTRUCT & cs);
    // Generated message map functions
    //{{AFX_MSG(CCpuWindow)
    afx_msg LONG OnXMRepaint(UINT wParam, LONG lParam);
    afx_msg void OnPaint();
    afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
    afx_msg void OnSize(UINT nType, int cx, int cy);
    afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
    afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
    afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
    afx_msg void OnViewConfigregisters();
    afx_msg void OnViewDecimal();
    afx_msg void OnUpdateViewDecimal(CCmdUI* pCmdUI);
    afx_msg void OnViewHexadecimal();
    afx_msg void OnUpdateViewHexadecimal(CCmdUI* pCmdUI);
    afx_msg void OnGetMinMaxInfo(MINMAXINFO FAR* lpMMI);
    afx_msg void OnMDIActivate(BOOL bActivate, CWnd* pActivateWnd, CWnd* pDeactivateWnd);
    afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
    afx_msg BOOL OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message);
    afx_msg void OnRunReset();
	afx_msg void OnViewRefresh();
	afx_msg void OnClose();
	afx_msg void OnChar(UINT nChar, UINT nRepCnt, UINT nFlags);
	//}}AFX_MSG
    DECLARE_MESSAGE_MAP()
};

#endif
////////////////////////////(EOF)////////////////////////////////////////////
