/***************************************************************************
**
**    $Header$
**
**    $Log$
** 
****************************************************************************/

/***************************************************************************
**
** File name : dad251.h
** Author:John Zhou
** Description:
**    class definition of dad251 class
**
**
**    Finished date: 1996.9
**
**
**    Copyright (C) 1995 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/

#ifndef _DAD251_H
#define _DAD251_H
                                                
#include "stdafx.h"             
#include "dadob.h"
#include "tbl51.h"       
#include "abiextfn.h"
#include "regsvr.h"
#include "cpusvr.h"
                        
//define for address attribute                        
#define NORMALAREA  1
#define NORMALSEGAREA  4 //only used for dad251
#define SFRAREA  2      
#define BITAREA  3
#define CPU_MODE_BIN 1
#define CPU_MODE_SOURCE 2

//extern function
int GetCpuMode();

extern BOOL AdrCheckAddrRange(ADDR addr );
extern BOOL AdrCheckAddrRange(ADDRESS addr);

/********************** for class CNextIceAddrRET *******************************/
class CNextIceAddrRET : public CNextIceAddr
{ 
//operator             
public:
	virtual ADDR GetNextIceAddr() {
		return CNextIceAddr::GetNextIceAddr();
	}
 };

/********************** for class CNextIceAddrRETI *******************************/
class CNextIceAddrRETI : public CNextIceAddr
{ 
//operator             
public:                                           
	virtual ADDR GetNextIceAddr() {
		return CNextIceAddr::GetNextIceAddr();
	}
 };

/********************** for class C51DADKey *******************************/
class C51DADKey : public CBaseDADKey
{                    
//member
protected:
	CMDLINE* m_Table;
public:
    enum { ERR_NOTHING = 4000};
//virtual operation
public:
	virtual BOOL SelectByValue(CAnalyseInstruction&);
	virtual BOOL SelectByInstr(CAnalyseInstruction&);               	
//operation
protected:
	BOOL HangOpDealAsm(CAnalyseInstruction& Baby,BYTE bKey); 	
		
//construct
public:
	C51DADKey();
	
 };        
 
/********************** for class CBaseDADSFRByte *******************************/
class C251DADSFRByte : public CBaseDADSFRByte
{
//member            
public:
	enum {UNDEFINED = 0xff };
protected:
	CString m_strName;
	CDADAddr m_addr;	 
//construct                  
public:
	C251DADSFRByte(DWORD dwCpuID=0) {	
		m_strName = "";		
		m_dwCpuID = dwCpuID;
		m_addr.Add(UNDEFINED,0);
	};                 
//virtual operation
protected:
	virtual BOOL SelectByAddr();
	virtual BOOL SelectByStr();
//operation
public:
	const CDADAddr& operator << (const CString& str)	{
		m_strName = str;
		if ( m_strName.GetLength()>2 && 'S' == toupper(m_strName[0]) 
			 && ':' == m_strName[1]) {
			m_strName = m_strName.Right(m_strName.GetLength()-2);
		}
		SelectByStr();
		return m_addr;              
	};	                
	
	const CDADAddr& operator << (const char* str)	{
		m_strName = str;
		if ( m_strName.GetLength()>2 && 'S' == toupper(m_strName[0]) 
			 && ':' == m_strName[1]) {
			m_strName = m_strName.Right(m_strName.GetLength()-2);
		}
		SelectByStr();
		return m_addr; 
	};	                
	
	const CString& operator << (CDADAddr& addr)	{
		m_addr = addr;
		SelectByAddr();
		return m_strName;
	};	                
	
 };

/********************** for class CBaseDADSFRBit *******************************/
class C251DADSFRBit : public CBaseDADSFRBit
{                             
//member
public:
	enum { UNDEFINED = 0xff};
protected:
	CString m_strName;
	CDADAddr m_addr;	 
//construct                  
public:
	C251DADSFRBit(DWORD dwCpuID=0) {	
		m_strName = "";		
		m_dwCpuID = dwCpuID;
		m_addr.Add(UNDEFINED,0);		
	};                 
//virtual operation
protected:
	virtual BOOL SelectByAddr();
	virtual BOOL SelectByStr();
//operation
public:
	const virtual CDADAddr& Str2Addr51(const CString& str) {
		m_strName = str;
		if ( m_strName.GetLength()>2 && 'S' == toupper(m_strName[0]) 
			 && ':' == m_strName[1]) {
			m_strName = m_strName.Right(m_strName.GetLength()-2);
		}
		SelectByStr(); 
		if ((m_addr.m_dwAddr&0x00000007)!=0 ) {
			m_addr.m_bAttribute = UNDEFINED;
		} else {
			m_addr.m_dwAddr += m_bBit;
		}	
		return m_addr; 
	};
	const virtual CDADAddr& Str2Addr251(const CString& str,BYTE& bit) { 
	    m_strName = str;
		if ( m_strName.GetLength()>2 && 'S' == toupper(m_strName[0]) 
			 && ':' == m_strName[1]) {
			m_strName = m_strName.Right(m_strName.GetLength()-2);
		}
		SelectByStr();
		bit = m_bBit; 
		return m_addr;
	};
	const virtual CString& Addr2Str51(CDADAddr& addr) {
		m_addr = addr; 
		m_bBit = (BYTE)(m_addr.m_dwAddr&0x00000007);
		m_addr.m_dwAddr &=0xfffffff8; 
		SelectByAddr();
		return m_strName;		
	};
	const virtual CString& Addr2Str251(CDADAddr& addr,BYTE bit) {
		m_addr = addr; 
		m_bBit = bit;
		SelectByAddr();
		return m_strName;		
	};
	
 };
 
/********************** for class C251DADSym *******************************/
class C251DADSym : public CBaseDADSym
{                
//construct & destruct 
public:
	C251DADSym();
//member                    
protected:          
	CString m_strSym;    
	CDADAddr m_addr;         
public:	
	enum { UNDEFINED = 0xff};
protected:
	char m_cHead;	                        
//virtual operation
public:
	virtual BOOL SelectByAddr();
	virtual BOOL SelectByStr();                     
//operation             
    const CDADAddr& operator << (const CString& str) {
		m_strSym = str;
		SelectByStr();
		if (m_addr.m_bAttribute == NORMALAREA) 
			m_addr.m_bAttribute = NORMALSEGAREA;			
		return m_addr; 
	};	                
	
	const CDADAddr& operator << (const char* str) {
		m_strSym = str;
		SelectByStr();
		if (m_addr.m_bAttribute == NORMALAREA) 
			m_addr.m_bAttribute = NORMALSEGAREA;			
		return m_addr; 
	};	                
	
	const CString& operator << (CDADAddr& addr)	{
		m_addr = addr;
		SelectByAddr();
		return m_strSym;
	};	                
    const CString& operator << (CDADAddress& addr)	{
		m_addr.Add(addr.m_bAttribute,addr.GetDWord());
		SelectByAddr();
		return m_strSym;
	};                                 
 };                                  
 
/********************** for class C51DADConstSym *******************************/
class C51DADConstSym : public CBaseDADConstSym       
{ 
//construct & destruct 
public:
	C51DADConstSym();
//member                    
public:
	enum { MAXINDEX = 28,UNDEFINED = 0xff };	
protected:          
	CString m_strSym;    
	WORD m_nIndex;         
	unsigned char** m_Table;
//virtual operation
public:
	virtual BOOL SelectByIndex();
	virtual BOOL SelectByStr();                     
//operation             
    virtual WORD operator << (const CString& str)	{
		m_strSym = str;
		SelectByStr();
		return m_nIndex; 
	};	                

    virtual WORD operator << (const char* str)	{
    	CString strTmp = str;
    	return *this<<(strTmp);
	};	                

	
	virtual const CString& operator << (WORD nIndex)	{
		m_nIndex = nIndex;
		SelectByIndex();
		return m_strSym;
	};	                
                                     
};

/********************** for class C251DADDatumAnalyse *******************************/
//deal with HEX DAD datum
class C251DADDAtumAnalyse : public CDADDatum
{
//vitual operator
protected:
	virtual CString AddPrefix() {
		CString strTmp = '#';
		return strTmp;
	};
		
	virtual BOOL GetPrefix(CString& strTmp) { 
		if ( 0 == strTmp.GetLength() ) return FALSE;
		return ('#' == strTmp[0]);
	};
                     
 };                                                                                   

/********************** for class C251DADAddrAnalyse *******************************/
//deal with HEX DAD address
class C251DADAddrAnalyse : public CDADAddress
{                                  
//member
public:
	enum { UNDEFINED = 0xff };	
//vitual operator
protected:
	virtual CString AddPrefix();
	virtual BOOL GetPrefix(CString& strTmp);
	public:	
//if is same 64k bank range
	virtual BOOL IsSameSeg(CDADAddress& tmpAddr) {
		return ((Get24()&0x00ff0000) == (tmpAddr.Get24()&0x00ff0000));
	};	                          
	
	virtual void MakeSameSeg(CDADAddress& tmpAddr) {
		DWORD dw1,dw2;              
		BYTE bAttr = GetAttribute();
		dw1 = tmpAddr.Get24();
		dw2 = Get24();
		dw2 = (dw1&0x00ff0000) | (dw2&0xff00ffff);
		Clear();                     
		Set24(bAttr,(DWORD)dw2);
	};
	
	CDADAddr StrToAddr(const CString& str) { 
		CDADAddr tmpAddr;                             
		if ( 0 == (*(CDADAddress*)(this)<<(str)) ) 
			tmpAddr.m_bAttribute = UNDEFINED;
		else 	
		    tmpAddr.m_bAttribute = m_bAttribute;
		tmpAddr.m_dwAddr = Get24();
		return tmpAddr;    
	};
	//return 0, refers it can't be converted	                    
	CDADAddr StrToAddr(const char* pCh) {
		CString str = pCh;
		CDADAddr tmpAddr;
		if ( 0 == (*(CDADAddress*)(this)<<(str)) ) 
			tmpAddr.m_bAttribute = UNDEFINED;
		else 	
		    tmpAddr.m_bAttribute = m_bAttribute;
		tmpAddr.m_dwAddr = Get24();
		return tmpAddr;             
	}; 
	
	//minus
	virtual void operator-(CDADAddress& tmpAddr) {
		DWORD dw1,dw2,dw3;
		dw1 = Get24();  dw2 = tmpAddr.Get24();
		dw3 = (long)dw1 - dw2;
		dw3 = dw3&0x00ffffff;
		BYTE bAttr = GetAttribute();
		Clear();
		Set24(bAttr,(DWORD)dw3);
	};
	//add
	virtual void operator+(CDADAddress& tmpAddr) {
		DWORD dw1,dw2,dw3;
		dw1 = GetDWord();  dw2 = tmpAddr.GetDWord();
		dw3 = dw1 + dw2;     
		dw3 = dw3&0x00ffffff;       
		BYTE bAttr = GetAttribute();
		Clear();
		Set24(bAttr,(DWORD)dw3);		
	};	
	

                     
 };

/********************** for class COpDeal51ASMAddrPg *******************************/ 
//to deal with 
class COpDeal51ASMAddrPg : public COpDealWriteDigit
{       
//member
public:
	enum { ERR_ASM_ADDRPG = 4050 };
//virtual class
public:
	virtual BOOL Do(CAnalyseInstruction& Baby,CDADAddress* pCurrentAddr);
 }; 

/********************** for class COpDeal51ASMAddr11 *******************************/ 
//to deal with 
class COpDeal51ASMAddr11 : public COpDealWriteDigit
{       
//member
public:
	enum { ERR_ASM_ADDR11 = 4100 };
//virtual class
public:
	virtual BOOL Do(CAnalyseInstruction& Baby,CDADAddress* pCurrentAddr);
 }; 

/********************** for class COpDeal51ASMAddr16 *******************************/ 
//to deal with 
class COpDeal51ASMAddr16 : public COpDealWriteDigit
{       
//member
public:
	enum { ERR_ASM_ADDR16 = 4150 };
//virtual class
public:
	virtual BOOL Do(CAnalyseInstruction& Baby,CDADAddress* pCurrentAddr);
 }; 

/********************** for class COpDeal51DASAddr16 *******************************/ 
//to deal with 
class COpDeal51DASAddr16 : public COpDealReadDigit
{                                 
//construct
public:
	COpDeal51DASAddr16(CAnalyseInstruction& Baby,BYTE bLoc,BYTE bNum)
					   :COpDealReadDigit(Baby,bLoc,bNum) {
		ASSERT(2 == bNum);
	};
//member
public:
	enum { ERR_DAS_ADDR16 = 4200 };
//virtual class
public:
	virtual BOOL Do(CAnalyseInstruction& Baby,CDADAddress* pCurrentAddr);
 }; 

/********************** for class COpDeal51DASAddrPg *******************************/ 
//to deal with 
class COpDeal51DASAddrPg : public COpDealReadDigit
{        
//member                                         
protected:
	BYTE m_bLen;
//construct
public:
	COpDeal51DASAddrPg(CAnalyseInstruction& Baby,BYTE bLoc,BYTE bNum,BYTE bLen)
					  :	COpDealReadDigit(Baby,bLoc,bNum) {
		ASSERT(1 == bNum);
		m_bLen = bLen;
	};
//member
public:
	enum { ERR_DAS_ADDRPg = 4250 };
//virtual class
public:
	virtual BOOL Do(CAnalyseInstruction& Baby,CDADAddress* pCurrentAddr);
 }; 

/********************** for class COpDeal51DASAddr11 *******************************/ 
//to deal with 
class COpDeal51DASAddr11 : public COpDealReadDigit
{        
//member                                         
protected:
	BYTE m_bLen;
	BYTE m_bFirstCode;	
//construct
public:
	COpDeal51DASAddr11(CAnalyseInstruction& Baby,BYTE bLoc,BYTE bNum,BYTE bLen,BYTE bFirstCode)
					  :	COpDealReadDigit(Baby,bLoc,bNum) {
		ASSERT(1 == bNum);
		m_bLen = bLen;   
		m_bFirstCode = bFirstCode;
	};
//member
public:
	enum { ERR_DAS_ADDR11 = 4300 };
//virtual class
public:
	virtual BOOL Do(CAnalyseInstruction& Baby,CDADAddress* pCurrentAddr);
 }; 

/********************** for class COpDeal51DASAddrDatum *******************************/ 
//to deal with 
class COpDeal51DASAddrDatum : public COpDealReadDigit
{        
//construct
public:
	COpDeal51DASAddrDatum(CAnalyseInstruction& Baby,BYTE bLoc,BYTE bNum)
						  : COpDealReadDigit(Baby,bLoc,bNum) {
	};
//member
public:
	enum { ERR_DAS_ADDRDATUM =4350 };
//virtual class
public:
	virtual BOOL Do(CAnalyseInstruction& Baby,CDADAddress* pCurrentAddr);
 }; 

/********************** for class COpDeal51DASAddrBit *******************************/ 
//to deal with 
class COpDeal51DASAddrBit : public COpDealReadDigit
{              
//member
protected:
	BOOL m_isN;
//construct
public:                           
	COpDeal51DASAddrBit(CAnalyseInstruction& Baby,BYTE bLoc,BYTE bNum,BOOL isN)
					  :	COpDealReadDigit(Baby,bLoc,bNum) {
		m_isN = isN;					  
	};
//member
public:
	enum { ERR_DAS_ADDR11 = 4400 };
//virtual class
public:
	virtual BOOL Do(CAnalyseInstruction& Baby,CDADAddress* pCurrentAddr);
 }; 

/********************** for class C51OpCodeAnalyse *******************************/
//Get opcode total set
class C51OpCodeAnalyse : public CBaseOpCodeAnalyse
{                         
//member 
public:
	enum { ERR_DOLLARS = 4450,ERR_OPCODE,ERR_DOT,
		   ERR_REVERSE,ERR_TOOMUCHOPCODE,ERR_INPUT,
		   ERR_ADDR_RANGE };	              
//construct & destruct
public:
	C51OpCodeAnalyse();
	virtual ~C51OpCodeAnalyse();
//virtual instruct
public:
	virtual BOOL Do(CAnalyseInstruction&,CDADAddress&);			
	
 };

/********************** for class C51DAD *******************************/
class C51DAD : public CBaseDAD
{                 
//member
protected:
	C51OpCodeAnalyse m_analyseInstr;
	C51DADKey m_tableControl;     
    enum { ERR_A5 = 11000,ERR_MODE }; 
//operator
public:

//virtual operation
protected:
	virtual BOOL ProcessAsm(CBaseDADMem&);
	virtual BOOL ProcessDisasm(CBaseDADMem&);
	virtual BOOL PreAsm(CBaseDADMem& mem) { 
		m_CurrentAddr.SetDWord((mem.GetAddr()).m_bAttribute,
							   (mem.GetAddr()).m_dwAddr);
		return TRUE;							   
	};
	virtual BOOL PreDisasm(CBaseDADMem& mem);
	
 };
 
/********************** for class C251DADMem *******************************/
class C251DADMem : public CBaseDADMem 
{     
//member
protected:
	CDADAddr m_bufStart; 
	DWORD m_dwBufLen;
	BYTE* m_pBuffer;
	BOOL isReadBufInvalid;   
public:
	enum { BUFFERLEN = 220 };	
//construct & destruct
public:
	C251DADMem() {
		m_bufStart.m_dwAddr =0;
		m_bufStart.m_bAttribute = 0;
		m_dwBufLen = 0;
		m_pBuffer = new BYTE[BUFFERLEN+2];
		isReadBufInvalid = FALSE;
	};	                                
	virtual ~C251DADMem() {
		if (NULL != m_pBuffer) delete m_pBuffer;
	};	
//virtual operator
public: 
	virtual BOOL WriteBytes(BYTE*,BYTE bNum=1);
	virtual BOOL ReadByte(BYTE&);
public:
	virtual BOOL UpdateBuffer();                                 
};
                 
 
#endif

/***********************  end of file **********************************/