/***************************************************************************
**
**    $Header$
**               
**    $Log$
** 
****************************************************************************/
/***************************************************************************
**
** File name : dadextfn.cpp
**
** Description:
**
** Programmer: JOHN CHOW
**
**
**    Copyright (C) 1996 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/
#include "stdafx.h"
#include "dadextfn.h"
#include "address.h"
#include "srcexp.h"   
#include "uicom2.h"
#include <sys\types.h>
#include <sys\timeb.h>
/********************** for class CDADExtFnBase *******************************/


void CDADExtFnBase::Disasm(BOOL isUpdateMem)
{                                               
	CString strTmp;   
	C196DADSym pSym;         
	WORD wInstrCounter = 0;
	char strAdrSave[20];
	//clear chain line
	m_listCode.RemoveAll();
	m_listInstr.RemoveAll();
	m_listSym.RemoveAll();
	m_listAddr.RemoveAll();
	
	//PREPARE MEMORY
    if ( !m_DADMem.SetAddr(m_addrStart) ) {
    	m_nResult = DAD_READ_ERR;
    	return;
    }   
    if(isUpdateMem) {
    	C196DADSym::m_isSymbolic = SrcIsSymbolic();   
	    if (!m_DADMem.UpdateBuffer() ) {
	    	m_nResult = DAD_READ_ERR;
	    	return;
	    }
    	m_DADMem.SetMaxAddr(0xffff); 
    }
    
    m_pDadOk = &m_dad196;

    ((C196DAD*)m_pDadOk)->SetCurWindow(::GetCurHWindow());
    
    //struct _timeb timebuffer1,timebuffer2;
	//_ftime( &timebuffer1 );
	ADDR addrSave;
    while( m_DADMem <= m_addrEnd && wInstrCounter < m_wNeedInstrLen) { 
    	m_DADMem.GetAddr(addrSave);
    	wInstrCounter++;
 		m_pDadOk->Baby.Clear();                
 		//save current address      
 		ADDR addrTmp;
 		m_DADMem.GetAddr(addrTmp);              
 		ADDR_RETCODE nAddrRet = AdrDadAddrToHexEx(addrTmp,strAdrSave);            
		if (ADR_OK != nAddrRet) ASSERT(FALSE);
		
		if (!m_pDadOk->Das(m_DADMem)) { 		
	    	//check if address invalid error
	    	if (CBaseDADMem::ERR_ADDR_INVALID == 
	    		m_pDadOk->GetDetailErrCode()) {
	    		m_nResult = DAD_ADDR_INVALID;
	    		return;
	    	}	
			//show error infor 
			m_DADMem.SetAddr(addrTmp); 
			strTmp = strAdrSave;
			if (strTmp.GetLength() >= 7) 
				strTmp = strTmp.Mid(strTmp.GetLength()-7,7); 
			m_listAddr.AddTail(strTmp);	
			//show wrong code            
			BYTE bTmp;             
			char pcTmp[10];
			m_DADMem.ReadByte(bTmp);
			sprintf(pcTmp,"%02X",bTmp);
			strTmp = pcTmp;
			m_listCode.AddTail(strTmp); 
			//show "?"
			//required by Dome Liu to convert "?" to DB
			strTmp = "DB ";
			strTmp += pcTmp;	
			m_listInstr.AddTail(strTmp);
			strTmp = "";
			m_listSym.AddTail(strTmp);
			//set dirty flag
			m_arrayIsDirtyResult.Add((WORD)(TRUE));
			if(m_DADMem < addrSave) {
				m_nResult = DAD_NEED_MORE;
				return;
			}
			continue;
		}

		//show the result                 
		CString strTmp = strAdrSave;  
		if (strTmp.GetLength() >= 7) 
			m_listAddr.AddTail(strTmp.Mid(strTmp.GetLength()-7,7));	
		else m_listAddr.AddTail(strTmp);		
		
		m_listSym.AddTail(pSym<<m_pDadOk->m_CurrentAddr);
		
		m_listCode.AddTail(m_pDadOk->Baby.GetCodeStr()); 
		
		m_listInstr.AddTail(m_pDadOk->Baby.m_Instruction.GetStr());
		
		m_arrayIsDirtyResult.Add((WORD)(m_pDadOk->Baby.m_isDirtyResult));
		if(m_DADMem < addrSave) {
			m_nResult = DAD_NEED_MORE;
			return;
		}
		
 	} 
 	/*
 	_ftime( &timebuffer2 );
	WORD x = (timebuffer2.time-timebuffer1.time)*1000 + timebuffer2.millitm-timebuffer1.millitm;
	_ftime( &timebuffer2 );
	WORD y = (timebuffer2.time-timebuffer1.time)*1000 + timebuffer2.millitm-timebuffer1.millitm;
	char tmp[100];
	sprintf(tmp,"%04d %04d",x,wInstrCounter);
	AfxMessageBox(tmp);
 	*/
 	--m_DADMem;                       //if m_DADMem+1>m_addrEnd
 	if (m_DADMem > m_addrEnd) {       //=> need more code
 		m_nResult = DAD_NEED_MORE;
 	} else {                      
 		m_nResult = DAD_OK;
 	}
 	
 }

void CDADExtFnBase::Asm(BOOL isUpdateMem)
{                    
	//PREPARE MEMORY
    if ( !m_DADMem.SetAddr(m_addrStart) ) {
    	m_nResult = DAD_READ_ERR;
    	return;
    }
    if(isUpdateMem) {
	    if ( !m_DADMem.UpdateBuffer() ) {
	    	m_nResult = DAD_READ_ERR;
	    	return;
	    }
    	m_DADMem.SetMaxAddr(0xffff); 
    }	
    
    m_pDadOk = NULL;
    m_bAsmCodeLen = 0;
    //if NULL input,return
	if( "" == m_strAsm ) {       
		m_nResult = DAD_ASM_ERROR;
	 	return;
	} 
	
	if(m_strAsm.GetLength() > 99) {                                            
		m_nResult = DAD_ASM_ERROR;
   		return;
    }                             

	C196DADSFRByte::m_nCurWindow = (int)GetCurHWindow();
    
    m_pDadOk = &m_dad196;
	m_pDadOk->Baby.Clear();                
	
	m_pDadOk->Baby = m_strAsm;
	if (!m_pDadOk->Asm(m_DADMem)) { 		
		m_nResult = DAD_ASM_ERROR;
		return;
	} 
	
	m_bAsmCodeLen = m_pDadOk->Baby.m_bNum; 
	m_nResult = DAD_OK;
	return;
	
 }                                               
                    


///////////////// end of file ////////////////////
