/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/DIAGNO/CONTAIN.H__   1.8   09 Jan 1997 14:28:08   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/DIAGNO/CONTAIN.H__  $
** 
**    Rev 1.8   09 Jan 1997 14:28:08   ZJRD
** No change.
** 
**    Rev 1.7   13 Dec 1996 11:23:26   ZJRD
** No change.
** 
**    Rev 1.6   22 Nov 1996 11:04:20   ZJRD
** No change.
** 
**    Rev 1.5   11 Nov 1996 12:51:38   ZJRD
** No change.
** 
**    Rev 1.4   06 Nov 1996 13:03:24   ZJRD
** No change.
** 
**    Rev 1.3   02 Nov 1996 09:50:50   ZJRD
** No change.
** 
**    Rev 1.2   30 Oct 1996 12:53:36   ZJRD
** No change.
** 
**    Rev 1.1   28 Oct 1996 09:46:04   ZJRD
** PIC/SLD Version 0.92
** 
****************************************************************************/

/***************************************************************************
**
** File name : contain.h
** Author:John Zhou
** Description:
**    class for contain
**
**
**    Finished date: 1996.9
**
**
**    Copyright (C) 1995 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/

//contain.h
//this file is the include file of contain.cpp
//created by john 1996.2-3
#ifndef _CONTAIN_H
#define _CONTAIN_H                                          
#include "stdafx.h"   

typedef void far* VP;
//define class CContain 
#define CONTAINLEN 4000

class CContain : public CObject                                          
{  
 //construct & destruct
public :
 CContain(unsigned short usContainLen = CONTAINLEN);
 ~CContain(); 
 
//member
private :
 unsigned short m_UsContainLen;
 unsigned short m_UsValidContainLen;
 void ** m_PointBuffer;

//operate
public :
 unsigned short GetContainLen() { return m_UsContainLen; }
 unsigned short GetValidContainLen() { return m_UsValidContainLen; }
 void *operator[](unsigned short index); 
 void operator += (void *);
 void operator -- ();
 BOOL CanBeAdd();
 void DeleteAt(unsigned short);
 };
 
 
//define class CBigContain 
struct BUFFER_CHAIN
{
    CContain buffer;
    BUFFER_CHAIN*     pNextBuffer;
};

class CBigContain : public CObject
{ 
//construct & destruct
public :
 CBigContain();
 ~CBigContain();              
 
//member 
private :
 BUFFER_CHAIN* m_pFirstBuffer;
 BUFFER_CHAIN* m_pLastBuffer;
 
//operations          
public :
unsigned long GetValidContainLen();
void *operator[](unsigned long); 
void operator += (void *);
void operator -- ();
void DeleteAt(unsigned long);
  
 };

//define class CContainEx 
//it will delete it's point when destory
class CContainEx : public CContain
{
//member
private:
	char m_Nothing[10];   
//operator
public:
	char* GetAt(unsigned long i) {
		if (i<GetValidContainLen()) {
			void* pTmp = (*this)[i];
			return (char*)pTmp;
		} else return m_Nothing;
	}

//construct & destruct
public:     
	CContainEx() {
		strcpy(m_Nothing,"NOTHING");
	};	 

	~CContainEx() {
		for(int i = 0; i < GetValidContainLen(); i++) {
			if ((*this)[i] != NULL)
				delete (*this)[i];
		}
	};	 
 }; 
#endif 