// diagno.cpp : Defines the class behaviors for the application.
//

#include "stdafx.h"
#include "diagno.h"   
#include "diagnost.h" 
#include "initapi.h"
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

#include "abiextfn.h"

extern BOOL isFirstTime;
extern BOOL isEpSldRunning;                                
extern BOOL m_isTraceBoard;
extern BOOL CALLBACK EnumWndProcx(HWND hwnd,LPARAM lParam);


/////////////////////////////////////////////////////////////////////////////
// CDiagnoApp

BEGIN_MESSAGE_MAP(CDiagnoApp, CWinApp)
	//{{AFX_MSG_MAP(CDiagnoApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
	ON_COMMAND(ID_APP_EXIT, OnAppExit)
	//}}AFX_MSG_MAP
	// Standard file based document commands
	ON_COMMAND(ID_FILE_NEW, CWinApp::OnFileNew)
	ON_COMMAND(ID_FILE_OPEN, CWinApp::OnFileOpen)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDiagnoApp construction

CDiagnoApp::CDiagnoApp()
{
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance
}

CDiagnoApp::~CDiagnoApp()
{
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance
}


//extern CWnd* pWnd;
/////////////////////////////////////////////////////////////////////////////
// The one and only CDiagnoApp object

CDiagnoApp NEAR theApp;

/////////////////////////////////////////////////////////////////////////////
// CDiagnoApp initialization

BOOL CDiagnoApp::InitInstance()
{
	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.

	SetDialogBkColor();        // Set dialog background color to gray
	LoadStdProfileSettings();  // Load standard INI file options (including MRU)

	if (m_lpCmdLine[0] != '\0')
	{
		// TODO: add command line processing here
	}           
	
	if (isFirstTime) {
		EnumWindows(EnumWndProcx,NULL);
    	if(isEpSldRunning) {                    
    	    isEpSldRunning = FALSE;
    		AfxMessageBox("      EasyPack is being runned!\nPlease quit it first?");
   			return FALSE;
    	}
    }
	
    
    //added by john 96.6 to support serial communication
    //init comset dialog and relink dialog                   
	Init196DLL();
    //init abi dll
    InitABIDLL(); 
    //new abi class                                                  
	if(!NewABIDLL(MAKE_REAL_196_ABI_DIAGNOSTIC)) return FALSE;
	//if(!NewABIDLL(MAKE_SIMULATOR_ABI)) return FALSE;
    
    // Call ABI function to get is trace board on.
    BYTE bTmp[20];
    int m_nErrorID = emuGetID(bTmp);
    if ( 0 != m_nErrorID ) {
		AfxMessageBox("Fw error!");
    } else {
    	m_isTraceBoard = (BOOL)bTmp[4];
    }
    
        
    CDiagnosticBox* pDialog = new CDiagnosticBox;
    //pWnd = pDialog;
    
    pDialog->DoModal();
    
    //pWnd = NULL;    
    
    ::PostQuitMessage(WM_QUIT);
	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

// Implementation
protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//{{AFX_MSG(CAboutDlg)
		// No message handlers
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// App command to run the dialog
void CDiagnoApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}

/////////////////////////////////////////////////////////////////////////////
// CDiagnoApp commands


void AFXAPI AfxAbort();
void ExitEpsld()
{ 
	((CDiagnoApp*)AfxGetApp())->OnAppExit();
	AfxAbort();

 }

void CDiagnoApp::OnAppExit()
{
	// TODO: Add your command handler code here
	//JOHN
	ExitABIDLL();   	
}
