/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/DIAGNO/DIAGNOST.CPP   1.14   09 Jan 1997 14:28:00   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/DIAGNO/DIAGNOST.CPP  $
** 
**    Rev 1.14   09 Jan 1997 14:28:00   ZJRD
** No change.
** 
**    Rev 1.13   13 Dec 1996 11:23:16   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 11:04:12   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:51:28   ZJRD
** PIC/SLD Version 0.96
** 
**    Rev 1.10   06 Nov 1996 13:03:06   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:50:42   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:53:20   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:45:54   ZJRD
** PIC/SLD Version 0.92
** 
**    Rev 1.4   23 Sep 1996 10:40:06   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:56:10   ZJRD
** PIC/SLD Version 0.60
** 
**    Rev 1.4.1.0   12 Aug 1996 11:06:18   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.2   05 Jun 1996 15:01:00   ZJRD
** EasyPack/SLD Version 1.96
** 
**    Rev 1.1   29 May 1996 09:43:00   ZJRD
** EasyPack/SLD Version 1.95
** 
**    Rev 1.0   16 May 1996 09:12:42   ZJRD
** Initial revision.
** 
****************************************************************************/
// diagnost.cpp : implementation file
//
//john chow 96.3
#include "stdafx.h"
#include "resource.h"
#include "diagnost.h"   
#include "diagnres.h"
#include "waningdi.h"
#include "colors.h"
#include "diagno.h"
#include "abiextfn.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

//defined for being used in checking wether there is a ep-sld
BOOL isEpSldRunning = FALSE;           
BOOL isFirstTime = TRUE;                   
BOOL m_isTraceBoard = FALSE;
//BOOL isOldFw = FALSE;
//BOOL isCanHWReset = FALSE;
BOOL CALLBACK EnumWndProcx(HWND hwnd,LPARAM lParam)
{                  
    char tmp[256];
    GetWindowText(hwnd,&tmp[0],230);
    //AfxMessageBox(tmp);
    if (NULL != strstr(&tmp[0],"EasyPack/SLD")) {
        isEpSldRunning = TRUE;           
        return FALSE;
    }   
    return TRUE;
 }

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   TestKey
//
//  Description: Test if a specified key pressed
//
//  Input:  
//      wKey -- Key code
//
//  Output: None
//
//  Return: 1 -- The key has been pressed
//          0 -- The key not been pressed
//
/////////////////////////////////////////////////////////////////////////////
int TestKey(WORD wKey)
{   
    /*MSG msg;
    if(PeekMessage(&msg, NULL, WM_KEYFIRST, WM_KEYLAST,
        PM_NOREMOVE|PM_NOYIELD)) {
        PeekMessage(&msg, NULL, WM_KEYFIRST, WM_KEYLAST,
            PM_REMOVE|PM_NOYIELD);
        if(msg.message == WM_KEYDOWN || msg.wParam == wKey) 
            return  1;        
    }            
    return  0;*/
    //if(isStop) return 1; else return 0;
    return 0;
}

/////////////////////////////////////////////////////////////////////////////
// CDiagnosticBox dialog


CDiagnosticBox::CDiagnosticBox(CWnd* pParent /*=NULL*/)
    : CDialog(CDiagnosticBox::IDD, pParent)
{
    //{{AFX_DATA_INIT(CDiagnosticBox)
	m_S1 = "";
	m_S2 = "";
	m_S3 = "";
	m_S4 = "";
	m_S5 = "";
	m_S6 = "";
	m_S7 = "";
	//}}AFX_DATA_INIT
    //define time (unit 2 seconds)
    wTimerCounter[0] = 0;//TOTAL TIME   
    wTimerCounter[1] = 2; 
    wTimerCounter[2] = 3; 
    wTimerCounter[3] = 20; 
    wTimerCounter[4] = 3; 
    wTimerCounter[5] = 2; 
    wTimerCounter[6] = 2; 
    wTimerCounter[7] = 5; 
    
    m_isCanTime = FALSE;
    
    hLib = LoadLibrary("METER.DLL");
    if(hLib < HINSTANCE_ERROR)  return;
    
    m_isCanTime = FALSE;
}                              

CDiagnosticBox::~CDiagnosticBox()
{ 
    FreeLibrary(hLib);
    if ( m_nTimerID != 0) KillTimer(m_nTimerID);
 }    
 
BOOL  CDiagnosticBox::ReadInfor()
{      
	               
	CString tblFileName = "",fileBuf;
	char * pcTmp;
 	int result=-1;          
 	
	char szHelpPath[256];
	
	strcpy(szHelpPath, AfxGetApp()->m_pszHelpFilePath);
	
    int nLen = strlen(szHelpPath);
    while ( nLen ) {
		if ( '\\' == szHelpPath[--nLen] ) {
		    break;  
		}
	}
    szHelpPath[++nLen] = '\0';
    
    tblFileName = szHelpPath;

 	tblFileName += "INFOR.DAT";
 	//open the file
 	CStdioFile tblFile;
 	if( !tblFile.Open( (const char *)tblFileName,
           CFile::modeRead | CFile::typeText ) ) {
	    AfxMessageBox((const char *)(tblFileName+" not found!"));
	    return FALSE;
    }
    //get function section
    /*
    do {
    	if(NULL==tblFile.ReadString(fileBuf.GetBuffer(300),300)) { 
	    	fileBuf.ReleaseBuffer(); 
	    	return FALSE; 
    	}
   		fileBuf.ReleaseBuffer();
   		result=fileBuf.Find("FUNCTION");
    } while(result==-1);

 	for(UINT i=0; i<200; i++) {
   		if(NULL==tblFile.ReadString(fileBuf.GetBuffer(300),300)) { 
   			fileBuf.ReleaseBuffer(); 
   			return FALSE; 
   		}
   		fileBuf.ReleaseBuffer();           
   		if (-1 != fileBuf.Find("STATUS")) break;
   		
   		result=fileBuf.Find(":");
   		if (-1 == result) { 
   			fileBuf.ReleaseBuffer(); 
   			return FALSE; 
   		}
   		fileBuf = fileBuf.Right(fileBuf.GetLength()-result-1);
   		pcTmp = new char[fileBuf.GetLength()+5];
   		strcpy(pcTmp,fileBuf.GetBuffer(fileBuf.GetLength()+2));
   		fileBuf.ReleaseBuffer(); 
   		m_Function += pcTmp;
   	}*/	
   	//get status information
   	/*
   	CString tmpStr = "";
   	for(i=0; i<500; i++) {
   		if(NULL==tblFile.ReadString(fileBuf.GetBuffer(300),300)) { 
   			fileBuf.ReleaseBuffer(); 
   			return FALSE; 
   		}
   		fileBuf.ReleaseBuffer();           
   		if (-1 != fileBuf.Find("ERROR")) {
   			pcTmp = new char[tmpStr.GetLength()+5];
	   		strcpy(pcTmp,tmpStr.GetBuffer(tmpStr.GetLength()+2));
	   		tmpStr.ReleaseBuffer(); 
	   		m_Status += pcTmp;
	   		tmpStr = "";
   			break;
   		}	
   		if (0 == fileBuf.Find("STATUS")) {
   			pcTmp = new char[tmpStr.GetLength()+5];
	   		strcpy(pcTmp,tmpStr.GetBuffer(tmpStr.GetLength()+2));
	   		tmpStr.ReleaseBuffer(); 
	   		m_Status += pcTmp;
	   		tmpStr = "";
   			continue;
   		}
   		
   		tmpStr += fileBuf;            
   	}
   	*/	
	//get error information
	/*
 	for(i=0; i<1000; i++) {
   		if(NULL==tblFile.ReadString(fileBuf.GetBuffer(300),300)) { 
   			fileBuf.ReleaseBuffer(); 
   			return FALSE; 
   		}
   		fileBuf.ReleaseBuffer();           
   		if (-1 != fileBuf.Find("ERROR_CODE")) 
   			break;
   		
   		result=fileBuf.Find(":");
   		if (-1 == result) { 
   			fileBuf.ReleaseBuffer(); 
   			return FALSE; 
   		}
   		fileBuf = fileBuf.Right(fileBuf.GetLength()-result-1);
   		pcTmp = new char[fileBuf.GetLength()+5];
   		strcpy(pcTmp,fileBuf.GetBuffer(fileBuf.GetLength()+2));
   		fileBuf.ReleaseBuffer(); 
   		m_Error += pcTmp;
   	}
   	*/	
	//get ERROR_CODE information
   	CString tmpStr = "";
   	for(int i=0; i<2000; i++) {
   		if(NULL==tblFile.ReadString(fileBuf.GetBuffer(300),300)) { 
   			fileBuf.ReleaseBuffer(); 
   			return FALSE; 
   		}
   		fileBuf.ReleaseBuffer();           
   		if (-1 != fileBuf.Find("END")) {
   			pcTmp = new char[tmpStr.GetLength()+5];
	   		strcpy(pcTmp,tmpStr.GetBuffer(tmpStr.GetLength()+2));
	   		tmpStr.ReleaseBuffer(); 
	   		m_ErrorCode += pcTmp;
	   		tmpStr = "";
   			break;
   		}	
   		if (0 == fileBuf.Find("ERROR_CODE")) {
   			pcTmp = new char[tmpStr.GetLength()+5];
	   		strcpy(pcTmp,tmpStr.GetBuffer(tmpStr.GetLength()+2));
	   		tmpStr.ReleaseBuffer(); 
	   		m_ErrorCode += pcTmp;
	   		tmpStr = "";
   			continue;
   		}
   		
   		tmpStr += fileBuf;
   	}               
   	
   	tblFile.Close();
   	return TRUE;
   	
 }

void CDiagnosticBox::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CDiagnosticBox)
	DDX_Control(pDX, DC_CHECK7, m_C7);
	DDX_Control(pDX, IDC_BUTTON_LOCATE, m_Button_Locate);
	DDX_Control(pDX, IDC_CHECKALL, m_CAll);
	DDX_Control(pDX, IDC_CHECK6, m_C6);
	DDX_Control(pDX, IDC_CHECK5, m_C5);
	DDX_Control(pDX, IDC_CHECK4, m_C4);
	DDX_Control(pDX, IDC_CHECK3, m_C3);
	DDX_Control(pDX, IDC_CHECK2, m_C2);
	DDX_Control(pDX, IDC_CHECK1, m_C1);
    DDX_Control(pDX, ID_BUTTON_DETAIL, m_buttonDetail);
    DDX_Control(pDX, IDCANCEL, m_buttonQuit);
    DDX_Control(pDX, ID_BUTTON_DIAGNOSTIC, m_buttonDiagnostic);
	DDX_Text(pDX, IDC_STATIC1, m_S1);
	DDX_Text(pDX, IDC_STATIC2, m_S2);
	DDX_Text(pDX, IDC_STATIC3, m_S3);
	DDX_Text(pDX, IDC_STATIC4, m_S4);
	DDX_Text(pDX, IDC_STATIC5, m_S5);
	DDX_Text(pDX, IDC_STATIC6, m_S6);
	DDX_Text(pDX, IDC_STATIC7, m_S7);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CDiagnosticBox, CDialog)
    //{{AFX_MSG_MAP(CDiagnosticBox)
    ON_BN_CLICKED(ID_BUTTON_DIAGNOSTIC, OnButtonDiagnostic)
    ON_WM_TIMER()
    ON_WM_SIZE()
    ON_BN_CLICKED(ID_BUTTON_DETAIL, OnButtonDetail)
    ON_WM_CTLCOLOR()
    ON_WM_DESTROY()
    ON_WM_PAINT()
    ON_BN_CLICKED(IDC_BUTTON_LOCATE, OnButtonLocate)
	ON_BN_CLICKED(IDC_CHECK1, OnCheck1)
	ON_BN_CLICKED(IDC_CHECK2, OnCheck2)
	ON_BN_CLICKED(IDC_CHECK3, OnCheck3)
	ON_BN_CLICKED(IDC_CHECK4, OnCheck4)
	ON_BN_CLICKED(IDC_CHECK5, OnCheck5)
	ON_BN_CLICKED(IDC_CHECK6, OnCheck6)
	ON_BN_CLICKED(IDC_CHECKALL, OnCheckall)
	ON_BN_CLICKED(DC_CHECK7, OnCheck7)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CDiagnosticBox message handlers


void CDiagnosticBox::OnButtonDiagnostic()
{                                                            

    // TODO: Add your control notification handler code here 
    //CHECK IF EP-SLD/52/F  IS RUNNING
    if (isFirstTime) {
        EnumWindows(EnumWndProcx,NULL);
        if(isEpSldRunning) {                    
            isEpSldRunning = FALSE;
            int nTmp = MessageBox("             Ep is running!\nDo You Really want to go on with it?","",
                                      MB_YESNO|MB_ICONSTOP);
            if (IDNO == nTmp)   return ;
                else isFirstTime = FALSE;
        }
    }       

    
    //caculate the total time needed to run this diagnosis
    wTimerCounter[0] = 0;
    if(m_C1.GetCheck()) {              
        wTimerCounter[0]+=wTimerCounter[1];
    }    
    if(m_C2.GetCheck()) {              
        wTimerCounter[0]+=wTimerCounter[2];
    }      
    if(m_C3.GetCheck()) {              
        wTimerCounter[0]+=wTimerCounter[3];
    }    
    if(m_C4.GetCheck()) {              
        wTimerCounter[0]+=wTimerCounter[4];
    }      
    if(m_C5.GetCheck()) {              
        wTimerCounter[0]+=wTimerCounter[5];
    }    
    if(m_C6.GetCheck()) {              
        wTimerCounter[0]+=wTimerCounter[6];
    }
    if(m_C7.GetCheck()) {              
        wTimerCounter[0]+=wTimerCounter[7];
    }
    if(m_CAll.GetCheck()) {              
        wTimerCounter[0]+=wTimerCounter[1];
        wTimerCounter[0]+=wTimerCounter[2];
        wTimerCounter[0]+=wTimerCounter[3];
        wTimerCounter[0]+=wTimerCounter[4];
        wTimerCounter[0]+=wTimerCounter[5];
        if(m_isTraceBoard) wTimerCounter[0]+=wTimerCounter[6];
        if(m_isTraceBoard) wTimerCounter[0]+=wTimerCounter[7];
    }      
    
    //show the meter 
    SetMeter();   
    
    BYTE bTmp=0;
    unsigned char bResult; 
    STATUS tmp;     
    
    m_S1 = "";
    m_S2 = "";
    m_S3 = "";
    m_S4 = "";
    m_S5 = "";
    m_S6 = "";      
    m_S7 = "";          
    
    UpdateData(FALSE);  
    
    for(int iTmp=1;iTmp<45;iTmp++) {
    	m_cpOption[iTmp] = 0;
    }		
    
    if(m_C1.GetCheck()) {
    	m_cpOption[1] = 1;
    	m_S1 = "OK";	
    		
    }		
    
    if(m_C2.GetCheck()) {      
    	m_cpOption[2] = 1;
    	m_S2 = "OK";	
    }		      
    
    if(m_C3.GetCheck()) {      
    	m_cpOption[3] = 1;
    	m_S3 = "OK";	
    }		

	if(m_C4.GetCheck()) {      
    	m_cpOption[4] = 1;
    	m_S4 = "OK";	
    }		    
    
    if(m_C5.GetCheck()) {      
   		m_cpOption[5] = 1;
    	m_S5 = "OK";	
    }			  
    
    if(m_C6.GetCheck()) {      
   		m_cpOption[6] = 1;
    	m_S6 = "OK";	
    }
    
    if(m_C7.GetCheck()) {      
   		m_cpOption[7] = 1;
    	m_S7 = "OK";	
    }
    
    if(m_CAll.GetCheck()) {      
    	for (iTmp=1;iTmp<6;iTmp++)
    		m_cpOption[iTmp] = 1;
    	if(m_isTraceBoard) m_cpOption[6] = 1;
    	if(m_isTraceBoard) m_cpOption[7] = 1;
	    m_S1 = "OK";
	    m_S2 = "OK";
	    m_S3 = "OK";
	    m_S4 = "OK";
	    m_S5 = "OK";
	    if(m_isTraceBoard) m_S6 = "OK";
        if(m_isTraceBoard) m_S7 = "OK";
    }		      
                  
    for(iTmp=1;iTmp<8;iTmp++) m_cpOption[0]+=m_cpOption[iTmp];
    if(0 == m_cpOption[0]) {        
	    UpdateData(FALSE);  
	    DeleteMeter();
	    DecideDetailButtonStatus();    
	    MessageBox("No Selection!","",MB_OKCANCEL|MB_ICONSTOP);
	    return;
    }
    
    m_isCanTime = TRUE;
    tmp = emuDiagnostic(&(m_cpOption[1]),&m_Result);
    m_isCanTime = FALSE;
    
    if (tmp != ICE_OK && tmp != ICE_ERR_STOP_BY_USER ) {
    	MessageBox("FW ERROR!","",MB_OKCANCEL|MB_ICONSTOP);
    	UpdateData(FALSE);  
	    DeleteMeter();
	    DecideDetailButtonStatus();
    	return;
    }	       
    
    for (int i=0; i<m_Result.bNum; i++) {
    	switch((m_Result.bErrorCode[i])>>8) {
    		case 1: m_S1 = "FAIL"; break;
    		case 2: m_S2 = "FAIL"; break;
    		case 3: m_S3 = "FAIL"; break;
    		case 4: m_S4 = "FAIL"; break;
    		case 5: m_S5 = "FAIL"; break;
    		case 6: m_S6 = "FAIL"; break;
    		case 7: m_S7 = "FAIL"; break;
    		default : ASSERT(FALSE);
    	}   
    	m_Result.bErrorCode[i] = (m_Result.bErrorCode[i])&0x00ff;
    }
    if (tmp != ICE_ERR_STOP_BY_USER) m_isDetail = TRUE;
    
    UpdateData(FALSE);  
    DeleteMeter();
    DecideDetailButtonStatus();
    
}

BOOL CDiagnosticBox::OnInitDialog()
{
    CDialog::OnInitDialog();

    // TODO: Add extra initialization here   
    m_br.CreateSolidBrush(PALETTEINDEX(COLOR_RED));
    CenterWindow();
    m_buttonDetail.EnableWindow(FALSE);
    m_buttonDiagnostic.EnableWindow(TRUE);
    
    m_nTimerID =SetTimer(1,200,NULL);
    if ( m_nTimerID == 0 ) {
        MessageBox("No more timers!","",MB_OKCANCEL|MB_ICONSTOP);
        return FALSE;
    }                            
	  
	m_isDetail = FALSE;
	
	DecideDiagnosticButtonStatus();
	
	if (!ReadInfor()) {
		AfxMessageBox("Information file error!");
		return FALSE;
	}                        
	
	m_C6.EnableWindow(m_isTraceBoard);
    m_C7.EnableWindow(m_isTraceBoard);
    
    return TRUE;  
}

void CDiagnosticBox::DecideDiagnosticButtonStatus()
{      
      BOOL bResult = FALSE;
      if(m_C1.GetCheck()) bResult = TRUE;
      if(m_C2.GetCheck()) bResult = TRUE;
      if(m_C3.GetCheck()) bResult = TRUE;
      if(m_C4.GetCheck()) bResult = TRUE;
      if(m_C5.GetCheck()) bResult = TRUE;
      if(m_C6.GetCheck()) bResult = TRUE;
      if(m_C7.GetCheck()) bResult = TRUE;
      if(m_CAll.GetCheck()) bResult = TRUE;
      
      m_buttonDiagnostic.EnableWindow(bResult);
 }

void CDiagnosticBox::DecideDetailButtonStatus()
{     
	m_isDetail = TRUE;
    m_buttonDetail.EnableWindow(m_isDetail);
 } 
 

void CDiagnosticBox::OnTimer(UINT nIDEvent)
{
    // TODO: Add your message handler code here and/or call default
    
    if ( m_nTimerID != nIDEvent) {
        CDialog::OnTimer(nIDEvent);
        return;
    }
    
    if (!m_isCanTime) return;
    BYTE bTimer,bTmp; 
    bTmp = emuGetDiagnosticMeterTimer(bTimer);
    ASSERT(bTmp == ICE_OK);
    bTmp = ( (double) ( (bTimer*100)
    				 	   / ((double)wTimerCounter[0]) ) );
    					   
    m_Meter.SetPartsComplete(bTmp);        
    
}

void CDiagnosticBox::SetMeter()
{                                            
    //DISABLE CHECK BUTTON
    m_C1.EnableWindow(FALSE);
    m_C2.EnableWindow(FALSE);
    m_C3.EnableWindow(FALSE);
    m_C4.EnableWindow(FALSE);
    m_C5.EnableWindow(FALSE);
    m_C6.EnableWindow(FALSE);
    m_C7.EnableWindow(FALSE);
    m_CAll.EnableWindow(FALSE);
             
    //decide the rect of meter
    CRect rect1,rect2;
    m_buttonDiagnostic.GetWindowRect(rect1);
    m_buttonDetail.GetWindowRect(rect2);
    
    rect1.right = rect2.right;
    ScreenToClient(rect1);
    //delete button to make space for meter
    m_buttonDetail.ShowWindow(SW_HIDE);
    m_buttonDiagnostic.ShowWindow(SW_HIDE);
    m_buttonQuit.SetWindowText("&Stop");
    
    m_Meter.Create(WS_VISIBLE|WS_CHILD|WS_BORDER, rect1,
        this, IDC_METER);       
        
    m_Meter.SetPartsInJob(100);
    m_Meter.SetPartsComplete(0);    
    
    m_isCanTime = TRUE;
    
    m_buttonQuit.SetFocus();
 }                              
 
void CDiagnosticBox::DeleteMeter()
{   
    m_isCanTime = FALSE;
    emuSetDiagnosticIsStop(FALSE);                  
    m_Meter.SetPartsComplete(100);        
    m_Meter.DestroyWindow();
    m_buttonDetail.ShowWindow(SW_SHOW);
    m_buttonDiagnostic.ShowWindow(SW_SHOW);
    m_buttonQuit.SetWindowText("&Quit");
    
    //ENABLE CHECK BUTTON       
    if(!m_CAll.GetCheck()) {
	    m_C1.EnableWindow(TRUE);
	    m_C2.EnableWindow(TRUE);
	    m_C3.EnableWindow(TRUE);
	    m_C4.EnableWindow(TRUE);
	    m_C5.EnableWindow(TRUE);
	    m_C6.EnableWindow(m_isTraceBoard);
	    m_C7.EnableWindow(m_isTraceBoard);
	}    
    m_CAll.EnableWindow(TRUE);   
    
    m_buttonQuit.SetFocus();
    ADDR tmpAddr;
    tmpAddr.addrType = 0x10;
    
    //if(isCanHWReset) AbiReset(tmpAddr);
     
 }

extern void TestMessage(void);
void CDiagnosticBox::OnCancel()
{
    // TODO: Add extra cleanup here
    if(m_isCanTime) {    
        //ask user to confirm the action   
        //CWaningDialog * tmpDialog;
        //tmpDialog = new CWaningDialog;
        //tmpDialog->Create(1);     //IDD_DIALOG_WARNING7
        
        if ( MessageBox("        Do you really want to stop it?\nNotes:You must push reset button on EasyPack \n      after your stopping.","",MB_OKCANCEL|MB_ICONSTOP)
             == IDCANCEL ) return;                                                                                       
        //while (0 == tmpDialog->nResult)   WaitMessage();//TestMessage();
        
        //delete tmpDialog;
        emuSetDiagnosticIsStop(TRUE);
        return;
    }   
    
    CDialog::OnCancel();
}



void CDiagnosticBox::OnSize(UINT nType, int cx, int cy)
{
    CDialog::OnSize(nType, cx, cy);
    
    // TODO: Add your message handler code here
    /*if ( nType == SIZE_MINIMIZED ) return;
    
    CRect rect(20, 200, 130, 215);
    m_Meter.MoveWindow(rect);*/
    
}

void CDiagnosticBox::OnButtonDetail()
{
    // TODO: Add your control notification handler code here
      CDiagnResultBox *diagnResultBox = new CDiagnResultBox(this);
      CContainEx* pContain = new CContainEx;     
      char * pChar;
      char * pTmp;
      int nTmpLen;
      int i;
      pChar = new char[128];
      //error  code
      if (m_Result.bNum != 0) {
	      strcpy(pChar,"ERROR CODE : ");                
	      *pContain += pChar;
	      pChar = new char[128];
	      strcpy(pChar,"    ");
	      for(i=0;i<m_Result.bNum;i++) {                       
	      	  if(m_Result.bErrorCode[i] == 0) return;
	      	  pTmp = m_ErrorCode.GetAt(m_Result.bErrorCode[i]-1);
		      nTmpLen = strlen(pTmp);
		      int ij=0;              
		      //change the show sequnce only for Mr Cheerson
		      BOOL isFirst = TRUE;
		      char* pcTmp2 = NULL;
		      while (ij<nTmpLen) {   
		      	  CString pTmp3 = pTmp[ij];
		          strcat(pChar,pTmp3.GetBuffer(3));
		          pTmp3.ReleaseBuffer();
		          if(pTmp[ij] == '\n' || ij+1 == nTmpLen) {
		          	  ij++;
		          	  if (isFirst) {    
		          	      pcTmp2 = pChar;
		          	      isFirst = FALSE;		
		          	  } else {
		          	  	  *pContain += pChar;
		          	  }	
		          	  pChar = new char[128];
		     		  strcpy(pChar,"    ");
		          	  continue;
		          }            
		          ij++;
		      }                  
		      if(NULL != pcTmp2) *pContain += pcTmp2;
		      *pContain += pChar;
	      	  pChar = new char[128];
	 		  strcpy(pChar,"    ");
	      }
	      delete pChar;
	  } else {                        
      	  strcpy(pChar,"The Easypack 196F Control Board is OK!");
      	  *pContain += pChar;
      }   
      
      diagnResultBox->m_InfoShow.SetInfo(pContain);
                            
      diagnResultBox->DoModal();                            
      delete pContain;
      delete diagnResultBox;
    
}

HBRUSH CDiagnosticBox::OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor)
{
    // TODO: Add your message handler code here and/or call default
    if(nCtlColor == CTLCOLOR_METER) {
        pDC->SetTextColor(PALETTEINDEX(COLOR_LTRED/*COLOR_LTBLUE*/));   
        //pDC->SetBkColor(PALETTEINDEX(COLOR_RED)); 
        return (HBRUSH)(m_br.m_hObject);
    } else return CDialog::OnCtlColor(pDC, pWnd, nCtlColor);
    
}

void CDiagnosticBox::OnDestroy()
{
    CDialog::OnDestroy();
    
    m_br.DeleteObject();
    // TODO: Add your message handler code here
    
}

void CDiagnosticBox::OnPaint()
{
    CPaintDC dc(this); // device context for painting
    
    // TODO: Add your message handler code here
    CRect rect1;   
    m_Button_Locate.GetWindowRect(rect1);
    ScreenToClient(rect1);

/*  
    HFONT hFont = (HFONT)::GetStockObject(ANSI_FIXED_FONT);
    CFont font;
    this->SetFont(font.FromHandle(hFont));
*/
    LOGFONT logFont;
    _fmemset(&logFont,0,sizeof(LOGFONT));
    logFont.lfHeight=18;
    logFont.lfWeight=800;
    lstrcpy(logFont.lfFaceName, "Arial");
    CFont font;
    font.CreateFontIndirect(&logFont);                                
    
    dc.SelectObject(&font);
    
    dc.SetBkMode(TRANSPARENT);
    dc.SetTextColor(RGB(255,0,0));  
    CString tmpStr;
    tmpStr = "Warning: Diagnostics will change the original system";
    tmpStr += " settings. So once executed, please reset the EasyPack to ensure the system running normally.";
    dc.DrawText(tmpStr,tmpStr.GetLength(),rect1,DT_WORDBREAK);
    
                                               
    // Do not call CDialog::OnPaint() for painting messages
}

void CDiagnosticBox::OnButtonLocate()
{
    // TODO: Add your control notification handler code here
    //notes this button has no use only for locating the station
    //of warning message
}

void CDiagnosticBox::OnCheck1()
{
	// TODO: Add your control notification handler code here
	DecideDiagnosticButtonStatus();
	
}

void CDiagnosticBox::OnCheck2()
{
	// TODO: Add your control notification handler code here
	DecideDiagnosticButtonStatus();
	
}

void CDiagnosticBox::OnCheck3()
{
	// TODO: Add your control notification handler code here
	DecideDiagnosticButtonStatus();
	
}

void CDiagnosticBox::OnCheck4()
{
	// TODO: Add your control notification handler code here
	DecideDiagnosticButtonStatus();
	
}

void CDiagnosticBox::OnCheck5()
{
	// TODO: Add your control notification handler code here
	DecideDiagnosticButtonStatus();
	
}

void CDiagnosticBox::OnCheck6()
{
	// TODO: Add your control notification handler code here
	DecideDiagnosticButtonStatus();
	
}

void CDiagnosticBox::OnCheckall()
{
	// TODO: Add your control notification handler code here
	if(m_CAll.GetCheck()) {
        m_C1.EnableWindow(FALSE);
        m_C2.EnableWindow(FALSE);
        m_C3.EnableWindow(FALSE);
        m_C4.EnableWindow(FALSE);
        m_C5.EnableWindow(FALSE);
        m_C6.EnableWindow(FALSE);
        m_C7.EnableWindow(FALSE);
    } else { 
        m_C1.EnableWindow(TRUE);
        m_C2.EnableWindow(TRUE);
        m_C3.EnableWindow(TRUE);
        m_C4.EnableWindow(TRUE);
        m_C5.EnableWindow(TRUE);
        m_C6.EnableWindow(m_isTraceBoard);
        m_C7.EnableWindow(m_isTraceBoard);
    }                            
        
    DecideDiagnosticButtonStatus();
	
}

void CDiagnosticBox::OnCheck7()
{
	// TODO: Add your control notification handler code here
	DecideDiagnosticButtonStatus();	
}
