//filectrl.h
//this file is the include file of filectrl.cpp
//created by john 1996.2-3

#include "stdafx.h"       
#include "windowsx.h"
#include "contain.h"

//define class CFileCtrl
class CFileCtrl : public CFile
{        
//construct & destruct
public :
 CFileCtrl(CString,unsigned long maxBufferLen = 10240);
 ~CFileCtrl();    
 
//members                  
public :
enum {                   //defined for the status and error code
  	    NOTLOADING = 0,
  	    LOADING,
  	    READINGOK,
  	    ENDOFFILE,
  	    MEMORYERROR,  
  	    FILENAMEERROR,
  	    FILEERROR 
       };
       
private :
 CString m_StrFileName;
 unsigned char m_UcStatus;
 unsigned char far * m_pBuffer;
 unsigned long m_MaxBufferLen; 
 unsigned long m_ValidBufferLen;
 unsigned long m_FilePos;
 unsigned long m_FileLength;
 
//operate
public :
 unsigned char operator[](unsigned long); 
 unsigned char GetStatus();
 unsigned long GetFileLength(); 
 unsigned char GetBuffer(unsigned char* &,unsigned long &,
                         unsigned long index=0,BOOL bMustFix=FALSE);
 void OpenFile(CString,unsigned long maxBufferLen = 10240);                         
private :
 void ReadBuffer(unsigned long);

 };
 
//define class CTextFileCtrl 
class CTextFileCtrl : public CFileCtrl
{  
//construct & destruct
public :
 CTextFileCtrl(CString,unsigned long maxBufferLen = 10240);  
 ~CTextFileCtrl();  
  
//members
private :  
 CBigContain m_Buffer;
 unsigned long m_lMaxALine;
 
//operations
public :            
 BOOL 
 unsigned long GetMaxLines() 
  { return m_Buffer.GetValidContainLen();   }
 CString operator[](unsigned long);
 void SetMaxAline(unsigned long);
 
 };