  /***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/DIAGNO/UISRLDIA.CPP   1.11   09 Jan 1997 14:28:06   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/DIAGNO/UISRLDIA.CPP  $
** 
**    Rev 1.11   09 Jan 1997 14:28:06   ZJRD
** No change.
** 
**    Rev 1.10   13 Dec 1996 11:23:24   ZJRD
** No change.
** 
**    Rev 1.9   22 Nov 1996 11:04:20   ZJRD
** No change.
** 
**    Rev 1.8   11 Nov 1996 12:51:36   ZJRD
** No change.
** 
**    Rev 1.7   06 Nov 1996 13:03:24   ZJRD
** No change.
** 
**    Rev 1.6   02 Nov 1996 09:50:50   ZJRD
** No change.
** 
**    Rev 1.5   30 Oct 1996 12:53:36   ZJRD
** No change.
** 
**    Rev 1.4   28 Oct 1996 09:46:02   ZJRD
** PIC/SLD Version 0.92
** 
**    Rev 1.1   23 Sep 1996 10:40:22   ZJRD
** No change.
** 
**    Rev 1.0   06 Sep 1996 13:56:44   ZJRD
** Initial revision.
** 
**    Rev 1.0   13 Aug 1996 09:20:14   ZJRD
** Initial revision.
** 
****************************************************************************/

/***************************************************************************
**
** File name : UISRLDIA.CPP
** Author:john chow
** Description:
**    Descript the derived class from CWinSerialPICAgree for using in setup
**
**    Finished date: 96.8
**    modifed date:
**
**    Copyright (C) 1995 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/

#include "stdafx.h"

#include "uisrldia.h"
#include "conio.h"
#include "resource.h"
#include "communic.h"
#include "abitype.h"
#include "abiextfn.h"

extern void TestMessage();
extern int OpenAbiComDlg(int fHelpComm);
extern void ExitEpsld(void);
STATUS AbiTestCom(char* pTestData,char* pRetData);   
extern "C" {
	WORD FAR PASCAL _export WhatCpu();    
}	

//implemention of class CWinSerialPICAgree

BOOL CWinSerialPICAgreeDia::CommInit()
{            
    //read init savings                        
    BYTE bTmpBaudRate;
    m_bPortNum = ReadCommType();
    if(m_bPortNum < COM_PORT_1 || m_bPortNum > COM_PORT_4) {
        m_bPortNum =  COM_PORT_2;    
    }
    
    m_bBaudRate = ReadCommBaud();
    if(m_bBaudRate < BAUD_9600 || m_bBaudRate > BAUD_115200) {
        m_bBaudRate = BAUD_19200;    
    }                               
    m_bBaudRate = BAUD_115200;
    bTmpBaudRate = m_bBaudRate;      
    
    m_bPICClockType = ReadClock();
    if(m_bPICClockType < CLOCK_LP || m_bPICClockType > CLOCK_RC) {
        m_bPICClockType = CLOCK_HS;    
    }                             
    
    m_bPICCpuType = ReadCpu();    
    //try to connect to PIC with the settings
    while (TRUE) {
        if (!SetSerialOption()) return FALSE;
        if (SetSerialPortBaud(m_bPortNum,m_bDefaultBaudRate)) {
            if (Init() || TryInit()) {  
                if (m_bBaudRate == bTmpBaudRate) break;
                
                BYTE bMaxBaudRate = BAUD_115200;
                switch (WhatCpu()) {
                	case 1 :
                	case 2 : bMaxBaudRate = BAUD_19200; break;
                	case 3 : bMaxBaudRate = BAUD_38400; break;
                	case 4 : bMaxBaudRate = BAUD_57600; break;
                	case 5 : 
                	default: bMaxBaudRate = BAUD_115200; break;
                }	
                bTmpBaudRate = (bTmpBaudRate > bMaxBaudRate)
                			   ? bMaxBaudRate : bTmpBaudRate;
                m_bBaudRate = bTmpBaudRate;  
                
                if (ICE_OK != AbiSelectBaud(m_bBaudRate)) return FALSE;
                if (SetSerialPortBaud(m_bPortNum,m_bBaudRate) 
                    && Init()) break;  
                if (0 != m_bBaudRate) {
                    m_bBaudRate--;   
                    bTmpBaudRate = m_bBaudRate;
                    continue;
                }    
                    
            }
        } 
        
        m_bPortNum++;
        if (m_bPortNum > COM_PORT_4) m_bPortNum = COM_PORT_1;
        
        CCommunicationDialog dlg;
        dlg.m_nComType = m_bPortNum;
        if(dlg.DoModal() != IDOK) return FALSE;
        m_bPortNum = dlg.m_nComType;
        bTmpBaudRate = m_bBaudRate;      
    }
      
    WriteCommType(m_bPortNum);
    WriteCommBaud(m_bBaudRate);     
    
    if (FALSE == SetPICClockType(0)) return FALSE;
    
    return TRUE;
    
 }

BYTE CWinSerialPICAgreeDia::ReadCommType()
{                             
	return 
		GetPrivateProfileInt("COMM", "Type", COM_PORT_2,"PICSLD.INI");	
 }
 
BYTE CWinSerialPICAgreeDia::ReadCommBaud()
{                             
	return 
		GetPrivateProfileInt("COMM", "BaudRate",BAUD_115200,"PICSLD.INI");	
 }      

BYTE CWinSerialPICAgreeDia::ReadClock()
{ 
	return
		GetPrivateProfileInt("CLOCK", "Type",CLOCK_HS,"PICSLD.INI");
 }      
 
BYTE CWinSerialPICAgreeDia::ReadCpu()
{ 
	return
		GetPrivateProfileInt("CPU", "Type",0,"PICSLD.INI");
 }      
 
 
void CWinSerialPICAgreeDia::WriteCommType(BYTE bInput) 
{ 
	 char pCharTmp[10];
	 sprintf(pCharTmp,"%X",bInput);
	 WritePrivateProfileString("COMM","Type",pCharTmp,"PICSLD.INI");
 }                                                    
 
void CWinSerialPICAgreeDia::WriteCommBaud(BYTE bInput) 
{ 
	 char pCharTmp[10];
	 sprintf(pCharTmp,"%X",bInput);
	 WritePrivateProfileString("COMM","BaudRate",pCharTmp,"PICSLD.INI");
 }                                                    
        
void CWinSerialPICAgreeDia::WriteClock(BYTE bInput) 
{ 
	 char pCharTmp[10];
	 sprintf(pCharTmp,"%X",bInput);
	 WritePrivateProfileString("CLOCK","Type",pCharTmp,"PICSLD.INI");
 }                                                    

void CWinSerialPICAgreeDia::WriteCpu(BYTE bInput) 
{ 
	 char pCharTmp[10];
	 sprintf(pCharTmp,"%X",bInput);
	 WritePrivateProfileString("CPU","Type",pCharTmp,"PICSLD.INI");
 }                                                    

BOOL CWinSerialPICAgreeDia::DoCanTime()
{                           
	m_bWaitTime = 0;
	m_isStop = FALSE;
	unsigned long nBackTimeBak = nBackTime;
	nBackTime = 1000;
	
	while (TRUE) {
    do {
        if(Shakehand()) break;
        if(ERR_TIME_OUT != m_nError)
        	return FALSE;
        if(!IsRelink()) {
            m_nError = ERR_RELINKQUIT;
            m_nDetailError = ERR_SHAKE_HAND;
            return FALSE;
        } else break;   
    } while (TRUE);  
    
    if(ERR_TIME_OUT == m_nError) continue;
    
    do {         
        if(SendHead()) break;
        if(ERR_RECEIVE_DOLLAR == m_nError) break;
        if(ERR_TIME_OUT != m_nError) 
        	return FALSE;
        if(!IsRelink()) {
            m_nError = ERR_RELINKQUIT;
            m_nDetailError = ERR_SEND_HEAD;
            return FALSE;
        } else break;   
    } while (TRUE);
    
    if(ERR_TIME_OUT == m_nError || ERR_RECEIVE_DOLLAR == m_nError) continue;
    
    do {         
        if(SendRec()) break;
        if(ERR_RECEIVE_DOLLAR == m_nError) break;
        if(ERR_TIME_OUT != m_nError) 
        	return FALSE;
        if(!IsRelink()) {
            m_nError = ERR_RELINKQUIT;     
            m_nDetailError = ERR_SEND_REC;
            return FALSE;
        } else break;   
    } while (TRUE);
    
    if(ERR_TIME_OUT == m_nError || ERR_RECEIVE_DOLLAR == m_nError) continue;
    
    do {         
        while(!Shakehand_()) { 
        	if(ERR_TIME_OUT != m_nError) return FALSE;
        	if(++m_bWaitTime >= (nBackTimeBak/1000)) break;
        	if(m_isStop) {                
        		m_nError = ERR_STOP_BY_USER;       
        		m_nDetailError = ERR_SHAKE_HAND_;
        		return FALSE;
        	}	
        	TestMessage();
        }	
        
        if(ERR_NO == m_nError) 
        	break;
        if(ERR_TIME_OUT != m_nError) 
        	return FALSE;
        if(!IsRelink()) {
            m_nError = ERR_RELINKQUIT;    
            m_nDetailError = ERR_SHAKE_HAND_;
            return FALSE;
        } else break;   
    } while (TRUE);         
    
    if(ERR_TIME_OUT == m_nError) continue;
                     
    do {         
        if(ReceiveHead()) break;
        if(ERR_SEND_DOLLAR == m_nError) break;
        if(ERR_TIME_OUT != m_nError) 
        	return FALSE;
        if(!IsRelink()) {
            m_nError = ERR_RELINKQUIT;  
            m_nDetailError = ERR_RECEIVE_HEAD;
            return FALSE;
        } else break;   
    } while (TRUE);
                     
    if(ERR_TIME_OUT == m_nError || ERR_SEND_DOLLAR == m_nError) continue;   
    
    do {         
        if(ReceiveRec()) break;
        if(ERR_SEND_DOLLAR == m_nError) break;
        if(ERR_TIME_OUT != m_nError) 
        	return FALSE;
        if(!IsRelink()) {
            m_nError = ERR_RELINKQUIT;        
            m_nDetailError = ERR_RECEIVE_REC;
            return FALSE;
        } else break;   
    } while (TRUE);
                     
    if(ERR_TIME_OUT == m_nError || ERR_SEND_DOLLAR == m_nError) continue;   
    return TRUE;
}   

 }        
     