/***************************************************************************
**
**    $Header$
**
**    $Log$
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  DSMEDIT2.CPP
//
//  Description:The implement file for the class: CDsmEdit2
//
//  Author:     Lane Li &       Daniel Lin
//
//  Modification:
//      1. 10/25/95, 0.1d version       Daniel Lin
//              modified function   OnInitDialog()
//
//      1. 09/10/95, Initial version
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

// dsmedit2.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
//#include "ep196.h"
#include "dsmedit2.h"
#include "uicom2.h"
#include "dadextfn.h"

#include "srcdef.h"


#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

long MemAssemble(DWORD,char*,WORD);

long MemAssemble(DWORD dwAddr, char* instruction,WORD space)
{
long	nRet=-1;
int		nResult;
ADDR	addr;
CString strAsm=instruction;

	addr.addr=dwAddr;
	addr.addrType=space;

CDADExtFnBase* pClass = new CDADExtFnCom(addr,strAsm);
	nResult=pClass->GetResult();
	if(nResult!=CDADExtFnBase::DAD_OK)
	{
		delete pClass;
		return -1;
	}
	nRet=long(dwAddr+(pClass->GetAsmCodeLen()));
	delete pClass;
	return nRet;
}

/////////////////////////////////////////////////////////////////////////////
// CDsmEdit2 dialog

CDsmEdit2::CDsmEdit2(CWnd* pParent /*=NULL*/)
    : CDialog(CDsmEdit2::IDD, pParent)
{
    //{{AFX_DATA_INIT(CDsmEdit2)
        // NOTE: the ClassWizard will add member initialization here
    //}}AFX_DATA_INIT
    m_pParent = pParent;
}

void CDsmEdit2::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CDsmEdit2)
        // NOTE: the ClassWizard will add DDX and DDV calls here
    //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CDsmEdit2, CDialog)
    //{{AFX_MSG_MAP(CDsmEdit2)
    ON_BN_CLICKED(IDC_DSMEDIT2_BUTTON1, OnDsmedit2Button1)
    ON_BN_CLICKED(IDC_DSMEDIT2_BUTTON2, OnDsmedit2Button2)
    ON_BN_CLICKED(IDC_DSMEDIT2_BUTTON3, OnDsmedit2Button3)
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CDsmEdit2 message handlers

BOOL CDsmEdit2::OnInitDialog()
{
    CDialog::OnInitDialog();
    CenterWindow();

    // TODO: Add extra initialization here
    char text[20];
    CWnd* ctrl;

    sprintf(text,"%04lX",m_dwAddress);
    SetDlgItemText(IDC_DSMEDIT2_EDIT1,text);

    ctrl=GetDlgItem(IDC_DSMEDIT2_EDIT2);
    ctrl->SetFocus();

    return FALSE;  // return TRUE  unless you set the focus to a control

    return TRUE;  // return TRUE  unless you set the focus to a control
}

void CDsmEdit2::OnDsmedit2Button1()
{
    // TODO: Add your control notification handler code here
    long l;
    char text[256];

    GetDlgItemText(IDC_DSMEDIT2_EDIT2,text,255);
    l = MemAssemble(m_dwAddress,text,m_wSpaceType);
    if (l<0)
    {
        MessageBeep(-1);
        MessageBox("Input instruction error or HW error!",NULL,MB_OK|MB_ICONEXCLAMATION);
        return;
    }
    EndDialog(1);
    BeginWaitCursor();
    // in program area, test command should modify memory, so
    // refresh source window
    if (m_wSpaceType == 1) {
       ::SrcUpdateSourceWindow(::srcUpdate);
    }
    EndWaitCursor();

}

void CDsmEdit2::OnDsmedit2Button2()
{
    // TODO: Add your control notification handler code here
    long l;
    char text[256];

    GetDlgItemText(IDC_DSMEDIT2_EDIT2,text,255);
    l = MemAssemble(m_dwAddress,text,m_wSpaceType);
    if (l<0)
    {
        MessageBeep(-1);
        MessageBox("Input instruction error or HW error!",NULL,MB_OK|MB_ICONEXCLAMATION);
        return;
    }
    else
    {
        //modify by chris, 3/31/97
        //m_pParent->InvalidateRect(NULL,FALSE);
        RepaintMemory();
    	///RepaintSource();
        m_dwAddress = l;
        sprintf(text,"%04lX",m_dwAddress);
        SetDlgItemText(IDC_DSMEDIT2_EDIT1,text);
        SetDlgItemText(IDC_DSMEDIT2_EDIT2,"");
    }
}

void CDsmEdit2::OnDsmedit2Button3()
{
    // TODO: Add your control notification handler code here
    EndDialog(0);
}
