/***************************************************************************
**
**    $Header$
**
**    $Log$
** 
****************************************************************************/

/***************************************************************************
**
**    $Header:   D:/ECB2S/SRC/LOG/ERROR/HOSTERR.H__   1.0.1.1.1.5   17 Apr 1997 16:29:38   ZJRD  $
**
**    $Log$
** 
**    Rev 1.30   12 Apr 1996 10:39:30   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.0   07 Sep 1995 09:55:40   Shirley
** Initial revision.
**
****************************************************************************/

/****************************************************************************
**
**  Name:  hosterrs.h
**
**  Description:
**     Host system errors are defined here, along with typical masks.
**
**  Status:  CODED
**
**  Date:	3/20/96 	by:  Jamoon
**
**  Copyright (C) 1996 Microtek International.  All rights reserved.
**
*****************************************************************************/

#ifndef _HOSTERRS_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#include "basictyp.h" 

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/
#define E_ERRSIZE           256     // maximum size of error text


// E_SEVERITY_MASK mask out the error property 
#define E_SEVERITY_MASK    	0xFF000000L
#define E_UNKNOWN         	0x00000000L
#define E_INFORMATIVE       0x10000000L
#define E_WARNING          	0x01000000L
#define E_ERROR				0x02000000L
#define E_FATAL            	0x04000000L
#define E_SEVERE           	0x08000000L
#define E_SEVERITYID(x) 	( (x) & E_SEVERITY_MASK )

// use E_COMPONET_MASK to mask out the componet that send the error
// detecting component id is upper 2 bytes less top 8 bits 
#define E_COMPONENT_MASK   	0x00FF0000L
#define E_MODULEID(x)  		( (x) & E_COMPONENT_MASK )

// module id define
#define MOD_UNKNOWN			0x00000000L

// error number is lower 2 bytes 
#define E_ERROR_NUMBER_MASK   0x0000FFFFL
#define E_ERRORID(x)  (U16) ((x) & E_ERROR_NUMBER_MASK)

// error id and recovery id in errcodec.h
//#include "errcodec.h"



                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/



/*****************************************************************************
** ErrGetErrorText
**
** Description:
**   Retrieve error text or recover text and plug in optional arguments.  
**	 The *caller* is expected to have allocated storage for the return 
**	 string of size E_ERRSIZE if LPSTR is used. 
**	 Optional arguments must fit with the error format string. Refer to 
**	 wvsprintf() window function for the format-control character sequences.
**
** Parameters:
**    input :
**       errCode :   error type, and error number 
**					 or recover type, and recover number
**    output :
**       lpszError : error string
**       strError 
** Return :
**		GOOD(0) for success    FAILURE(-1) for failure	
*****************************************************************************/
//RETCODE EXPORT ErrGetErrorText(U32 errorCode, LPSTR lpszError ...);
//RETCODE EXPORT ErrGetErrorText(U32 errorCode, CString& strError ...);


/*****************************************************************************
** ErrGetErrorText
**
** Description:
**   Retrieve error text and recover text and plug in optional arguments.  
**	 The *caller* is expected to have allocated storage for the return 
**	 string of size E_ERRSIZE if LPSTR is used
**	 Optional arguments must fit with the error format string. Refer to 
**	 wvsprintf() window function for the format-control character sequences.
**
** Parameters:
**    input :
**       errCode :   error type, and error number 
**		 recCode :	 recover type, and recover number
**    output :
**       lpszError : error string 
**		 lpszRecov : recover string
**       strError  : error CString
**		 strRecov  : recover CString
** Return :
**		GOOD(0) for success    FAILURE(-1) for failure	
*****************************************************************************/
//RETCODE EXPORT ErrGetErrorText(U32 errCode,U32 recCode,
//				LPSTR lpszError, LPSTR lpszRecov ...);
//RETCODE EXPORT ErrGetErrorText(U32 errCode,U32 recCode,
//				CString& strError, CString& strRecov ...);



/****************************************************************************
**
**  ErrDisplayError
**
**  Description:
**     Obtain and display the error text corresponding to the given error code
**     with MessageBox, optional arguments must fit with the error  format  
**     string. Refer to wvsprintf() window function for the format-control  
**     character sequences.
**
**  Parameters:
**     input:
**        errCode          error code
**        recCode          recovery code, recCode = 0 for no recovery
**     output:
**
*****************************************************************************/
//RETCODE EXPORT ErrDisplayError(U32 errCode, U32 recCode ...);
//RETCODE EXPORT ErrDisplayError(U32 errCode);


#define _HOSTERRS_
#endif
/******************************** E O F ***********************************/
