/***************************************************************************
**
**    $Header$
**
**    $Log$
** 
****************************************************************************/

/****************************************************************************
**
**  Name:  mkerrors.h
**
**  Description:
**     This is the ONLY file to change in order to add or change error
**     definitions in EP/SLD.  This file is the source for several
**     other files, which are automatically produced by mkerrors.exe.
**     The generated files are:
**       errcodec.h : error code defines in C format
**       errerr.h : error code offsets in the errtext.rc file
**       errtext.rc : string resources (error text)
**       mkerrors.new : the next version of THIS header file
**
**  Status:  PRELIMINARY
**
**  Date:     8 March 1996 09:11:00  by Jamoon Zhou
**
**
**  Copyright (C) 1996 Microtek International.  All rights reserved.
**
*****************************************************************************/
#ifndef _MKERRORS_
#define _MKERRORS_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/
#define     ICE_OK                        0    /* Normal return */
#define     ICE_MICE_HALT              ( -1)   /* Target CPU halted */
#define     ICE_MEM_GUARD              ( -2)   /* Access the guarded memory */
#define     ICE_MEM_PROTECT            ( -3)   /* Access the protected memory */
#define     ICE_ERROR_READ             ( -4)   /* Memory read failure */
#define     ICE_ERROR_WRITE            ( -5)   /* Memory write failure */
#define     ICE_STEP_ERROR             ( -6)   /* Target cannot step */
#define     ICE_NO_DIFF                ( -7)   /* No difference in memory compare                                */
#define     ICE_NO_FOUND               ( -8)   /* Not found in memory search */
#define     ICE_BREAK                  ( -9)   /* Break on memory access */
#define     ICE_BREAK_I                (-10)   /* Break on instruction fetch */
#define     ICE_BAD_REG                (-11)   /* Bad register number encountered                                */
#define     ICE_BAD_IN                 (-12)   /* Error encountered on user input                                */
#define     ICE_HALT_USER              (-13)   /* user pressed ^C */
#define     ICE_ERROR_COM              (-14)   /* communication error */
#define     ICE_ERROR_MICE             (-15)   /* linking incorrect MICE model */
#define     ICE_MICE_LIMIT             (-16)   /* MICE limitation */
#define     ICE_BUS_REQUEST            (-17)   /* Bus request */
#define     ICE_BAD_FRAME              (-18)   /* invalid frame number */
#define     ICE_ERROR_BOUN             (-19)   /* error map boundary */
#define     ICE_MAP_FAIL               (-20)   /* memory map fail */
#define     ICE_ABS_OVERFLOW           (-21)   /* abs address overflow */
#define     ICE_TEST_FAIL              (-22)   /* test failure */
#define     ICE_CPU_RUN                (-23)   /* CPU free running */
#define     ICE_BROKE                  (-24)   /* CPU stop */
#define     ICE_NOT_READY              (-25)   /* target is not ready */
#define     ICE_COMMAND_ERROR          (-26)   /*  */
#define     ICE_TIME_OUT               (-27)   /*  */
#define     ICE_NO_TRACE_MODULE        (-28)   /*  */
#define     ICE_BKPT1_HALT             (-29)   /*  */
#define     ICE_BKPT2_HALT             (-30)   /*  */
#define     ICE_VIOL_HALT              (-31)   /*  */
#define     ICE_RBW_HALT               (-32)   /*  */
#define     ICE_TRIG_HALT              (-33)   /*  */
#define     ICE_LINK_MICE_FAIL         (-34)   /*  */
#define     ICE_WARN_START             (-35)   /*  */
#define     ICE_BANK_FULL              (-36)
#define     ICE_ADDR_RANGE_OVERFLOW    (-37)
#define     ICE_ATTRIBUTE_MISMATCH     (-38)
#define     ICE_BANK_MISMATCH          (-39)
#define     ICE_SPACE_MISMATCH         (-40)
#define     ICE_ADDR_MISMATCH          (-41)
#define     ICE_NO_VCC                 (-42)
#define     ICE_USER_CC                (-43)
#define     ICE_TARGET_RESET           (-44)
#define     ICE_NO_EMM                 (-45)
#define     ICE_CNT_ERROR              (-46)
#define     ICE_TIMER_ERROR            (-47)
#define     ICE_EVENT_FULL             (-48)
#define     ICE_BUFFER_EMPTY           (-49)
#define     ICE_EMM_SET_ERROR          (-50)
#define     ICE_EP_PENDING             (-51)
#define     ICE_REC_TIME_OUT           (-52)
#define     ICE_INVALID_CPU            (-53)
#define     ICE_MCE16A_FAIL            (-54)
#define     ICE_EMM_FAIL               (-55)
#define     ICE_TRACE_BOARD_FAIL       (-56)
#define     ICE_COV_RBW_FAIL           (-57)
#define     ICE_CPU_FLY                (-58)
#define     ICE_INVALID_FLY_COMMAND    (-59)
#define     ICE_INVALID_FIRMWARE       (-60)
#define     ICE_FLASH_EREASE_FAIL      (-61)
#define     ICE_FLASH_PROG_FAIL        (-62)
#define     ICE_FLASH_SWITCH_FAIL      (-63)
#define     ICE_NO_MATCH               (-64)
#define     ICE_IDLE                   (-65)
#define     ICE_POWERDOWN              (-66)
#define     ICE_SLEEPING               (-67)
#define     ICE_JED_CHECK_DEVICE_ERROR (-68)
#define     ICE_JED_CHECK_DATA_ERROR (-69)
#define     ICE_JED_PROGRAME_VERIFY_ERROR (-70)

//  Here are all the error codes for all the error types in EP/SLD
//  The corresponding error text is in errtext.rc.
//  ONLY MAKE CHANGES BELOW THIS LINE (in mkerrors.h)
/*
{
	"ER_LDR_",
	( 0x400 ),
	
}, 
*/

//ER_ABI_BASE(0x1000) entry abi##
{
	"ER_ICE_OK",
	E_ERROR | ( ER_ABI_BASE ),
	"Abi return OK!",
}, 
{
	"ER_ICE_1",
	E_ERROR | ( ER_ABI_BASE+1 ),
	"EP running!",
}, 
{
	"ER_ICE_MICE_HALT",
	E_ERROR | ( ER_ABI_BASE+ICE_MICE_HALT ),
	"Target CPU halted!",
}, 
{
	"ER_ICE_MEM_GUARD",
	E_ERROR | ( ER_ABI_BASE+ICE_MEM_GUARD ),
	"Access the guarded memory!",
}, 
{
	"ER_ICE_MEM_PROTECT",
	E_ERROR | ( ER_ABI_BASE+ICE_MEM_PROTECT ),
	"Access the protected memory!",
}, 
{
	"ER_ICE_ERROR_READ",
	E_ERROR | ( ER_ABI_BASE+ICE_ERROR_READ ),
	"Memory read failure!",
}, 
{
	"ER_ICE_ERROR_WRITE",
	E_ERROR | ( ER_ABI_BASE+ICE_ERROR_WRITE ),
	"Memory write failure!",
}, 
{
	"ER_ICE_STEP_ERROR",
	E_ERROR | ( ER_ABI_BASE+ICE_STEP_ERROR ),
	"Target cannot step!",
}, 
{
	"ER_ICE_NO_DIFF",
	E_ERROR | ( ER_ABI_BASE+ICE_NO_DIFF ),
	"No difference in memory compare!",
}, 
{
	"ER_ICE_NO_FOUND",
	E_ERROR | ( ER_ABI_BASE+ICE_NO_FOUND ),
	"Not found in memory search!",
}, 
{
	"ER_ICE_BREAK",
	E_ERROR | ( ER_ABI_BASE+ICE_BREAK ),
	"Break on memory access!",
}, 
{
	"ER_ICE_BREAK_I",
	E_ERROR | ( ER_ABI_BASE+ICE_BREAK_I ),
	"Break on instruction fetch!",
}, 
{
	"ER_ICE_BAD_REG",
	E_ERROR | ( ER_ABI_BASE+ICE_BAD_REG ),
	"Bad register number encountered!",
}, 
{
	"ER_ICE_BAD_IN",
	E_ERROR | ( ER_ABI_BASE+ICE_BAD_IN ),
	"Error encountered on user input!",
}, 
{
	"ER_ICE_HALT_USER",
	E_ERROR | ( ER_ABI_BASE+ICE_HALT_USER ),
	"user pressed ^C!",
}, 
{
	"ER_ICE_ERROR_COM",
	E_ERROR | ( ER_ABI_BASE+ICE_ERROR_COM ),
	"Communication error!",
}, 
{
	"ER_ICE_ERROR_MICE",
	E_ERROR | ( ER_ABI_BASE+ICE_ERROR_MICE ),
	"Linking incorrect MICE model!",
}, 
{
	"ER_ICE_MICE_LIMIT",
	E_ERROR | ( ER_ABI_BASE+ICE_MICE_LIMIT ),
	"MICE limitation!",
}, 
{
	"ER_ICE_BUS_REQUEST",
	E_ERROR | ( ER_ABI_BASE+ICE_BUS_REQUEST ),
	"Bus request!",
}, 
{
	"ER_ICE_BAD_FRAME",
	E_ERROR | ( ER_ABI_BASE+ICE_BAD_FRAME ),
	"Invalid frame number!",
}, 
{
	"ER_ICE_ERROR_BOUN",    
	E_ERROR | ( ER_ABI_BASE+ICE_ERROR_BOUN ),
	"Error map boundary!",
}, 
{
	"ER_ICE_MAP_FAIL",
	E_ERROR | ( ER_ABI_BASE+ICE_MAP_FAIL ),
	"Memory map fail!",
}, 
{
	"ER_ICE_ABS_OVERFLOW",
	E_ERROR | ( ER_ABI_BASE+ICE_ABS_OVERFLOW ),
	"Abs address overflow!",
}, 
{
	"ER_ICE_TEST_FAIL",
	E_ERROR | ( ER_ABI_BASE+ICE_TEST_FAIL ),
	"Test failure!",
}, 
{
	"ER_ICE_CPU_RUN",
	E_ERROR | ( ER_ABI_BASE+ICE_CPU_RUN ),
	"CPU free running!",
}, 
{
	"ER_ICE_BROKE",
	E_ERROR | ( ER_ABI_BASE+ICE_BROKE ),
	"CPU stop!",
}, 
{
	"ER_ICE_NOT_READY",
	E_ERROR | ( ER_ABI_BASE+ICE_NOT_READY ),
	"Target is not ready!",
}, 
{
	"ER_ICE_COMMAND_ERROR",
	E_ERROR | ( ER_ABI_BASE+ICE_COMMAND_ERROR ),
	"ER_ICE_COMMAND_ERROR!",
}, 
{
	"ER_ICE_TIME_OUT",
	E_ERROR | ( ER_ABI_BASE+ICE_TIME_OUT ),
	"ER_ICE_TIME_OUT!",
}, 
{
	"ER_ICE_NO_TRACE_MODULE",
	E_ERROR | ( ER_ABI_BASE+ICE_NO_TRACE_MODULE ),
	"ER_ICE_NO_TRACE_MODULE!",
}, 
{
	"ER_ICE_BKPT1_HALT",
	E_ERROR | ( ER_ABI_BASE+ICE_BKPT1_HALT ),
	"ER_ICE_BKPT1_HALT!",
}, 
{
	"ER_ICE_BKPT2_HALT",
	E_ERROR | ( ER_ABI_BASE+ICE_BKPT2_HALT ),
	"ER_ICE_BKPT2_HALT!",
}, 
{
	"ER_ICE_VIOL_HALT",
	E_ERROR | ( ER_ABI_BASE+ICE_VIOL_HALT ),
	"ER_ICE_VIOL_HALT!",
}, 
{
	"ER_ICE_RBW_HALT",
	E_ERROR | ( ER_ABI_BASE+ICE_RBW_HALT ),
	"ER_ICE_RBW_HALT!",
}, 
{
	"ER_ICE_TRIG_HALT",
	E_ERROR | ( ER_ABI_BASE+ICE_TRIG_HALT ),
	"ER_ICE_TRIG_HALT!",
}, 
{
	"ER_ICE_LINK_MICE_FAIL",
	E_ERROR | ( ER_ABI_BASE+ICE_LINK_MICE_FAIL ),
	"ER_ICE_LINK_MICE_FAIL!",
}, 
{
	"ER_ICE_WARN_START",
	E_ERROR | ( ER_ABI_BASE+ICE_WARN_START ),
	"ER_ICE_WARN_START!",
}, 
{
	"ER_ICE_BANK_FULL",
	E_ERROR | ( ER_ABI_BASE+ICE_BANK_FULL ),
	"ER_ICE_BANK_FULL!",
}, 
{
	"ER_ICE_ADDR_RANGE_OVERFLOW",
	E_ERROR | ( ER_ABI_BASE+ICE_ADDR_RANGE_OVERFLOW ),
	"ER_ICE_ADDR_RANGE_OVERFLOW!",
}, 
{
	"ER_ICE_ATTRIBUTE_MISMATCH",
	E_ERROR | ( ER_ABI_BASE+ICE_ATTRIBUTE_MISMATCH ),
	"ER_ICE_ATTRIBUTE_MISMATCH!",
}, 
{
	"ER_ICE_BANK_MISMATCH",
	E_ERROR | ( ER_ABI_BASE+ICE_BANK_MISMATCH ),
	"ER_ICE_BANK_MISMATCH!",
}, 
{
	"ER_ICE_SPACE_MISMATCH",
	E_ERROR | ( ER_ABI_BASE+ICE_SPACE_MISMATCH ),
	"ER_ICE_SPACE_MISMATCH!",
}, 
{
	"ER_ICE_ADDR_MISMATCH",
	E_ERROR | ( ER_ABI_BASE+ICE_ADDR_MISMATCH ),
	"ER_ICE_ADDR_MISMATCH!",
}, 
{
	"ER_ICE_NO_VCC",
	E_ERROR | ( ER_ABI_BASE+ICE_NO_VCC ),
	"ER_ICE_NO_VCC!",
}, 
{
	"ER_ICE_USER_CC",
	E_ERROR | ( ER_ABI_BASE+ICE_USER_CC ),
	"ER_ICE_USER_CC!",
}, 
{
	"ER_ICE_TARGET_RESET",
	E_ERROR | ( ER_ABI_BASE+ICE_TARGET_RESET ),
	"ER_ICE_TARGET_RESET!",
}, 
{
	"ER_ICE_NO_EMM",
	E_ERROR | ( ER_ABI_BASE+ICE_NO_EMM ),
	"ER_ICE_NO_EMM!",
}, 
{
	"ER_ICE_CNT_ERROR",
	E_ERROR | ( ER_ABI_BASE+ICE_CNT_ERROR ),
	"ER_ICE_CNT_ERROR!",
}, 
{
	"ER_ICE_TIMER_ERROR",
	E_ERROR | ( ER_ABI_BASE+ICE_TIMER_ERROR ),
	"ER_ICE_TIMER_ERROR!",
}, 
{
	"ER_ICE_EVENT_FULL",
	E_ERROR | ( ER_ABI_BASE+ICE_EVENT_FULL ),
	"ER_ICE_EVENT_FULL!",
}, 
{
	"ER_ICE_BUFFER_EMPTY",
	E_ERROR | ( ER_ABI_BASE+ICE_BUFFER_EMPTY ),
	"ER_ICE_BUFFER_EMPTY!", 
}, 
{
	"ER_ICE_EMM_SET_ERROR",
	E_ERROR | ( ER_ABI_BASE+ICE_EMM_SET_ERROR ),
	"ER_ICE_EMM_SET_ERROR!",
}, 
{
	"ER_ICE_EP_PENDING",
	E_ERROR | ( ER_ABI_BASE+ICE_EP_PENDING ),
	"ER_ICE_EP_PENDING!",
}, 
{
	"ER_ICE_REC_TIME_OUT",
	E_ERROR | ( ER_ABI_BASE+ICE_REC_TIME_OUT ),
	"ER_ICE_REC_TIME_OUT!",
}, 
{
	"ER_ICE_INVALID_CPU",
	E_ERROR | ( ER_ABI_BASE+ICE_INVALID_CPU ),
	"ER_ICE_INVALID_CPU!",
}, 
{
	"ER_ICE_MCE16A_FAIL",
	E_ERROR | ( ER_ABI_BASE+ICE_MCE16A_FAIL ),
	"ER_ICE_MCE16A_FAIL!",
}, 
{
	"ER_ICE_EMM_FAIL",
	E_ERROR | ( ER_ABI_BASE+ICE_EMM_FAIL),
	"ER_ICE_EMM_FAIL!",
}, 
{
	"ER_ICE_TRACE_BOARD_FAIL",
	E_ERROR | ( ER_ABI_BASE+ICE_TRACE_BOARD_FAIL ),
	"ER_ICE_TRACE_BOARD_FAIL!",
}, 
{
	"ER_ICE_COV_RBW_FAIL",
	E_ERROR | ( ER_ABI_BASE+ICE_COV_RBW_FAIL ),
	"ER_ICE_COV_RBW_FAIL!",
}, 
{
	"ER_ICE_CPU_FLY",
	E_ERROR | ( ER_ABI_BASE+ICE_CPU_FLY ),
	"ER_ICE_CPU_FLY!",
}, 
{
	"ER_ICE_INVALID_FLY_COMMAND",
	E_ERROR | ( ER_ABI_BASE+ICE_INVALID_FLY_COMMAND ),
	"ER_ICE_INVALID_FLY_COMMAND!",
}, 
{
	"ER_ICE_INVALID_FIRMWARE",
	E_ERROR | ( ER_ABI_BASE+ICE_INVALID_FIRMWARE ),
	"ER_ICE_INVALID_FIRMWARE!",
}, 
{
	"ER_ICE_FLASH_EREASE_FAIL",
	E_ERROR | ( ER_ABI_BASE+ICE_FLASH_EREASE_FAIL ),
	"ER_ICE_FLASH_EREASE_FAIL!",
}, 
{
	"ER_ICE_FLASH_PROG_FAIL",
	E_ERROR | ( ER_ABI_BASE+ICE_FLASH_PROG_FAIL ),
	"ER_ICE_FLASH_PROG_FAIL!",
}, 
{
	"ER_ICE_FLASH_SWITCH_FAIL",
	E_ERROR | ( ER_ABI_BASE+ICE_FLASH_SWITCH_FAIL ),
	"ER_ICE_FLASH_SWITCH_FAIL!",
}, 
{
	"ER_ICE_NO_MATCH",
	E_ERROR | ( ER_ABI_BASE+ICE_NO_MATCH ),
	"ER_ICE_NO_MATCH!",
}, 
{
	"ER_ICE_IDLE",
	E_ERROR | ( ER_ABI_BASE+ICE_IDLE ),
	"ER_ICE_IDLE!",
}, 
{
	"ER_ICE_POWERDOWN",
	E_ERROR | ( ER_ABI_BASE+ICE_POWERDOWN ),
	"ER_ICE_POWERDOWN!",
}, 
{
	"ER_ICE_SLEEPING",
	E_ERROR | ( ER_ABI_BASE+ICE_SLEEPING ),
	"ER_ICE_SLEEPING!",
}, 
{
	"ER_ICE_JED_CHECK_DEVICE_ERROR",
	E_ERROR | ( ER_ABI_BASE+ICE_JED_CHECK_DEVICE_ERROR ),
	"ER_ICE_JED_CHECK_DEVICE_ERROR!",
}, 
{
	"ER_ICE_JED_CHECK_DATA_ERROR",
	E_ERROR | ( ER_ABI_BASE+ICE_JED_CHECK_DATA_ERROR ),
	"ER_ICE_JED_CHECK_DATA_ERROR!",
}, 
{
	"ER_ICE_JED_PROGRAME_VERIFY_ERROR",
	E_ERROR | ( ER_ABI_BASE+ICE_JED_PROGRAME_VERIFY_ERROR ),
	"ER_ICE_JED_PROGRAME_VERIFY_ERROR!",
}, 
//ER_EMU_BASE(0x1800) entry emu##
{
	"ER_EMU_TARGET_CPU_HALT",
	E_ERROR | ( ER_EMU_BASE+1 ),
	"Cpu is Halted!",
}, 
{
	"ER_EMU_PROGRAM_IS_RUN",
	E_ERROR | ( ER_EMU_BASE+2 ),
	"EP Running!",
}, 
{
	"ER_EMU_GOFLY_ERR_MSG",
	E_ERROR | ( ER_EMU_BASE+3 ),
	"Cpu is running!",
}, 
//ER_PRE_BASE(0x2000) entry pre##
{
	"ER_PRE_SEL_REG",
	E_ERROR | (ER_PRE_BASE +1 ),
	"Must select one register at least!"
},
{
	"ER_PRE_REG_VALUE",
	E_ERROR | (ER_PRE_BASE +2 ),
	"Invalid register value."
},
{
	"ER_PRE_REG_NOT_EXIST",
	E_ERROR | (ER_PRE_BASE +3 ),
	"This register does not exist."
},
{
	"ER_PRE_CPU_SETTING",
	E_ERROR | (ER_PRE_BASE +4 ),
	"Can not set cpu type."
},
//ER_DAD_BASE(0x2800) entry dad##
{
	"ER_DAD_ERROR",
	E_ERROR | ( ER_DAD_BASE+1 ),
    "Dad Server Error!"
}, 
//ER_MEM_BASE(0x3000) entry mem##
//ER_SYN_BASE(0x3800) entry syn##
{
	"ER_SYN_BASE",
	E_ERROR | ( ER_SYN_BASE ),
    "base."
}, 
{
	"ER_SYN_BASE3",
	E_ERROR | ( ER_SYN_BASE+3 ),
    "No such command."
}, 
{
	"ER_SYN_BASE4",
	E_ERROR | ( ER_SYN_BASE+4 ),
	"Syntax error."
},
{
	"ER_SYN_BASE5",
	E_ERROR | ( ER_SYN_BASE+5 ),
	"The address is out of range."
},
{
	"ER_SYN_BASE6",
	E_ERROR | ( ER_SYN_BASE+6 ),
	"The length is out of range."
},
{
	"ER_SYN_BASE7",
	E_ERROR | ( ER_SYN_BASE+7 ),
	"The length is invalid."
},
{
	"ER_SYN_BASE8",
	E_ERROR | ( ER_SYN_BASE+8 ),
	"The address include invalid char."
},
{
	"ER_SYN_BASE9",
	E_ERROR | ( ER_SYN_BASE+9 ),
	"The address type is error."
},
{
	"ER_SYN_BASE10",
	E_ERROR | ( ER_SYN_BASE+10 ),
	"Map address boundary error."
},
{
	"ER_SYN_BASE11",
	E_ERROR | ( ER_SYN_BASE+11 ),
	"The map attribute is error."
},
{
	"ER_SYN_BASE12",
	E_ERROR | ( ER_SYN_BASE+12 ),
	"The register name is invalid."
},
{
	"ER_SYN_BASE13",
	E_ERROR | ( ER_SYN_BASE+13 ),
	"The data is out of range."
},
{
	"ER_SYN_BASE14",
	E_ERROR | ( ER_SYN_BASE+14 ),
	"The data is invalid."
}, 
{
	"ER_SYN_BASE15",
	E_ERROR | ( ER_SYN_BASE+15 ),
	"The file name is invalid."
},
{
	"ER_SYN_BASE16",
	E_ERROR | ( ER_SYN_BASE+16 ),
	"The module name is invalid."
},
{
	"ER_SYN_BASE17",
	E_ERROR | ( ER_SYN_BASE+17 ),
	"The variable name is invalid."
},
{
	"ER_SYN_BASE18",
	E_ERROR | ( ER_SYN_BASE+18 ),
	"The symbol name is invalid."
},
{
	"ER_SYN_BASE19",
	E_ERROR | ( ER_SYN_BASE+19 ),
	"The count is invalid."
},
{
	"ER_SYN_BASE20",
	E_ERROR | ( ER_SYN_BASE+20 ),
	"The count is out of range."
},
{
	"ER_SYN_BASE21",
	E_ERROR | ( ER_SYN_BASE+21 ),
	"The port is invalid."
},
{
	"ER_SYN_BASE22",
	E_ERROR | ( ER_SYN_BASE+22 ),
	"The address format is error."
},
{
	"ER_SYN_BASE23",
	E_ERROR | ( ER_SYN_BASE+23 ),
	"The symbol doesn't exist."
},
{
	"ER_SYN_BASE24",
	E_ERROR | ( ER_SYN_BASE+24 ),
	"The second address is less than first."
}, 
{
	"ER_SYN_BASE25",
	E_ERROR | ( ER_SYN_BASE+25 ),
	"The address text string is overflow."
},
{
	"ER_SYN_BASE26",
	E_ERROR | ( ER_SYN_BASE+26 ),
	"The address text string is empty."
},
{
	"ER_SYN_BASE27",
	E_ERROR | ( ER_SYN_BASE+27 ),
	"The status is error."
},
{
	"ER_SYN_BASE28",
	E_ERROR | ( ER_SYN_BASE+28 ),
	"No trace board."
},
//ER_TRC_BASE(0x4000) entry trc##
{
    "ER_TRC_NONEINPUT",
    E_ERROR | ( ER_TRC_BASE+1 ),
    "You Must Input Something!"
},
{
    "ER_TRC_COUNT_ERR",
    E_ERROR | ( ER_TRC_BASE+2 ),
    "Input count error!"
},
{
    "ER_TRC_CONVERTERR",
    E_ERROR | ( ER_TRC_BASE+3 ),
    "Convert value error!"
},
{
    "ER_TRC_PSPACEERR",
    E_ERROR | ( ER_TRC_BASE+4 ),
    "Accept program space only!"
},
{
    "ER_TRC_RANGEERR",
    E_ERROR | ( ER_TRC_BASE+5 ),
    "Memory range error!"
},
{
    "ER_TRC_ADDR_TOOMUCH",
    E_ERROR | ( ER_TRC_BASE+6 ),
    "Too many address input!"
},
{
    "ER_TRC_INPUT_ERR",
    E_ERROR | ( ER_TRC_BASE+7 ),
    "Input error!"
},
//ER_SPA_BASE(0x4800) entry spa##
//ER_TST_BASE(0x5000) entry tst##
//ER_ADR_BASE(0x5800) entry adr##
{
	"ER_ADDR_FORMAT",
	E_ERROR | (ER_ADR_BASE +1 ),
	"The address format is error."
},
{
	"ER_ADDR_INVALID",
	E_ERROR | (ER_ADR_BASE +2 ),
	"The address include invalid char."
},
{
	"ER_ADDR_OUTRANGE",
	E_ERROR | (ER_ADR_BASE +3 ),
	"The address is out of range."
},
{
	"ER_ADDR_SYMBOL",
	E_ERROR | (ER_ADR_BASE +4 ),
	"The symbol is not exist."
},
{
	"ER_ADDR_COMPARE",
	E_ERROR | (ER_ADR_BASE +5 ),
	"Invalid address range."
},
{
	"ER_ADDR_OVERFLOW",
	E_ERROR | (ER_ADR_BASE +6 ),
	"The address is overflow."
},
{
	"ER_ADDR_EMPTY",
	E_ERROR | (ER_ADR_BASE +7 ),
	"The address string is empty."
},
{
	"ER_ADDR_DEFAULT",
	E_ERROR | (ER_ADR_BASE +8 ),
	"The address is error."
},
{
	"ER_ADDR_BANKERROR",
	E_ERROR | (ER_ADR_BASE +9 ),
	"The address bank is error."
},
{
	"ER_ADDR_NOBANK",
	E_ERROR | (ER_ADR_BASE +10 ),
	"The FW not support bank switch."
},
//ER_LDR_BASE(0x6000) entry ldr##
{
	"ER_LDR_MEMORY_ALLOC",
	E_SEVERE | ( ER_LDR_BASE +1 ),
	"Memory alloc failure!",
}, 
{
	"ER_LDR_ABI_MEMORY_READ",
	E_FATAL | ( ER_LDR_BASE +2 ),
	"Memory read failure!"
}, 
{
	"ER_LDR_ABI_MEMORY_WRITE",
	E_FATAL | ( ER_LDR_BASE +3 ),
	"Memory write failure!"
}, 
{
	"ER_LDR_READ_FILE",
	E_ERROR | ( ER_LDR_BASE +4 ),
    "Loader read file error!"
}, 
{
	"ER_LDR_ABORT",
	E_WARNING | ( ER_LDR_BASE +5 ),
	"User abort requested.",
}, 
{
	"ER_LDR_SYM_TYPE",
	E_ERROR | ( ER_LDR_BASE +6 ),
	"Symbol Type Error!",
}, 
{
	"ER_LDR_FILE_FORMAT",
	E_ERROR | ( ER_LDR_BASE +7 ),
    "Load file format error!",
}, 
{
	"ER_LDR_TYPE",
	E_ERROR | ( ER_LDR_BASE +8 ),
    "Error type!",
}, 
{
	"ER_LDR_SCOPE",
	E_ERROR | ( ER_LDR_BASE +9 ),
	"scope error! Current offset in file: 0x%X",
}, 
{
	"ER_LDR_MODULE_FORMAT",
	E_ERROR | ( ER_LDR_BASE +10 ),
	"Module format error !",
}, 
{
	"ER_LDR_BLOCK_INFO",
	E_ERROR | ( ER_LDR_BASE +11 ),
	"Block information error!",
}, 
{
	"ER_LDR_LOAD_MODULE",
	E_ERROR | ( ER_LDR_BASE +12 ),
	"Load module error!",
}, 
{
	"ER_LDR_UBROF_FORMAT",
	E_ERROR | ( ER_LDR_BASE +13 ),
	"Ubrof format error ! Current offset in file: 0x%X",
}, 
{
	"ER_LDR_SYM_SERVER",
	E_SEVERE | ( ER_LDR_BASE +14 ),
	"Symbol Server Failure !",
}, 
{
	"ER_LDR_UNKNOWN",
	E_ERROR | ( ER_LDR_BASE +15 ),
	"Loader Unknown error!"
},
{
	"ER_LDR_BANKSIZE",
	E_ERROR | ( ER_LDR_BASE +16 ),
    "Bank number you specified in file has not been supported by HardWare!"
},
{
	"ER_CODE_NOT_IN_CODESEG",
	E_ERROR | ( ER_LDR_BASE +17 ),
	"Download code not in code segment!"
},
{
	"ER_LDR_FILE_BANK",
	E_ERROR | ( ER_LDR_BASE +18 ),
	"This file contained bank information. Please remove option located to bank area when you load this file!"
},
{
    "ER_LDR_VERSION_FORMAT",
	E_ERROR | ( ER_LDR_BASE +19 ),
    "Version information is not right"
},
{
   "ER_LDR_MODULE_ERRONEOUS",
   E_ERROR | ( ER_LDR_BASE +20 ),
   "Warning: This loader file is invalid"
},
{
   "ER_LDR_LONG_NAME",
	E_ERROR | ( ER_LDR_BASE +21 ),
   "Name of symbol is too long, please redefine!"
},
{
   "ER_LDR_RELOCATE",
    E_ERROR | ( ER_LDR_BASE +22 ),
   "This loader file is not an absolute file"
},
{
   "ER_LDR_NO_BANK",
   E_ERROR | ( ER_LDR_BASE +23 ),
   "Bank switching is not supported by HardWare"
},
{
   "ER_LDR_GET_CPU",
   E_ERROR | ( ER_LDR_BASE +24 ),
   "Error: Can not get cpu status from HardWare!"
},
{
   "ER_LDR_HALT_CPU",
	E_ERROR | ( ER_LDR_BASE +25 ),
   "Error:Can not load file when CPU is running"
},
//ER_SEG_BASE(0x6800) entry seg##
//ER_SYM_BASE(0x7000) entry sym##
//ER_STK_BASE(0x7800) entry stk##
{
	"ER_STK_BASE",
	E_ERROR | ( ER_STK_BASE ),
	"OK"
},
{
	"ER_STK_BASE1",
	E_ERROR | ( ER_STK_BASE + 1 ),
	"Insufficient memory."
},
{
	"ER_STK_BASE2",
	E_ERROR | ( ER_STK_BASE + 2 ),
	"Cannot load bitmap for the variable window."
},
{
	"ER_STK_BASE3",
	E_ERROR | ( ER_STK_BASE + 3 ),
	"Invalid trace back level."
},  
{
	"ER_STK_BASE4",
	E_ERROR | ( ER_STK_BASE + 4 ),
	"Error status."
},
//ER_VAR_BASE(0x8000) entry var##
{
	"ER_VAR_BASE",
	E_ERROR | ( ER_VAR_BASE ),
	"OK"
},
{
	"ER_VAR_BASE1",
	E_ERROR | ( ER_VAR_BASE + 1 ),
	"Insufficient memory."
},
{
	"ER_VAR_BASE2",
	E_ERROR | ( ER_VAR_BASE + 2 ),
	"Cannot load bitmap for the Variable window."
},
{
	"ER_VAR_BASE3",
	E_ERROR | ( ER_VAR_BASE + 3 ),
	"Error status."
},
//ER_INFO_BASE(0x8800) entry info##
//ER_SRC_BASE(0x9000) entry src##
//ER_SHL_BASE(0x9800) entry shl##
//ER_CPU_BASE(0xA000) entry cpu##
//ER_APP_BASE(0xF000) entry app##
{
	"ER_APP_OUTMEMORY",
	E_ERROR | ( ER_APP_BASE+1 ),
	"Out of memory!",
}, 
{
	"ER_APP_ERRLOADFILE",
	E_ERROR | ( ER_APP_BASE+2 ),
	"Cannot loading %s!",
},
{
    "ER_APP_SYNTAXERR",
    E_ERROR | ( ER_APP_BASE+3 ),
    "Syntax Error!",
},

/* - STOP - DO NOT ADD ANY ERROR CODE TO THIS FILE
**
** If you remove any error code form this file please put the error number
** in the list below so that the next person can reuse it.
**
** REUSABLE ERRORCODE:
**
**
*/

/***************************** EOF *****************************************/
#endif
