/***************************************************************************
**
**    $Header$
**
**    $Log$
** 
****************************************************************************/

/****************************************************************************
**
**  Name:  mkerrs.h
**
**  Description:
**     Contains declarations for MKERRORS.EXE
**
**  Date:	3/26/96		by: Jamoon
**
**  Copyright (C) 1996 Microtek International.  All rights reserved.
**
*****************************************************************************/
#ifndef _MKERRS_
#define _MKERRS_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#include <stdio.h>

#include "basictyp.h"


                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

#define ER_ICE_OK		0x1000
#define ER_ABI_BASE		0x1000
#define ER_EMU_BASE		0x1800
#define ER_PRE_BASE		0x2000
#define ER_DAD_BASE		0x2800
#define ER_MEM_BASE		0x3000
#define ER_SYN_BASE		0x3800
#define ER_TRC_BASE		0x4000
#define ER_SPA_BASE		0x4800
#define ER_TST_BASE		0x5000
#define ER_ADR_BASE		0x5800
#define ER_LDR_BASE		0x6000
#define ER_SEG_BASE		0x6800 
#define ER_SYM_BASE		0x7000
#define ER_STK_BASE		0x7800
#define ER_VAR_BASE		0x8000
#define ER_INFO_BASE	0x8800
#define ER_SRC_BASE		0x9000
#define ER_SHL_BASE		0x9800
#define ER_CPU_BASE		0xA000
#define ER_APP_BASE		0xF000

/*
 * LOCKED means that you can't change the error code, even if changeCodes
 * is true.
 */
#define LOCKED       1
#define UNLOCKED     2

#define ER_RC_BASE   500
#define ER_HELP_BASE 3000
#define BAD          (GOOD + 666)
#define MAX_ERRORS   4096

typedef struct {
   CHAR *name;
   U32  code;
   CHAR *text;
//   CHAR *helpentry;
//   U8   flags; /* only LOCKED/UNLOCKED so far */
} ErrorDef;

typedef ErrorDef * ErrorDefPtr;

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

RETCODE Regen_mkerrs_h(VOID);
RETCODE CopyHeader(FILE *fp, char *HeaderFile);
RETCODE Regen_errcodec_h(VOID);
RETCODE Regen_errcodea_h(VOID);
RETCODE Regen_errerr_h(VOID);
RETCODE Regen_errtext_rc(VOID);

U32 SizeErrArray(VOID);
U32 SizeErrArray1(VOID);
U32 SizeErrArray2(VOID);
U32 SizeErrArray3(VOID);


#endif /* _MKERRS_ */
/******************************** E O F *************************************/
