// flttool.cpp : implementation file
//

#include "stdafx.h"
#include "ep196.h"
#include "afxpriv.h"
#include "flttool.h"
#include "tipwnd.h"

// Added by Chen, 01/13/97
#include "srcdef.h"


#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif
         
struct AFX_TIP_DATA
{
   CFont  g_Font;
   CBrush g_Brush;
};
         
static AFX_TIP_DATA afxdata;
#define BORDER_ANY     0x0F00
#define BORDER_LEFT    0x0100
#define BORDER_TOP     0x0200
#define BORDER_RIGHT   0x0400
#define BORDER_BOTTOM  0x0800                   
#define CX_BORDER      1
#define CY_BORDER      1

/////////////////////////////////////////////////////////////////////////////
// CFloatToolBar

CFloatToolBar::CFloatToolBar()
{          
	m_bCanMove = 0;	 
    m_pTip=0; 
    m_nDelayTime=15;
    m_nTimeCount=0;   
    m_bSetTimer=0;   
    m_isCmbSrch=0;
	
}

CFloatToolBar::~CFloatToolBar()
{
}

inline AFX_TBBUTTON* CFloatToolBar::GetButtonPtr(int nIndex) const
{
	ASSERT(nIndex >= 0 && nIndex < m_nCount);
	ASSERT(m_pData != NULL);
	return ((AFX_TBBUTTON*)m_pData) + nIndex;
}

BEGIN_MESSAGE_MAP(CFloatToolBar, CToolBar)
	//{{AFX_MSG_MAP(CFloatToolBar)
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_TIMER()
	ON_WM_CREATE()
	ON_WM_DESTROY()
	ON_WM_PAINT()
	ON_WM_RBUTTONDOWN()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFloatToolBar message handlers

void CFloatToolBar::FilterTipMessage(MSG *pMsg)
{    
    static CPoint point;
    static HWND   hWnd=0;
                               
 	if(pMsg->message==WM_MOUSEMOVE||pMsg->message==WM_NCMOUSEMOVE) {    
		if ( (m_iButtonCapture < 0) && m_bCanMove ) {
		    CRect ClientRect;
		    CPoint Offset,pointT = pMsg->pt; 
		    GetParent()->ScreenToClient(&pointT);
	        GetParent()->GetClientRect(&ClientRect);
		    int width  = ClientRect.Width()/4;
		    int height = ClientRect.Height()/2;
	        CRect rectH(0,0,30000,22);
	        CRect rectV(0,0,22,30000);
	        DrawFrame(m_WinRect);
	        if(pointT.x < width) { 
		   		if(m_WinRect.Width()>m_WinRect.Height()) 
			    	m_WinRect = rectV + pointT;
			}  
			else if(pointT.x > 3*width) {                
				if(m_WinRect.Width()>m_WinRect.Height())
			    	m_WinRect = rectV + pointT;
			}
			else if(pointT.y > height) {
			    if(m_WinRect.Width()<m_WinRect.Height())
			        m_WinRect = rectH + pointT;		       
			} 
			else if(pointT.y<height) {
			    if(m_WinRect.Width()<m_WinRect.Height())
			  	    m_WinRect = rectH + pointT;  
			}  	     
		    Offset.y = pointT.y-m_LBDPoint.y;
		    Offset.x = pointT.x-m_LBDPoint.x;
	        m_LBDPoint.x += Offset.x;
	        m_LBDPoint.y += Offset.y;
			
		    m_WinRect += Offset; 
		    m_LBDPoint = pointT;
		    DrawFrame(m_WinRect);
		}
      	if(pMsg->hwnd==GetSafeHwnd()) { 	                                   	      		
      		if(!m_bSetTimer ) {              
		        m_bSetTimer=1;  
		        m_nDelayTime=15;
		        SetTimer(m_TimerID,55,NULL);
   	        } 
	    	else {
	        	if( (pMsg->hwnd!=hWnd)&&(point.x!=pMsg->pt.x||point.y!=pMsg->pt.y) ) {
		            hWnd=pMsg->hwnd;
		            point=pMsg->pt;
		            ReleaseTip();
			    }    
	    	}  
	  	}
	}  	
  	else if(pMsg->message==WM_KEYDOWN||
          pMsg->message==WM_SYSKEYDOWN||
          pMsg->message==WM_LBUTTONDOWN||
          pMsg->message==WM_MBUTTONDOWN||
          pMsg->message==WM_RBUTTONDOWN||
          pMsg->message==WM_LBUTTONUP||
          pMsg->message==WM_MBUTTONUP||
          pMsg->message==WM_RBUTTONUP) {        
          ReleaseTip();  
    }        
}


void CFloatToolBar::OnLButtonDown(UINT nFlags, CPoint point)
{
	// TODO: Add your message handler code here and/or call default
	if ( FloatHitTest(point) < 0 ) {	                    
	    SetCapture();
		GetWindowRect(&m_WinRect);  
		GetParent()->ScreenToClient(&m_WinRect);
		CRect rect;
		GetParent()->GetClientRect(&rect);
		m_LBDPoint = point;
	    ClientToScreen(&m_LBDPoint);
		GetParent()->ScreenToClient(&m_LBDPoint);
	
	    m_bCanMove = 1;
	    DrawFrame(m_WinRect);
	}

	if ((m_iButtonCapture = FloatHitTest(point)) < 0)
		return;     // nothing hit
	AFX_TBBUTTON* pTBB = GetButtonPtr(m_iButtonCapture);
	ASSERT( (!(pTBB->nStyle & TBBS_SEPARATOR)|pTBB->nID==IDC_SERCOMBO));
    if(pTBB->nID==IDC_SERCOMBO) return;
	if (pTBB->nStyle & TBBS_DISABLED)
	{
		m_iButtonCapture = -1;
		return;     // don't press it
	}

	SetCapture();
	pTBB->nStyle |= TBBS_PRESSED;
	FloatInvalidateButton(m_iButtonCapture);
	UpdateWindow(); // immediate feedback

	//GetOwner()->SendMessage(WM_SETMESSAGESTRING, (WPARAM)pTBB->nID);

	CToolBar::OnLButtonDown(nFlags, point);
}
    
void CFloatToolBar::OnLButtonUp(UINT nFlags, CPoint point)
{
	// TODO: Add your message handler code here and/or call default 
	if ( m_bCanMove ) {
		if(!FloatHitTest(point)) { 
			ReleaseCapture();
		}
		else { 
			CRect ClientRect;
			GetParent()->GetClientRect(&ClientRect);
			DrawFrame(m_WinRect);
			int width = ClientRect.Width()/4;
			int height = ClientRect.Height()/2;
		    CPoint pointT = point; 
		    GetParent()->GetClientRect(&ClientRect); 
		    ClientToScreen(&pointT);
		    GetParent()->ScreenToClient(&pointT);
	
			if(pointT.x<width) 
				SetPos(CBRS_LEFT);
			else if(pointT.x>3*width) 
				SetPos(CBRS_RIGHT);
			else if(pointT.y>height) 
				SetPos(CBRS_BOTTOM);
			else if(pointT.y<height) 
				SetPos(CBRS_TOP);
	
			ReleaseCapture();
			m_bCanMove=0;  
		}	
	}	                

	m_iButtonCapture = FloatHitTest(point);     
	if ( m_iButtonCapture < 0) {               
		//SendMessage(WM_RBUTTONDOWN, NULL, NULL);
		return;     // not captured 
	}	
	AFX_TBBUTTON* pTBB = GetButtonPtr(m_iButtonCapture);
    if(pTBB->nID==IDC_SERCOMBO) return;
	ASSERT(!(pTBB->nStyle & TBBS_SEPARATOR));
	UINT nIDCmd = 0;

	UINT nNewStyle = (pTBB->nStyle & ~TBBS_PRESSED);
	if (GetCapture() == this) {
		// we did not lose the capture
		ReleaseCapture();
		if (FloatHitTest(point) == m_iButtonCapture &&
		  !(pTBB->nStyle & TBBS_DISABLED)) {
			// pressed, will send command notification
			nIDCmd = pTBB->nID;

			if (pTBB->nStyle & TBBS_CHECKBOX) {
				// auto check: three state => down
				if (nNewStyle & TBBS_INDETERMINATE)
					nNewStyle &= ~TBBS_INDETERMINATE;

				nNewStyle ^= TBBS_CHECKED;
			}
		}
	}

	_SetButtonStyle(m_iButtonCapture, nNewStyle);
	m_iButtonCapture = -1;
	UpdateWindow(); // immediate feedback

	// first flush the drag mode
	//GetOwner()->SendMessage(WM_SETMESSAGESTRING, (WPARAM)AFX_IDS_IDLEMESSAGE);

	if (nIDCmd != 0)
		GetOwner()->SendMessage(WM_COMMAND, nIDCmd);    // send command

	CToolBar::OnLButtonUp(nFlags, point);   
}               

void CFloatToolBar::OnTimer(UINT nIDEvent)
{
	// TODO: Add your message handler code here and/or call default
    CPoint point;
    GetCursorPos(&point);  
	ScreenToClient(&point);
	int nHit;           
	                                                                
	if(nIDEvent == m_TimerID) {
		if((nHit=HitTipTest(point))==HITTYPE_TIP_SUCCESS)  {
			m_nTimeCount++;
      		if(m_nTimeCount>=m_nDelayTime) {    
                TipProcess(point);
            }    
		}
		else {
        	ReleaseTip();  
      		if(nHit!=HITTYPE_TIP_NOTHING) {
         		KillTimer(m_TimerID);
         		m_bSetTimer=0;
      		}   
    	}    
	}                                                                        
	
	CToolBar::OnTimer(nIDEvent);
}

int CFloatToolBar::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CToolBar::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	// TODO: Add your specialized creation code here
    LOGFONT logFont;
    _fmemset(&logFont,0,sizeof(LOGFONT));
    logFont.lfHeight=14;
    logFont.lfWidth=7;
    logFont.lfWeight=100;
    lstrcpy(logFont.lfFaceName,"System");//"Arail");
                                                  
    CRect rect(0,0,0,0);                                              
	m_pTip = new CTipWnd();
    ((CTipWnd *)m_pTip)->CreateTipWnd(NULL);

	SetBackColor(RGB(255,255,128));
    SetTipFont(&logFont);
	return 0;

}

void CFloatToolBar::OnPaint()
{
	CPaintDC dc(this); // device context for painting
	
	// TODO: Add your message handler code here
	CFloatToolBar::DoPaint(&dc);

	// Do not call CToolBar::OnPaint() for painting messages
}

void CFloatToolBar::OnRButtonDown(UINT nFlags, CPoint point)
{
	// TODO: Add your message handler code here and/or call default
	Invalidate();
	UpdateWindow();
	
	CToolBar::OnRButtonDown(nFlags, point);
}

void CFloatToolBar::OnDestroy()
{
	CToolBar::OnDestroy();
	
	// TODO: Add your message handler code here
    if(m_bSetTimer)
      KillTimer(m_TimerID);                
	m_pTip->DestroyWindow();
	delete m_pTip;
    if(afxdata.g_Brush.GetSafeHandle())
       afxdata.g_Brush.DeleteObject();
    if(afxdata.g_Font.GetSafeHandle())
       afxdata.g_Font.DeleteObject();           
	
}

    
void CFloatToolBar::DrawFrame(CRect WinRect)
{                           
	CDC *pDC;                    
	pDC=GetParent()->GetDC();
	pDC->DrawFocusRect(&WinRect);
    GetParent()->ReleaseDC(pDC);
}    
    
                 
int CFloatToolBar::FloatHitTest(CPoint point) // in window relative coords
{
	CRect rect,Client;
	rect.SetRectEmpty();        // only need top and left
	FloatCalcInsideRect(rect); 
	
	DWORD dwStyle=GetStyle();
	if( dwStyle&CBRS_TOP) {
	   if (point.y < rect.top || point.y >= rect.top + m_sizeButton.cy)
	  	  return -1; 	// no Y hit
	}      
    else if(dwStyle&CBRS_LEFT) {
       if (point.x < rect.left || point.x >= rect.left + m_sizeButton.cx)
	  	  return -1;
	}
	else if(dwStyle&CBRS_BOTTOM) {  	        // no Y hit                                    
	   GetClientRect(&Client);
	   if (point.y > Client.bottom-rect.bottom || point.y <= rect.bottom )
	  	  return -1;
	} 	  
	else if(dwStyle&CBRS_RIGHT) { 
	   GetClientRect(&Client); 	        // no Y hit                                    
	   if (point.x > Client.right-rect.right || point.x <= rect.right )
	  	  return -1;
	} 	    	  
	AFX_TBBUTTON* pTBB = (AFX_TBBUTTON*)m_pData;
	ASSERT(pTBB != NULL);
	for (int iButton = 0; iButton < m_nCount; iButton++, pTBB++) {
		if( dwStyle&CBRS_TOP||dwStyle&CBRS_BOTTOM) {
			if (point.x < rect.left)	
				break;     // missed it
		} 
    	else if(dwStyle&CBRS_LEFT||dwStyle&CBRS_RIGHT) {
       		if (point.y < rect.top)	
       			break;         
       	}// missed it
				
    	if( dwStyle&CBRS_TOP||dwStyle&CBRS_BOTTOM) {	
			rect.left += (pTBB->nStyle & TBBS_SEPARATOR) ?
							pTBB->iImage : m_sizeButton.cx;
							
			rect.left--;    // go back one for overlap
			if (point.x <= rect.left && ((!(pTBB->nStyle & TBBS_SEPARATOR) )|pTBB->nID==IDC_SERCOMBO))
				return iButton;     // hit !
        }
    	else if(dwStyle&CBRS_LEFT||dwStyle&CBRS_RIGHT) {	
    		rect.top += (pTBB->nStyle & TBBS_SEPARATOR) ?
							pTBB->iImage : m_sizeButton.cy;
			rect.top--;    // go back one for overlap
			if (point.y <= rect.top && !(pTBB->nStyle & TBBS_SEPARATOR))
				return iButton;     // hit !
        }               
	}
	return -1;      // nothing hit
}                                          
                        
void CFloatToolBar::FloatInvalidateButton(int nIndex)
{
	ASSERT_VALID(this);
	CRect rect;
	FloatGetItemRect(nIndex,&rect);
	InvalidateRect(rect,FALSE);
}              

void CFloatToolBar::FloatGetItemRect(int nIndex, LPRECT lpRect)
{
	ASSERT_VALID(this);
	ASSERT(nIndex >= 0 && nIndex < m_nCount);
	ASSERT(AfxIsValidAddress(lpRect, sizeof(RECT)));

	CRect rect;
	rect.SetRectEmpty();        // only need top and left
	CalcInsideRect(rect);
	DWORD dwStyle=GetStyle();
	AFX_TBBUTTON* pTBB = (AFX_TBBUTTON*)m_pData;
	for (int iButton = 0; iButton < nIndex; iButton++, pTBB++) {
		ASSERT(pTBB != NULL);                        
		// skip this button or separator
		if(dwStyle&CBRS_TOP||dwStyle&CBRS_BOTTOM) {
			if(pTBB->nID==IDC_SERCOMBO)
			   rect.left+=pTBB->iImage;
			else   
			   rect.left += (pTBB->nStyle & TBBS_SEPARATOR) ?
							pTBB->iImage : m_sizeButton.cx;
							
			rect.left--;    // go back one for overlap
		}
		else {
		    rect.top+= (pTBB->nStyle & TBBS_SEPARATOR) ?
							pTBB->iImage : m_sizeButton.cy;
			rect.top--;    // go back one for overlap    
		}					
	}
	ASSERT(iButton == nIndex);
	ASSERT(pTBB == GetButtonPtr(nIndex));
                             
    if(dwStyle&CBRS_TOP||dwStyle&CBRS_BOTTOM) {
		// button or image width
		int cx = (pTBB->nStyle & TBBS_SEPARATOR) ? pTBB->iImage : m_sizeButton.cx;
		if(pTBB->nID==IDC_SERCOMBO) cx=pTBB->iImage;
		lpRect->right = (lpRect->left = rect.left) + cx;
		lpRect->bottom = (lpRect->top = rect.top) + m_sizeButton.cy;
	}
	else {
		int cy = (pTBB->nStyle & TBBS_SEPARATOR) ? pTBB->iImage : m_sizeButton.cy;
		lpRect->bottom = (lpRect->top = rect.top) + cy;
		lpRect->right = (lpRect->left = rect.left) + m_sizeButton.cx;
    }
}
                                        

void CFloatToolBar::_SetButtonStyle(int  nIndex,UINT nStyle)
{
	AFX_TBBUTTON* pTBB = GetButtonPtr(nIndex);
	if (pTBB->nStyle != nStyle) {
		// change the style and invalidate
		pTBB->nStyle = nStyle;
		FloatInvalidateButton(nIndex);
	}
}     

void CFloatToolBar::TipProcess(CPoint point)
{    
  	if(m_OldBtnID==m_BtnID && m_pTip->IsWindowVisible())   
     	return;
  	else {    
    	if(m_OldBtnID==m_BtnID) 
       		return;
    	m_OldBtnID=m_BtnID;
  	}   
    
    ClientToScreen(&point); 
  	ShowTipCard(m_BtnID,point);   
} 
           
void CFloatToolBar::ShowTipCard(UINT ID,POINT point)  
{    
	POINT p;
    CRect rect;
    GetWindowRect(&rect);
    GetCursorPos(&p);
    //if(!rect.PtInRect(p))
    //   return;
                                                      
    //if(::GetActiveWindow()!=AfxGetApp()->m_pMainWnd->m_hWnd || ID==0) 
      //return;

    CString string;
    CString stringText;

    if(string.LoadString(ID)) { 
    	int nIdx=string.Find('\n');  
        if(nIdx>=0)
        	stringText=string.Mid(0,nIdx);
        else
            return;
         
        CStatusBar *pWnd=(CStatusBar *)AfxGetApp()->m_pMainWnd->
                        GetDescendantWindow(AFX_IDW_STATUS_BAR);
        if(pWnd && stringText.GetLength())
        	pWnd->SetWindowText((const char *)stringText);
     
        if(nIdx>=0) {           
            stringText=string.Mid(nIdx+1,string.GetLength()-nIdx);
            if(stringText.GetLength())
            	DrawContent(stringText,point); 
            else
                return;
        } 
    }  
}  

void CFloatToolBar::DrawContent(LPCSTR lpText,POINT point)
{                  
  
	ASSERT_VALID(this);
    ASSERT_VALID(m_pTip);
    CClientDC dc(m_pTip);
    CFont     font;   

    dc.SelectObject(&afxdata.g_Font);  
    int nWidth=dc.GetTextExtent(lpText,lstrlen(lpText)).cx+15;
    int nHeight=dc.GetTextExtent(lpText,lstrlen(lpText)).cy+4;

    CRect rect,rectWin;
    GetWindowRect(&rect);
    GetParent()->GetWindowRect(&rectWin);
        
  	int x = 0;
  	int y = 0;      
  	CRect rectTip,rectFrame,rcToolBar;
  	GetWindowRect(&rcToolBar);
  	GetParent()->GetClientRect(&rectFrame);
  
  	if(rcToolBar.Width()>=rcToolBar.Height()) {
  		//if(rectFrame.Height()/2>rcToolBar.top) {
  	 		x = point.x-(nWidth+1)/2;
  	 		y = rcToolBar.bottom+2;
  	 	/*
  	 	}
  	  	else {
	  	 	x = point.x-(nWidth+1)/2;
	  	 	y = rcToolBar.top-nHeight-2;
	  	}*/
  	 
  	}                   
	else {
		if(rectFrame.Width()/2>rcToolBar.left) {
	  	 	x = rcToolBar.right+2;
	  	 	y = point.y;
	  	}
	  	else {
	  	 	x = rcToolBar.left-nWidth-2;
	  	 	y = point.y;
	  	}
	} 
  
  	rectTip.SetRect(x,y,x+nWidth,y+nHeight);

  	m_pTip->SetWindowText(lpText);
  	m_pTip->SetWindowPos(NULL,//&wndTopMost,
                       x<0?0:x,y,
                       nWidth,
                       nHeight,
                       SWP_SHOWWINDOW|SWP_NOACTIVATE|SWP_NOZORDER);

}
                          

void CFloatToolBar::SetBackColor(COLORREF colorRef)
{                               
	if(afxdata.g_Brush.GetSafeHandle())
    	afxdata.g_Brush.DeleteObject();

  	afxdata.g_Brush.CreateSolidBrush(colorRef);   
}
              
void CFloatToolBar::SetTipFont(LOGFONT *logFont)
{                                    
  	if(afxdata.g_Font.GetSafeHandle()&&logFont)
    	afxdata.g_Font.DeleteObject();           
  	if(logFont)                           
    	afxdata.g_Font.CreateFontIndirect(logFont);

}                 
              
void CFloatToolBar::ReleaseTip(void)
{       
  	CPoint point;
  	GetCursorPos(&point);

  	if(::WindowFromPoint(point)!=m_hWnd)
		m_OldBtnID=0;
  	m_nTimeCount=0;
  
  	if(m_pTip)
    	if(m_pTip->IsWindowVisible())
       		m_pTip->ShowWindow(SW_HIDE);
	 
  	CWnd *pWnd=(AfxGetApp()->m_pMainWnd)->GetDlgItem(AFX_IDW_STATUS_BAR);
  	if(pWnd)
    	pWnd->SetWindowText(" ");
}   

int CFloatToolBar::HitTipTest(CPoint point/*client postion*/)
{
  	m_BtnID=(UINT)-1;
    
  	if(GetActiveWindow()!=AfxGetApp()->m_pMainWnd)
   	 	return HITTYPE_TIP_INACTIVE;
/*
  	CWnd* pParent = GetTopLevelParent();
  	if(!pParent->IsWindowEnabled())
 	 	return HITTYPE_TIP_DISABLED;
*/  
    CPoint point1;
    point1 = point;

	ClientToScreen(&point1);      
  	HWND hWnd = ::WindowFromPoint(point1);
  	if(hWnd == NULL || (hWnd != m_hWnd && !::IsChild(m_hWnd, hWnd)))
   	 	return HITTYPE_TIP_OUTSIDE;
	   
  	int nHit=FloatHitTest(point);
  	if(nHit >= 0) {
    	AFX_TBBUTTON* pTBB = GetButtonPtr(nHit);
    	m_BtnID= pTBB->nID;    
    	if(m_BtnID!=ID_SEPARATOR)
      		return HITTYPE_TIP_SUCCESS;
  	}  

   	return HITTYPE_TIP_NOTHING;
	// finally do the hit test on the items within the control bar
}        

BOOL CFloatToolBar::SetPos(DWORD wPos)
{                       
	ASSERT(wPos&(CBRS_LEFT|CBRS_TOP|CBRS_RIGHT|CBRS_BOTTOM));
	DWORD dwStyle;
	dwStyle=::GetWindowLong(m_hWnd,  GWL_STYLE	);
    if(dwStyle&wPos) return 0;
    else {
		m_cxLeftBorder=(wPos&(CBRS_LEFT|CBRS_RIGHT))?1:8;
		m_cyTopBorder=(wPos&(CBRS_LEFT|CBRS_RIGHT))?8:1;
		m_cyBottomBorder=(wPos&(CBRS_LEFT|CBRS_RIGHT))?8:1;
	
		dwStyle=dwStyle&~CBRS_TOP&~CBRS_BOTTOM&~CBRS_RIGHT&~CBRS_LEFT;
		dwStyle=dwStyle|wPos;                                    
		SetWindowLong(m_hWnd,  GWL_STYLE,dwStyle);
		CRect rect;
		rect.SetRectEmpty();
		FloatCalcInsideRect(rect); 
		if(wPos&(CBRS_LEFT|CBRS_RIGHT) ) {
			m_sizeFixedLayout.cx=m_sizeButton.cx-rect.Width();
			m_sizeFixedLayout.cy=32767;
			
		}
		else { 
			m_sizeFixedLayout.cy=m_sizeButton.cy-rect.Height();
			m_sizeFixedLayout.cx=32767;
        }
        UpdateToolbar(m_nActiveWinID);
        GetParent()->SendMessage(WM_SIZE,SIZE_RESTORED,MAKELONG(1,1) );
		Invalidate();
		UpdateWindow();
		return 1;
	}
}                                        

// input CRect should be client rectangle size
void CFloatToolBar::FloatCalcInsideRect(CRect& rect) 
{
	ASSERT_VALID(this);
	DWORD dwStyle = GetStyle();

	// adjust for border size
	if (dwStyle & BORDER_LEFT)
		rect.left += CX_BORDER;
	if (dwStyle & BORDER_TOP)
		rect.top += CY_BORDER;
	if (dwStyle & BORDER_RIGHT)
		rect.right -= CX_BORDER;
	if (dwStyle & BORDER_BOTTOM)
		rect.bottom -= CY_BORDER;

	// inset the top and bottom.
	if(dwStyle&CBRS_TOP) {
		rect.left += m_cxLeftBorder;
		rect.top += m_cyTopBorder;
		rect.bottom -= m_cyBottomBorder;
	}
	else if(dwStyle&CBRS_LEFT) {	 
	    rect.right -= m_cxLeftBorder;
		rect.top += m_cyTopBorder;
		rect.left+=m_cxLeftBorder;
	}	
    else if(dwStyle&CBRS_BOTTOM) {	 
	    rect.bottom -= m_cyBottomBorder+1;
		rect.top -= m_cyTopBorder;
		rect.left+=m_cxLeftBorder;
	}                          
	else if(dwStyle&CBRS_RIGHT) {	 
	    rect.right-= m_cxLeftBorder+1;
		rect.top += m_cyTopBorder;
		rect.left-=m_cxLeftBorder;
	}
}
                 
void CFloatToolBar::DoPaint(CDC* pDC) 
{
	ASSERT_VALID(this);
	ASSERT_VALID(pDC);

	//CControlBar::DoPaint(pDC);      // draw border
	CToolBar::DoPaint(pDC);      // draw border
	CRect rect;
	GetClientRect(&rect);
	FloatCalcInsideRect(rect);
	// force the full size of the button
	DWORD dwStyle=GetStyle();
	if(dwStyle&CBRS_TOP)
		rect.bottom = rect.top + m_sizeButton.cy;
    else if(dwStyle&CBRS_LEFT)
        rect.right=rect.left+ m_sizeButton.cx;
    else if(dwStyle&CBRS_BOTTOM)
        rect.top=rect.bottom-m_sizeButton.cy+2;
    else rect.left=rect.right-m_sizeButton.cx+2;        
        
	DrawState ds;
	if (!PrepareDrawButton(ds))
		return;   
	AFX_TBBUTTON* pTBB = (AFX_TBBUTTON*)m_pData;
	for (int iButton = 0; iButton < m_nCount; iButton++, pTBB++) {
		ASSERT(pTBB != NULL);
		if (pTBB->nStyle & TBBS_SEPARATOR) {
			// separator
  			if(dwStyle&CBRS_TOP)
				rect.right = rect.left + pTBB->iImage;
    		else if(dwStyle&CBRS_LEFT)
        		rect.bottom=rect.top+ pTBB->iImage;
    		else if(dwStyle&CBRS_BOTTOM)
        		rect.right = rect.left + pTBB->iImage;
    		else rect.bottom=rect.top+ pTBB->iImage; 			
		}
		else {   
		    if(dwStyle&CBRS_TOP)
				rect.right = rect.left + m_sizeButton.cx;
    		else if(dwStyle&CBRS_LEFT)
        		rect.bottom=rect.top+ m_sizeButton.cy;
    		else if(dwStyle&CBRS_BOTTOM)
        		rect.right = rect.left + m_sizeButton.cx;
    		else if (dwStyle&CBRS_RIGHT)
    			rect.bottom=rect.top+ m_sizeButton.cy;
			
//			if (::RectVisible(pDC->m_hDC, &rect)) {
				int n= pTBB->nStyle;
				int n1 = pTBB->iImage;                  
				DrawButton(pDC->m_hDC, rect.left, rect.top,
					pTBB->iImage, pTBB->nStyle);  				
//			}
		}
		// adjust for overlap
		if(dwStyle&CBRS_TOP||dwStyle&CBRS_BOTTOM)
		    rect.left = rect.right - 1;
		else 
			rect.top = rect.bottom - 1;   
	}
	EndDrawButton(ds);
}   
                                 
void CFloatToolBar::AddMainToolButton(void)  
{   
	int i = 0;
    
    if ( SetButtons(NULL, 20) ) {        
        SetButtonInfo(i++, ID_FILE_BROWSEMODULE, TBBS_BUTTON, BTN_MODULE);        
        SetButtonInfo(i++, ID_FILE_LOAD, TBBS_BUTTON, BTN_LOAD);
        SetButtonInfo(i++, ID_SEPARATOR, TBBS_SEPARATOR, 6);

        SetButtonInfo(i++, ID_OPTIONS_MAP, TBBS_BUTTON, BTN_MAP);
        SetButtonInfo(i++, ID_SEPARATOR, TBBS_SEPARATOR, 6);

        SetButtonInfo(i++, ID_RUN_RESET, TBBS_BUTTON, BTN_RESET);
        SetButtonInfo(i++, ID_RUN_RESTART, TBBS_BUTTON, BTN_RESTART );        
        SetButtonInfo(i++, ID_RUN_BREAKPOINT, TBBS_BUTTON, BTN_BP);
        SetButtonInfo(i++, ID_RUN_GO, TBBS_BUTTON, BTN_GO);
        SetButtonInfo(i++, ID_RUN_GORUN, TBBS_BUTTON, BTN_GORUN);
        SetButtonInfo(i++, ID_RUN_HALT, TBBS_BUTTON, BTN_HALT);
        SetButtonInfo(i++, ID_SEPARATOR, TBBS_SEPARATOR, 6);

        SetButtonInfo(i++, ID_RUN_STEPINTO, TBBS_BUTTON, BTN_STEPINTO);
        SetButtonInfo(i++, ID_RUN_STEPOVER, TBBS_BUTTON, BTN_STEPOVER);
        SetButtonInfo(i++, ID_RUN_STEPOUT, TBBS_BUTTON, BTN_STEPOUT);
        SetButtonInfo(i++, ID_SEPARATOR, TBBS_SEPARATOR, 6);
        
        SetButtonInfo(i++, ID_GOTO_SHELL, TBBS_BUTTON, BTN_SHELL);
        SetButtonInfo(i++, ID_TOGGLE_TRACE, TBBS_BUTTON, BTN_TRACE_TOGGLE);
        SetButtonInfo(i++, ID_SEPARATOR, TBBS_SEPARATOR, 6);
        SetButtonInfo(i++, ID_HELP_INDEX, TBBS_BUTTON, BTN_HELP);
    }

}                               
                                 
void CFloatToolBar::NewMain(void)
{
    // Update the tool bar buttons.    
	AddMainToolButton();
	Invalidate();
	m_nActiveWinID = WID_MAIN;
}                

void CFloatToolBar::NewSource(void)
{                            
    DWORD dwStyle=GetStyle();
	int i = 0;
    // Update the tool bar buttons.
    if ( SetButtons(NULL, 31) ) {
        SetButtonInfo(i++, ID_FILE_BROWSEMODULE, TBBS_BUTTON, BTN_MODULE);        
		SetButtonInfo(i++, ID_FILE_PREVMODULE, TBBS_BUTTON, BTN_PREV_MODULE); 
		SetButtonInfo(i++, ID_FILE_NEXTMODULE, TBBS_BUTTON, BTN_NEXT_MODULE);
		SetButtonInfo(i++, ID_SEPARATOR, TBBS_SEPARATOR, 6);
        SetButtonInfo(i++, ID_FILE_LOAD, TBBS_BUTTON, BTN_LOAD);
		SetButtonInfo(i++, ID_SEPARATOR, TBBS_SEPARATOR, 6);
	    if(dwStyle&(CBRS_LEFT|CBRS_RIGHT)) {		                  
	    //no search combo box
	        SetButtonInfo(i++, ID_SEPARATOR, TBBS_SEPARATOR, 6);
	    }    
	    else {
	      	SetButtonInfo(i, IDC_SERCOMBO, TBBS_SEPARATOR, 100);
	      	AddSourceCombo(i++);
	    }  	
        SetButtonInfo(i++, ID_SEPARATOR, TBBS_SEPARATOR, 6);
		SetButtonInfo(i++, ID_EDIT_SEARCHNEXT, TBBS_BUTTON, BTN_SEARCH_NEXT);
		SetButtonInfo(i++, ID_SEPARATOR, TBBS_SEPARATOR, 6);
		SetButtonInfo(i++, ID_VIEW_SOURCE, TBBS_BUTTON, BTN_SRC_MODE);
		SetButtonInfo(i++, ID_VIEW_MIXED, TBBS_BUTTON, BTN_MIX_MODE );		    
		SetButtonInfo(i++, ID_VIEW_ASSEMBLE, TBBS_BUTTON, BTN_ASSEMBLE );		
		SetButtonInfo(i++, ID_SEPARATOR, TBBS_SEPARATOR, 6);
        SetButtonInfo(i++, ID_OPTIONS_MAP, TBBS_BUTTON, BTN_MAP);
        SetButtonInfo(i++, ID_SEPARATOR, TBBS_SEPARATOR, 6);
        SetButtonInfo(i++, ID_RUN_RESET, TBBS_BUTTON, BTN_RESET);
        SetButtonInfo(i++, ID_RUN_RESTART, TBBS_BUTTON, BTN_RESTART );        
        SetButtonInfo(i++, ID_RUN_BREAKPOINT, TBBS_BUTTON, BTN_BP);           
        SetButtonInfo(i++, ID_RUN_GO, TBBS_BUTTON, BTN_GO);
        SetButtonInfo(i++, ID_RUN_GORUN, TBBS_BUTTON, BTN_GORUN);
        SetButtonInfo(i++, ID_RUN_HALT, TBBS_BUTTON, BTN_HALT);
        SetButtonInfo(i++, ID_SEPARATOR, TBBS_SEPARATOR, 6);
        SetButtonInfo(i++, ID_RUN_STEPINTO, TBBS_BUTTON, BTN_STEPINTO);
        SetButtonInfo(i++, ID_RUN_STEPOVER, TBBS_BUTTON, BTN_STEPOVER);
        SetButtonInfo(i++, ID_RUN_STEPOUT, TBBS_BUTTON, BTN_STEPOUT);
        SetButtonInfo(i++, ID_SEPARATOR, TBBS_SEPARATOR, 6);
        SetButtonInfo(i++, ID_GOTO_SHELL, TBBS_BUTTON, BTN_SHELL);
        SetButtonInfo(i++, ID_TOGGLE_TRACE, TBBS_BUTTON, BTN_TRACE_TOGGLE);
        SetButtonInfo(i++, ID_SEPARATOR, TBBS_SEPARATOR, 6);
        SetButtonInfo(i++, ID_HELP_INDEX, TBBS_BUTTON, BTN_HELP);
    }
    Invalidate();
    m_nActiveWinID = WID_SOURCE;
}

void CFloatToolBar::NewBrowse(void)
{
    DWORD dwStyle=GetStyle();
    int i = 0;
    // Update the tool bar buttons.
    if ( SetButtons(NULL, 31) ) {
        SetButtonInfo(i++, ID_FILE_BROWSEMODULE, TBBS_BUTTON, BTN_MODULE);        
		SetButtonInfo(i++, ID_FILE_PREVMODULE, TBBS_BUTTON, BTN_PREV_MODULE); 
		SetButtonInfo(i++, ID_FILE_NEXTMODULE, TBBS_BUTTON, BTN_NEXT_MODULE);
		SetButtonInfo(i++, ID_SEPARATOR, TBBS_SEPARATOR, 6);
        SetButtonInfo(i++, ID_FILE_LOAD, TBBS_BUTTON, BTN_LOAD);
		SetButtonInfo(i++, ID_SEPARATOR, TBBS_SEPARATOR, 6);
	    if(dwStyle&(CBRS_LEFT|CBRS_RIGHT)) {		                  
	    //no search combo box
	        SetButtonInfo(i++, ID_SEPARATOR, TBBS_SEPARATOR, 6);
	    }    
	    else {
	      	SetButtonInfo(i, IDC_SERCOMBO, TBBS_SEPARATOR, 100);
	      	AddSourceCombo(i++);
	    }  	
        SetButtonInfo(i++, ID_SEPARATOR, TBBS_SEPARATOR, 6);
		SetButtonInfo(i++, ID_EDIT_SEARCHNEXT, TBBS_BUTTON, BTN_SEARCH_NEXT);
		SetButtonInfo(i++, ID_SEPARATOR, TBBS_SEPARATOR, 6);
		SetButtonInfo(i++, ID_VIEW_SOURCE, TBBS_BUTTON, BTN_SRC_MODE);
		SetButtonInfo(i++, ID_VIEW_MIXED, TBBS_BUTTON, BTN_MIX_MODE );		
		SetButtonInfo(i++, ID_VIEW_ASSEMBLE, TBBS_BUTTON, BTN_ASSEMBLE );		
		SetButtonInfo(i++, ID_SEPARATOR, TBBS_SEPARATOR, 6);
        SetButtonInfo(i++, ID_OPTIONS_MAP, TBBS_BUTTON, BTN_MAP);
        SetButtonInfo(i++, ID_SEPARATOR, TBBS_SEPARATOR, 6);
        SetButtonInfo(i++, ID_RUN_RESET, TBBS_BUTTON, BTN_RESET);
        SetButtonInfo(i++, ID_RUN_RESTART, TBBS_BUTTON, BTN_RESTART );        
        SetButtonInfo(i++, ID_RUN_BREAKPOINT, TBBS_BUTTON, BTN_BP);           
        SetButtonInfo(i++, ID_RUN_GO, TBBS_BUTTON, BTN_GO);
        SetButtonInfo(i++, ID_RUN_GORUN, TBBS_BUTTON, BTN_GORUN);
        SetButtonInfo(i++, ID_RUN_HALT, TBBS_BUTTON, BTN_HALT);       
        SetButtonInfo(i++, ID_SEPARATOR, TBBS_SEPARATOR, 6);
        SetButtonInfo(i++, ID_RUN_STEPINTO, TBBS_BUTTON, BTN_STEPINTO);
        SetButtonInfo(i++, ID_RUN_STEPOVER, TBBS_BUTTON, BTN_STEPOVER);
        SetButtonInfo(i++, ID_RUN_STEPOUT, TBBS_BUTTON, BTN_STEPOUT);
        SetButtonInfo(i++, ID_SEPARATOR, TBBS_SEPARATOR, 6);
        SetButtonInfo(i++, ID_GOTO_SHELL, TBBS_BUTTON, BTN_SHELL);
        SetButtonInfo(i++, ID_TOGGLE_TRACE, TBBS_BUTTON, BTN_TRACE_TOGGLE);
        SetButtonInfo(i++, ID_SEPARATOR, TBBS_SEPARATOR, 6);
        SetButtonInfo(i++, ID_HELP_INDEX, TBBS_BUTTON, BTN_HELP);
    }
    Invalidate();
    m_nActiveWinID = WID_BROWSE; 
}

void CFloatToolBar::NewCpu(void)
{
    // Update the tool bar buttons.
	AddMainToolButton();    
	Invalidate();
    m_nActiveWinID = WID_CPU;
}

void CFloatToolBar::NewPeri(void)
{
    // Update the tool bar buttons.
	AddMainToolButton();    
	Invalidate();    
    m_nActiveWinID = WID_PERI;
}

void CFloatToolBar::NewShell(void)
{
	AddMainToolButton();
    Invalidate();    
    m_nActiveWinID = WID_SHELL;
}

void CFloatToolBar::NewTrace(void)
{
    // Update the tool bar buttons.
    int i = 0;
    if ( SetButtons(NULL, 29) ) {        
        SetButtonInfo(i++, ID_FILE_BROWSEMODULE, TBBS_BUTTON, BTN_MODULE);        
        SetButtonInfo(i++, ID_FILE_LOAD, TBBS_BUTTON, BTN_LOAD);
        SetButtonInfo(i++, ID_SEPARATOR, TBBS_SEPARATOR, 6);

        SetButtonInfo(i++, ID_OPTIONS_MAP, TBBS_BUTTON, BTN_MAP);
        SetButtonInfo(i++, ID_SEPARATOR, TBBS_SEPARATOR, 6);

        SetButtonInfo(i++, ID_RUN_RESET, TBBS_BUTTON, BTN_RESET);
        SetButtonInfo(i++, ID_RUN_RESTART, TBBS_BUTTON, BTN_RESTART );        
        SetButtonInfo(i++, ID_RUN_BREAKPOINT, TBBS_BUTTON, BTN_BP);
        SetButtonInfo(i++, ID_RUN_GO, TBBS_BUTTON, BTN_GO);
        SetButtonInfo(i++, ID_RUN_GORUN, TBBS_BUTTON, BTN_GORUN);
        SetButtonInfo(i++, ID_RUN_HALT, TBBS_BUTTON, BTN_HALT);
        SetButtonInfo(i++, ID_SEPARATOR, TBBS_SEPARATOR, 6);

        SetButtonInfo(i++, ID_RUN_STEPINTO, TBBS_BUTTON, BTN_STEPINTO);
        SetButtonInfo(i++, ID_RUN_STEPOVER, TBBS_BUTTON, BTN_STEPOVER);
        SetButtonInfo(i++, ID_RUN_STEPOUT, TBBS_BUTTON, BTN_STEPOUT);
        SetButtonInfo(i++, ID_SEPARATOR, TBBS_SEPARATOR, 6);
		                                         
        SetButtonInfo(i++, ID_TRACE_CLEAR, TBBS_BUTTON, BTN_TRACECLEAR);
        SetButtonInfo(i++, ID_EDIT_GOTOSTARTFRAME, TBBS_BUTTON, BTN_FRAME1);
        SetButtonInfo(i++, ID_EDIT_GOTOENDFRAME, TBBS_BUTTON, BTN_FRAMEn);
        SetButtonInfo(i++, ID_EDIT_GOTOFRAME, TBBS_BUTTON, BTN_FRAME);
        SetButtonInfo(i++, ID_SEPARATOR, TBBS_SEPARATOR, 6);                        
        SetButtonInfo(i++, ID_VIEW_BUS, TBBS_BUTTON, BTN_BUS_MODE);        
        SetButtonInfo(i++, ID_VIEW_INSTRUCTION, TBBS_BUTTON, BTN_INS_MODE);        
        SetButtonInfo(i++, ID_VIEW_CURSORLINK, TBBS_BUTTON, BTN_CURSERLINK);        
        SetButtonInfo(i++, ID_SEPARATOR, TBBS_SEPARATOR, 6);
                                          
        SetButtonInfo(i++, ID_GOTO_SHELL, TBBS_BUTTON, BTN_SHELL);
        SetButtonInfo(i++, ID_TOGGLE_TRACE, TBBS_BUTTON, BTN_TRACE_TOGGLE);
        SetButtonInfo(i++, ID_SEPARATOR, TBBS_SEPARATOR, 6);
        SetButtonInfo(i++, ID_HELP_INDEX, TBBS_BUTTON, BTN_HELP);
    }
    Invalidate();    
    m_nActiveWinID = WID_TRACE;
}


void CFloatToolBar::NewBMem(void)
{
    // Update the tool bar buttons.
    if ( SetButtons(NULL, 14) ) {
        SetButtonInfo(0, ID_FILE_LOAD, TBBS_BUTTON, BTN_LOAD);
        SetButtonInfo(1, ID_SEPARATOR, TBBS_SEPARATOR, 6);

        SetButtonInfo(2, ID_OPTIONS_MAP, TBBS_BUTTON, BTN_MAP);
        SetButtonInfo(3, ID_SEPARATOR, TBBS_SEPARATOR, 6);

        SetButtonInfo(4, ID_RUN_RESET, TBBS_BUTTON, BTN_RESET);
        SetButtonInfo(5, ID_RUN_BREAKPOINT, TBBS_BUTTON, BTN_BP);
        SetButtonInfo(6, ID_RUN_GO, TBBS_BUTTON, BTN_GO);
        SetButtonInfo(7, ID_RUN_HALT, TBBS_BUTTON, BTN_HALT);
        SetButtonInfo(8, ID_SEPARATOR, TBBS_SEPARATOR, 6);

        SetButtonInfo(9, ID_RUN_STEPINTO, TBBS_BUTTON, BTN_STEPINTO);
        SetButtonInfo(10, ID_RUN_STEPOVER, TBBS_BUTTON, BTN_STEPOVER);
        SetButtonInfo(11, ID_RUN_STEPOUT, TBBS_BUTTON, BTN_STEPOUT);
        SetButtonInfo(12, ID_SEPARATOR, TBBS_SEPARATOR, 6);

        SetButtonInfo(13, ID_HELP_INDEX, TBBS_BUTTON, BTN_HELP);
    }            
    Invalidate();    
    m_nActiveWinID = WID_BMEM;
}

void CFloatToolBar::NewVariable(void)
{
    // Update the tool bar buttons.
    DWORD dwStyle=GetStyle();
	int i = 0;
    // Update the tool bar buttons.
    if ( SetButtons(NULL, 27) ) {        
        SetButtonInfo(i++, ID_FILE_BROWSEMODULE, TBBS_BUTTON, BTN_MODULE);        
        SetButtonInfo(i++, ID_FILE_LOAD, TBBS_BUTTON, BTN_LOAD);
        SetButtonInfo(i++, ID_SEPARATOR, TBBS_SEPARATOR, 6);

        SetButtonInfo(i++, ID_OPTIONS_MAP, TBBS_BUTTON, BTN_MAP);
        SetButtonInfo(i++, ID_SEPARATOR, TBBS_SEPARATOR, 6);

        SetButtonInfo(i++, ID_RUN_RESET, TBBS_BUTTON, BTN_RESET);
        SetButtonInfo(i++, ID_RUN_RESTART, TBBS_BUTTON, BTN_RESTART );        
        SetButtonInfo(i++, ID_RUN_BREAKPOINT, TBBS_BUTTON, BTN_BP);
        SetButtonInfo(i++, ID_RUN_GO, TBBS_BUTTON, BTN_GO);
        SetButtonInfo(i++, ID_RUN_GORUN, TBBS_BUTTON, BTN_GORUN);
        SetButtonInfo(i++, ID_RUN_HALT, TBBS_BUTTON, BTN_HALT);
        SetButtonInfo(i++, ID_SEPARATOR, TBBS_SEPARATOR, 6);

        SetButtonInfo(i++, ID_RUN_STEPINTO, TBBS_BUTTON, BTN_STEPINTO);
        SetButtonInfo(i++, ID_RUN_STEPOVER, TBBS_BUTTON, BTN_STEPOVER);
        SetButtonInfo(i++, ID_RUN_STEPOUT, TBBS_BUTTON, BTN_STEPOUT);
        SetButtonInfo(i++, ID_SEPARATOR, TBBS_SEPARATOR, 6);

		SetButtonInfo(i++, ID_VARIABLE_ADD, TBBS_BUTTON, BTN_ADD_VAR); 
		SetButtonInfo(i++, ID_VARIABLE_DELETE, TBBS_BUTTON, BTN_DEL_VAR); 
        SetButtonInfo(i++, ID_SEPARATOR, TBBS_SEPARATOR, 6);
        
	    if(dwStyle&(CBRS_LEFT|CBRS_RIGHT)) {		                  
	    //no search combo box
	        SetButtonInfo(i++, ID_SEPARATOR, TBBS_SEPARATOR, 6);
	    }    
	    else {
	      	SetButtonInfo(i, IDC_SERCOMBO, TBBS_SEPARATOR, 100);
	      	AddVariableCombo(i++);
	    }  	          		
        SetButtonInfo(i++, ID_SEPARATOR, TBBS_SEPARATOR, 6);
		SetButtonInfo(i++, ID_EDIT_SEARCHNEXT, TBBS_BUTTON, BTN_SEARCH_NEXT);
		SetButtonInfo(i++, ID_SEPARATOR, TBBS_SEPARATOR, 6);
		        
        SetButtonInfo(i++, ID_GOTO_SHELL, TBBS_BUTTON, BTN_SHELL);
        SetButtonInfo(i++, ID_TOGGLE_TRACE, TBBS_BUTTON, BTN_TRACE_TOGGLE);
        SetButtonInfo(i++, ID_SEPARATOR, TBBS_SEPARATOR, 6);
        SetButtonInfo(i++, ID_HELP_INDEX, TBBS_BUTTON, BTN_HELP);
    }
    Invalidate();    
    m_nActiveWinID = WID_VARIABLE;
}

void CFloatToolBar::NewStack(void)
{
    // Update the tool bar buttons.
    DWORD dwStyle=GetStyle();
	int i = 0;
    // Update the tool bar buttons.
    if ( SetButtons(NULL, 26) ) {        
        SetButtonInfo(i++, ID_FILE_BROWSEMODULE, TBBS_BUTTON, BTN_MODULE);        
        SetButtonInfo(i++, ID_FILE_LOAD, TBBS_BUTTON, BTN_LOAD);
        SetButtonInfo(i++, ID_SEPARATOR, TBBS_SEPARATOR, 6);

        SetButtonInfo(i++, ID_OPTIONS_MAP, TBBS_BUTTON, BTN_MAP);
        SetButtonInfo(i++, ID_SEPARATOR, TBBS_SEPARATOR, 6);

        SetButtonInfo(i++, ID_RUN_RESET, TBBS_BUTTON, BTN_RESET);
        SetButtonInfo(i++, ID_RUN_RESTART, TBBS_BUTTON, BTN_RESTART );        
        SetButtonInfo(i++, ID_RUN_BREAKPOINT, TBBS_BUTTON, BTN_BP);
        SetButtonInfo(i++, ID_RUN_GO, TBBS_BUTTON, BTN_GO);
        SetButtonInfo(i++, ID_RUN_GORUN, TBBS_BUTTON, BTN_GORUN);
        SetButtonInfo(i++, ID_RUN_HALT, TBBS_BUTTON, BTN_HALT);
        SetButtonInfo(i++, ID_SEPARATOR, TBBS_SEPARATOR, 6);

        SetButtonInfo(i++, ID_RUN_STEPINTO, TBBS_BUTTON, BTN_STEPINTO);
        SetButtonInfo(i++, ID_RUN_STEPOVER, TBBS_BUTTON, BTN_STEPOVER);
        SetButtonInfo(i++, ID_RUN_STEPOUT, TBBS_BUTTON, BTN_STEPOUT);
        SetButtonInfo(i++, ID_SEPARATOR, TBBS_SEPARATOR, 6);

        SetButtonInfo(i++, ID_EDIT_SELECTLOCALVARIABLES, TBBS_BUTTON, 
                            BTN_LOCAL_VAR);
        SetButtonInfo(i++, ID_SEPARATOR, TBBS_SEPARATOR, 6);
        
	    if(dwStyle&(CBRS_LEFT|CBRS_RIGHT)) {		                  
	    //no search combo box
	        SetButtonInfo(i++, ID_SEPARATOR, TBBS_SEPARATOR, 6);
	    }    
	    else {
	      	SetButtonInfo(i, IDC_SERCOMBO, TBBS_SEPARATOR, 100);
	      	AddStackCombo(i++);
	    }  	          		
        SetButtonInfo(i++, ID_SEPARATOR, TBBS_SEPARATOR, 6);
		SetButtonInfo(i++, ID_EDIT_SEARCHNEXT, TBBS_BUTTON, BTN_SEARCH_NEXT);
		SetButtonInfo(i++, ID_SEPARATOR, TBBS_SEPARATOR, 6);
		        
        SetButtonInfo(i++, ID_GOTO_SHELL, TBBS_BUTTON, BTN_SHELL);
        SetButtonInfo(i++, ID_TOGGLE_TRACE, TBBS_BUTTON, BTN_TRACE_TOGGLE);
        SetButtonInfo(i++, ID_SEPARATOR, TBBS_SEPARATOR, 6);
        SetButtonInfo(i++, ID_HELP_INDEX, TBBS_BUTTON, BTN_HELP);
    }
    Invalidate();    
    m_nActiveWinID = WID_STACK;
}

void CFloatToolBar::NewMemory(void)
{
	AddMainToolButton();
    Invalidate();    
    m_nActiveWinID = WID_MEMORY;
}

void CFloatToolBar::UpdateToolbar(long nActiveID)
{
	switch(nActiveID) {
        case WID_SOURCE:
            NewSource();
            break;
        case WID_BROWSE:             
            NewBrowse();
            break;
        case WID_CPU:
            NewCpu();
            break;
        case WID_PERI:
            NewPeri();
            break;
        case WID_SHELL:
            NewShell();
            break;               
        case WID_BMEM:
            NewBMem();
            break;               
        case WID_TRACE:
            NewTrace();
            break;               
        case WID_STACK:
            NewStack();
            break;               
        case WID_MEMORY:
            NewMemory();
            break;               
        case WID_VARIABLE:
            NewVariable();
            break;               
        default:
            NewMain();
            break;               
    }                                
}
                                                             
BOOL CFloatToolBar::AddCombo(int item)
{

     CRect rect;
     GetItemRect(item, &rect);
     rect.top = 1;
     rect.bottom = rect.top + 100;
     if(!m_isCmbSrch)
       if(!m_cmbSrch.Create(CBS_DROPDOWN|CBS_AUTOHSCROLL|WS_VISIBLE, 
            rect, this, IDC_SERCOMBO)) {
         TRACE0("Failed to create combo-box\n");
         return FALSE;
       }
     else 0;             
     m_isCmbSrch = TRUE;                 
     /*   
     POSITION pos = SrcSrchData.m_StrList.GetTailPosition();
     while(pos) {
          m_cmbSrch.AddString(SrcSrchData.m_StrList.GetPrev(pos));
     } */
     m_cmbSrch.SetCurSel(0);

	return 1;
}                                              

void CFloatToolBar::Del(void)
{                        
    if(m_isCmbSrch){
    	m_isCmbSrch = FALSE;
        m_cmbSrch.DestroyWindow();
    }
}                                                             


// Added by Chen, 01/13/97
BOOL CFloatToolBar::AddSourceCombo(int nItem)
{
	// Create combo-box
	CRect rect;
	GetItemRect(nItem, &rect);
	rect.top = 1;
	rect.bottom = rect.top + 100;
	if(!m_isCmbSrch)
		if(!m_cmbSrch.Create(WS_VSCROLL|CBS_DROPDOWN|CBS_AUTOHSCROLL|WS_VISIBLE, rect, this, IDC_SERCOMBO)) {
		 	TRACE0("Failed to create combo-box\n");
		 	return FALSE;
		}
	m_isCmbSrch = TRUE;
	
	// Set combo-box content
	m_cmbSrch.ResetContent();
	POSITION pos = ::SrcGetSearchList()->GetHeadPosition();
	while ( pos ) {
		m_cmbSrch.AddString(::SrcGetSearchList()->GetNext(pos));
	}
	m_cmbSrch.SetCurSel(0);

	return TRUE;
}


// Added by John, 01/13/97            
extern CStringList* pVarSearchPatternList;  // Defined in VARSRCH.CPP
extern CStringList* pStkSearchPatternList;  // Defined in VARSRCH.CPP

BOOL CFloatToolBar::AddVariableCombo(int nItem)
{
	// Create combo-box
	CRect rect;
	GetItemRect(nItem, &rect);
	rect.top = 1;
	rect.bottom = rect.top + 100;
	if(!m_isCmbSrch)
		if(!m_cmbSrch.Create(WS_VSCROLL|CBS_DROPDOWN|CBS_AUTOHSCROLL|WS_VISIBLE, rect, this, IDC_SERCOMBO)) {
		 	TRACE0("Failed to create combo-box\n");
		 	return FALSE;
		}
	m_isCmbSrch = TRUE;
	
	// Set combo-box content
	m_cmbSrch.ResetContent();
	POSITION pos = ::pVarSearchPatternList->GetHeadPosition();
	while ( pos ) {
		m_cmbSrch.AddString(::pVarSearchPatternList->GetNext(pos));
	}
	m_cmbSrch.SetCurSel(0);

	return TRUE;
}
                            
BOOL CFloatToolBar::AddStackCombo(int nItem)
{
	// Create combo-box
	CRect rect;
	GetItemRect(nItem, &rect);
	rect.top = 1;
	rect.bottom = rect.top + 100;
	if(!m_isCmbSrch)
		if(!m_cmbSrch.Create(WS_VSCROLL|CBS_DROPDOWN|CBS_AUTOHSCROLL|WS_VISIBLE, rect, this, IDC_SERCOMBO)) {
		 	TRACE0("Failed to create combo-box\n");
		 	return FALSE;
		}
	m_isCmbSrch = TRUE;
	
	// Set combo-box content
	m_cmbSrch.ResetContent();
	POSITION pos = ::pStkSearchPatternList->GetHeadPosition();
	while ( pos ) {
		m_cmbSrch.AddString(::pStkSearchPatternList->GetNext(pos));
	}
	m_cmbSrch.SetCurSel(0);

	return TRUE;
}

CString CFloatToolBar::GetSrchEditText(void)
{                
    CString str;
    m_cmbSrch.GetWindowText(str);
    return  str;
}                                     

void CFloatToolBar::AddSrchText(const char * str)
{
    if(!m_isCmbSrch)    return;
    CString strTemp;
    if(m_cmbSrch.GetCount()) {
        m_cmbSrch.GetLBText(0, strTemp);
        if(strTemp == str)  return;
    }    
    m_cmbSrch.InsertString(0, str);
    m_cmbSrch.SetCurSel(0);
}


/////////////////////////////////////////////////////////////////////////////
// CTipStatic

CTipWnd::CTipWnd()
{ 
}

CTipWnd::~CTipWnd()
{ 
}
      
BOOL CTipWnd::CreateTipWnd(CWnd* /*pParent*/)
{       
// ASSERT(pParent && pParent->m_hWnd); 
 	return CreateEx(WS_EX_TOPMOST,//NULL,
           	   	AfxRegisterWndClass(CS_SAVEBITS|CS_HREDRAW),
          		NULL,
          		WS_POPUP|WS_BORDER,
	      		0,0,0,0,NULL/*pParent->m_hWnd*/,0);  

}      

BEGIN_MESSAGE_MAP(CTipWnd, CWnd)
    //{{AFX_MSG_MAP(CTipWnd)
	ON_WM_PAINT()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()
/////////////////////////////////////////////////////////////////////////////
// CTStstic message handlers
void CTipWnd::OnPaint()
{
  	CPaintDC dc(this); // device context for painting
	// TODO: Add your message handler code here 
 	GetWindowText(m_stringText);	
  	CRect rect;
  	dc.SaveDC();
  	dc.SelectObject(&afxdata.g_Font);
  	GetClientRect(&rect);
  	dc.FillRect(&rect,&afxdata.g_Brush);      
  	dc.SetBkMode(TRANSPARENT);
  	dc.DrawText((const char *)m_stringText,m_stringText.GetLength(),
              &rect,DT_CENTER|DT_VCENTER);
  	dc.RestoreDC(-1);

}                                

