// flttool.h : header file
//                           

#ifndef _FLTTOOL_H_
#define _FLTTOOL_H_
           
struct AFX_TBBUTTON
{
	UINT nID;        // Command ID that this button sends
	UINT nStyle;    // TBBS_ styles
	int iImage;     // index into mondo bitmap of this button's picture
						// or size of this spacer
}; 

// MDI Child Window ID
enum {
    WID_MAIN,
    WID_CPU, 
    WID_SHELL, 
    WID_TRACE, 
    WID_MEMORY, 
    WID_MEM2,
    WID_MEM3,
    WID_SOURCE,
    WID_STACK,
    WID_VARIABLE,
    WID_BMEM,
    WID_PERI,
    WID_COUNT,
    WID_BROWSE
};

           
/////////////////////////////////////////////////////////////////////////////
// CFloatToolBar window

class CFloatToolBar : public CToolBar
{
// Construction
public:
	CFloatToolBar();

// Attributes
public: 
	int	m_nActiveWinID;        
    CComboBox m_cmbSrch;
    BOOL    m_isCmbSrch;
	
	BOOL m_bCanMove;         
	enum {
	    BTN_LOAD = 0,
	    BTN_MAP,
	    BTN_RESET,
	    BTN_BP,
	    BTN_GO,
	    BTN_HALT,
	    BTN_STEPINTO,
	    BTN_STEPOVER,
	    BTN_STEPOUT,
	    BTN_HELP,
	    BTN_SHELL,
	    BTN_SEARCH_NEXT,
	    BTN_MODULE,
	    BTN_PREV_MODULE,
	    BTN_NEXT_MODULE,
	    BTN_SRC_MODE,
	    BTN_MIX_MODE,
	    BTN_BUS_MODE,
	    BTN_INS_MODE,
	    BTN_TRACE_MIXED,
	    BTN_WATCH,
	    BTN_STATEMENT,
	    BTN_INST,     	  
	    BTN_LOCAL_VAR,
	    BTN_FRAME1,
	    BTN_FRAMEn,
	    BTN_FRAME,
	    BTN_ADD_VAR,
	    BTN_DEL_VAR,       
	    BTN_GORUN,    	    
	    BTN_LISTSRC,
	    BTN_TRACE_TOGGLE,
	    BTN_SPA,
	    BTN_RESTART,
	    BTN_TRACECLEAR,
	    BTN_SHORTLINE,	    	    
	    BTN_ASSEMBLE,
	    BTN_CURSERLINK,
	    BTN_SRCHCOM,	    
	};
	
private: 
    CRect  m_WinRect;
    CPoint m_LBDPoint; 
    CWnd   *m_pTip; 
    CRect  m_wndRect;
	BOOL   m_bSetTimer; 
    int    m_nDelayTime;
    int    m_nTimeCount;           
    UINT   m_BtnID;
    UINT   m_OldBtnID;
    enum   { m_TimerID = 1300 };
    
// Operations
public:
	void SetBackColor(COLORREF);
	void SetTipFont(LOGFONT *logFont);
	void FilterTipMessage(MSG *pMsg);                              	
	              
    void NewMain(void);
    void NewSource(void);
    void NewBrowse(void);
    void NewCpu(void);
    void NewPeri(void);
    void NewShell(void);
    void NewTrace(void);
    void NewBMem(void);
    void NewVariable(void);
    void NewStack(void);
    void NewMemory(void);
    void UpdateToolbar(long nActiveID);
    void AddMainToolButton(void);
    BOOL AddCombo(int item);
    void Del(void);

public:
	// Added by Chen, 01/13/97
    BOOL AddSourceCombo(int nItem);
    BOOL AddVariableCombo(int nItem);
    BOOL AddStackCombo(int nItem);
    CString GetSrchEditText(void);
    void AddSrchText(const char * str);
    
protected:
	void TipProcess(CPoint point);
	void DrawContent(LPCSTR lpText,POINT point);

private:                  
	void ShowTipCard(UINT ID,POINT point);
    void ReleaseTip(void);
    int  HitTipTest(CPoint point/*screen postion*/);
	BOOL SetPos(DWORD wPos);
	void _SetButtonStyle(int  nIndex,UINT nStyle);	
	void FloatCalcInsideRect(CRect& rect); 
	void DoPaint(CDC* pDC);
	int  FloatHitTest(CPoint point);	 		    
	void FloatInvalidateButton(int nIndex);
	void FloatGetItemRect(int nIndex, LPRECT lpRect);

// Implementation
public:
	virtual ~CFloatToolBar();
                                                        
protected:                                                        
    inline AFX_TBBUTTON* GetButtonPtr(int nIndex) const;
    
protected:
	void DrawFrame(CRect);
	
	// Generated message map functions
	//{{AFX_MSG(CFloatToolBar)
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnDestroy();
	afx_msg void OnPaint();
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
#endif
