
/***************************************************************************
**
**    $Header:   D:/ECB2S/SRC/LOG/EMUHALT.CPP   1.2.1.5   17 Apr 1997 15:48:34   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/EMUHALT.CPP  $
** 
**    Rev 1.0   07 Sep 1995 09:55:40   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: EMUHALT.CPP
//
//  Description: The implementation file for the class: CEmulationHalt.
//
//  Author: Chen Jun
//
//  Date: 05/08/95
//
//  Modification:
//      1. 05/08/95, Initial version of the class: CEmulationHalt.
//
/////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////
// Include files.
#include "stdafx.h"
//#include "resource.h"

//#include "symbscty.h"
#include "emuhalt.h"
#include "emugo.h"
#include "srcdef.h"
//#include "cpust.h"           
//#include "hosterrs.h"
//#include "errcodec.h"
//#include "mainfrm.h"
#include "trcpub.h"
#include "ep196.h"                                                           
#include "uicom2.h"
#include "emugo.h"
#include "address.h"
/////////////////////////////////////////////////////////////////////////////
// Debug flags.
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// Type definitions.


/////////////////////////////////////////////////////////////////////////////
// Macro definitions.


/////////////////////////////////////////////////////////////////////////////
// Global variables.


/////////////////////////////////////////////////////////////////////////////
// Static variables.


/////////////////////////////////////////////////////////////////////////////
// External variables.


/////////////////////////////////////////////////////////////////////////////
// Global function prototypes.
//extern void ErrShow(U32 errorCode,BOOL bUI);//JOHN 96.3
//void TraceWnd(unsigned char trace);         //

/////////////////////////////////////////////////////////////////////////////
// Local function prototypes.


/////////////////////////////////////////////////////////////////////////////
// Executable codes.

/////////////////////////////////////////////////////////////////////////////
// Public functions.

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   HaltCmd().
//
//  Description: The main control routine of Halt command.
//
//  Input:  nArgc - Number of input parameters.
//          pszArgv - Input parameters.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
#ifdef __cplusplus
extern "C" {
#endif	// __cplusplus
void WINAPI EmuServerGo(int nMode, ADDR addr);
void WINAPI RestartCmd(int m_nArgc,char* m_pszArgv[]) {
	DoReset();
	ADDR addr;                  
	
	ADDRESS tmpAddr;
	ADDR_RETCODE nAddrRet = AdrTextToAddr("#main",tmpAddr);	
	
	if (ADR_OK != nAddrRet) {
		OnEmulation();	
		return;
	}	
	
	addr.addrType = tmpAddr.adrSpace;
	addr.addr = tmpAddr.adrAddress;
	
	
	if (addr.addrType > MEM_P3 || addr.addrType<MEM_P0) {
		ASSERT(FALSE);  
		OnEmulation();	          
		return;
	}
    
    EmuServerGo(3, addr); //go till #main
	OnEmulation();	
}   

void WINAPI HaltCmd(int nArgc, char* pszArgv[])
{
    // Assertion of the input parameters.
    ASSERT( 1 == nArgc );
    for ( int i = 0; i < nArgc; i++ ) {
        ASSERT( pszArgv[i] );
    }
    
    // Execute Halt command.
    CEmulationHalt* pEmulationHalt = new CEmulationHalt;
    if ( !pEmulationHalt ) {
        //::ErrShow(ER_APP_OUTMEMORY,TRUE);
        ASSERT( FALSE );
        return;
    }
    else {
        pEmulationHalt->HaltAction(nArgc, pszArgv);
        delete pEmulationHalt;
    }
    
//    CEmulationHalt objHalt;
//    objHalt.HaltAction(nArgc, pszArgv);

}   // End of HaltCmd().


// Halt server routine for Source window.
void WINAPI EmuServerHalt(void)
{
    // Assertion of the input parameters.
    
    // Execute Halt command.
    CEmulationHalt* pEmulationHalt = new CEmulationHalt;
    if ( !pEmulationHalt ) {
    	::ErrShow(ER_APP_OUTMEMORY,TRUE);
        ASSERT( FALSE );
        return;
    }
    else {
        pEmulationHalt->EmuServerHalt();
        delete pEmulationHalt;
    }
    
}   // End of HaltCmd().

#ifdef __cplusplus
}
#endif	// __cplusplus

/////////////////////////////////////////////////////////////////////////////
// Implementation codes of class: CEmulationHalt.

// Construction.
CEmulationHalt::CEmulationHalt()
{

}   // End of CEmulationHalt::CEmulationHalt().


// Destruction.
CEmulationHalt::~CEmulationHalt()
{

}   // End of CEmulationHalt::~CEmulationHalt().


// Emulation Halt command.
void CEmulationHalt::HaltAction(int nArgc, char* pszArgv[])
{
    // Assertion of the input parameters.
    ASSERT( 1 == nArgc );
    for ( int i = 0; i < nArgc; i++ ) {
        ASSERT( pszArgv[i] );
    }
    m_isServer = FALSE;
    // Call the Halt kernel.
    HaltKernel();

}   // End of CEmulationHalt::HaltAction().

static char timeStr[50];                               
// Halt kernel routine.
void CEmulationHalt::HaltKernel(void)
{
    // Assertion of the input parameters.
    
    // Call the ABI function.
    m_nErrorID = emuAbort();  
    SetCpuStatus2(STATUS_HALT);

	// Add elapse timer.
    if(GetElapseTimeStr(timeStr)) {
    	UpdateStatusBar(6, timeStr);
    }
    if ( 0 != m_nErrorID ) {
        ::ErrShow(ER_ICE_OK+m_nErrorID,m_isServer);
        
    }
    else { 
       if ( !m_isServer ) {
       SrcShowLine("Cpu is halted.");
       }
        SetCpuStatus2(STATUS_HALT);
        
        TraceWnd(0);     //TRACE OFF
    }

}   // End of CEmulationHalt::HaltKernel().


// Halt server.
void CEmulationHalt::EmuServerHalt(void)
{
    // Assertion of the input parameters.

    // Call the Halt kernel.
    m_isServer = TRUE;
    HaltKernel();

}   // End of CEmulationHalt::EmuServerHalt().

//halt for go fly and go
BOOL CEmulationHalt::GoFlyHalt(void)
{ 
    if(GetCpuStatus2() != STATUS_GO &&
       GetCpuStatus2() != STATUS_GORUN)  return FALSE;
       
    m_nErrorID = emuAbort();
    
    if ( 0 != m_nErrorID ) {
        ErrShow(ER_ICE_OK+m_nErrorID,m_isServer);
        return FALSE;
    }
    else {                  
         SetCpuStatus2(STATUS_HALT);   
         
		// Add elapse timer.
        if(GetElapseTimeStr(timeStr)) {
	    	UpdateStatusBar(6, timeStr);
	    }
        return TRUE;
    }  
    
    return TRUE;   
 }

//added by john 96.3
/**************************************************************************
**
** Name : CpuHalt()
**
** Function  support go fly function
**
**    Input  : 
**
**    return : TRUE ==> OK
**             FALSE ==> FAIL
** Notes:
**
**************************************************************************/
BOOL CpuHalt()
{      
    CEmulationHalt* pEmulationHalt = new CEmulationHalt;
    if ( !pEmulationHalt ) {
        ErrShow(ER_APP_OUTMEMORY,TRUE);
        ASSERT( FALSE );
        return FALSE;
    }
    else {
        BOOL bResult = pEmulationHalt->GoFlyHalt();
        delete pEmulationHalt;
        return bResult;
    }                  
    return TRUE;
    
 }


//////////////////////////////// End of File ////////////////////////////////
