
/***************************************************************************
**
**    $Header:   D:/ECB2S/SRC/LOG/EMUJUMP.CPP   1.2.1.5   17 Apr 1997 15:48:38   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/EMUJUMP.CPP  $
** 
** 
**    Rev 1.0   07 Sep 1995 09:55:40   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: EMUJUMP.CPP
//
//  Description: The implementation file for the class: CEmulationJump.
//
//  Author: Chen Jun
//
//  Date: 05/08/95
//
//  Modification:
//      1. 05/08/95, Initial version of the class: CEmulationJump.
//
/////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////
// Include files.
#include "stdafx.h"
//#include "resource.h"
                     
//#include "symbscty.h"                     
#include "emujump.h"
#include "emugo.h"
#include "uicom2.h"
#include "ep196.h"
//#include "errcodec.h"                       
//#include "cpust.h" //john 96.4
//extern void ErrShow(U32 errorCode,BOOL bUI);


/////////////////////////////////////////////////////////////////////////////
// Debug flags.
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// Type definitions.


/////////////////////////////////////////////////////////////////////////////
// Macro definitions.


/////////////////////////////////////////////////////////////////////////////
// Global variables.


/////////////////////////////////////////////////////////////////////////////
// Static variables.


/////////////////////////////////////////////////////////////////////////////
// Global function prototypes.

/////////////////////////////////////////////////////////////////////////////
// Local function prototypes.


/////////////////////////////////////////////////////////////////////////////
// Executable codes.

/////////////////////////////////////////////////////////////////////////////
// Public functions.

#ifdef __cplusplus
extern "C" {
#endif	// __cplusplus

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   JumpCmd().
//
//  Description: The main control routine of Jump command.
//
//  Input:  nArgc - Number of input parameters.
//          pszArgv - Input parameters.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
void WINAPI JumpCmd(int nArgc, char* pszArgv[])
{
    // Assertion of the input parameters.
    ASSERT( 2 == nArgc );
    for ( int i = 0; i < nArgc; i++ ) {
        ASSERT( pszArgv[i] );
    }
    
    // Execute Jump command.
    CEmulationJump* pEmulationJump = new CEmulationJump;
    if ( !pEmulationJump ) {
        ::ErrShow(ER_APP_OUTMEMORY,TRUE);
        ASSERT( FALSE );
        return;
    }
    else {
        pEmulationJump->JumpAction(nArgc, pszArgv);
        delete pEmulationJump;
    }

//    CEmulationJump objJump;
//    objJump.JumpAction(nArgc, pszArgv);

}   // End of JumpCmd().

// Jump server.
void WINAPI EmuServerJump(ADDR uAddr)
{
    // Assertion of the input parameters.
    
    // Execute Jump command.
    CEmulationJump* pEmulationJump = new CEmulationJump;
    if ( !pEmulationJump ) {
        ::ErrShow(ER_APP_OUTMEMORY,TRUE);
        ASSERT( FALSE );
        return;
    }
    else {
        pEmulationJump->EmuServerJump(uAddr);
        delete pEmulationJump;
    }

}   // End of EmuServerJump().

#ifdef __cplusplus
}
#endif	// __cplusplus
/////////////////////////////////////////////////////////////////////////////
// Implementation codes of class: CEmulationJump.

// Construction.
CEmulationJump::CEmulationJump()
{

}   // End of CEmulationJump::CEmulationJump().


// Destruction.
CEmulationJump::~CEmulationJump()
{

}   // End of CEmulationJump::~CEmulationJump().


// Emulation Jump command.
void CEmulationJump::JumpAction(int nArgc, char* pszArgv[])
{
    // Assertion of the input parameters.
    ASSERT( 2 == nArgc );
    for ( int i = 0; i < nArgc; i++ ) {
        ASSERT( pszArgv[i] );
    }

    // Set the parameters.
    switch ( nArgc ) {
        case 2:
            // Jump adr
            m_nRegID = 0;
            SetAddrVar(pszArgv[1], m_JumpAddr);
            break;
        default:
            ASSERT( FALSE );
            break;
    }
    
    // Call the Jump kernel.
    m_isServer = FALSE;
    JumpKernel();

}   // End of CEmulationJump::JumpAction().


// Jump kernel routine.
void CEmulationJump::JumpKernel(void)
{
    // Assertion of the input parameters.
    
    // Test parameters.
    //DumpVar(m_nRegID);
    //DumpVar((unsigned long)m_JumpAddr.m_uAddr);
    //john 96.4
    if(GetCpuStatus2() == STATUS_GO) {
    	if ( !m_isServer ) ::ErrShow(ER_EMU_GOFLY_ERR_MSG,FALSE);
        	else ::ErrShow(ER_EMU_GOFLY_ERR_MSG,TRUE);
        return;	
    }
    // Call the ABI function.
    m_nErrorID = emuSetReg(0,m_nRegID, m_JumpAddr.addr+(m_JumpAddr.addrType-1)*0x10000);
    
    if ( 0 != m_nErrorID ) {
        //DisplayErrorMessage(); 
        ErrShow(ER_ICE_OK+m_nErrorID,m_isServer);
        return;
    }
    
}   // End of CEmulationJump::JumpKernel().


// Jump server.
void CEmulationJump::EmuServerJump(ADDR addr)
{
    // Assertion of the input parameters.

    // Set the parameters.
    m_nRegID = 0;
    m_JumpAddr.addr = addr.addr;
    m_JumpAddr.addrType = addr.addrType;
    // Call the Jump kernel.
    m_isServer = TRUE;
    JumpKernel();

}   // End of CEmulationJump::EmuServerJump().
void CEmulationJump::SetAddrVar(char* Str,ADDR& addr)
{ 
	ADDRESS tmpAddr;
	ADDR_RETCODE nAddrRet = AdrTextToAddr(Str,tmpAddr);	
	addr.addrType = tmpAddr.adrSpace;
	addr.addr = tmpAddr.adrAddress;
	return ;
}

//////////////////////////////// End of File ////////////////////////////////
