/***************************************************************************
**
**    $Header$
**
**    $Log$
** 
****************************************************************************/

// init196.cpp : initial & exit routines
//

#include "stdafx.h"
#include "ep196.h"

#include "srcdef.h"
#include "aliaspub.h"
#include "address.h" 
#include "symblsvr.h"
#include "ldrexp.h"
#include "abiextfn.h"
#include "bankinit.h"
#include "initapi.h"
#include "regsvr.h"
#include "uicom2.h"
#include "mapdlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


BOOL g_isTraceBoard;
extern int  g_nLogoEnable;

/////////////////////////////////////////////////////////////////////////////
// Extern functions
extern int	InitCpu(int iRoger);     
extern BOOL	InitTrace();
extern int	InitGetCpuType(void);
extern void	InitRegSelect(void);
extern BOOL VarAllocateSpace(void);
extern BOOL StkAllocateSpace(void);
extern void VarReleaseSpace(void);
extern void StkReleaseSpace(void);
extern void CloseFire(void);
extern void CreateFire(void);


void TstInit(BOOL& isTraceBoardOn);

/////////////////////////////////////////////////////////////////////////////
// Global initial function 

BOOL RegisterDll()
{ 
	//init comset dialog and relink dialog                   
	Init196DLL();

    //init abi dll
    InitABIDLL();
        
    // Initial loader
   	InitDLLLoad();

    // Initial Symblsvr
    InitDLL_SymBolServer();  

	// Initial Address
	InitDLL_AddressServer();
	
	// Initial SRCDLL
	::InitDLL_SourceWindow();
	
	// Initial BPTDLL
	::InitDLL_BreakpointServer();
    
	// Initial STEPDLL
	::InitDLL_StepServer();      

	// Initial RegMap dll
	InitDLL_RegMap();
	return TRUE;
	                         	
}

BOOL InitProject()
{    
    //notes: the init dll routines are moved to RegisterDll()               
                         
	//new abi class                                                  
	if(!NewABIDLL(MAKE_REAL_196_ABI)) return FALSE;
//	if(!NewABIDLL(MAKE_SIMULATOR_ABI)) return FALSE;
    
    DoReset();
    //initialize setup of bank 
    if(!InitBank()) return FALSE;
	// Added by Chris
    int i = InitGetCpuType();
    if(i == -1) return FALSE;
    if(i < 0)
    {
		AfxMessageBox("F/W can't support this CPU");
    }                   
    i = InitCpu(i);
    if(!i) return FALSE;
                                                                      
	// add by Richard in order to support hiding logo window                                                                      
	g_nLogoEnable = AfxGetApp()->GetProfileInt("LogoInfo","LogoOption",1);
	
	if (g_nLogoEnable != 0)
		CreateFire();
		
    //Init trace and all control 
	if (!::InitTrace()) return FALSE;

	// Added by Gates Hua
	SymInitialize();

	MakeTable();
   	AdrSetAddrRange();                             

	// Added by Chen
	if ( !::SrcInitSourceEnv() ) {
		return FALSE;
	}
	::BptInitBpEnv();
	::SrcReadProfile();

    //Add by Chris:
    extern BOOL ReadMemWndIni();
    ReadMemWndIni();
    
    // Open Map dialog.
    HINSTANCE hLib;
    if ( (hLib = LoadLibrary("MUSCROLL.DLL")) < HINSTANCE_ERROR ) {
        AfxMessageBox("MUSCROLL.DLL loading error.");
		//	::ErrGetErrorMsg(....);
        return FALSE;
    }
    
    if ( hLib >= HINSTANCE_ERROR ) {
        FreeLibrary(hLib);
    }
	    
    // For Variable window.
    if ( !::VarAllocateSpace() ) {
        return (0);
    }
    
    // For Stack window.
    if ( !::StkAllocateSpace() ) {
        return (0);
    }

    TstInit(g_isTraceBoard);
    
	return TRUE;
}

void ExitProject()
{
    // Added by Annie
	FreeTable();     
	
	// added by Richard
	AfxGetApp()->WriteProfileInt("LogoInfo","LogoOption",g_nLogoEnable);
	

	// Added by Chen
	::SrcWriteProfile();
	::SrcFreeSourceEnv();
	::BptFreeBpEnv();

	// Dragon
    DelRegMem();
    DelLdrDLL();
    
    //Add by Chris:
	extern BOOL WriteMemWndIni();
    WriteMemWndIni();
    
    // Variable & Stack window.
    ::VarReleaseSpace();
    ::StkReleaseSpace();
    
    //JOHN
	ExitABIDLL();    
	
}

void ExitEpsld() 
{              
	AfxMessageBox("Communication Failure!!!");
	
	//AfxAbort();   
	AfxGetMainWnd()->SendMessage(WM_CLOSE);
}
 
#ifdef __cplusplus
extern "C" {
#endif	// __cplusplus	  
	void WINAPI ComErrExit() {    
		AfxMessageBox("Communication Failure!!!\n\rPlease exit programe!");
		//AfxAbort();   
		//AfxGetMainWnd()->SendMessage(WM_CLOSE);
	}
#ifdef __cplusplus
}
#endif
