// ldriccf96.h : header file

#include "symbscty.h"

/* segment type */
#define SEGTYPE_UNTYPED     0
#define SEGTYPE_CODE        1
#define SEGTYPE_DATA        2
#define SEGTYPE_XDATA       3
#define SEGTYPE_IDATA       4
#define SEGTYPE_BIT         5
#define SEGTYPE_REG         6
#define SEGTYPE_CONST       7

/* register ID */
#define REG_R0      0
#define REG_R1      1
#define REG_R2      2
#define REG_R3      3
#define REG_R4      4
#define REG_R5      5
#define REG_R6      6
#define REG_R7      7
#define REG_A       8
#define REG_B       9
#define REG_DPL     10
#define REG_DPH     11
#define REG_C       12

//for UBROF V6.0
#define t_version       189     /* 0xBD */
#define t_seg_info      192     /* 0xC0 */
#define t_grp           190     /* 0xBE */
#define t_grp_ref       191     /* 0xBF */

#define t_beg_file      77      /* 0x4d */
#define t_beg_file1     165     /* 0xA5 */
#define t_beg_lib       0       /* 0x0  */
#define t_beg_pgm       1       /* 0x1  */
#define t_end_abs       61      /* 0x3d */
#define t_end           63      /* 0x3f */
#define t_end_rel       62      /* 0x3E */
#define t_debug         82      /* 0x52 */
#define t_aux           83      /* 0x53 */
#define t_aux_1         84      /* 0x54 */
#define t_check_lib     187     /* 0xBB */

#define t_file          70      /* 0x46 */
#define t_file_ref      185		// 0xB9
#define t_new_file      186		// 0xBA
#define t_src_stat      71      /* 0x47 */

#define t_pub_abs       6       
#define t_loc_abs       8       
#define t_pub_rel       7       
#define t_loc_rel       9       
#define t_ext_def       5       
#define t_seg_rel       2       
#define t_seg_stk       3
#define t_seg_com       4

#define t_func_begin        80      /* 0x50 */
#define t_func_begin1       167     /* 0xA7 */
#define t_func_begin2       183     /* 0xB7 */
#define t_block_begin       72      /* 0x48 */
#define t_block_begin1      168     /* 0xA8 */
#define t_block_begin2      184     /* 0xB8 */
#define t_block_end         73      /* 0x49 */  
#define t_abs_8             54      // 0x36
#define t_abs_16            55      // 0x37
#define t_abs_24            163     // 0xA3
#define t_abs_32            56      // 0x38
#define t_abs_var           57      /* 0x39 */
#define t_abs_block         116     // 0x74
#define t_error             60      // 0x3C
#define t_org_abs           58      // 0x3A
#define t_org               81      /* 0x51 */
#define t_ubrof_eof         255     /* 0xFF */


#define t_symbol_def        76      /* 0x4C */
#define t_symbol_def1       166     /* 0xA6 */
#define t_sub_def_func      176     // 0xB0
#define t_sub_def_xfunc     177     // 0xB1
#define t_sub_def_stat_locs 178     // 0xB2
#define t_sub_def_stat_args 179     // 0xB3
#define t_sub_def_stack     180     // 0xB4
#define t_sub_def_regs      182     // 0xB6
#define t_sub_def_useage    181     // 0xB5

#define t_seg           75      // 0x4B
#define t_macro         78      /* 0x4E */
#define t_ldef_fn_51    120     // 0x78
#define t_xdef_fn_51    121     // 0x79

#define t_def_ptr_types 193     // 0xC1
#define t_type          74      /* 0x4A */
#define t_size_type     79      /* 0x4F */
#define t_type_pointer	15		/* 0x0F */
#define t_type_array	16		/* 0x10 */
#define t_type_struct	17		/* 0x11 */
#define t_type_union	18		/* 0x12 */
#define t_type_bits		19		/* 0x13 */
#define t_type_func		20		/* 0x14 */
#define t_type_func1	35		/* 0x23 */
#define t_type_attr		21		/* 0x15 */
#define t_type_attr1	36		/* 0x24 */
#define t_type_dptr0	23		/* 0x17 */
#define t_type_dptr1	24		/* 0x18 */
#define t_type_dptr2	25		/* 0x19 */
#define t_type_dptr3	26		/* 0x1A */
#define t_type_dptr4	27		/* 0x1B */
#define t_type_dptr5	28		/* 0x1C */
#define t_type_dptr6	29		/* 0x1D */
#define t_type_dptr7	30		/* 0x1E */
#define t_type_cptr0	31		/* 0x1F */
#define t_type_cptr1	32		/* 0x20 */
#define t_type_cptr2	33		/* 0x21 */
#define t_type_cptr3	34		/* 0x22 */
#define t_type_cptr4    37      // 0x25
#define t_type_cptr5    38      // 0x26
#define t_type_cptr6    39      // 0x27
#define t_type_cptr7    40      // 0x28
                    

 struct symbol{
    U8 SC;
    U32 addr;
    U8 * name;
    U16 typeindex; 
    U16 segnum;
    struct symbol * next;
 public:
    symbol(){
      name=0;    
      next=0;
    };
 };           

struct StoreExtendVar {
    U8 * name;
    U16 typeindex; 
    struct StoreExtendVar *next;
public :
    StoreExtendVar() {
     next = 0;   
     name = 0;
    };
};

struct attrCC {
    unsigned int num ;
    unsigned long attr ;
    unsigned int type ;
    struct attrCC *next;
    
public :
    attrCC() {
        num = 0;
        attr = 0;
        type = 0;
        next = 0;
    };
};

typedef struct {
    SEGMENTTYPE type;
    U32 addr;
} ORG_ADDRESS;

typedef struct {
    ORG_ADDRESS start;
    ORG_ADDRESS end;
    int flag;
} STATE_ADDR;
           
           
/////////////////////////////////////////////////////////////////////////////

class CLdrICC196 : public CLdrSvr
{   
public:
   CLdrICC196(LPCSTR lpsczFile , int nFlag , int where);			
// Attributes
public:
   U8   m_uMajorVer;
   U8   m_uMinorVer;
   U8   m_uRevision; 
   
   BOOL m_bIsAssemble;
   //for bank switching
   int  m_nMemMode;
   int  m_nBankNum;   

private:
   struct StoreExtendVar *varExtHdrPtr, *varExtPtr;
   struct attrCC *attrExtHdrPtr , *attrExtPtr;
   struct symbol * m_CurSymbol;
   STATE_ADDR  stat_addr;
   ORG_ADDRESS m_uCurAddr;  
   QUAL_ADDR_RANGE_TYPE m_qaddr; 
   U8  m_uLineInfo[8];
public:
// Operations        
   void GetBankCallRetAddr(U32 addr, char * Name);
   BOOL JutifyBank();
   BOOL LoadStarter();
   BOOL GetVersionInfo();  
   BOOL GetSegInfo(); 
   BOOL LoadTypes(U8 tag); 
   BOOL LoadSubType(U16 ti, U16 subtag);
   BOOL GetGrpInfo();
   BOOL GetSymbol(U8 uTag, int flag);   
   BOOL LdrGetModule(U8 uTag);
   BOOL GetCodeOfMod(U8 uTag,int flag,SYM_DESCRIPTOR moduleDesc);
public:
   BOOL FillCodeToMem(U8 * data);
   BOOL AddLineToSym(SYM_DESCRIPTOR moduleDesc);
   void AdjustModBlkRange(U8 tag);
   BOOL AddFunToSym(U8* name, U8* data);
   BOOL AddBlkOfFuncToSym(); 
   BOOL CloseFuncToSym();
   void UbrofMatchFuncType(LPSTR str , TYPE_INDEX& typeindex );
   void UbrofMatchAttrType(U16& typeindex );
   void UbrofTypeConv(U16& typeindex );
   BOOL UbrofProcessModSym(void);
   BOOL UbrofProcessBlockSym(void);
   void UbrofSegIdToEnum(U8 ti , SEGMENTTYPE* type);
   void InitList(); 
   BOOL GetLenBytes(U8 uTag=0);
public:
   BOOL LoadProcess();  
// Implementation
public:
	virtual ~CLdrICC196();
};

/////////////////////////////////////////////////////////////////////////////
