// ldrmgr.h : header file
#ifndef _LDRMGR_H_
#define _LDRMGR_H_

#include "ldrsvr.h"

typedef struct LdrOpt{
   BOOL m_isCode ;
   BOOL m_isStatus ;
   BOOL m_isSymbol;
   BOOL m_isWarnings ;
   BOOL m_isSystem;
   int  m_isBank;
}CLdrOpt;

/////////////////////////////////////////////////////////////////////////////
// CLdrMgr 

class CLdrMgr 
{   
public:
	CLdrMgr();			// protected constructor used by dynamic creation

// Attributes
public:
   CLdrSvr * m_pLdrSvr; //base class of loader
   CLdrOpt * m_pLdrOpt;  //options of loader   
public:
   int m_nWhere;  //0 from dialog ; 1 from window
   //for bank switch
   int m_nComOrSep;
   int m_nBankNumber;
   int m_nLowPort;
   int m_nLowBit;
   int m_nHighPort;
   int m_nHighBit;
   int m_nHighSignal;
   int m_nLowSignal;
public:
   BOOL SrcIsLoaded(void);
   BOOL SrcIsOmf96(void);
   BOOL SrcIsUbrof(void);
   BOOL SrcIsIEEE(void);
   void GetFileLength(long& l);
   void GetFileCurPos(long& l);                           
   void GetStartAddress(U32& addr,int& nBank); 
   U32 GetCurLdrBytes();
public:
   BOOL LoadFile(LPCSTR lpcszFile,int nOption);
   BOOL WhatisCompiler(LPCSTR lpcszFile); 
   void SetLoadOption(int nOption); 
   BOOL LoadCmd(int argc , char * argv[]);
public:
   //for other modules
   void CloseLoader();
   int  JustifyBank(int LowBit, int HighBit, int nBank);
   int  StkNumConvToBank(int ul);
   U32  StkAddrConvToBank(U32 ul);
   BOOL SrcSupportBankSwitch();
   void GetBankInfo();    
   BOOL GetBankAddr(unsigned long& uCallAddr,unsigned long& uRetAddr); 
   int  SrcGetLoadPath(CString& strPath);
   U32  GetRegOff(U16 regIndex);
   void GetRootBankValue(ADDRESS& addr);
// Implementation
public:
   virtual ~CLdrMgr();

};
#endif

/////////////////////////////////////////////////////////////////////////////
