// ldromf96.h : header file

#define REC_MODULE_HEADER    0x02
#define REC_MODULE_END       0x04
#define REC_CONTENT          0x06
#define REC_LINE_NUMBERS     0x08
#define REC_BLOCK_DEF        0x0A
#define REC_BLOCK_END        0x0C
#define REC_EOF              0x0E
#define REC_MODULE_ANCESTOR  0x10
#define debug_records        0x10
#define REC_LOCALS_SYMBOLS   0x12
#define REC_TYPE_DEFS        0x14
#define REC_PUBLIC_DEFS      0x16
#define REC_EXTERNAL_DEFS    0x18

#define REC_SEGMENT_DEFS     0x20
#define REC_FIXUP            0x22

#define REC_LIBRARY_MODULE_LOCATIONS    0x26
#define REC_LIBRARY_MODULE_NAMES        0x28
#define REC_LIBRARY_DICTIONRY           0x2A
#define REC_LIBRARY_HEADER              0x2E

#define REC_FIXUP2           0x34
#define REC_FILENAME         0x36
#define REC_FILELINE         0x38
#define REC_EXPRESSION       0x3A
#define REC_PUBLIC2_DEF      0x3C
#define REC_MODULE_INFO      0x3E
#define REC_COMMENT          0x40
#define REC_INIT             0x42

// for type desciptor

#define NIL_LEAF             100
#define TWO_BYTE_SGNINT      101
#define FOUR_BYTE_SGNINT     102
#define STRING_LEAF          103
#define INDEX_LEAF           104
#define REPEAT_LEAF          105
#define EOB                  106

#define SBIT_LEAF            111
#define UBIT_LEAF            112

#define TYPE_POINTER              110
#define TYPE_BIT                  109
#define TYPE_ENUM                 108
#define TYPE_UNION                107
#define TYPE_SCALAR               99
#define TYPE_REAL                 98
#define TYPE_ENTRY                97
#define TYPE_UNSINT               96
#define TYPE_SGNINT               95
#define TYPE_ARRAY                94
#define TYPE_STRUCTURE            93
#define TYPE_LIST                 92
#define TYPE_PROCEDURE            91
#define TYPE_LABLE                90
#define TYPE_WHOLE                89
#define TYPE_FPL_PROCEDURE        88
#define TYPE_VPL_PROCEDURE        87
#define TYPE_WSR_POINTER          86

#define  TYPE_ASM_NULL            0
#define  TYPE_ASM_BYTE            1
#define  TYPE_ASM_WORD            2
#define  TYPE_ASM_LONG            3
#define  TYPE_ASM_ENTRY           4
#define  TYPE_C_CHAR              5
#define  TYPE_C_INT               6
#define  TYPE_C_LONG              7
#define  TYPE_C_FLOAT             8
#define  TYPE_C_UCHAR             9
#define  TYPE_C_UINT              10
#define  TYPE_C_ULONG             11
#define  TYPE_ASM_LABEL           12

typedef enum 
{
  TRANSLATOR_ASM196,
  TRANSLATOR_PLM96,      
  TRANSLATOR_C196,
  TRANSLATOR_UNSPECIFIED = 7
} OMF96_TRANSLATOR;

typedef enum
{
  OMF96_VERSION_10,
  OMF96_RESERVED,
  OMF96_VERSION_20,
  OMF96_VERSION_31,
  OMF96_VERSION_32
} OMF96_VERSION;

typedef enum
{
  OMF96_TRANSLATOR96,
  OMF96_RL196
} OMF96_GENERATOR;

typedef enum
{
  OMF96_CODE,
  OMF96_DATA,
  OMF96_REGISTER,
  OMF96_OVERLAY,
  OMF96_DYNAMIC,
  OMF96_STACK,
  OMF96_SEG_NULL,
  OMF96_CONSTANT,
  OMF96_FAR_CODE,
  OMF96_FAR_DATA,
  OMF96_HIGH_CODE,
  OMF96_USER_STACK,
  OMF96_HEAP,
  OMF96_FAR_HEAP,
  OMF96_SEG_NULL_32,
  OMF96_FAR_CONSTANT,
  OMF96_IREGISTER,
  OMF96_IOVERLAY,
  OMF96_IDATA,
  OMF96_IFAR_DATA,
  OMF96_NC_IREGISTER,
  OMF96_NC_IOVERLAY,
  OMF96_NC_IDATA,
  OMF96_NC_IFAR_DATA,
  OMF96_NC_IABS,
  OMF96_FC_IREGISTER,
  OMF96_FC_IOVERLAY,
  OMF96_FC_IDATA,
  OMF96_FC_IFAR_DATA,
  OMF96_FC_IABS,
  OMF96_ODATA,
  OMF96_OFAR_DATA
} OMF96_SEG_TYPE;      

typedef enum
{
  TYPE_BYTE,
  TYPE_WORD,
  TYPE_LONG
} OMF96_ALIGN_TYPE;
                 
typedef enum
{
  SEG_ABSOLUTE,
  SEG_RELOCATE
} OMF96_INPUT;  

typedef enum
{
  SEG_NONBASED,
  SEG_BASED16 = 2,   
  SEG_BASED24 = 3
} OMF96_SEG_BASED_VAR;
                 
struct Segment
{
 int    segId;
 OMF96_INPUT  bFlag; //for absolute or relocate
 U16    BaseAddr;
 U16    segSize;
 OMF96_SEG_BASED_VAR    Based_Var;
 struct Segment * next;
 struct Segment * Brother;
public:
  Segment(){
  segId= -1;
  bFlag = (OMF96_INPUT)0;
  BaseAddr = 0;
  segSize = 0;      
  Based_Var = (OMF96_SEG_BASED_VAR)0;
  next=0;
  Brother = 0;
 };   
};


struct _preSymbol
{
 U16  segId;
 U16  Addr;
 U8 * name;
 U16  Type_Index;
 struct _preSymbol * next;
 
  _preSymbol(){
  segId = -1;
  name = 0;
  Type_Index = -1;
  next=0;
 };         
}; 

struct IndexList
{ 
  U16 index;
  U8  BitPos;
  U8  BitLen;
  BOOL BitFlag;
  struct IndexList * next;
public:
  IndexList(){
   next = 0;   
   BitFlag = 0;
 };
};

struct NameList
{ 
  U8 *name;
  struct NameList * next;
public:
  NameList(){
   name = 0;
   next = 0;
 };
};

struct OffsetList
{ 
  U32 Offset;
  struct OffsetList * next;
public:
  OffsetList(){
   next = 0;
 };
};
struct IndexListList
{ 
  U16 index;
  struct IndexList * m_IndexList;
  struct IndexListList *next;
public:
  IndexListList(){
   m_IndexList = 0;          
   next = 0;
 };
};

struct NameListList
{ 
  U16  index;
  struct NameList * m_NameList;
  struct NameListList *next;
public:
  NameListList(){
   m_NameList = 0;
   next = 0;
 };
};

struct OffsetListList
{ 
  U16  index;
  struct OffsetList * m_OffsetList;
  struct OffsetListList *next;
public:
  OffsetListList(){
   m_OffsetList = 0;
   next = 0;
 };
};

/////////////////////////////////////////////////////////////////////////////

class CLdrOMF96 : public CLdrSvr
{   
public:
   CLdrOMF96(LPCSTR lpsczFile , int nFlag, int where);			
// Attributes
public:
   U16 m_uCurRecLen;     
   U8  m_uKey[3];
   U16 m_nTypeIndex;
   
   struct Segment   * m_SegmentHdr;         
   struct Segment   * m_ModSeg;    
   struct IndexListList * m_IndexListHdr;
   struct NameListList  * m_NameListHdr;
   struct OffsetListList* m_OffsetListHdr;     
   struct IndexList * m_IndexList;
   struct NameList  * m_NameList;
   struct OffsetList* m_OffsetList;     
   //for filling code
public:
   OMF96_TRANSLATOR m_nTranslator;
   OMF96_GENERATOR  m_nGenerator;
   OMF96_VERSION    m_nVersion;
   OMF96_ALIGN_TYPE m_nAlignType;
   CString          m_strModuleName;   //abs
   
   CStringList      m_ModSrcFile;
   CStringList      m_strSrcFile; 
// Operations
public:
   BOOL LoadProcess();  
public:
   BOOL GetSegAttr(struct Segment*& segList);      
   BOOL ProcessTypDef();
   int  ProcessPubDef();
   BOOL GetSrcFile();  
   BOOL ProcessContent();
   int  ProcessFileLineRec();
   int  ProcessLocSym();
   BOOL ProcessExternDef();
public:                  
   void DelNameListMem(NameList* tmp);
   void InitList();
   void FindList(IndexList*& tlist,NameList*& nlist,OffsetList*& olist,U16 *index);

   BOOL GetSize(int& len, U32& size);
   BOOL GetBitSize(int& len, IndexList* list);
   BOOL GetIndex(int& len, U16& index);
   BOOL GetList(int& len);
   BOOL GetListName(int& len, U8*& name);
   BOOL AddIndexToList(int& len, U8 IndexOrBit);
   BOOL AddNameToList(int& len);
   BOOL AddOffsetToList(int& len);
   BOOL ProcessTypeStruct(int& len);
   BOOL ProcessTypeUnion(int& len);
   BOOL ProcessTypeEnum(int& len);
   BOOL ProcessTypeEntry(int& len);
   
public:
   BOOL LdrGetOMF96Module();
   BOOL GetComponentofMod();
   BOOL GetModAnsOfPrj();
   BOOL GetBlockofModAnc();
public:
   void ClearSegList(struct Segment *& list);
   BOOL GetOneRecHdr();
   U8   SegIdConvToType(U8 id); 
   void Omf96TypeConv(U16& temp);
   void Omf96SegIdToEnum(U8 segId , SEGMENTTYPE* type);
public:
   BOOL AddPointerToSym(U32 size,U16 index);
   BOOL AddArrToSym(U32 size,U16 index);
   BOOL AddStructToSym(U32 size,U32 num,U16* index,U8* name);
   BOOL AddUnionToSym(U32 size,U32 num,U16* index,U8* name);
   BOOL AddEnumToSym(U16 type,U32 num,U16* index,U8* name);
   BOOL AddProcToSym(BOOL voidflag,U16 index,U32 num,U16 *data);
   BOOL AddLocToSym(U8 segId, U16 address, U16 index, LPSTR name);
   BOOL AddPublicToSym(struct _preSymbol* sym);
// Implementation
public:
	virtual ~CLdrOMF96();
};

/////////////////////////////////////////////////////////////////////////////
