/***************************************************************************
**
**    $Header$
**
**    $Log$
** 
****************************************************************************/

// mainfrm.cpp : implementation of the CMainFrame class
//

#include "stdafx.h"
#include "ep196.h"

#include "mainfrm.h"
#include "ctl3d.h"
#include "trcpub.h"
#include "goapi.h"
// Added by Chen
#include "srcdef.h"
// Added by Annie
#include "shlinc.h"
#include "shlcom.h"

// Added by Chris
#include "uicom2.h"
#include "memdlg.h"
#include "mapdlg.h"
#include "trcgrpdi.h"
#include "trcpub.h"                

#include "savecfg.h"

#include "address.h"
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif                          

int  g_nLogoEnable;
BOOL isSaveLayoutOnExit = TRUE;
extern BOOL g_isTraceBoard;
extern ADDR_RETCODE AdrTextToAddrEx(const LPSTR  adrstr, ADDR &addr);
/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNAMIC(CMainFrame, CMDIFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CMDIFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_MESSAGE(XM_MDIACTIVE, OnXMMDIActive)
	ON_WM_CREATE()
	ON_WM_CLOSE()
	ON_UPDATE_COMMAND_UI(ID_WINDOW_CLOSEALL, OnUpdateWindowCloseall)
	ON_UPDATE_COMMAND_UI(ID_INDICATOR_OVR, OnUpdateInsert)
	ON_COMMAND(ID_WINDOW_CLOSEALL, OnWindowCloseall)
	ON_WM_RBUTTONDOWN()
	ON_COMMAND(ID_FILE_LOAD, OnFileLoad)
	ON_COMMAND(ID_WINDOW_SOURCE, OnWindowSource)
	ON_UPDATE_COMMAND_UI(ID_WINDOW_SOURCE, OnUpdateWindowSource)
	ON_UPDATE_COMMAND_UI(ID_WINDOW_BROWSE, OnUpdateWindowBrowse)
	ON_COMMAND(ID_WINDOW_BROWSE, OnWindowBrowse)
	ON_UPDATE_COMMAND_UI(ID_WINDOW_SHELL, OnUpdateWindowShell)
	ON_COMMAND(ID_WINDOW_SHELL, OnWindowShell)
	ON_COMMAND(ID_FILE_INCLUDE, OnFileInclude)
	ON_UPDATE_COMMAND_UI(ID_WINDOW_CPU, OnUpdateWindowCpu)
	ON_COMMAND(ID_WINDOW_CPU, OnWindowCpu)
	ON_UPDATE_COMMAND_UI(ID_WINDOW_MEMORY, OnUpdateWindowMemory)
	ON_COMMAND(ID_WINDOW_MEMORY, OnWindowMemory)
	ON_COMMAND(ID_GROUP_MEMORY, OnGroupMemory)
	ON_COMMAND(ID_GROUP_SOURCE, OnGroupSource)
	ON_UPDATE_COMMAND_UI(ID_FILE_BROWSEMODULE, OnUpdateFileBrowsemodule)
	ON_COMMAND(ID_FILE_BROWSEMODULE, OnFileBrowsemodule)
	ON_COMMAND(ID_RUN_BREAKPOINT, OnRunBreakpoint)
	ON_COMMAND(ID_TOGGLE_INSERT, OnToggleInsert)
	ON_UPDATE_COMMAND_UI(ID_TOGGLE_INSERT, OnUpdateToggleInsert)
	ON_WM_TIMER()
	ON_COMMAND(ID_WINDOW_TRACE, OnWindowTrace)
	ON_UPDATE_COMMAND_UI(ID_WINDOW_TRACE, OnUpdateWindowTrace)
	ON_COMMAND(ID_WINDOW_VARIABLE, OnWindowVariable)
	ON_UPDATE_COMMAND_UI(ID_WINDOW_VARIABLE, OnUpdateWindowVariable)
	ON_UPDATE_COMMAND_UI(ID_WINDOW_STACK, OnUpdateWindowStack)
	ON_COMMAND(ID_WINDOW_STACK, OnWindowStack)
	ON_COMMAND(ID_RUN_GO, OnRunGo)
	ON_UPDATE_COMMAND_UI(ID_RUN_GO, OnUpdateRunGo)
	ON_COMMAND(ID_RUN_GO_CONDITION, OnRunGoCondition)
	ON_UPDATE_COMMAND_UI(ID_RUN_GO_CONDITION, OnUpdateRunGoCondition)
	ON_COMMAND(ID_RUN_JUMP, OnRunJump)
	ON_COMMAND(ID_RUN_HALT, OnRunHalt)
	ON_UPDATE_COMMAND_UI(ID_RUN_HALT, OnUpdateRunHalt)
	ON_COMMAND(ID_RUN_RESTART, OnRunRestart)
	ON_UPDATE_COMMAND_UI(ID_RUN_RESTART, OnUpdateRunRestart)
	ON_COMMAND(ID_RUN_RESET, OnRunReset)
	ON_UPDATE_COMMAND_UI(ID_RUN_RESET, OnUpdateRunReset)
	ON_COMMAND(ID_WINDOW_PERIPHERAL, OnWindowPeripheral)
	ON_UPDATE_COMMAND_UI(ID_WINDOW_PERIPHERAL, OnUpdateWindowPeripheral)
	ON_COMMAND(ID_OPTIONS_SAVELAYOUTNOW, OnOptionsSavelayoutnow)
	ON_COMMAND(ID_OPTIONS_SAVELAYOUTONEXIT, OnOptionsSavelayoutonexit)
	ON_UPDATE_COMMAND_UI(ID_OPTIONS_SAVELAYOUTONEXIT, OnUpdateOptionsSavelayoutonexit)
	ON_COMMAND(ID_GOTO_SHELL, OnGotoShell)
	ON_COMMAND(ID_OPTIONS_MAP, OnOptionsMap)
	ON_COMMAND(ID_RUN_STEPINTO, OnRunStepinto)
	ON_COMMAND(ID_RUN_STEPINTOCONTINUOUSLY, OnRunStepintocontinuously)
	ON_COMMAND(ID_RUN_STEPOUT, OnRunStepout)
	ON_COMMAND(ID_RUN_STEPOVER, OnRunStepover)
	ON_COMMAND(ID_RUN_STEPOVERCONTINUOUSLY, OnRunStepovercontinuously)
	ON_COMMAND(ID_GROUP_TRACE, OnGroupTrace)
	ON_UPDATE_COMMAND_UI(ID_GROUP_TRACE, OnUpdateGroupTrace)
	ON_COMMAND(ID_RUN_GORUN, OnRunGorun)
	ON_COMMAND(ID_TOGGLE_TRACE, OnToggleTrace)
	ON_UPDATE_COMMAND_UI(ID_TOGGLE_TRACE, OnUpdateToggleTrace)
	ON_UPDATE_COMMAND_UI(ID_OPTIONS_MAP, OnUpdateOptionsMap)
	ON_UPDATE_COMMAND_UI(ID_GROUP_MEMORY, OnUpdateGroupMemory)
	ON_UPDATE_COMMAND_UI(ID_RUN_BREAKPOINT, OnUpdateRunBreakpoint)
	ON_UPDATE_COMMAND_UI(ID_RUN_GORUN, OnUpdateRunGorun)
	ON_UPDATE_COMMAND_UI(ID_GROUP_SOURCE, OnUpdateGroupSource)
	ON_UPDATE_COMMAND_UI(ID_RUN_JUMP, OnUpdateRunJump)
	ON_UPDATE_COMMAND_UI(ID_RUN_STEPINTO, OnUpdateRunStepinto)
	ON_UPDATE_COMMAND_UI(ID_RUN_STEPINTOCONTINUOUSLY, OnUpdateRunStepintocontinuously)
	ON_UPDATE_COMMAND_UI(ID_RUN_STEPOUT, OnUpdateRunStepout)
	ON_UPDATE_COMMAND_UI(ID_RUN_STEPOVER, OnUpdateRunStepover)
	ON_UPDATE_COMMAND_UI(ID_RUN_STEPOVERCONTINUOUSLY, OnUpdateRunStepovercontinuously)
	ON_UPDATE_COMMAND_UI(ID_FILE_LOAD, OnUpdateFileLoad)
	ON_COMMAND(ID_FILE_RESTORECONFIG, OnFileRestoreconfig)
	ON_COMMAND(ID_FILE_SAVECONFIG, OnFileSaveconfig)
	ON_COMMAND(ID_RUN_RESETANDGO, OnRunResetandgo)
	ON_UPDATE_COMMAND_UI(ID_RUN_RESETANDGO, OnUpdateRunResetandgo)
	ON_COMMAND(ID_OPTION_LOGO, OnOptionLogo)
	ON_UPDATE_COMMAND_UI(ID_OPTION_LOGO, OnUpdateOptionLogo)
	//}}AFX_MSG_MAP
	// Global help commands
	ON_COMMAND(ID_HELP_INDEX, CMDIFrameWnd::OnHelpIndex)
	ON_COMMAND(ID_HELP_USING, CMDIFrameWnd::OnHelpUsing)
	ON_COMMAND(ID_HELP, CMDIFrameWnd::OnHelp)
	ON_COMMAND(ID_CONTEXT_HELP, CMDIFrameWnd::OnContextHelp)
	ON_COMMAND(ID_DEFAULT_HELP, CMDIFrameWnd::OnHelpIndex)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction

CMainFrame::CMainFrame()
	: m_bInPrev(FALSE)
{
	// TODO: add member initialization code here
	m_nTimerID = 0; //john 96.3
}

CMainFrame::~CMainFrame()
{

}

BOOL CMainFrame::PreCreateWindow(CREATESTRUCT & cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	// Avoid to show child window caption to main frame
    if ( cs.style & FWS_ADDTOTITLE ) {
    	cs.style ^= FWS_ADDTOTITLE;
    }

    return CMDIFrameWnd::PreCreateWindow(cs);
}

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CMDIFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
    
    // create a timer john 96.3
    m_nTimerID =SetTimer(1,1000,NULL);
    if ( m_nTimerID == 0 ) {
        AfxMessageBox("No more timers!");
        return -1;
    }
    
    // Create Status Bar
	if ( !m_wndStatusBar.CreateBar(this) ) {
		TRACE("Failed to create status bar\n");
		return -1;      // fail to create
	} else {
        m_wndStatusBar.UpdateStatusBar();
        m_wndStatusBar.UpdateStatusBar(6, "0000.00s");
        m_wndStatusBar.UpdateStatusBar(2, "Halt");
    }

    // Create Tool Bar
    if ( !m_wndToolBar.CreateBar(this, IDR_MAINFRAME) ) {
        TRACE("Failed to create tool bar\n");
        return -1;
    }

	// Show title
	CString strTitle;
	strTitle.LoadString(AFX_IDS_APP_TITLE);
    SetWindowText(strTitle);

	return 0;
}

BOOL CMainFrame::PreTranslateMessage(MSG* pMsg)
{
    // TODO: Add your specialized code here and/or call the base class

    // Send WM_RBUTTONDOWN to MainFrame
    if ( WM_RBUTTONDOWN == pMsg->message ) {
        if ( !FromHandlePermanent(pMsg->hwnd) ) {
            // This window is MDICLIENT
            SendMessage(WM_RBUTTONDOWN, pMsg->wParam, pMsg->lParam);
        }
    }

	// WM_MOUSEMOVE, WM_KEYDOWN
    if ( WM_MOUSEMOVE == pMsg->message || WM_KEYDOWN == pMsg->message ) {
        ::SrcFilterMessage(pMsg);
    }

    return CMDIFrameWnd::PreTranslateMessage(pMsg);
}

void CMainFrame::OnSetPreviewMode(BOOL bPreview, CPrintPreviewState* pState)
{
	// TODO: Add your message handler code here and/or call default

	// Get preview status
	m_bInPrev = bPreview;

	CMDIFrameWnd::OnSetPreviewMode(bPreview, pState);
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CMDIFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CMDIFrameWnd::Dump(dc);
}
#endif //_DEBUG


/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers

LONG CMainFrame::OnXMMDIActive(UINT wParam, LONG lParam)
{                              
    // Delete Old Tool Bar
    m_wndToolBar.Del();   
    
    // Add New Tool Bar
    if(wParam) { 
    	m_wndToolBar.UpdateToolbar(lParam);
    } 
    else 
    	m_wndToolBar.NewMain();
    
    return 0;
}

void CMainFrame::OnClose()
{
	// TODO: Add your message handler code here and/or call default
	
	if(isSaveLayoutOnExit) SaveWindowPlacement();	    
	// Close main frame
    if ( m_bInPrev || IDYES == AfxMessageBox(IDS_PROM_EXIT, MB_YESNO) ) {
        
    	// Save Window Placement
        //if(isSaveLayoutOnExit) SaveWindowPlacement();
    
        CMDIFrameWnd::OnClose();
    }
}

void CMainFrame::OnUpdateWindowCloseall(CCmdUI* pCmdUI)
{
	// TODO: Add your command update UI handler code here
	
    // Disable when no child window opening.
    pCmdUI->Enable(MDIGetActive() != 0);
}

void CMainFrame::OnWindowCloseall()
{
	// TODO: Add your command handler code here
	
    // Close all child windows
    CMDIChildWnd * pWnd;
    while ( 0 != (pWnd = MDIGetActive()) ) {
        pWnd->SendMessage(WM_CLOSE);
    }
}

void CMainFrame::OnRButtonDown(UINT nFlags, CPoint point)
{
    // TODO: Add your message handler code here and/or call default

    // Create the local menu
    CMenu menuLocal;
    if ( menuLocal.LoadMenu(IDR_LOCAL) ) {
        CMenu* pSubMenu = menuLocal.GetSubMenu(0);
        if ( pSubMenu ) {
            ClientToScreen(&point);
            pSubMenu->TrackPopupMenu(TPM_LEFTALIGN, point.x, point.y, this);
        }
        menuLocal.DestroyMenu();
    }

    CMDIFrameWnd::OnRButtonDown(nFlags, point);
}

void CMainFrame::OnFileLoad()
{
	// TODO: Add your command handler code here

	// Open file load dialog  
	::SetCurLoadPath();
	::SrcOnFileLoad(); 
	::RestoreLastPath();
	
}

void CMainFrame::OnWindowSource() 
{
	// TODO: Add your command handler code here
	
	// Open or Close the window
	if ( !::SrcIsSourceWindowOpened() ) {
		::SrcOpenSourceWindow();
	}
	else {
		::SrcCloseSourceWindow();
	}
}

void CMainFrame::OnUpdateWindowSource(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here

	// Set check if the window opened
	if(GetCpuStatus2() != STATUS_HALT) {
		pCmdUI->Enable(FALSE);	
		return;
	}
	pCmdUI->Enable(TRUE);		
    pCmdUI->SetCheck(::SrcIsSourceWindowOpened() ? 1 : 0);
}

void CMainFrame::OnUpdateWindowBrowse(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	
	// Set check if the window opened
	if(GetCpuStatus2() != STATUS_HALT) {
		pCmdUI->Enable(FALSE);	
		return;
	}
	pCmdUI->Enable(TRUE);		
    pCmdUI->SetCheck(::SrcIsBrowseWindowOpened() ? 1 : 0);
}

void CMainFrame::OnWindowBrowse() 
{
	// TODO: Add your command handler code here
	
	// Open or Close the window
	if ( !::SrcIsBrowseWindowOpened() ) {
		::SrcOpenBrowseWindow();
	}
	else {
		::SrcCloseBrowseWindow();
	}
}

void CMainFrame::OnUpdateWindowShell(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here

	pCmdUI->SetCheck(isShellOn);	
}

void CMainFrame::OnWindowShell() 
{
	// TODO: Add your command handler code here
	
    if(!isShellOn) {
        BeginWaitCursor();
        ShlOpenWindow(this);
        EndWaitCursor();
    } else pShellWnd->SendMessage(WM_CLOSE);
}

void CMainFrame::OnFileInclude() 
{
	// TODO: Add your command handler code here
	
    CString strFilter;
    strFilter.LoadString(IDS_INC_FILTER);
    CIncludeDialog dlgInc(TRUE, NULL, "*.inc", 
        OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, strFilter);
    dlgInc.m_ofn.lpstrTitle = "Include";
    if(dlgInc.DoModal() == IDOK) {
        strIncludeFile = dlgInc.GetPathName();
        if(!isShellOn)  ShlOpenWindow(this, FALSE);
        else pShellWnd->BringWindowToTop();
		extern void ShlRunInclude(const char * pszFileName);
        ShlRunInclude(strIncludeFile);
    }
}

void CMainFrame::OnUpdateWindowCpu(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	if(GetCpuStatus2() != STATUS_HALT) {
		pCmdUI->Enable(FALSE);	
		return;
	}
	pCmdUI->Enable(TRUE);		
    pCmdUI->SetCheck(gb_isCpuOn);
}

void CMainFrame::OnWindowCpu() 
{
	// TODO: Add your command handler code here
	
	if(!gb_isCpuOn)
	{
		BeginWaitCursor();
		CpuOpenWindow(this);
		EndWaitCursor();
	}
	else
		gp_CpuWnd->SendMessage(WM_CLOSE);
}

void CMainFrame::OnUpdateWindowMemory(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	if(GetCpuStatus2() != STATUS_HALT) {
		pCmdUI->Enable(FALSE);	
		return;
	}
	pCmdUI->Enable(TRUE);		
	pCmdUI->SetCheck(gb_isMemOn[0]);
/*	unsigned char uchCpuStatus;

	if (GetCpuStatus(uchCpuStatus))
	{
		if ( 1 == uchCpuStatus )
		{       // Is on GO status (STATUS_GO)
			if (gb_isMemOn[0])
				pCmdUI->Enable(TRUE);	        
			else
				pCmdUI->Enable(FALSE);
		}
		else
			pCmdUI->Enable(TRUE);
	}
*/
}

void CMainFrame::OnWindowMemory() 
{
	// TODO: Add your command handler code here
	
	if(!gb_isMemOn[0])
	{
		BeginWaitCursor();
		NewMemoryOpenWindow(this,0);
		EndWaitCursor();
	}
	else gp_MemWnd[0]->SendMessage(WM_CLOSE);
}

void CMainFrame::OnGroupMemory() 
{
	// TODO: Add your command handler code here
	
	CMemDlg memoryDlg(this);
	memoryDlg.DoModal();
}

void CMainFrame::OnGroupSource() 
{
	// TODO: Add your command handler code here
	
	// Open LoadOption page
	::SrcOnGroup(::pageLoadOption);
}

void CMainFrame::OnUpdateFileBrowsemodule(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	
	// Check CPU status
	if (::GetCpuStatus2() != STATUS_HALT) {
		pCmdUI->Enable(FALSE);
	}
	else {
		// Grayed if no module info
		pCmdUI->Enable(::SrcIsLoadedSymbol());
	}
}

void CMainFrame::OnFileBrowsemodule() 
{
	// TODO: Add your command handler code here

	// Open BrowseModule page
	::SrcOnGroup(::pageModule);
}

void CMainFrame::OnRunBreakpoint() 
{
	// TODO: Add your command handler code here
	
	// Open Breakpoint page
	::SrcOnGroup(::pageBp);
}

/////////////////////////////////////////////////////////////////////////////
// Toggle Insert Status
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnUpdateInsert(CCmdUI* pCmdUI)
{
//    pCmdUI->Enable(!isInsertOn);
	
    pCmdUI->Enable(TRUE);
}


void CMainFrame::OnToggleInsert()
{
	// TODO: Add your command handler code here

	// Toggle INSERT/OVERWRITE in Shell window
	extern BOOL isInsertOn;
	isInsertOn = !isInsertOn;	                 
	
	// Show to status bar.
	CString strPrompt = ::isInsertOn ? "INS" : "OVR";
	m_wndStatusBar.UpdateStatusBar(8, strPrompt);
}

void CMainFrame::OnUpdateToggleInsert(CCmdUI* /*pCmdUI*/)
{
	// TODO: Add your command update UI handler code here
	
}

void CMainFrame::OnTimer(UINT nIDEvent)         
{
	// TODO: Add your message handler code here and/or call default
	
	//CMDIFrameWnd::OnTimer(nIDEvent);
	
	if ( m_nTimerID != nIDEvent) {
        CMDIFrameWnd::OnTimer(nIDEvent);
        return;
    } 
    
    //added by john 96.4    
    switch(GetCpuStatus2()) {
            case STATUS_GO : 
            case STATUS_GOMONI:
                //TRACE("GO\n"); 
                m_wndStatusBar.UpdateStatusBar(2, "Running");
                m_wndStatusBar.UpdateStatusBar(6, "........");
                break;
            case STATUS_GORUN : 
                //TRACE("GORUN\n");
                m_wndStatusBar.UpdateStatusBar(2, "Running");
                m_wndStatusBar.UpdateStatusBar(6, "........");
                break;
            case STATUS_GOFLY : 
                //TRACE("GOFLY\n");
                m_wndStatusBar.UpdateStatusBar(2, "Running");
                m_wndStatusBar.UpdateStatusBar(6, "........");
                break;
            case STATUS_HALT : 
                //TRACE("HALT\n");
                m_wndStatusBar.UpdateStatusBar(2, "Halt");
                break;    
            case STATUS_SLEEPING :
                m_wndStatusBar.UpdateStatusBar(2, "Sleeping");
                break;   
            case STATUS_POWERDOWN :
            	m_wndStatusBar.UpdateStatusBar(2, "PowerDown");
            	break;
            case STATUS_IDLE :
            	m_wndStatusBar.UpdateStatusBar(2, "Idle");	
        }
    
    if(g_isTraceBoard) {
	    BYTE TT = GetTraceOn();
	    if ( GetTraceOn() == 1 ) {
	        m_wndStatusBar.UpdateStatusBar(4, "Trace On");
	    }
	    else {
	        m_wndStatusBar.UpdateStatusBar(4, "Trace Off");
	    }
    } else {
    	m_wndStatusBar.UpdateStatusBar(4, "No Trace");
    }
    if(GetCpuStatus2() == STATUS_HALT) return;
// Modified by Gates Hua    
//    if(GetXviewAppJohn()->m_nCpuStatus == STATUS_SLEEPING) return;
    if(GetCpuStatus2() == STATUS_GOMONI) return;
    if(!GetCanTimer()) return; //the abi communication is on
    BYTE bCpuStatus;             
    
    SetCanTimer(FALSE);      
    
    if (!GetCpuStatus(bCpuStatus)) return;
    
    if (STATUS_GO == bCpuStatus) {   
    	SetCpuStatus2(bCpuStatus);
    } else {
    	SetCpuStatus2(bCpuStatus);
        TraceWnd(0); //TRACE off 
        RepaintWindows();   
        RefreshTraceWnd();
        
    }
    
    SetCanTimer(TRUE); 
    
}

void CMainFrame::OnWindowTrace()
{
	// TODO: Add your command handler code here
extern void TrcOpenWindow(CMDIFrameWnd * pParent);

	if(!gb_isTraceOn)
	{
		BeginWaitCursor();
		TrcOpenWindow(this);
		EndWaitCursor();
	}
	else
		gp_TraceWnd->SendMessage(WM_CLOSE);
}

void CMainFrame::OnUpdateWindowTrace(CCmdUI* pCmdUI)
{
	// TODO: Add your command update UI handler code here
	pCmdUI->Enable(g_isTraceBoard);	
	if(g_isTraceBoard)
		pCmdUI->SetCheck(gb_isTraceOn);
}

extern BOOL isVariableOn;               
extern BOOL isStackOn;               
extern void VarOpenWindow(CMDIFrameWnd* /* pParent */);
extern void VarCloseWindow(void);
extern void StkOpenWindow(CMDIFrameWnd* /* pParent */);
extern void StkCloseWindow(void);

void CMainFrame::OnWindowVariable()
{
	// TODO: Add your command handler code here
	if(!isVariableOn) {
        BeginWaitCursor();
        VarOpenWindow(this);
        EndWaitCursor();
    } else VarCloseWindow();
	
}

void CMainFrame::OnUpdateWindowVariable(CCmdUI* pCmdUI)
{
	// TODO: Add your command update UI handler code here  
	if(GetCpuStatus2() != STATUS_HALT) {
		pCmdUI->Enable(FALSE);	
		return;
	}
	pCmdUI->Enable(TRUE);		
	pCmdUI->SetCheck(isVariableOn);
	
}

void CMainFrame::OnUpdateWindowStack(CCmdUI* pCmdUI)
{
	// TODO: Add your command update UI handler code here    
	if(GetCpuStatus2() != STATUS_HALT) {
		pCmdUI->Enable(FALSE);	
		return;
	}
	pCmdUI->Enable(TRUE);		
	pCmdUI->SetCheck(isStackOn);	
}

void CMainFrame::OnWindowStack()
{
	// TODO: Add your command handler code here
	if(!isStackOn) {
        BeginWaitCursor();
        StkOpenWindow(this);
        EndWaitCursor();
    } else StkCloseWindow();
	
}

void CMainFrame::OnRunGo()
{
	// TODO: Add your command handler code here
	BeginWaitCursor();
    //::MinAllMemWnd(); 
    ADDR tmpAddr;
    tmpAddr.addr = 0;
    tmpAddr.addrType = MEM_P0;
    EmuServerGo(1, tmpAddr);
    EndWaitCursor();
    //OnEmulation();                        
	
}

void CMainFrame::OnUpdateRunGo(CCmdUI* pCmdUI)
{
	// TODO: Add your command update UI handler code here
	if(GetCpuStatus2() != STATUS_HALT) {
		pCmdUI->Enable(FALSE);	
		return;
	}
	pCmdUI->Enable(TRUE);	
	
}
#include "emumon.h"
void CMainFrame::OnRunGoCondition()
{
	// TODO: Add your command handler code here 
	
	// Open Go Monitor dialog.
    CGoMonitorDlg* dlg = new CGoMonitorDlg;
    ASSERT (dlg != NULL);
    if ( IDOK == dlg->DoModal() ) {
    	ADDR addr;
    	addr.addr = (unsigned short)dlg->m_nCount;
        ::EmuServerGo(8, addr);
    }        
    if (dlg != NULL) delete dlg;
	
}

void CMainFrame::OnUpdateRunGoCondition(CCmdUI* pCmdUI)
{
	// TODO: Add your command update UI handler code here   
	if(GetCpuStatus2() != STATUS_HALT) {
		pCmdUI->Enable(FALSE);	
		return;
	}
	pCmdUI->Enable(TRUE);	
	
}

void CMainFrame::OnRunHalt()
{
	// TODO: Add your command handler code here
	EmuServerHalt();
    OnEmulation();    
    RefreshTraceWnd();
}

void CMainFrame::OnUpdateRunHalt(CCmdUI* pCmdUI)
{
	// TODO: Add your command update UI handler code here
	
}

void CMainFrame::OnRunRestart()
{
	// TODO: Add your command handler code here
	if(AfxMessageBox("Confirm restart operation?", MB_YESNO|MB_ICONQUESTION)
        == IDNO)    
        return;
        
    BeginWaitCursor();

    DoReset();
    ADDR addr;
    ADDR_RETCODE nAddrRet = AdrTextToAddrEx("#main",addr);            
	if (ADR_OK != nAddrRet) {
		OnEmulation();	
		return;
	}	
	if (addr.addrType > MEM_P3 || addr.addrType<MEM_P0) {
		ASSERT(FALSE);            
		OnEmulation();	
		return;
	}
    
    EmuServerGo(3, addr); //go till #main

    EndWaitCursor();    
    OnEmulation();	         
    
    RefreshTraceWnd();
	
}

void CMainFrame::OnUpdateRunRestart(CCmdUI* pCmdUI)
{
	// TODO: Add your command update UI handler code here
	
}

void CMainFrame::OnRunReset()
{
	// TODO: Add your command handler code here
	if(AfxMessageBox("Confirm reset operation?", MB_YESNO|MB_ICONQUESTION) == IDNO)    
    return;
	        
    BeginWaitCursor();
    DoReset();
    EndWaitCursor();
    OnEmulation();
}

void CMainFrame::OnUpdateRunReset(CCmdUI* pCmdUI)
{
	// TODO: Add your command update UI handler code here
	
}

void CMainFrame::OnWindowPeripheral()
{
	// TODO: Add your command handler code here
	if(!gb_isPeriOn) {
        BeginWaitCursor();
        PeriOpenWindow(this);
        EndWaitCursor();
    } else gp_PeriWnd->PostMessage(WM_CLOSE);
}

void CMainFrame::OnUpdateWindowPeripheral(CCmdUI* pCmdUI)
{
	// TODO: Add your command update UI handler code here     
	if(GetCpuStatus2() != STATUS_HALT) {
		pCmdUI->Enable(FALSE);	
		return;
	}
	pCmdUI->Enable(TRUE);		
	pCmdUI->SetCheck(gb_isPeriOn);
}

void CMainFrame::OnOptionsSavelayoutnow()
{
	// TODO: Add your command handler code here
		SaveWindowPlacement();	
}

void CMainFrame::OnOptionsSavelayoutonexit()
{
	// TODO: Add your command handler code here
	isSaveLayoutOnExit = isSaveLayoutOnExit ? FALSE : TRUE;	
}

void CMainFrame::OnUpdateOptionsSavelayoutonexit(CCmdUI* pCmdUI)
{
	// TODO: Add your command update UI handler code here
	pCmdUI->SetCheck(isSaveLayoutOnExit);  	
}
           
void ShellShowTop(void);
           
void CMainFrame::OnGotoShell()
{
	// TODO: Add your command handler code here
	ShellShowTop(); 	
}

void CMainFrame::OnOptionsMap()
{
	// TODO: Add your command handler code here     
    HINSTANCE hLib;
    if ( (hLib = LoadLibrary("MUSCROLL.DLL")) < HINSTANCE_ERROR ) {
        AfxMessageBox("MUSCROLL.DLL loading error.");
        // ::ErrGetErrorText(....);
        return;
    }
    
    CMapDlg dlg;
    dlg.DoModal();
    
    if ( hLib >= HINSTANCE_ERROR ) FreeLibrary(hLib);
}

void CMainFrame::OnRunJump()
{
	// TODO: Add your command handler code here
	
	// Open Jump dialog
	::SrcOnRunJump();

	// Update other windows
	::RepaintCPU();
	::RepaintMemory();
	::RepaintStack();
	::RepaintVariable();
	::RepaintPeri();
}

void CMainFrame::OnRunStepinto() 
{
	// TODO: Add your command handler code here
	
	// Step into
	::StepServer(::step);
}

void CMainFrame::OnRunStepintocontinuously() 
{
	// TODO: Add your command handler code here
	
	// Step continuously
	::StepServer(::stepForever);
}

void CMainFrame::OnRunStepout() 
{
	// TODO: Add your command handler code here

	// Step out
	::StepServer(::stepOut);
}

void CMainFrame::OnRunStepover() 
{
	// TODO: Add your command handler code here

	// Step over
	::StepServer(::stepOver);
}

void CMainFrame::OnRunStepovercontinuously() 
{
	// TODO: Add your command handler code here

	// Step over continuously
	::StepServer(::stepOverForever);
}

void CMainFrame::OnGroupTrace()
{
	// TODO: Add your command handler code here
	CTraceGroupDialog dlg(this);
	dlg.DoModal();
	if(dlg.m_bDisplayChange){
		MSG msg;
		while (PeekMessage(&msg, dlg.m_hWnd, 0, 0, PM_REMOVE)) {
		    TranslateMessage(&msg);
		    DispatchMessage(&msg);
		}

		SendMessage(WM_COMMAND,ID_VIEW_REFRESH, NULL);
	}
}

void CMainFrame::OnUpdateGroupTrace(CCmdUI* pCmdUI)
{
	// TODO: Add your command update UI handler code here
	if(g_isTraceBoard) {
		pCmdUI->Enable(g_isTraceBoard);	          
		return;
	}	
	if(GetCpuStatus2() != STATUS_HALT) {
		pCmdUI->Enable(FALSE);	
		return;
	}
	pCmdUI->Enable(TRUE);	
//	if(g_isTraceBoard)
//		pCmdUI->SetCheck(gb_isTraceOn);
}

void CMainFrame::OnRunGorun()
{
	// TODO: Add your command handler code here
	BeginWaitCursor();

    DoReset();
    ADDR addr;
    addr.addrType = MEM_UNDEFINED;
    EmuServerGo(7, addr); //go till #main

    EndWaitCursor();

    //OnEmulation();		
}

void CMainFrame::OnToggleTrace()
{
	// TODO: Add your command handler code here  
	STATUS retSvr;
	BOOL trcData;

	if(!TS_GetTraceOnGo(trcData))
		return;
	TS_SetTraceOnGo(!trcData);
	
	
}

void CMainFrame::OnUpdateToggleTrace(CCmdUI* pCmdUI)
{
	// TODO: Add your command update UI handler code here
	BOOL trcData;

	if (!g_isTraceBoard)
	{
		pCmdUI->Enable(FALSE);
		return;   
	}
		
	if(!TS_GetTraceOnGo(trcData))
		return;
	pCmdUI->SetCheck(trcData);
	
}

void CMainFrame::OnUpdateOptionsMap(CCmdUI* pCmdUI)
{
	// TODO: Add your command update UI handler code here   
	if(GetCpuStatus2() != STATUS_HALT) {
		pCmdUI->Enable(FALSE);	
		return;
	}
	pCmdUI->Enable(TRUE);	
	
}

void CMainFrame::OnUpdateGroupMemory(CCmdUI* pCmdUI)
{
	// TODO: Add your command update UI handler code here
	if(GetCpuStatus2() != STATUS_HALT) {
		pCmdUI->Enable(FALSE);	
		return;
	}
	pCmdUI->Enable(TRUE);	
}

void CMainFrame::OnUpdateRunBreakpoint(CCmdUI* pCmdUI)
{
	// TODO: Add your command update UI handler code here
	if(GetCpuStatus2() != STATUS_HALT) {
		pCmdUI->Enable(FALSE);	
		return;
	}
	pCmdUI->Enable(TRUE);	
	
}

void CMainFrame::OnUpdateRunGorun(CCmdUI* pCmdUI)
{
	// TODO: Add your command update UI handler code here
	if(GetCpuStatus2() != STATUS_HALT) {
		pCmdUI->Enable(FALSE);	
		return;
	}
	pCmdUI->Enable(TRUE);	
	
}

void CMainFrame::OnUpdateGroupSource(CCmdUI* pCmdUI)
{
	// TODO: Add your command update UI handler code here

	// Check CPU status
	if(!g_isTraceBoard) {
		pCmdUI->Enable(FALSE);
		return;	
	}	
	pCmdUI->Enable(::GetCpuStatus2() == STATUS_HALT);
}

void CMainFrame::OnUpdateRunJump(CCmdUI* pCmdUI)
{
	// TODO: Add your command update UI handler code here
	
	// Check CPU status
	pCmdUI->Enable(::GetCpuStatus2() == STATUS_HALT);
}

void CMainFrame::OnUpdateRunStepinto(CCmdUI* pCmdUI)
{
	// TODO: Add your command update UI handler code here
	
	// Check CPU status
	pCmdUI->Enable(::GetCpuStatus2() == STATUS_HALT);
}

void CMainFrame::OnUpdateRunStepintocontinuously(CCmdUI* pCmdUI)
{
	// TODO: Add your command update UI handler code here
	
	// Check CPU status
	pCmdUI->Enable(::GetCpuStatus2() == STATUS_HALT);
}

void CMainFrame::OnUpdateRunStepout(CCmdUI* pCmdUI)
{
	// TODO: Add your command update UI handler code here
	
	// Check CPU status
	pCmdUI->Enable(::GetCpuStatus2() == STATUS_HALT);
}

void CMainFrame::OnUpdateRunStepover(CCmdUI* pCmdUI)
{
	// TODO: Add your command update UI handler code here
	
	// Check CPU status
	pCmdUI->Enable(::GetCpuStatus2() == STATUS_HALT);
}

void CMainFrame::OnUpdateRunStepovercontinuously(CCmdUI* pCmdUI)
{
	// TODO: Add your command update UI handler code here
	
	// Check CPU status
	pCmdUI->Enable(::GetCpuStatus2() == STATUS_HALT);
}

void CMainFrame::OnUpdateFileLoad(CCmdUI* pCmdUI)
{
	// TODO: Add your command update UI handler code here
	
	// Check CPU status
	pCmdUI->Enable(::GetCpuStatus2() == STATUS_HALT);
}

void CMainFrame::OnFileRestoreconfig()
{
	// TODO: Add your command handler code here
    WORD i;
    
    CSavecfgDialog dlgCfg(FALSE);
    i = 0;
    if(dlgCfg.DoModal() == IDOK) {
        i = 0;
        CString str = dlgCfg.GetPathName();
        if(dlgCfg.m_nMap)       i |= STORE_MAP;
        if(dlgCfg.m_nEvent)     i |= STORE_EVENT;
        if(dlgCfg.m_nQualify)   i |= STORE_QUALIFY;
        BeginWaitCursor();
        RestoreConfig(str,i);
        EndWaitCursor();
    }    
	
}

void CMainFrame::OnFileSaveconfig()
{
	// TODO: Add your command handler code here
    WORD i;
    
    CSavecfgDialog dlgCfg(TRUE);
    i = 0;        
    
    if(dlgCfg.DoModal() == IDOK) {
        CString str = dlgCfg.GetPathName();
        if(dlgCfg.m_nMap)       i |= STORE_MAP;
        if(dlgCfg.m_nEvent)     i |= STORE_EVENT;
        if(dlgCfg.m_nQualify)   i |= STORE_QUALIFY;
        BeginWaitCursor();
        SaveConfig(str,i);
        EndWaitCursor();
    }
}

void CMainFrame::OnRunResetandgo()
{
	// TODO: Add your command handler code here
	if(AfxMessageBox("Confirm reset and go operation?", MB_YESNO|MB_ICONQUESTION) == IDNO)    
    return;
	        
    BeginWaitCursor();

    DoReset();             

    ADDR tmpAddr;
    tmpAddr.addr = 0;
    tmpAddr.addrType = MEM_P0;
    EmuServerGo(1, tmpAddr);

    EndWaitCursor();
    OnEmulation();
	
}

void CMainFrame::OnUpdateRunResetandgo(CCmdUI* pCmdUI)
{
	// TODO: Add your command update UI handler code here
	
}

void CMainFrame::OnOptionLogo()
{
	// TODO: Add your command handler code here
	g_nLogoEnable = g_nLogoEnable==0? 1 : 0;	
}

void CMainFrame::OnUpdateOptionLogo(CCmdUI* pCmdUI)
{
	// TODO: Add your command update UI handler code here
	
	pCmdUI->SetCheck(g_nLogoEnable != 0);
}
