#include "stdafx.h"

typedef struct comtag{
    char* pszCommandName;
    BYTE nMinKeyword;
    char* pszHints;
} tagComTable;

typedef struct roottag{
    char* pszCommandName;
    BYTE nMinKeyword;
} tagRootTable;
              
tagComTable ComTable[] = {
    {"@",1,"macroname [(arg0,...,arg9)]"},
    {"$",1,"variable [= value]"},
    {"ALias",2,"[original_name new_name]"},
    {"Assemble",1,"[adr]"},
    //{"BIt",2,"bit_adr data1 [..data32]"},
    {"Breakpoint",1,"[adr]"},
    {"BYte",2,"adr data1 [..data32]"},
    {"CHecksum",2,"adr1 {adr2|Length length}"},
    {"CLear",2,"{ALl|adr}"},
    {"COMpare",3,"adr1 {adr2|Length length} adr3"},
    {"CONtrol",3,"[{Reset|Nmi}{Enable|Disable}]"},
    {"Copy",1,"adr1 {adr2|Length length} adr3"},
    {"CReate",2,"#symbol adr"},
    //{"CYcle",2,""},
    {"DElete",2,"#symbol|$variable|All"},
    {"Disassemble",1,"[adr1 [adr2|Length length]]"},
    {"EV1",3,"[[Address {Range adr1 adr2|xadr|<badrs..>}][DATum Byte|Word {Range data1 data2|xdata|bdata}][COunt count]]|[Clear]"},
    {"EV2",3,"[[Address {Range adr1 adr2|xadr|<badrs..>}][DATum Byte|Word {Range data1 data2|xdata|bdata}]]|[Clear]"},
    {"EV3",3,"[High|Low]"},
    {"Event",1,"[1|2|3|Clear]"},
    {"Fill",1,"adr1 {adr2|Length length} {\"string\"|data..}"},
    {"Go",1,"[[Run][From adr1]|[From adr1][Till adr2]|[Monitor timer]]"},
    {"HAlt",2,""},
    {"Help",1,"[command]"},
    {"IDentify",2,""},
    {"Include",1,"filename"},
    {"INPort",3,"port [BIt bit_no|Byte]"},
    {"Jump",1,"adr"},
    {"LEvel",2,"[{1|2} [eventlogic]]"},
    {"List",1,"[Number]|[[frame][Address {Range adr1 adr2|xadr|<badrs..>}][DATum Byte|Word {Range data1 data2|xdata|bdata}][STatus <status..>]]"},
    {"LOad",2,"filename [Symbols|NOSymbols] [Code|NOCode] [Warn|NOWarn][SYStem|NOSYStem][P0|P1|P2|P3|X0|X1]"},
    {"LOG",3,"{filename [Command] [Append]}|{On|OFf|CLose}"},
    {"LONg",3,"adr data1 [..data8]"},
    {"LV1",3,"[eventlogic]"},
    {"LV2",3,"[eventlogic]"},
    {"MACro",3,"macroname"},
    {"MAp",2,"[{ALl adrtype}|{adr1 {adr2|Length length}} map_attribute]"},
    {"MDel",2,"macroname|ALL"},
    {"Memory",1,"adr1 [adr2|Length length]"},
    {"MENd",3,""},
    {"MList",2,"[macroname]"},
    {"Outport",1,"port data"},
    //{"Port",1,"port"},
    {"Qualify",1,"[[Address {Range adr1 adr2|xadr|<badrs..>}][DATum Byte|Word {Range data1 data2|xdata|bdata}][Status <status..>]]|[Clear]"},
    {"QUEry",3,"#symbol|hex_adr"},
    {"Register",1,"[{reg_id} [data]]"},
    {"RESet",3,"[adr]"},
    {"RESTart",4,""},
    {"SEarch",2,"adr1 {adr2|Length length} {[Insensitive] \"string\"|data..}"},
    {"SRecall",2,"filename"},
    {"SSave",2,"filename"},
    {"Step",1,"[[Over] [Forever]]|[OUt]"},
    {"SYmbol",2,"[Global|Module|#module|Lines]"},
    {"TEst",2,"adr1 {adr2|Length length}"},
    {"TRAce",3,"[On|OFf|Clear]"},
    {"Trigger",1,"[[Run] {LV1 | LV2 | LV1 Then LV2}[Forward|Backward|Center|Delay count]]|[On|OFf]"},
    {"Upload",1,"adr1 {adr2|Length length} filename"},
    {"Verify",1,"[On|OFf]"},
    {"WAtch",2,"\"C-Expression\""},
    {"Word",1,"adr data1 [..data16]"}};
 
 
int ParaNum[] = {
    0,    //run macro
    0,    //define variable
    0,    //Alias
    0,    //Assemble
    //0,    //Bit
    0,    //Breakpoint
    0,    //Byte
    1,    //Checksum
    1,    //Clear
    1,    //Compare
    4,    //Control
    1,    //Copy
    0,    //Create
    //0,    //Cycle
    1,    //Delete
    1,    //Disassemble
    7,    //EV1
    6,    //EV2 
    2, 	  //EV3
    1,    //Event          
    1,    //Fill
    4,    //Go
    0,    //Halt
    0,    //Help
    0,    //Identify
    0,    //Include
    2,    //Inport
    0,    //Jump
    2,	  //Level	
    7,    //List
    8,    //Load
    5,    //Log
    0,    //Long
    2,	  //Lv1  	
    2,	  //Lv2    
    0,    //Macro
    6,    //Map
    1,    //Mdel
    1,    //Memory
    0,    //Mend
    0,    //Mlist
    0,    //Outport
    //0,    //Port
    7,    //Qualify  
    0,    //Query
    0,    //Register
    0,    //Reset    
    0,    //Restart
    2,    //Search
    0,    //Srecall
    0,    //SSave
    3,    //Step
    3,    //Symbol
    1,    //Test
    3,    //Trace
    8,    //Trigger
    1,    //Upload
    2,    //Verify
    0,    //Watch
    0     //Word
    };
    
    
tagRootTable ParaTable[] = {
    { "Length", 1 },     //Checksum
    { "ALl", 2 },        //Clear
    { "Length", 1},      //Compare
    { "Reset", 1 },      //Control
    { "Nmi", 1},         //Control    
    { "Enable", 1},      //Control
    { "Disable", 1},     //Control
    { "Length", 1},      //Copy
    { "All", 1},         //Delete
    { "Length", 1},      //Disassemble
    { "Address", 1},	 //Ev1
    { "Range", 1},		 //Ev1
    { "DATum", 3},		 //Ev1  
    { "Byte", 1},		 //Ev1
    { "Word", 1},		 //Ev1    
    { "COunt", 2},       //Ev1
    { "Clear", 1},		 //Ev1
    { "Address", 1},	 //Ev2
    { "Range", 1},		 //Ev2
    { "DATum", 3},		 //Ev2  
    { "Byte", 1},		 //Ev2
    { "Word", 1},		 //Ev2    
    { "Clear", 1},		 //Ev2
    { "High", 1},		 //Ev3
    { "Low", 1},		 //Ev3
    { "Clear", 1},       //Event		
    { "Length", 1},      //Fill
    { "Run", 1},         //Go
    { "From", 1},        //Go
    { "Till", 1},        //Go
    { "Monitor", 1},     //Go
    { "BIt", 2},         //Inport
    { "Byte", 1},        //Inport              
    { "And", 1},         //Level           
    { "Or", 1}, 		 //Level
    { "Number", 1},		 //List
    { "Address", 1},     //List
    { "Range", 1},       //List
    { "DATum", 3},       //List
    { "Byte", 1},		 //List
    { "Word", 1},		 //List   
    { "Status", 1},      //List    
    { "Symbols",1},      //Load
    { "NOSymbols",3},    //Load
    { "Code",1},         //Load
    { "NOCode",3},       //Load
    { "Warn", 1},        //Load
    { "NOWarn", 3},      //Load
    { "SYStem", 3},		 //Load	
    { "NOSYStem", 5},	 //Load
    { "Command",1},      //Log
    { "Append", 1},      //Log
    { "On", 1},          //Log
    { "OFf", 2},         //Log
    { "CLose", 2},       //Log 
    { "And", 1},         //Lv1           
    { "Or", 1}, 		 //Lv1
    { "And", 1},         //Lv2           
    { "Or", 1}, 		 //Lv2
    { "ALl", 2},         //Map
    { "Length",1},       //Map
    { "Overlay",1},	     //Map
//    { "OR",2},			 //Map
//    { "Guard",1},        //Map
//    { "Target",1},       //Map
	{ "Target", 1},		 //Map   
	{ "COmbination", 2}, //Map
	{ "Separation", 1},  //Map
    { "ALL", 3},         //Mdel
    { "Length", 1},      //Memory    
    { "Address", 1},	 //Qualify
    { "Range", 1},		 //Qualify
    { "DATum", 3},		 //Qualify
    { "Byte", 1},		 //Qualify
    { "Word", 1},		 //Qualify
    { "Status", 1},      //Qualify
    { "Clear", 1},		 //Qualify
    { "Length", 1},      //Search
    { "Insensitive",1},  //Search
    { "Over", 1},        //Step
    { "Forever",1},      //Step
    { "OUt", 2},         //Step
    { "Global", 1},      //Symbol
    { "Module", 1},      //Symbol
    { "Lines", 1},       //Symbol
    { "Length", 1},      //Test
    { "On", 1},			 //Trace
    { "OFf", 2}, 		 //Trace
    { "Clear", 1},       //Trace
    { "Run", 1},         //Trigger
    { "Then", 1},        //Trigger
    { "Forward", 1},     //Trigger
    { "Backward", 1},    //Trigger
    { "Center", 1},      //Trigger
    { "Delay", 1},       //Trigger
    { "On", 1},          //Trigger
    { "OFf", 2},         //Trigger		
    { "Length", 1},      //Upload
    { "On",1},           //Verify
    { "OFf",2}           //Verify
    };
    
// below are hiden command table .    
tagComTable HiddenComTable[] = {   
    {"!DIAGNOSTICS",12,"[[Pio] [Map] [EVentaddr] [EVENTData] [Spoon] [Emulation] [Trace] ]"}
    };            
    
int HiddenParaNum[] = {    
        7 };                

tagRootTable HiddenParaTable[] = {
    { "Pio", 1},
    { "Map", 1},
    { "EVentaddr", 2},
    { "EVENTData", 6},
    { "Spoon", 1},
    { "Emulation", 1},
    { "Trace", 1}
    };
    
    
    
 
