/***************************************************************************
**
**    $Header$
**
**    $Log$
** 
****************************************************************************/

#include "stdafx.h"
#include "mapbtn.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

COLORREF PaletteIndex[16] = {
  RGB(0,0,0),         //0
  RGB(255,255,255),   //1
  RGB(255,0,0),       //2
  RGB(0,255,0),       //3
  RGB(0,0,255),       //4
  RGB(255,255,0),     //5
  RGB(255,0,255),     //6
  RGB(0,255,255),     //7
  RGB(128,128,128),   //8
  RGB(192,192,192),   //9
  RGB(128,0,0),       //10
  RGB(0,128,0),       //11
  RGB(0,0,128),       //12
  RGB(128,128,0),     //13
  RGB(128,0,128),     //14
  RGB(0,128,128)      //15
};

CMapColorBtn::CMapColorBtn(int nColorIndex, LPCSTR lpString/*=NULL*/)
{          
  if(lpString)
     m_string=lpString;
  else       
     m_string.Empty();
  m_bHighlight=0;   
  m_nColorIndex=nColorIndex;   
}

CMapColorBtn::CMapColorBtn()
{

}

CMapColorBtn::~CMapColorBtn()
{

}

BEGIN_MESSAGE_MAP(CMapColorBtn, CButton)
   //{{AFX_MSG_MAP(CMapColorBtn)
   //}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMapColorBtn message handlers

void CMapColorBtn::SetColor(int nColorIndex)
{
  m_bHighlight=0;   
  m_nColorIndex=nColorIndex;   
}

void CMapColorBtn::SetBtnTitle(LPCSTR lpString)
{
  if(lpString)
     m_string=lpString;
  else       
     m_string.Empty();
}

void CMapColorBtn::DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct)
{
   // TODO: Add your message handler code here and/or call default
   
   LPDRAWITEMSTRUCT pDrawItem=lpDrawItemStruct;
   CDC *pDC=CDC::FromHandle(pDrawItem->hDC);
   if(m_string.IsEmpty()) {
      CBrush FillBrush(PaletteIndex[m_nColorIndex]);
      DrawColorBtn(pDC, pDrawItem);  
      pDC->FillRect(&pDrawItem->rcItem, &FillBrush);
   }
   else {
     CRect rect(&pDrawItem->rcItem);                    
     rect.left +=4;             
     rect.right -= 2;
     rect.top += 4;
     rect.bottom -= 2;
     pDrawItem->rcItem.left -= 2;
     pDrawItem->rcItem.right += 2;
     pDrawItem->rcItem.top -= 2;
     pDrawItem->rcItem.bottom += 2;
     DrawDownFrame(pDC, &pDrawItem->rcItem);
     
     pDC->SetBkColor(PaletteIndex[m_nColorIndex]);
     pDC->SetTextColor(PaletteIndex[0]);
     CBrush brush(PaletteIndex[m_nColorIndex]);
     pDC->FillRect(&rect,&brush);
     pDC->DrawText(m_string, m_string.GetLength(), 
                   &rect, DT_CENTER|DT_VCENTER);
   }
}

void CMapColorBtn::DrawColorBtn(CDC *pDC,LPDRAWITEMSTRUCT pDrawItem)
{                
  if(pDrawItem->itemAction&(ODA_FOCUS)) {
    CBrush brush;      
    if(pDrawItem->itemState&(ODS_FOCUS))
       brush.CreateSolidBrush(RGB(0,0,0));
    else             
       brush.CreateSolidBrush(GetSysColor(COLOR_BTNFACE));

    pDC->FrameRect(&pDrawItem->rcItem, &brush);  
    pDrawItem->rcItem.left += 1;
    pDrawItem->rcItem.right -= 1;  
    pDrawItem->rcItem.top += 1;
    pDrawItem->rcItem.bottom -= 1;  
    pDC->FrameRect(&pDrawItem->rcItem, &brush);  
    
    brush.DeleteObject();
    pDrawItem->rcItem.left += 3;
    pDrawItem->rcItem.right -= 3;  
    pDrawItem->rcItem.top += 3;
    pDrawItem->rcItem.bottom -= 3;  
  }
  else if(m_bHighlight)
      DrawDownFrame(pDC, &pDrawItem->rcItem);
  else                                      
      DrawUpFrame(pDC, &pDrawItem->rcItem);
}

void  CMapColorBtn::DrawDownFrame(CDC *pDC, LPRECT pRect)
{                        
  CRect rect=*pRect;
  HBRUSH hWFrame  = CreateSolidBrush(RGB(255, 255, 255));
  HBRUSH hWGFrame = CreateSolidBrush(RGB(192, 192, 192));
  HBRUSH hGFrame  = CreateSolidBrush(RGB(128, 128, 128));
  HBRUSH hBFrame  = CreateSolidBrush(RGB(0, 0, 0));
            
  HGDIOBJ hOldBrush = pDC->SelectObject(hGFrame);
//white            
  if (hWFrame != NULL) {
    pDC->PatBlt(0+2, 0+2, rect.right-4, 1, PATCOPY);
    pDC->PatBlt(0+2, 0+2, 1, rect.bottom-4, PATCOPY);
  }                    
  
//b
  if (hBFrame != NULL) {
    pDC->SelectObject(hBFrame);
    pDC->PatBlt(1+2, 1+2, rect.right-6, 1, PATCOPY);
    pDC->PatBlt(1+2, 1+2, 1, rect.bottom-6, PATCOPY);
  }

//WG
  if (hGFrame != NULL) {
    pDC->SelectObject(hWGFrame);
    pDC->PatBlt(1+2, rect.bottom-2-2, rect.right-2-4, 1, PATCOPY);
    pDC->PatBlt(rect.right-2-2, 1+2, 1, rect.bottom-2-4, PATCOPY);
  }                            
  
//W
  if (hWFrame != NULL) {
    pDC->SelectObject(hWFrame);
    pDC->PatBlt(0+2, rect.bottom-1-2, rect.right-4, 1, PATCOPY);
    pDC->PatBlt(rect.right-1-2, 0+2, 1, rect.bottom-4, PATCOPY);
  }                            
  
  pRect->left += 4;
  pRect->right -= 4;  
  pRect->top += 4;
  pRect->bottom -= 4;  
  
  pDC->SelectObject(hOldBrush);
  DeleteObject(hWFrame);
  DeleteObject(hWGFrame);
  DeleteObject(hGFrame);
  DeleteObject(hBFrame);
}

void  CMapColorBtn::DrawUpFrame(CDC *pDC, LPRECT pRect)
{                                                 
  CRect rect=*pRect;
  HBRUSH hWFrame  = CreateSolidBrush(RGB(255, 255, 255));
  HBRUSH hWGFrame = CreateSolidBrush(RGB(192, 192, 192));
  HBRUSH hGFrame  = CreateSolidBrush(RGB(128, 128, 128));
  HBRUSH hBFrame  = CreateSolidBrush(RGB(0, 0, 0));
            
  HGDIOBJ hOldBrush = pDC->SelectObject(hWFrame);
//white            
  if (hWFrame != NULL) {
    pDC->PatBlt(0+2, 0+2, rect.right-4, 1, PATCOPY);
    pDC->PatBlt(0+2, 0+2, 1, rect.bottom-4, PATCOPY);
  }
//LG
  if (hWGFrame != NULL) {
    pDC->SelectObject(hWGFrame);
    pDC->PatBlt(1+2, 1+2, rect.right-2-4, 1, PATCOPY);
    pDC->PatBlt(1+2, 1+2, 1, rect.bottom-2-4, PATCOPY);
  }
    
//G
  if (hGFrame != NULL) {
    pDC->SelectObject(hGFrame);
    pDC->PatBlt(1+2, rect.bottom-2-2, rect.right-2-4, 1, PATCOPY);
    pDC->PatBlt(rect.right-2-2, 1+2, 1, rect.bottom-2-4, PATCOPY);
  }                            
  
//B
  if (hBFrame != NULL) {
    pDC->SelectObject(hBFrame);
    pDC->PatBlt(0+2, rect.bottom-1-2, rect.right-4, 1, PATCOPY);
    pDC->PatBlt(rect.right-1-2, 0+2, 1, rect.bottom-4, PATCOPY);
  }                            
  
  pRect->left += 4;
  pRect->right -= 4;  
  pRect->top += 4;
  pRect->bottom -= 4;  
  
  pDC->SelectObject(hOldBrush);
  DeleteObject(hWFrame);
  DeleteObject(hWGFrame);
  DeleteObject(hGFrame);
  DeleteObject(hBFrame);
}
