/***************************************************************************
**
**    $Header:   D:/EP196/SRC/LOG/MAPDLG.CPP   1.0   15 Aug 1997 14:01:06   ZJRD  $
**
**    $Log:   D:/EP196/SRC/LOG/MAPDLG.CPP  $
** 
**    Rev 1.0   15 Aug 1997 14:01:06   ZJRD
** Initial revision.
** 
****************************************************************************/

#include "stdafx.h"
#include "resource.h"
#include "uicom2.h"
//#include "xview.h"
#include "myedit2.h"
//#include "spin.h"
//#include "cpucom.h"
#include "abiextfn.h"
#include "cpusvr.h"

//
// For address server
//
#include "address.h"
#include "addrapi.h"

#include "memsvr.h"
#include "mapedit.h"
#include "mapbtn.h"
#include "mapdlg.h"                               

#include "trcpub.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

                       /****************************
                        *                          *
                        *    EXTERNAL VARIABLES    *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/
#define     IRW_COLOR         5
#define     IR_COLOR          7
#define     GUARD_COLOR       6
#define     ERW_COLOR         4
//#define     ER_COLOR          7
//#define     CRW_COLOR         3
//#define     CR_COLOR          6

#define     BTN_IRW           10
#define     BTN_IR            11
#define     BTN_GUARD         12
#define     BTN_ERW           13
//#define     BTN_ER            14
//#define     BTN_CRW           15
//#define     BTN_CR            16

#define     BLOCK_LINE        16       // 8
#define     BLOCK_COLON       32       // 8

#define     BLOCK_NUM         512      // 64
#define     BYTE_PER_BLOCK    128      // 1024 


   
                       /****************************
                        *                          *
                        *       GLOBAL VARS        *
                        *                          *
                        ****************************/
char  strSelectItem[100];
char  *strPosition;
char  strStartAddress[10];
char  strEndAddress[10];
char  strLength[
10];
char  strAttrib[30];
char  strSpace[40];
int   gnAttribIndex = 0;

const char*  g_pszAttrComOverlay = "Overlay Combination";
const char*  g_pszAttrComTarget = "Target Combination";
const char*  g_pszAttrSepOverlay = "Overlay Separation";
const char*  g_pszAttrSepTarget = "Target Separation";
static const char* BASED_CODE g_pszMapComma = ",";
static const char* BASED_CODE g_pszMapProgram = "Program";
static const char* BASED_CODE g_pszMapBank = "Bank";

static char BASED_CODE MICROTEK_MAP_MARK[] = "Microtek Map:";


                       /****************************
                        *                          *
                        *     LOCAL PROTOTYPES     *
                        *                          *
                        ****************************/
BOOL DoMapRestore();             // Restore the map setting from the file
void DoMapSave();                // Save the map setting to the file

                       /****************************
                        *                          *
                        *      EXECUTABLE CODE     *
                        *                          *
                        ****************************/

/********************************************************************** 
**
**  Modification only for 196 according to what xu told.
**  I only map new attributes to old ones without changing variable and
**  constant name as followed:
**  Combination Target ------ Overlay
**  Combination Overlay ------ Overlay Read Only                          
**  Separation Target ------ Guard
**  Separation Overlay ------ Target
**
**********************************************************************/

//index==-1: return space number:
BYTE GetSpace(int index)
{
static BOOL	bCombination;
static int	nBank=-1;

	//init:
	if(nBank==-1)
	{
		bCombination=IsMapCombination();
		nBank=GetBankNum();
		ASSERT(nBank>0&&nBank<5);
	}
	if(index==-1)
	{
		return (BYTE)nBank;
	}
	ASSERT(index>=0&&index<nBank);
	if(index==0)
		return SPACE_P0;
    ASSERT(nBank>1);
	if(nBank==2)
	{
		if(bCombination)
			return SPACE_P1;
		else
			return SPACE_X0;
	}
	else if(nBank==4)
	{
		if(bCombination)
		{
			if(index==1)
				return SPACE_P1;
			else if(index==2)
				return SPACE_P2;
			else
				return SPACE_P3;
		}
		else
		{
			if(index==1)
				return SPACE_P1;
			else if(index==2)
				return SPACE_X0;
			else
				return SPACE_X1;
		}
	}
	else
		return -1;
}

void SaveMapToFile(CArchive& ar)
{
	WORD attribute;
	int i, count = 0;
	ADDRESS startAddress, endAddress; 
	CString strMsg;

	CString flag = MICROTEK_MAP_MARK;
	ar << flag;					//input 1 string

    // Do the first get map setting is for getting the map setting count
    // Get Program area map setting
	int nSpaceNum=GetSpace(-1);
	for(i=0; i<nSpaceNum; i++)
	{
		startAddress.adrAddress = 0;
		startAddress.adrSpace = GetSpace(i);
		endAddress.adrAddress = 0xffff;
		endAddress.adrSpace = startAddress.adrSpace;
	    do
	    {
			MemServerGetMap(startAddress,
							endAddress,
							attribute, strMsg, 1);
			startAddress.adrAddress = endAddress.adrAddress + 1;
			count++;
		}while(endAddress.adrAddress < 0xffff);
	}

	ar << (WORD)count;			//input 4 word

	for(i=0; i<nSpaceNum; i++)
	{
		startAddress.adrAddress = 0;
		startAddress.adrSpace = GetSpace(i);
		endAddress.adrAddress = 0xffff;
		endAddress.adrSpace = startAddress.adrSpace;
	    do
	    {
			MemServerGetMap(startAddress,
							endAddress,
							attribute, strMsg, 1);
			ar<<startAddress.adrAddress;	//input 5 dword
			ar<<endAddress.adrAddress;		//input 6 dword
			ar<<startAddress.adrSpace;		//input 7 byte
			ar<<attribute;					//input 8 word
			startAddress.adrAddress = endAddress.adrAddress + 1;
			count++;
		}while(endAddress.adrAddress < 0xffff);
	}
}

BOOL RestoreMapFromFile(CArchive& ar, BOOL bAction)
{                                                 
	WORD attribute;
	ADDRESS startAddress, endAddress;
	int count;
	int i;
	WORD w;
	CString strMsg;

	int nSpaceNum=GetSpace(-1);

	CString flag;
	CString oldflag = MICROTEK_MAP_MARK;;

	ar >> flag;				//output 1 string
	if ( flag != oldflag )
		return FALSE;

	ar >> w;
	count = (int)w;

	for(i=1; i<=count; i++)
	{
		ar >> startAddress.adrAddress;
		ar >> endAddress.adrAddress;
		ar >> startAddress.adrSpace;
		ar >> attribute;
		endAddress.adrSpace=startAddress.adrSpace;
		
		if (bAction)
		{
			if(ICE_OK!=MemServerSetMap(startAddress, 
						endAddress, 
						attribute, strMsg, 1))
				return FALSE;
		}
	}
	return TRUE;
}

////////////////////////////////////////////////////////////////////////////
// DoMapSave
//
// Save the map setting to the file map.sav.
// The file is under the execution file's path
// 
// parameter
//    none
//
// return value
//    none
//
////////////////////////////////////////////////////////////////////////////

void DoMapSave()
{
	char exefilename[125];
	CString strMsg;

    // Do the first get map setting is for getting the map setting count
    // Get Program area map setting
	::GetModuleFileName(AfxGetInstanceHandle(), exefilename, 125);
	int pp = 0;
	for (pp = strlen(exefilename); pp > 0; pp--)
	{
		if (exefilename[pp] == '\\')
			break;
	}

	exefilename[pp+1] = '\0';
	strcat(exefilename, "map.sav");
	CFile file(exefilename, CFile::modeCreate|CFile::modeWrite);
	CArchive ar(&file,CArchive::store);

	SaveConfigHead(ar, STORE_MAP);
	
	SaveMapToFile(ar);
	    
	ar.Close();
	file.Close();
}     // End of DoMapSave()


///////////////////////////////////////////////////////////////////////////  
// DoMapRestore
//
// Restore the map setting from the file map.sav.
// The file is under the execution file's path
//
// parameter
//    none
//
// return value
//    none
//
////////////////////////////////////////////////////////////////////////////

BOOL DoMapRestore()
{
	CFile file;
	BOOL b;

	char exefilename[125];
	::GetModuleFileName(AfxGetInstanceHandle(), exefilename, 125);
	int pp = 0;
	for (pp = strlen(exefilename); pp > 0; pp--)
	{
		if (exefilename[pp] == '\\')
			break;
	}        
    exefilename[pp+1] = '\0';
    strcat(exefilename, "map.sav");

	b = file.Open(exefilename, CFile::modeRead);
	if (!b)
	{
		file.Abort();
		return FALSE;
	}

	CArchive ar(&file, CArchive::load);  
	
	WORD wOldOption;
	if (!RestoreConfigHead(ar, wOldOption,FALSE)){
		ar.Close();
		file.Close();
		return FALSE;
	}

	
	BOOL bReturn = TRUE;
	
	if (wOldOption & STORE_MAP)
	{
		if (!RestoreMapFromFile(ar, TRUE))
			bReturn = FALSE;
	}
	else bReturn = FALSE;
		
	ar.Close();
	file.Close();
	return bReturn;
}     // End of DoRestoreMap()


/////////////////////////////////////////////////////////////////////////////
// CMapDlg dialog
//
extern COLORREF PaletteIndex[16];

CMapDlg::CMapDlg(CWnd* pParent /*=NULL*/)
   : CDialog(CMapDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CMapDlg)
	m_nAreaSelect = 0;
	//}}AFX_DATA_INIT
	m_nArea = SPACE_P0;
	m_nColorIndex = 9;
	m_bCapture = FALSE;
	//m_bStart = FALSE; 
	//m_bEnd = FALSE;
	m_dwStartAddr = m_dwEndAddr = m_dwCurAddr = 0;   
	m_bFirst = TRUE;
	m_nSelectLast = -1;
	m_nStartBlock = -1;   
	m_nEndBlock = -1;   
	m_nLastBlock = -1;   
	m_nCurBlock = -1;   
}

void CMapDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMapDlg)
	DDX_Control(pDX, IDC_MAP_UNDO, m_ctrlUndo);
	DDX_Control(pDX, IDC_MAP_EDIT, m_ctrlMapEdit);
	DDX_Control(pDX, IDC_CURADDR, m_ctrlCurAddr);
	DDX_Control(pDX, IDC_MAP_VIEW, m_ctrlMapView);
	DDX_Control(pDX, IDC_MAP_LIST, m_ctrlListMap);
	DDX_Control(pDX, IDC_STARTADDR, m_ctrlStartAddr);
	DDX_Control(pDX, IDC_ENDADDR, m_ctrlEndAddr);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CMapDlg, CDialog)
	//{{AFX_MSG_MAP(CMapDlg)
	ON_BN_CLICKED(IDC_MAP_RESTORE, OnMapRestore)
	ON_BN_CLICKED(IDC_MAP_SAVE, OnMapSave)
	ON_BN_CLICKED(IDC_MAP_SET, OnMapSet)
	ON_BN_CLICKED(IDC_BTN_ERW, OnBtnErw)
	ON_BN_CLICKED(IDC_BTN_G, OnBtnG)
	ON_BN_CLICKED(IDC_BTN_IR, OnBtnIr)
	ON_BN_CLICKED(IDC_BTN_IRW, OnBtnIrw)
	ON_BN_CLICKED(IDC_RDATA, OnRdata)
	ON_BN_CLICKED(IDC_RPROGRAM, OnRprogram)
	ON_WM_PAINT()
	ON_WM_MOUSEMOVE()
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_BN_CLICKED(IDC_MAP_EDIT, OnMapEdit)
	ON_LBN_SELCHANGE(IDC_MAP_LIST, OnSelchangeMapList)
	ON_LBN_SETFOCUS(IDC_MAP_LIST, OnSetfocusMapList)
	ON_LBN_KILLFOCUS(IDC_MAP_LIST, OnKillfocusMapList)
	ON_BN_CLICKED(IDC_MAP_UNDO, OnMapUndo)
	ON_BN_CLICKED(IDC_RBANK1, OnRbank1)
	ON_BN_CLICKED(IDC_RBANK2, OnRbank2)
	ON_BN_CLICKED(IDC_RBANK3, OnRbank3)
	ON_BN_CLICKED(IDC_RBANK4, OnRbank4)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CMapDlg message handlers

BOOL CMapDlg::OnInitDialog()
{
   CDialog::OnInitDialog();
   CenterWindow();
   
   BOOL bFind = FALSE;
   bFind = FindMapSave();
   if ( bFind == FALSE ) {
   	  GetDlgItem(IDC_MAP_RESTORE)->EnableWindow(FALSE);
   }
   else {
   	  GetDlgItem(IDC_MAP_RESTORE)->EnableWindow(TRUE);
   }	  
   //CheckRadioButton(IDC_RPROGRAM, IDC_RBANK4, IDC_RPROGRAM);
	int	nBankNum=GetSpace(-1);
	BOOL bCombination=IsMapCombination();
	if(nBankNum==1)
	{
		((CButton*)GetDlgItem(IDC_RBANK1))->SetCheck(1);
		GetDlgItem(IDC_RDATA)->EnableWindow(FALSE);
		GetDlgItem(IDC_RBANK1)->EnableWindow(FALSE);
		GetDlgItem(IDC_RBANK2)->EnableWindow(FALSE);
		GetDlgItem(IDC_RBANK3)->EnableWindow(FALSE);
		GetDlgItem(IDC_RBANK4)->EnableWindow(FALSE);
		((CButton*)GetDlgItem(IDC_RPROGRAM))->SetCheck(1);
		GetDlgItem(IDC_RPROGRAM)->EnableWindow(FALSE);
	}
	else if(nBankNum==2)
	{
		if(bCombination)
		{
			GetDlgItem(IDC_RDATA)->EnableWindow(FALSE);
			GetDlgItem(IDC_RBANK3)->EnableWindow(FALSE);
			GetDlgItem(IDC_RBANK4)->EnableWindow(FALSE);
			((CButton*)GetDlgItem(IDC_RPROGRAM))->SetCheck(1);
			GetDlgItem(IDC_RPROGRAM)->EnableWindow(FALSE);
			((CButton*)GetDlgItem(IDC_RBANK1))->SetCheck(1);
		}
		else
		{
			((CButton*)GetDlgItem(IDC_RBANK1))->SetCheck(1);
			GetDlgItem(IDC_RBANK1)->EnableWindow(FALSE);
			GetDlgItem(IDC_RBANK2)->EnableWindow(FALSE);
			GetDlgItem(IDC_RBANK3)->EnableWindow(FALSE);
			GetDlgItem(IDC_RBANK4)->EnableWindow(FALSE);
			((CButton*)GetDlgItem(IDC_RPROGRAM))->SetCheck(1);
		}
	}
	else
	{
		if(bCombination)
		{
			GetDlgItem(IDC_RDATA)->EnableWindow(FALSE);
			((CButton*)GetDlgItem(IDC_RPROGRAM))->SetCheck(1);
			GetDlgItem(IDC_RPROGRAM)->EnableWindow(FALSE);
			((CButton*)GetDlgItem(IDC_RBANK1))->SetCheck(1);
		}
		else
		{
			((CButton*)GetDlgItem(IDC_RPROGRAM))->SetCheck(1);
			((CButton*)GetDlgItem(IDC_RBANK1))->SetCheck(1);
			GetDlgItem(IDC_RBANK3)->EnableWindow(FALSE);
			GetDlgItem(IDC_RBANK4)->EnableWindow(FALSE);
		}
	}

   InitBtn();   
   m_ctrlMapView.GetWindowRect(m_ViewRect);
   ScreenToClient(m_ViewRect);
   
   int left = 0, top = 0, right = 0, bottom = 0;
   CPoint topleft;
   int blockwidth = 11;
   int blockheight= 10;
   int leftmargin = 5;
   int topmargin = 7; 
   
   topleft = m_ViewRect.TopLeft();
   for ( int i = 0; i < BLOCK_LINE; i ++) {
      for ( int j = 0; j < BLOCK_COLON; j ++ ) {
         left = topleft.x + leftmargin + j * blockwidth;
         top = topleft.y + topmargin + i * blockheight;
         right = left + blockwidth;
         bottom = top + blockheight;
         m_block[i*BLOCK_COLON+j].m_block.SetRect(left, top, right, bottom);
         m_block[i*BLOCK_COLON+j].attribute = -1;
      }
   }

   // TODO: Add extra initialization here
   return TRUE;  // return TRUE  unless you set the focus to a control
}

void CMapDlg::InitBtn()
{
   VERIFY(btnIRW.SubclassDlgItem(IDC_BTN_IRW, this));
   VERIFY(btnIR.SubclassDlgItem(IDC_BTN_IR, this));
   VERIFY(btnGuard.SubclassDlgItem(IDC_BTN_G, this));
   VERIFY(btnERW.SubclassDlgItem(IDC_BTN_ERW, this));
   
   btnIRW.SetColor(IRW_COLOR);
   btnIRW.SetBtnTitle();
   
   btnIR.SetColor(IR_COLOR);
   btnIR.SetBtnTitle();
   
   btnGuard.SetColor(GUARD_COLOR);
   btnGuard.SetBtnTitle();
   
   btnERW.SetColor(ERW_COLOR);
   btnERW.SetBtnTitle();
   
   // for 196 modified according to Xu
   if (IsMapCombination()){
   		btnGuard.EnableWindow(FALSE);
   		btnERW.EnableWindow(FALSE);
   		GetDlgItem(IDC_STATIC_RG)->EnableWindow(FALSE);
   		GetDlgItem(IDC_STATIC_RERW)->EnableWindow(FALSE);
   	}	
}

void CMapDlg::BtnProcess(int nWhichBtn)
{
   btnIRW.m_bHighlight = FALSE;
   btnIRW.SetState(btnIRW.m_bHighlight);
   btnIR.m_bHighlight = FALSE;
   btnIR.SetState(btnIR.m_bHighlight);
   
   btnGuard.m_bHighlight = FALSE;
   btnGuard.SetState(btnGuard.m_bHighlight);   
   
   btnERW.m_bHighlight = FALSE;
   btnERW.SetState(btnER.m_bHighlight);

   switch(nWhichBtn) {
      case  BTN_IRW:                            // IRW
            btnIRW.m_bHighlight = TRUE;
            btnIRW.SetState(btnIRW.m_bHighlight);
            break;
            
      case  BTN_IR:                             // IR
            btnIR.m_bHighlight = TRUE;
            btnIR.SetState(btnIR.m_bHighlight);
            break;
            
      case  BTN_GUARD:                          // Guard
            btnGuard.m_bHighlight = TRUE;
            btnGuard.SetState(btnGuard.m_bHighlight);   
            break;
            
      case  BTN_ERW:                            // ERW
            btnERW.m_bHighlight = TRUE;
            btnERW.SetState(btnERW.m_bHighlight);
            break;
   }                  
}

void CMapDlg::DrawMapView(CDC* pDC)
{
   CBrush brush;
   CPen   pen(PS_SOLID, 1, RGB(0, 0, 0));
   int    nColorIndex;
   CPoint lefttop, rightbottom, leftbottom, righttop;
   
   for ( int i = 0; i < BLOCK_LINE*BLOCK_COLON; i ++ ) {
      switch(m_block[i].attribute) {
//         case MAP_ORW:
		   case MAP_ERW:
             nColorIndex = IRW_COLOR;
             break;
                            
//         case MAP_OR:
         case MAP_ORW:
             nColorIndex = IR_COLOR;
             break;
                            
//         case MAP_ERW:
         case MAP_GUARD:
             nColorIndex = ERW_COLOR;
             break;

//         case MAP_GUARD:
         case MAP_OR:

             nColorIndex = GUARD_COLOR;
             break;

         default:
             nColorIndex = 9;    
      }
      
      brush.CreateSolidBrush(PaletteIndex[nColorIndex]);
      DrawBlock(pDC, i, &brush, &pen);
      brush.DeleteObject();
   }

}

void CMapDlg::InitMapView(DWORD startAddress, DWORD endAddress, int attrib)
{
   int startline = 0, endline = 0, startcolon = 0, endcolon = 0;
      
   startline = (int)(startAddress/0x1000);  // each line is 0~0xFFF
   startcolon = (int)(startAddress-(DWORD)(startline*0x1000))/0x80;
   endline = (int)(endAddress/0x1000);    // each line is 0~0xFFF
   endcolon = (int)(endAddress-(DWORD)(endline*0x1000))/0x80;

   int    nWhich = 0;
   
   for (;;) {
      nWhich = startline*BLOCK_COLON+startcolon;
      m_block[nWhich].attribute = attrib;
      startcolon++;
      if ( (startline == endline) && (startcolon > endcolon) )
         break;
      if ( startcolon > (BLOCK_COLON-1) ) {  
         startcolon = 0;
         startline ++;
      }
      if ( startline > endline ) break;   
   }
}

void CMapDlg::DrawInitMap(int nWhichArea)            // Draw the area map 
{
	m_dwxMin = 0;     // dwxMin
	m_dwxMax = 0xFFFF;// dwxMax
	m_dwpMin = 0;     // dwxMin
	m_dwpMax = 0xFFFF;// dwxMax    
	
	m_nStartBlock = -1;
	m_nEndBlock = -1;

   GetMap(nWhichArea);
   
   Invalidate(FALSE);
   UpdateWindow();
//   DrawMapView();
}
                           
void CMapDlg::DrawBlockFrame(CDC * pDC, int nStartBlock, 
							int nEndBlock, CPen* pen)
{
	for (int nWhich = nStartBlock; nWhich<=nEndBlock; nWhich++){
		DrawBlockFrame(pDC, nWhich, pen);
	}
}

void CMapDlg::DrawBlockFrame(CDC *pDC, int nWhichBlock, CPen* pen)
{
   CPen* oldPen;
   oldPen = pDC->SelectObject(pen);
   
   CPoint lefttop, rightbottom, leftbottom, righttop;
   
   lefttop = m_block[nWhichBlock].m_block.TopLeft();
   rightbottom = m_block[nWhichBlock].m_block.BottomRight();
   
   leftbottom.x = lefttop.x;
   leftbottom.y = rightbottom.y;
   righttop.x = rightbottom.x;
   righttop.y = lefttop.y;
   
   pDC->MoveTo(lefttop);
   pDC->LineTo(leftbottom);
   
   pDC->MoveTo(lefttop);
   pDC->LineTo(righttop);
   
   pDC->MoveTo(rightbottom);
   pDC->LineTo(righttop);
   
   pDC->MoveTo(rightbottom);
   pDC->LineTo(leftbottom);
   pDC->SelectObject(oldPen);
}

//
// Fill the blocks with the attribute
//
void CMapDlg::DrawAllBlockFrame()
{
   CDC* pDC = GetDC();
   CBrush brush(PaletteIndex[m_nColorIndex]);
   CPen  whitepen(PS_SOLID, 1, RGB(255, 255, 255));
   int nWhichBlock, attrib;

   if ( m_nStartBlock == -1 && m_nEndBlock == -1 ) return;   
   for ( nWhichBlock = m_nStartBlock; 
         nWhichBlock <= m_nEndBlock;
         nWhichBlock ++ ) {
      switch ( m_nColorIndex ) {
         case  IRW_COLOR:
//               attrib = MAP_ORW;
			   attrib = MAP_ERW;
               break;
               
         case  IR_COLOR:
//               attrib = MAP_OR;
               attrib = MAP_ORW;
               break;
               
         case  GUARD_COLOR:
//               attrib = MAP_GUARD;
               attrib = MAP_OR;
               break;
               
         case  ERW_COLOR:
//               attrib = MAP_ERW;
               attrib = MAP_GUARD;
               break;
      }
      
      m_block[nWhichBlock].attribute = attrib;       
      DrawBlock(pDC, nWhichBlock, &brush, &whitepen);    
   }      
   
   ReleaseDC(pDC);
}

void CMapDlg::DrawBlock(CDC *pDC, int nWhichBlock, CBrush* brush, CPen* pen)
{  
   CRect rect = m_block[nWhichBlock].m_block;
   CPoint x, y;
   x = rect.TopLeft();
   y = rect.BottomRight();
   x.x += 2;
   x.y += 2;
   y.x --;
   y.y --;
   rect.SetRect(x.x, x.y, y.x, y.y);
   pDC->FillRect(rect, brush);      
   
   CPen* oldPen;
   oldPen = pDC->SelectObject(pen);
   
   CPoint lefttop, rightbottom, leftbottom, righttop;
   
   lefttop = m_block[nWhichBlock].m_block.TopLeft();
   rightbottom = m_block[nWhichBlock].m_block.BottomRight();
   
   leftbottom.x = lefttop.x;
   leftbottom.y = rightbottom.y;
   righttop.x = rightbottom.x;
   righttop.y = lefttop.y;
   
   pDC->MoveTo(lefttop);
   pDC->LineTo(leftbottom);
   
   pDC->MoveTo(lefttop);
   pDC->LineTo(righttop);
   
   pDC->MoveTo(rightbottom);
   pDC->LineTo(righttop);
   
   pDC->MoveTo(rightbottom);
   pDC->LineTo(leftbottom);
   pDC->SelectObject(oldPen);
}

void CMapDlg::OnMapRestore()
{
   // TODO: Add your control notification handler code here
   m_bCapture = FALSE;
   
   AfxGetApp()->DoWaitCursor(1);   
   DoMapRestore();
   
   GetMap(m_nArea);        // Repaint the map list box
//   DrawMapView();
   m_ctrlMapEdit.EnableWindow(FALSE);
   AfxGetApp()->DoWaitCursor(0);   

   m_nStartBlock = -1;
   m_nEndBlock = -1;
   
   Invalidate(FALSE);
   UpdateWindow();
   
   //
   // Repaint any window relateed to the memory
   //
   ::RepaintMemory();
//   ::RepaintStack();
//   ::RepaintVariable();
}

void CMapDlg::OnMapSave()
{
   // TODO: Add your control notification handler code here
   m_bCapture = FALSE;
   AfxGetApp()->DoWaitCursor(1);   
   DoMapSave();   
   GetDlgItem(IDC_MAP_RESTORE)->EnableWindow(TRUE);
   AfxGetApp()->DoWaitCursor(0);   
}

void CMapDlg::OnMapSet()
{
// TODO: Add your control notification handler code here
int nBlock;
WORD attribute1 = 0, attribute2 = 0;
ADDRESS startAddress, endAddress, curAddress;
CString strMsg;

	m_bCapture = FALSE;
	m_ctrlUndo.EnableWindow(FALSE);
	AfxGetApp()->DoWaitCursor(1);   

	endAddress.adrSpace=startAddress.adrSpace=(BYTE)m_nArea;
	for ( nBlock = 0; nBlock < BLOCK_NUM; nBlock ++ )
	{
		if ( nBlock == 0 )
			startAddress.adrAddress=0;
		else
		{
			attribute1 = (WORD)m_block[nBlock].attribute;
			attribute2 = (WORD)m_block[nBlock-1].attribute;
			if ( attribute1 == attribute2 )
			{
				curAddress.adrAddress = DWORD(nBlock)*DWORD(0x80);
				endAddress.adrAddress = (DWORD)(curAddress.adrAddress+0x7f);
				
				if ( endAddress.adrAddress >= 0xffff )
				{
				   MemServerSetMap(startAddress, 
				                   endAddress, 
				                   attribute2, strMsg, 1);
				}
			}
			else
			{
				curAddress.adrAddress = (DWORD)(nBlock)*DWORD(0x80);
				endAddress.adrAddress = (DWORD)(curAddress.adrAddress-1);
				MemServerSetMap(startAddress,
				                endAddress, 
				                attribute2, strMsg, 1);
				startAddress.adrAddress = (DWORD)(nBlock)*DWORD(0x80);
				if ( nBlock == (BLOCK_NUM - 1) )
				{
					endAddress.adrAddress = (DWORD)(startAddress.adrAddress + 0x7f);
					MemServerSetMap(startAddress, 
					               endAddress, 
					               attribute1, strMsg, 1);
				}
			}
		}
		if(startAddress.adrAddress > 0xffff)
			break;
	}
	GetMap(m_nArea);
	m_ctrlMapEdit.EnableWindow(FALSE);
	AfxGetApp()->DoWaitCursor(0);   
}

/*
void CMapDlg::OnHelp()
{
   // TODO: Add your control notification handler code here
   m_bCapture = FALSE;
   AfxGetApp()->WinHelp(IDD_MAPDLG);
}
*/

void CMapDlg::OnMapEdit()
{
   // TODO: Add your control notification handler code here
CMapEdit mapEdit;
int nCurSel = m_ctrlListMap.GetCurSel();

	m_bCapture = FALSE;
	if ( nCurSel != -1 ) {
	  GetListSelect(nCurSel);   
	}   
	else {
	  return;
	}

	switch ( m_nArea )
	{
		case     MEM_P0:
			mapEdit.m_strSpaceArea = "Program Bank0";
			break;
		case     MEM_P1:
			mapEdit.m_strSpaceArea = "Program Bank1";
			break;
		case     MEM_P2:
			mapEdit.m_strSpaceArea = "Program Bank2";
			break;
		case     MEM_P3:
			mapEdit.m_strSpaceArea = "Program Bank3";
			break;
		case     MEM_X0:
			mapEdit.m_strSpaceArea = "Data Bank0";
			break;
		case     MEM_X1:
			mapEdit.m_strSpaceArea = "Data Bank1";
			break;
	}
	mapEdit.m_nArea = m_nArea;

	mapEdit.m_strStartAddr = strStartAddress;
	mapEdit.m_strEndAddr = strEndAddress;
	switch ( gnAttribIndex )
	{
		case     IRW_COLOR:
		       mapEdit.m_nAttribute = 0;
		       break;
		case     IR_COLOR:
		       mapEdit.m_nAttribute = 1;
		       BtnProcess(BTN_IR);
		       break;
		case     ERW_COLOR:
		       mapEdit.m_nAttribute = 3;
		       break;
		case     GUARD_COLOR:
		       mapEdit.m_nAttribute = 2;
		       break;
	}
	mapEdit.DoModal();
	GetMap(m_nArea);
//	DrawMapView();                

    m_nStartBlock = -1;
    m_nEndBlock = -1;

	Invalidate(FALSE);
	UpdateWindow();
	
	m_ctrlMapEdit.EnableWindow(FALSE);
}

//
// Internal Read Only
//
void CMapDlg::OnBtnIr()
{
   // TODO: Add your control notification handler code here
   m_bCapture = FALSE;
   m_nColorIndex = IR_COLOR;
   BtnProcess(BTN_IR);
   DrawAllBlockFrame();
}

//
// Internal Read/Write
//
void CMapDlg::OnBtnIrw()
{
   // TODO: Add your control notification handler code here
   m_bCapture = FALSE;
   m_nColorIndex = IRW_COLOR;
   BtnProcess(BTN_IRW);
   DrawAllBlockFrame();
}

//
// Guard
//
void CMapDlg::OnBtnG()
{
   // TODO: Add your control notification handler code here
   m_bCapture = FALSE;
   m_nColorIndex = GUARD_COLOR;
   BtnProcess(BTN_GUARD);
   DrawAllBlockFrame();
}

// External Read/Write
//
void CMapDlg::OnBtnErw()
{
   // TODO: Add your control notification handler code here
   m_bCapture = FALSE;
   m_nColorIndex = ERW_COLOR;
   BtnProcess(BTN_ERW);
   DrawAllBlockFrame();
}

void CMapDlg::OnRdata()
{
	// TODO: Add your control notification handler code here
//	GetDlgItem(IDC_BTN_IR)->EnableWindow(FALSE);
//	GetDlgItem(IDC_BTN_G)->EnableWindow(FALSE);
	m_bCapture = FALSE;
	if ( m_nArea == MEM_X0|| m_nArea == MEM_X1)
		return;
	if(m_nArea==MEM_P0)
		m_nArea=MEM_X0;
	else
		m_nArea=MEM_X1;
	DrawInitMap(m_nArea);
	int sele = m_ctrlListMap.GetCurSel();
	if ( sele == -1 )
		m_ctrlMapEdit.EnableWindow(FALSE);
}

void CMapDlg::OnRprogram()
{
	// TODO: Add your control notification handler code here
//	GetDlgItem(IDC_BTN_IR)->EnableWindow(TRUE);
//	GetDlgItem(IDC_BTN_G)->EnableWindow(TRUE);
	m_bCapture = FALSE;
	if ( m_nArea == MEM_P0|| m_nArea == MEM_P1||
		m_nArea == MEM_P2|| m_nArea == MEM_P3)
		return;
	if(m_nArea==MEM_X0)
		m_nArea=MEM_P0;
	else
		m_nArea=MEM_P1;
	DrawInitMap(m_nArea);
	int sele = m_ctrlListMap.GetCurSel();
	if ( sele == -1 )
		m_ctrlMapEdit.EnableWindow(FALSE);
}

void CMapDlg::OnRbank1()
{
	// TODO: Add your control notification handler code here
	m_bCapture = FALSE;
	if ( m_nArea == MEM_X0|| m_nArea == MEM_P0)
		return;
	if(m_nArea==MEM_X1)
		m_nArea=MEM_X0;
	else
		m_nArea=MEM_P0;
	DrawInitMap(m_nArea);
	int sele = m_ctrlListMap.GetCurSel();
	if ( sele == -1 )
		m_ctrlMapEdit.EnableWindow(FALSE);
}

void CMapDlg::OnRbank2()
{
	// TODO: Add your control notification handler code here
	m_bCapture = FALSE;
	if ( m_nArea == MEM_X1|| m_nArea == MEM_P1)
		return;
	if(m_nArea==MEM_X0)
		m_nArea=MEM_X1;
	else
		m_nArea=MEM_P1;
	DrawInitMap(m_nArea);
	int sele = m_ctrlListMap.GetCurSel();
	if ( sele == -1 )
		m_ctrlMapEdit.EnableWindow(FALSE);
}

void CMapDlg::OnRbank3()
{
	// TODO: Add your control notification handler code here
	m_bCapture = FALSE;
	if ( m_nArea == MEM_P2)
		return;
	m_nArea=MEM_P2;
	DrawInitMap(m_nArea);
	int sele = m_ctrlListMap.GetCurSel();
	if ( sele == -1 ) m_ctrlMapEdit.EnableWindow(FALSE);
}

void CMapDlg::OnRbank4()
{
	// TODO: Add your control notification handler code here
	m_bCapture = FALSE;
	if ( m_nArea == MEM_P3)
		return;
	m_nArea=MEM_P3;
	DrawInitMap(m_nArea);
	int sele = m_ctrlListMap.GetCurSel();
	if ( sele == -1 )
		m_ctrlMapEdit.EnableWindow(FALSE);
}

/**----------------------------------------------------------------------
 **   GetMap
 **
 **   Remark
 **      Call this function to get the current map setting.
 **      Call the map server
 **
 **   Return value
 **      none
 **----------------------------------------------------------------------*/

void CMapDlg::GetMap(int nWhichArea)
{
ADDRESS startAddress, endAddress;
long length;
WORD attribute;
char *buf;
char *p;
CFont font;
int i;
CString strMsg;

	buf = new char[100];
	ASSERT(NULL != buf);
	m_ctrlListMap.ResetContent();
	font.Attach(::GetStockObject(ANSI_FIXED_FONT));
	m_ctrlListMap.SetFont(&font, FALSE);

	startAddress.adrAddress= 0;
	endAddress.adrAddress=0xffff;
	startAddress.adrSpace=endAddress.adrSpace=(BYTE)nWhichArea;
	if ( startAddress.adrAddress == 0 && endAddress.adrAddress == 0 &&
			startAddress.adrSpace == endAddress.adrSpace)
	 	return;
					       
	do
	{
		memset(buf, ' ', 100*sizeof(char)); 
		MemServerGetMap(startAddress,
		             endAddress,
		             attribute, strMsg, 1);

		length = endAddress.adrAddress - startAddress.adrAddress + 1;

		p = buf;
		sprintf(p, "%X,", startAddress.adrAddress);
		i = lstrlen(buf);
		buf[i] = ' ';
									         
		p = buf + 9;
		sprintf(p, "%X,", endAddress.adrAddress);
		i = lstrlen(buf);
		buf[i] = ' ';
									         
		p = buf + 18;
		sprintf(p, "%lX,", length);
		i = lstrlen(buf);
		buf[i] = ' ';
									         
		p = buf + 27;
		switch(attribute)
		{
//			case MAP_ORW:
			case MAP_ERW:
				m_nColorIndex = IRW_COLOR;   
//				lstrcpy(p,"Overlay,");        
				lstrcpy(p, g_pszAttrComOverlay);
				lstrcat(p, g_pszMapComma);
				break;
//			case MAP_OR:
			case MAP_ORW:
				m_nColorIndex = IR_COLOR;   
//				lstrcpy(p,"Overlay Read Only,");
				lstrcpy(p, g_pszAttrComTarget);
				lstrcat(p, g_pszMapComma);
				break;
//			case MAP_GUARD:
			case MAP_OR:
				m_nColorIndex = GUARD_COLOR;   
//				lstrcpy(p,"Guard,");
				lstrcpy(p, g_pszAttrSepOverlay);
				lstrcat(p, g_pszMapComma);
				break;
//			case MAP_ERW:
			case MAP_GUARD:
				m_nColorIndex = ERW_COLOR;   
//				lstrcpy(p,"Target,");
				lstrcpy(p, g_pszAttrSepTarget);
				lstrcat(p, g_pszMapComma);
				break;
			default:
				lstrcpy(p, "No map,");
				break;
		}
		i = lstrlen(buf);
		buf[i]=' ';
		p=buf + 50;
		if((BYTE)nWhichArea==SPACE_P0)
			lstrcpy(p, "Program bank0");
		else if((BYTE)nWhichArea==SPACE_P1)
			lstrcpy(p, "Program bank1");
		else if((BYTE)nWhichArea==SPACE_P2)
			lstrcpy(p, "Program bank2");
		else if((BYTE)nWhichArea==SPACE_P3)
			lstrcpy(p, "Program bank3");
		else if((BYTE)nWhichArea==SPACE_X0)
			lstrcpy(p, "Data bank0");
		else if((BYTE)nWhichArea==SPACE_X1)
			lstrcpy(p, "Data bank1");
		else
			ASSERT(0);
		i = strlen(buf);
		buf[i] = '\0';
		m_ctrlListMap.AddString(buf);
		InitMapView(startAddress.adrAddress, endAddress.adrAddress, attribute);
		startAddress.adrAddress = endAddress.adrAddress + 1;
	}while (endAddress.adrAddress<0xffff);
	if ( buf )
		delete []buf;
}

void CMapDlg::OnPaint()
{
   CPaintDC dc(this); // device context for painting
   
   if ( m_bFirst )
   {
      GetMap(MEM_P0);                 // in initial, get the program map setting
      DrawMapView(&dc);
      m_bFirst = FALSE;
   }
   else
   {
      DrawMapView(&dc);
      if ( m_nStartBlock != -1 && m_nEndBlock != -1 ) {
         CPen blackpen(PS_SOLID, 1, RGB(255, 255, 255));
		 DrawBlockFrame(&dc, m_nStartBlock, m_nEndBlock, &blackpen);	
      }
   }      
      
      
   // TODO: Add your message handler code here
   // Do not call CDialog::OnPaint() for painting messages
}

int nLastBlock = 0;;


void CMapDlg::OnMouseMove(UINT nFlags, CPoint point)
{
   // TODO: Add your message handler code here and/or call default
   char  curAddr[20];
   BOOL  bInMapView = FALSE, bInBlock = FALSE;
   int   nBlock, nMaxBlock;
   CDC   *pDC = GetDC();
//   CBrush brush(PaletteIndex[9]);
   CPen  whitepen(PS_SOLID, 1, RGB(255, 255, 255)),
         blackpen(PS_SOLID, 1, RGB(0, 0, 0));
         
   int m_nOldStart = m_nStartBlock;
   int m_nOldEnd = m_nEndBlock;         

   bInMapView = m_ViewRect.PtInRect(point);
   if ( bInMapView ) {
      for ( nBlock = 0; nBlock < BLOCK_NUM; nBlock ++ ) {
         bInBlock = m_block[nBlock].m_block.PtInRect(point);
         if ( bInBlock ) {
            int nAttribute = -1;
            nMaxBlock = 0xffff / 0x7f;
            if ( nBlock >= nMaxBlock ) return;
            
            m_dwCurAddr = DWORD(nBlock*BYTE_PER_BLOCK);
            wsprintf(curAddr, "0x%X", nBlock*BYTE_PER_BLOCK);
            m_ctrlCurAddr.SetWindowText(curAddr);
            if ( m_bCapture ) {           // Mouse Button is down
                  
               m_nCurBlock = nBlock;
               if ( m_nCurBlock > m_nSplitBlock ) {
                  m_nStartBlock = m_nSplitBlock;
                  m_nLastBlock = m_nCurBlock;
                  m_nEndBlock = m_nCurBlock;
               }
               else {         // m_nCurBlock < m_nSplitBlock

					m_nStartBlock = m_nCurBlock;
					m_nLastBlock = m_nCurBlock;         
					m_nEndBlock = m_nSplitBlock;
			   }
             break;
            }   
         }
      }
   }

   	if (m_nOldStart < m_nStartBlock) // draw down 
   		DrawBlockFrame(pDC, m_nOldStart, m_nStartBlock, &blackpen);

	if (m_nOldEnd > m_nEndBlock)
		DrawBlockFrame(pDC, m_nEndBlock+1, m_nOldEnd, &blackpen);
	
	if (m_nOldStart != m_nStartBlock || m_nOldEnd != m_nEndBlock)
		DrawBlockFrame(pDC, m_nStartBlock, m_nEndBlock, &whitepen);
   			   
   ReleaseDC(pDC);      
   CDialog::OnMouseMove(nFlags, point);
}



void CMapDlg::OnLButtonDown(UINT nFlags, CPoint point)
{
   // TODO: Add your message handler code here and/or call default
   int   nBlock;
   BOOL  bInBlock = FALSE;
   char  startAddr[20], curAddr[20];
   int   nWhichBlock;
   int   nMaxBlock;   
      
   CDC   *pDC = GetDC();
   CPen  pen(PS_SOLID, 1, RGB(255, 255, 255));     // white pen
   CPen  blackpen(PS_SOLID, 1, RGB(0, 0, 0));      // black pen
   
   m_bCapture = m_ViewRect.PtInRect(point);
   //m_bStart = TRUE;
   for ( nBlock = 0; nBlock < BLOCK_NUM; nBlock ++ ) {
      bInBlock = m_block[nBlock].m_block.PtInRect(point);
      if ( bInBlock ) {
          nMaxBlock = 0xffff / 0x7f;
          if ( nBlock >= nMaxBlock ) return;
         
         m_ctrlUndo.EnableWindow(TRUE);
         if ( m_nStartBlock != -1 && m_nEndBlock != -1 ) {
            for ( nWhichBlock = m_nStartBlock; 
                  nWhichBlock <= m_nEndBlock;
                  nWhichBlock ++ ) {
               DrawBlockFrame(pDC, nWhichBlock, &blackpen);
            }                  
         }
         
         m_nStartBlock = nBlock;
         m_nEndBlock = nBlock;
         m_nLastBlock = nBlock;
         m_nCurBlock = nBlock;
         m_nSplitBlock = nBlock;
         
         m_dwStartAddr = DWORD(nBlock*BYTE_PER_BLOCK);
         m_dwStartAddr &= 0x0000FFFF;
         wsprintf(startAddr, "0x%X", nBlock*BYTE_PER_BLOCK);
         m_ctrlStartAddr.SetWindowText(startAddr);
         wsprintf(curAddr, "0x%X", nBlock*BYTE_PER_BLOCK);
         m_ctrlCurAddr.SetWindowText(curAddr);
         DrawBlockFrame(pDC, nBlock, &pen);
         
         break;
      }                  
   }
   
   ReleaseDC(pDC);
   CDialog::OnLButtonDown(nFlags, point);
}

void CMapDlg::OnLButtonUp(UINT nFlags, CPoint point)
{
   // TODO: Add your message handler code here and/or call default
   BOOL  bInBlock = FALSE;
   char  startAddr[20], endAddr[20];
   int   nBlock;
   DWORD dwTemp = 0;
      
   //m_bCapture = m_ViewRect.PtInRect(point);
   if ( m_bCapture ) {
      m_bCapture = FALSE;
      //m_bEnd = TRUE;
      for ( nBlock = 0; nBlock < BLOCK_NUM; nBlock ++ ) {
         bInBlock = m_block[nBlock].m_block.PtInRect(point);
         if ( bInBlock ) {
            m_dwEndAddr = DWORD(nBlock*BYTE_PER_BLOCK);
            m_dwEndAddr &= 0x0000FFFF;
            m_dwStartAddr &= 0x0000FFFF;
            if ( m_dwEndAddr < m_dwStartAddr ) {
               dwTemp = m_dwEndAddr;
               m_dwEndAddr = m_dwStartAddr;
               m_dwStartAddr = dwTemp;
               wsprintf(startAddr, "0x%4X", m_dwStartAddr);
               m_ctrlStartAddr.SetWindowText(startAddr);
               wsprintf(endAddr, "0x%4X", m_dwEndAddr);
               m_ctrlEndAddr.SetWindowText(endAddr);
            }
            else {
               wsprintf(endAddr, "0x%X", nBlock*BYTE_PER_BLOCK);
               m_ctrlEndAddr.SetWindowText(endAddr);
            }               
            break;
         }                  
      }
   }
   
   CDialog::OnLButtonUp(nFlags, point);
}

void CMapDlg::OnMapUndo()
{
	// TODO: Add your control notification handler code here
	AfxGetApp()->DoWaitCursor(1);   
	GetMap(m_nArea);
//	DrawMapView();
	AfxGetApp()->DoWaitCursor(0);   

	m_nStartBlock = -1;   
	m_nEndBlock = -1;   
	m_nLastBlock = -1;   
	m_nCurBlock = -1;   
	
	Invalidate(FALSE);
	UpdateWindow();
	
	m_ctrlMapEdit.EnableWindow(FALSE);
	m_ctrlUndo.EnableWindow(FALSE);

}

void CMapDlg::OnSelchangeMapList()
{
   // TODO: Add your control notification handler code here
   //CPen  solid_pen(PS_SOLID, 1, RGB(0, 0, 0)), 
   //      dot_pen(PS_SOLID, 1, RGB(255, 255, 255));
   CDC *pDC = GetDC();
            
   //DrawSelectMap(m_nSelectLast, pDC);
   m_nSelectLast = m_ctrlListMap.GetCurSel();   
   DrawSelectMap(m_nSelectLast, pDC);
   ReleaseDC(pDC);
}

void CMapDlg::OnSetfocusMapList()
{
   // TODO: Add your control notification handler code here
   //CPen  dot_pen(PS_DOT, 1, RGB(0, 0, 0));
   CDC *pDC = GetDC();
   UpdateData(TRUE);
   if(((CButton*)GetDlgItem(IDC_RPROGRAM))->GetCheck())
   		m_nAreaSelect=0;
   else if(((CButton*)GetDlgItem(IDC_RDATA))->GetCheck())
   		m_nAreaSelect=1;
   else if(((CButton*)GetDlgItem(IDC_RBANK1))->GetCheck())
   		m_nAreaSelect=2;
   else if(((CButton*)GetDlgItem(IDC_RBANK2))->GetCheck())
   		m_nAreaSelect=3;
   else if(((CButton*)GetDlgItem(IDC_RBANK3))->GetCheck())
   		m_nAreaSelect=4;
   else if(((CButton*)GetDlgItem(IDC_RBANK4))->GetCheck())
   		m_nAreaSelect=5;
   else
   		ASSERT(0);
   m_nSelectLast = m_ctrlListMap.GetCurSel();
   DrawSelectMap(m_nSelectLast, pDC);
   ReleaseDC(pDC);
   
   m_ctrlMapEdit.EnableWindow(TRUE);
}

void CMapDlg::OnKillfocusMapList()
{
   // TODO: Add your control notification handler code here
   //CPen  solid_pen(PS_SOLID, 1, RGB(0, 0, 0));
   CDC *pDC = GetDC();
   DrawSelectMap(m_nSelectLast, pDC);
   ReleaseDC(pDC);
}

BOOL CMapDlg::GetListSelect(int nSelectLast)
{
   if ( nSelectLast == -1 ) return FALSE;
   memset(strSelectItem, 0, 100);
   memset(strStartAddress, 0, 10);   
   memset(strEndAddress, 0, 10);   
   memset(strLength, 0, 10);   
   memset(strAttrib, 0, 30);   
   memset(strSpace, 0, 40);      
   
   m_ctrlListMap.GetText(nSelectLast, strSelectItem);
   strPosition = strSelectItem;
   strncpy(strStartAddress, strPosition, 10);
   strncpy(strEndAddress, strPosition+9, 10);
   strncpy(strLength, strPosition+18, 10);
   strncpy(strAttrib, strPosition+27, 22);
   strncpy(strSpace, strPosition+50, 40);   
   
   int iCount;   
   for (iCount = 10; iCount > 0; iCount--) {
      if (',' == strStartAddress[iCount]) {
         strStartAddress[iCount] = '\0';
         break;
      }
   }
   for (iCount = 10; iCount > 0; iCount--) {
      if (',' == strEndAddress[iCount]) {
         strEndAddress[iCount] = '\0';
         break;
      }
   }
   for (iCount = 10; iCount > 0; iCount--) {
      if (',' == strLength[iCount]) {
         strLength[iCount] = '\0';
         break;
      }
   }
   for (iCount = 22; iCount > 0; iCount--) {
      if (',' == strAttrib[iCount]) {
         strAttrib[iCount] = '\0';
         break;
      }
   }
   for (iCount = 40; iCount > 0; iCount--) {
      if (',' == strSpace[iCount]) {
         strSpace[iCount] = '\0';
         break;
      }
   }
   
//   if (0 == strcmp(strAttrib, "Overlay")) {
   if (0 == stricmp(strAttrib, g_pszAttrComOverlay)) {
      gnAttribIndex = IRW_COLOR;
      goto SETSEL;
   }
//   if (0 == strcmp(strAttrib, "Overlay Read Only")) {
   if (0 == stricmp(strAttrib, g_pszAttrComTarget)) {
      gnAttribIndex = IR_COLOR;
      goto SETSEL;
   }
//   if (0 == strcmp(strAttrib, "Guard")) {
   if (0 == stricmp(strAttrib, g_pszAttrSepOverlay)) {
      gnAttribIndex = GUARD_COLOR;
      goto SETSEL;
   }           
//   if (0 == strcmp(strAttrib, "Target")) {
   if (0 == strcmp(strAttrib, g_pszAttrSepTarget)) {
      gnAttribIndex = ERW_COLOR;
      goto SETSEL;
   }           
SETSEL:  
   return TRUE;

}

void CMapDlg::DrawSelectMap(int nSelectLast, CDC* pDC)
{
   ADDRESS nStartAddr, nEndAddr;
   //CBrush brush;
   CPen blackpen(PS_SOLID, 1, RGB(0, 0, 0));
   CPen whitepen(PS_SOLID, 1, RGB(255, 255, 255));
   
   int nWhichBlock;
   if ( m_nStartBlock != -1 && m_nEndBlock != -1 ) {
      for ( nWhichBlock = m_nStartBlock; 
            nWhichBlock <= m_nEndBlock;
            nWhichBlock ++ ) {
         DrawBlockFrame(pDC, nWhichBlock, &blackpen);
      }                  
   }

   if ( FALSE == GetListSelect(nSelectLast) ) return;      

   switch ( gnAttribIndex ) {          // Color Index
      case     IRW_COLOR:
               m_nColorIndex = IRW_COLOR;
               BtnProcess(BTN_IRW);
               break;
               
      case     IR_COLOR:
               m_nColorIndex = IR_COLOR;
               BtnProcess(BTN_IR);
               break;
               
      case     ERW_COLOR:
               m_nColorIndex = ERW_COLOR;
               BtnProcess(BTN_ERW);
               break;
               
      case     GUARD_COLOR:
               m_nColorIndex = GUARD_COLOR;
               BtnProcess(BTN_GUARD);
               break;
   }
         
   AdrTextToAddr(strStartAddress, nStartAddr);
   AdrTextToAddr(strEndAddress, nEndAddr);
   
   m_ctrlStartAddr.SetWindowText(strStartAddress);
   m_ctrlEndAddr.SetWindowText(strEndAddress);
   
   m_nStartBlock = int(nStartAddr.adrAddress/0x80);
   m_nEndBlock = int(nEndAddr.adrAddress/0x80);
   
   if ( m_nStartBlock != -1 && m_nEndBlock != -1 ) {
      for ( nWhichBlock = m_nStartBlock; 
            nWhichBlock <= m_nEndBlock; 
            nWhichBlock ++ ) {
         DrawBlockFrame(pDC, nWhichBlock, &whitepen);
      }   
   }      
}

BOOL CMapDlg::FindMapSave()
{
    char exefilename[125];
    ::GetModuleFileName(AfxGetInstanceHandle(), exefilename, 125);
    int pp = 0;
    for (pp = strlen(exefilename); pp > 0; pp--) {
      if (exefilename[pp] == '\\')
         break;
    }        
    
    exefilename[pp+1] = '\0';
    strcat(exefilename, "map.sav");
    
    BOOL b;
    CFile file;
    b = file.Open(exefilename, CFile::modeRead);
    if (!b) {
        file.Abort();
        return FALSE;
    }
    
    file.Close();
    return TRUE;
}

/////////////////////////////(EOF of MAPDLG.CPP)/////////////////////////////
