/***************************************************************************
**
**    $Header$
**
**    $Log$
** 
****************************************************************************/

//
// mapedit.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "uicom2.h"
#include "abitype.h"
#include "memsvr.h"
//#include "xview.h"
//#include "myedit2.h"
//#include "spin.h"
//#include "cpucom.h"
//#include "abibase.h"
//#include "cpuserve.h"

//
// For address server
//
#include "address.h"
#include "addrapi.h"

#include "mapedit.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

                       /****************************
                        *                          *
                        *    EXTERNAL VARIABLES    *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/
                        
                       /****************************
                        *                          *
                        *       GLOBAL VARS        *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *     LOCAL PROTOTYPES     *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *      EXECUTABLE CODE     *
                        *                          *
                        ****************************/

/////////////////////////////////////////////////////////////////////////////
// CMapEdit dialog


CMapEdit::CMapEdit(CWnd* pParent /*=NULL*/)
   : CDialog(CMapEdit::IDD, pParent)
{
   //{{AFX_DATA_INIT(CMapEdit)
   m_nAttribute = -1;
   m_strSpaceArea = "";
   m_strStartAddr = "";
   m_strEndAddr = "";
   //}}AFX_DATA_INIT
   m_nArea = -1;
   m_IsSet = FALSE;
}

void CMapEdit::DoDataExchange(CDataExchange* pDX)
{
   CDialog::DoDataExchange(pDX);
   //{{AFX_DATA_MAP(CMapEdit)
   DDX_Radio(pDX, IDC_RIRW, m_nAttribute);
   DDX_Text(pDX, IDC_SPACE, m_strSpaceArea);
   DDX_Text(pDX, IDC_STARTADDR, m_strStartAddr);
   DDX_Text(pDX, IDC_ENDADDR, m_strEndAddr);
   //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CMapEdit, CDialog)
   //{{AFX_MSG_MAP(CMapEdit)
   ON_BN_CLICKED(IDB_SET, OnSet)
   //}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CMapEdit message handlers

BOOL CMapEdit::OnInitDialog()
{
	CDialog::OnInitDialog();
	CenterWindow();

	// TODO: Add extra initialization here
	RECT rect, editrect;

	SetDlgItemText(IDC_MAP_EDIT1, "0x0");
	SetDlgItemText(IDC_MAP_EDIT2, "0x7f");
	m_edit1.SubclassEdit(IDC_STARTADDR, this, PES_NUMBERS);
	m_edit1.SetRange(0, 0xffff);  // Should be changed
	m_edit1.m_uWhichEdit = 1;
	m_edit1.m_uAddOrLen = 0;
	m_edit1.GetWindowRect(&editrect);
	ScreenToClient(&editrect);
	rect.left = editrect.right + 1;
	rect.right = rect.left + 15;
	rect.top = editrect.top;
	rect.bottom = editrect.bottom;
	m_spin1.Create(WS_VISIBLE|WS_CHILD|MSS_VERTICAL,rect,this,IDC_MAP_EDIT1);
	m_spin1.SetAssociate(&m_edit1);

	m_edit2.SubclassEdit(IDC_ENDADDR, this, PES_NUMBERS);
	m_edit2.SetRange(0, 0xffff);  // Should be changed
	m_edit2.m_uWhichEdit = 2;
	m_edit2.m_uAddOrLen = 0;    
	m_edit2.GetWindowRect(&editrect);
	ScreenToClient(&editrect);
	rect.left = editrect.right + 1;
	rect.right = rect.left + 15;
	rect.top = editrect.top;
	rect.bottom = editrect.bottom;

	m_spin2.Create(WS_VISIBLE|WS_CHILD|MSS_VERTICAL,rect,this,IDC_MAP_EDIT2);
	m_spin2.SetAssociate(&m_edit2);

// modified for Xu
   if (IsMapCombination()){
	    GetDlgItem(IDC_RG)->EnableWindow(FALSE);
	    GetDlgItem(IDC_RERW)->EnableWindow(FALSE);
	}
    
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CMapEdit::OnCancel()
{
   // TODO: Add extra cleanup here
   m_IsSet = FALSE;   
   CDialog::OnCancel();
}

void CMapEdit::OnSet()
{
   // TODO: Add your control notification handler code here
ADDRESS nStartAddr, nEndAddr;
ADDR_RETCODE retCode;
WORD attribute;
CString	strMsg;      
char* szErrAddr = "Error address";
char* szErrAddrRange = "Error address range";

	AfxGetApp()->DoWaitCursor(1);   

	UpdateData(TRUE);

	retCode = AdrTextToAddr(m_strStartAddr, nStartAddr);
	if ( ADR_OK != retCode ){
		AfxGetApp()->DoWaitCursor(0);   
		::MessageBox(NULL, szErrAddr,
                  NULL,MB_OK|MB_ICONSTOP);
//		CDialog::OnOK();
		return;
	}
	
	retCode = AdrTextToAddr(m_strEndAddr, nEndAddr);
	if ( ADR_OK != retCode ){
		AfxGetApp()->DoWaitCursor(0);   
		::MessageBox(NULL, szErrAddr,
                  NULL,MB_OK|MB_ICONSTOP);
//		CDialog::OnOK();
		return;
	}
	
	if (nStartAddr.adrAddress > nEndAddr.adrAddress){
		AfxGetApp()->DoWaitCursor(0);   
		::MessageBox(NULL, szErrAddrRange,
                  NULL,MB_OK|MB_ICONSTOP);
//		CDialog::OnOK();
		return;
	}
	
	switch ( m_nAttribute )
	{
	  case     0:
//	           attribute = MAP_ORW;
			   attribute = MAP_ERW;
	           break;
	               
	  case     1:
//	           attribute = MAP_OR;
	           attribute = MAP_ORW;
	           break;
	               
	  case     2:
//	           attribute = MAP_GUARD;
	           attribute = MAP_OR;
	           break;
	               
	  case     3:
//	           attribute = MAP_ERW;
	           attribute = MAP_GUARD;
	           break;   
	}
	            
	nStartAddr.adrSpace=nEndAddr.adrSpace=m_nArea;
	MemServerSetMap(nStartAddr, nEndAddr,
	               attribute, strMsg, 1);
	   
	m_IsSet = TRUE;   
	   
	AfxGetApp()->DoWaitCursor(0);   
	   
	CDialog::OnOK();
}
