/***************************************************************************
**
**    $Header$
**
**    $Log$
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  MEMDLG.CPP
//
//  Description:The implement file for the class: CMemDlg
//
//  Author:     Lane Li         &       Daniel Lin
//
//  Date:       09/10/95
//
//  Modification:
//      5. 04/05/96 ~           1.0 version               Daniel Lin
//          All changed for no useing VBX
//          Use the CPropertySheet for the main dialog and the CPropertyPage
//          for the CPropertyPage for every process dialog
//          Relative file is MEMPAGE.CPP(All page dialog file)
//
//      4. 03/06/96 ~ 03/??/96  1.0  version               Daniel Lin
//          Change any input field by Address Server.
//          For all input index will change to C convention format and
//          the address will be processed by Address server
//
//          Change function:
//                   OnTestButton1();      
//                   OnSearchButton1();
//                   OnCopyButton1()
//                   OnFillButton1()
//                   OnChecksumButton1()
//                   OnCompareButton1()
//                   CMemDlg::CMemDlg
//
//          All data input radix is modified to have head leading '0x'(hex)
//             
//
//      3. 11/03/95, 0.1h version.              Daniel Lin
//                 modify function:     OnTestButton1()
//                 modify function:     OnCopyButton1()
//                 modify function:     OnFillButton1()
//                 modify function:     OnSearchButton1()
//                 modify function:     OnChecksumButton1()
//                 modify function:     OnCompareButton1()
//
//      2. 10/31/95, 0.1g version.              Daniel Lin
//                 modify function:     OnTestButton1()
//                 modify function:     OnCopyButton1()
//                 modify function:     OnFillButton1()
//                 modify function:     OnSearchButton1()
//                 modify function:     OnChecksumButton1()
//                 modify function:     OnCompare()
//
//
//  Modification:
//
//      1. 09/10/95, Initial version
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "resource.h"

#include "memdlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif
                   
IMPLEMENT_DYNAMIC(CMemDlg, CPropertySheet)

BEGIN_MESSAGE_MAP(CMemDlg, CPropertySheet)
   //{{AFX_MSG_MAP(CMemDlg)
   ON_WM_CREATE()
	ON_WM_CLOSE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()
                   
/////////////////////////////////////////////////////////////////////////////
// CMemDlg dialog construct
//    Add six pape to the memory diaolg sheet
//
/////////////////////////////////////////////////////////////////////////////

CMemDlg::CMemDlg(CWnd* pParent /*=NULL*/)
   : CPropertySheet(IDS_MEMORY_GROUP/*CMemDlg::IDD*/, pParent)
{
	// Add six page to the memory sheet
	//
	AddPage (&m_searchPage);   
	AddPage (&m_comparePage);
	AddPage (&m_copyPage);
	AddPage (&m_fillPage);
	AddPage (&m_testPage);
	AddPage (&m_checksumPage);
}

/*
void CMemDlg::DoDataExchange(CDataExchange* pDX)
{
   CDialog::DoDataExchange(pDX);
   //{{AFX_DATA_MAP(CMemDlg)
      // NOTE: the ClassWizard will add DDX and DDV calls here
   //}}AFX_DATA_MAP
}
*/

/////////////////////////////////////////////////////////////////////////////
// CMemDlg message handlers
//

////////////////////////////////////////////////////////////////////////////
// OnCreate
//
//    Create the memory dialog use property sheet
//    Disable and invisible the OK, Cancel, Apply, Help button
//
////////////////////////////////////////////////////////////////////////////

void CMemDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
    // TODO: Add your message handler code here and/or call default

    // Disable to move or restore main frame window.
    switch ( nID & 0x0FFF0 ) {
        case SC_MOVE:
            return;
        default:
            break;
    }
        
    CPropertySheet::OnSysCommand(nID,lParam);
}

int CMemDlg::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CPropertySheet::OnCreate(lpCreateStruct) == -1)
		return -1;

	// TODO: Add your specialized creation code here
	CWnd *ctrl = NULL;
//	ctrl = GetDlgItem(IDOK);
//	ctrl->SetWindowText("Act");
//	ctrl = GetDlgItem(IDCANCEL);
//	ctrl->SetWindowText("Quit");
	ctrl = GetDlgItem(ID_APPLY_NOW);
	ctrl->ShowWindow(FALSE);

	// TODO: Add your specialized creation code here
	CenterWindow();   

	return 0;
}

void CMemDlg::SetModal(BOOL bModeless)
{
   m_bModeless = bModeless;
}

void CMemDlg::OnClose()
{
	// TODO: Add your message handler code here and/or call default
	SetModal(FALSE);	
	CPropertySheet::OnClose();
}

///////////////////////////(EOF MEMDLG.CPP)//////////////////////////////////
